/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.client.internal;

import io.github.apfelcreme.SupportTickets.lib.mongodb.AutoEncryptionSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ClientEncryptionSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoClientSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoNamespace;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.MongoClient;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.MongoClients;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.internal.CollectionInfoRetriever;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.internal.CommandMarker;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.internal.Crypt;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.internal.KeyManagementService;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.internal.KeyRetriever;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.internal.MongoClientImpl;
import io.github.apfelcreme.SupportTickets.lib.mongodb.crypt.capi.MongoCrypt;
import io.github.apfelcreme.SupportTickets.lib.mongodb.crypt.capi.MongoCryptOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.crypt.capi.MongoCrypts;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.capi.MongoCryptHelper;
import java.util.Map;
import javax.net.ssl.SSLContext;

public final class Crypts {
    public static Crypt createCrypt(MongoClientImpl client, AutoEncryptionSettings settings) {
        MongoClient internalClient = null;
        MongoClientSettings keyVaultMongoClientSettings = settings.getKeyVaultMongoClientSettings();
        if (keyVaultMongoClientSettings == null || !settings.isBypassAutoEncryption()) {
            MongoClientSettings mongoClientSettings = MongoClientSettings.builder(client.getSettings()).applyToConnectionPoolSettings(builder -> builder.minSize(0)).autoEncryptionSettings(null).build();
            internalClient = MongoClients.create(mongoClientSettings);
        }
        MongoClient keyVaultClient = keyVaultMongoClientSettings == null ? internalClient : MongoClients.create(keyVaultMongoClientSettings);
        MongoCrypt mongoCrypt = MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(settings));
        return new Crypt(mongoCrypt, Crypts.createKeyRetriever(keyVaultClient, settings.getKeyVaultNamespace()), Crypts.createKeyManagementService(settings.getKmsProviderSslContextMap()), settings.getKmsProviders(), settings.getKmsProviderPropertySuppliers(), settings.isBypassAutoEncryption(), settings.isBypassAutoEncryption() ? null : new CollectionInfoRetriever(internalClient), new CommandMarker(mongoCrypt, settings), internalClient);
    }

    static Crypt create(MongoClient keyVaultClient, ClientEncryptionSettings settings) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(settings)), Crypts.createKeyRetriever(keyVaultClient, settings.getKeyVaultNamespace()), Crypts.createKeyManagementService(settings.getKmsProviderSslContextMap()), settings.getKmsProviders(), settings.getKmsProviderPropertySuppliers());
    }

    private static KeyRetriever createKeyRetriever(MongoClient keyVaultClient, String keyVaultNamespaceString) {
        return new KeyRetriever(keyVaultClient, new MongoNamespace(keyVaultNamespaceString));
    }

    private static KeyManagementService createKeyManagementService(Map<String, SSLContext> kmsProviderSslContextMap) {
        return new KeyManagementService(kmsProviderSslContextMap, 10000);
    }

    private Crypts() {
    }
}

