/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.client.internal;

import io.github.apfelcreme.SupportTickets.lib.bson.RawBsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.conversions.Bson;
import io.github.apfelcreme.SupportTickets.lib.mongodb.AutoEncryptionSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoClientException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoTimeoutException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ReadConcern;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ReadPreference;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.MongoClient;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.MongoClients;
import io.github.apfelcreme.SupportTickets.lib.mongodb.crypt.capi.MongoCrypt;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.capi.MongoCryptHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.io.Closeable;
import java.util.Map;

class CommandMarker
implements Closeable {
    @Nullable
    private final MongoClient client;
    @Nullable
    private final ProcessBuilder processBuilder;

    CommandMarker(MongoCrypt mongoCrypt, AutoEncryptionSettings settings) {
        if (MongoCryptHelper.isMongocryptdSpawningDisabled(mongoCrypt.getCryptSharedLibVersionString(), settings)) {
            this.processBuilder = null;
            this.client = null;
        } else {
            Map<String, Object> extraOptions = settings.getExtraOptions();
            boolean mongocryptdBypassSpawn = (Boolean)extraOptions.getOrDefault("mongocryptdBypassSpawn", false);
            if (!mongocryptdBypassSpawn) {
                this.processBuilder = MongoCryptHelper.createProcessBuilder(extraOptions);
                MongoCryptHelper.startProcess(this.processBuilder);
            } else {
                this.processBuilder = null;
            }
            this.client = MongoClients.create(MongoCryptHelper.createMongocryptdClientSettings((String)extraOptions.get("mongocryptdURI")));
        }
    }

    RawBsonDocument mark(String databaseName, RawBsonDocument command) {
        if (this.client != null) {
            try {
                try {
                    return this.executeCommand(databaseName, command);
                }
                catch (MongoTimeoutException e) {
                    if (this.processBuilder == null) {
                        throw e;
                    }
                    MongoCryptHelper.startProcess(this.processBuilder);
                    return this.executeCommand(databaseName, command);
                }
            }
            catch (MongoException e) {
                throw this.wrapInClientException(e);
            }
        }
        return command;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private RawBsonDocument executeCommand(String databaseName, RawBsonDocument markableCommand) {
        Assertions.assertNotNull(this.client);
        return this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary()).runCommand((Bson)markableCommand, RawBsonDocument.class);
    }

    private MongoClientException wrapInClientException(MongoException e) {
        return new MongoClientException("Exception in encryption library: " + e.getMessage(), e);
    }
}

