/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.client.internal;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonArray;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonBinary;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonNull;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonString;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonValue;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecRegistry;
import io.github.apfelcreme.SupportTickets.lib.bson.conversions.Bson;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ClientEncryptionSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoClientSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoConfigurationException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoNamespace;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoUpdatedEncryptedFieldsException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ReadConcern;
import io.github.apfelcreme.SupportTickets.lib.mongodb.WriteConcern;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.FindIterable;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.MongoClient;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.MongoClients;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.MongoCollection;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.MongoDatabase;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.internal.Crypt;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.internal.Crypts;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.CreateCollectionOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.CreateEncryptedCollectionParams;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.Filters;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.UpdateOneModel;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.Updates;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.vault.DataKeyOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.vault.EncryptOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.vault.RewrapManyDataKeyOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.vault.RewrapManyDataKeyResult;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.result.DeleteResult;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.vault.ClientEncryption;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.capi.MongoCryptHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class ClientEncryptionImpl
implements ClientEncryption {
    private final Crypt crypt;
    private final ClientEncryptionSettings options;
    private final MongoClient keyVaultClient;
    private final MongoCollection<BsonDocument> collection;

    public ClientEncryptionImpl(ClientEncryptionSettings options) {
        this(MongoClients.create(options.getKeyVaultMongoClientSettings()), options);
    }

    public ClientEncryptionImpl(MongoClient keyVaultClient, ClientEncryptionSettings options) {
        this.keyVaultClient = keyVaultClient;
        this.crypt = Crypts.create(keyVaultClient, options);
        this.options = options;
        MongoNamespace namespace = new MongoNamespace(options.getKeyVaultNamespace());
        this.collection = keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).withReadConcern(ReadConcern.MAJORITY);
    }

    @Override
    public BsonBinary createDataKey(String kmsProvider) {
        return this.createDataKey(kmsProvider, new DataKeyOptions());
    }

    @Override
    public BsonBinary createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions) {
        BsonDocument dataKeyDocument = this.crypt.createDataKey(kmsProvider, dataKeyOptions);
        this.collection.insertOne(dataKeyDocument);
        return dataKeyDocument.getBinary("_id");
    }

    @Override
    public BsonBinary encrypt(BsonValue value, EncryptOptions options) {
        return this.crypt.encryptExplicitly(value, options);
    }

    @Override
    public BsonDocument encryptExpression(Bson expression, EncryptOptions options) {
        return this.crypt.encryptExpression(expression.toBsonDocument(BsonDocument.class, this.collection.getCodecRegistry()), options);
    }

    @Override
    public BsonValue decrypt(BsonBinary value) {
        return this.crypt.decryptExplicitly(value);
    }

    @Override
    public DeleteResult deleteKey(BsonBinary id) {
        return this.collection.deleteOne(Filters.eq("_id", id));
    }

    @Override
    public BsonDocument getKey(BsonBinary id) {
        return (BsonDocument)this.collection.find(Filters.eq("_id", id)).first();
    }

    @Override
    public FindIterable<BsonDocument> getKeys() {
        return this.collection.find();
    }

    @Override
    public BsonDocument addKeyAltName(BsonBinary id, String keyAltName) {
        return this.collection.findOneAndUpdate(Filters.eq("_id", id), Updates.addToSet("keyAltNames", keyAltName));
    }

    @Override
    public BsonDocument removeKeyAltName(BsonBinary id, String keyAltName) {
        BsonDocument updateDocument = new BsonDocument().append("$set", new BsonDocument().append("keyAltNames", new BsonDocument().append("$cond", new BsonArray(Arrays.asList(new BsonDocument().append("$eq", new BsonArray(Arrays.asList(new BsonString("$keyAltNames"), new BsonArray(Collections.singletonList(new BsonString(keyAltName)))))), new BsonString("$$REMOVE"), new BsonDocument().append("$filter", new BsonDocument().append("input", new BsonString("$keyAltNames")).append("cond", new BsonDocument().append("$ne", new BsonArray(Arrays.asList(new BsonString("$$this"), new BsonString(keyAltName)))))))))));
        return this.collection.findOneAndUpdate(Filters.eq("_id", id), Collections.singletonList(updateDocument));
    }

    @Override
    public BsonDocument getKeyByAltName(String keyAltName) {
        return (BsonDocument)this.collection.find(Filters.eq("keyAltNames", keyAltName)).first();
    }

    @Override
    public RewrapManyDataKeyResult rewrapManyDataKey(Bson filter) {
        return this.rewrapManyDataKey(filter, new RewrapManyDataKeyOptions());
    }

    @Override
    public RewrapManyDataKeyResult rewrapManyDataKey(Bson filter, RewrapManyDataKeyOptions options) {
        MongoCryptHelper.validateRewrapManyDataKeyOptions(options);
        BsonDocument results = this.crypt.rewrapManyDataKey(filter.toBsonDocument(BsonDocument.class, this.collection.getCodecRegistry()), options);
        if (results.isEmpty()) {
            return new RewrapManyDataKeyResult();
        }
        List updateModels = results.getArray("v", new BsonArray()).stream().map(v -> {
            BsonDocument updateDocument = v.asDocument();
            return new UpdateOneModel(Filters.eq(updateDocument.get("_id")), Updates.combine(Updates.set("masterKey", updateDocument.get("masterKey")), Updates.set("keyMaterial", updateDocument.get("keyMaterial")), Updates.currentDate("updateDate")));
        }).collect(Collectors.toList());
        return new RewrapManyDataKeyResult(this.collection.bulkWrite(updateModels));
    }

    @Override
    public BsonDocument createEncryptedCollection(MongoDatabase database, String collectionName, CreateCollectionOptions createCollectionOptions, CreateEncryptedCollectionParams createEncryptedCollectionParams) {
        Assertions.notNull("collectionName", collectionName);
        Assertions.notNull("createCollectionOptions", createCollectionOptions);
        Assertions.notNull("createEncryptedCollectionParams", createEncryptedCollectionParams);
        MongoNamespace namespace = new MongoNamespace(database.getName(), collectionName);
        Bson rawEncryptedFields = createCollectionOptions.getEncryptedFields();
        if (rawEncryptedFields == null) {
            throw new MongoConfigurationException(String.format("`encryptedFields` is not configured for the collection %s.", namespace));
        }
        CodecRegistry codecRegistry = this.options.getKeyVaultMongoClientSettings() == null ? MongoClientSettings.getDefaultCodecRegistry() : this.options.getKeyVaultMongoClientSettings().getCodecRegistry();
        BsonDocument encryptedFields = rawEncryptedFields.toBsonDocument(BsonDocument.class, codecRegistry);
        BsonValue fields = encryptedFields.get("fields");
        if (fields != null && fields.isArray()) {
            String kmsProvider = createEncryptedCollectionParams.getKmsProvider();
            DataKeyOptions dataKeyOptions = new DataKeyOptions();
            BsonDocument masterKey = createEncryptedCollectionParams.getMasterKey();
            if (masterKey != null) {
                dataKeyOptions.masterKey(masterKey);
            }
            String keyIdBsonKey = "keyId";
            BsonDocument maybeUpdatedEncryptedFields = encryptedFields.clone();
            AtomicBoolean dataKeyMightBeCreated = new AtomicBoolean();
            try {
                maybeUpdatedEncryptedFields.get("fields").asArray().stream().filter(BsonValue::isDocument).map(BsonValue::asDocument).filter(field -> field.containsKey(keyIdBsonKey)).filter(field -> Objects.equals(field.get(keyIdBsonKey), BsonNull.VALUE)).forEachOrdered(field -> {
                    dataKeyMightBeCreated.set(true);
                    BsonBinary dataKeyId = this.createDataKey(kmsProvider, dataKeyOptions);
                    field.put(keyIdBsonKey, dataKeyId);
                });
                database.createCollection(collectionName, new CreateCollectionOptions(createCollectionOptions).encryptedFields(maybeUpdatedEncryptedFields));
                return maybeUpdatedEncryptedFields;
            }
            catch (Exception e) {
                if (dataKeyMightBeCreated.get()) {
                    throw new MongoUpdatedEncryptedFieldsException(maybeUpdatedEncryptedFields, String.format("Failed to create %s.", namespace), (Throwable)e);
                }
                throw e;
            }
        }
        database.createCollection(collectionName, createCollectionOptions);
        return encryptedFields;
    }

    @Override
    public void close() {
        this.crypt.close();
        this.keyVaultClient.close();
    }
}

