/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.assertions;

import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.SingleResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.util.Collection;

public final class Assertions {
    public static <T> T notNull(String name, T value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " can not be null");
        }
        return value;
    }

    public static <T> T notNull(String name, T value, SingleResultCallback<?> callback) {
        if (value == null) {
            IllegalArgumentException exception = new IllegalArgumentException(name + " can not be null");
            callback.onResult(null, exception);
            throw exception;
        }
        return value;
    }

    public static void isTrue(String name, boolean condition) {
        if (!condition) {
            throw new IllegalStateException("state should be: " + name);
        }
    }

    public static void isTrue(String name, boolean condition, SingleResultCallback<?> callback) {
        if (!condition) {
            IllegalStateException exception = new IllegalStateException("state should be: " + name);
            callback.onResult(null, exception);
            throw exception;
        }
    }

    public static void isTrueArgument(String name, boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException("state should be: " + name);
        }
    }

    public static void doesNotContainNull(String name, Collection<?> collection) {
        for (Object o : collection) {
            if (o != null) continue;
            throw new IllegalArgumentException(name + " can not contain a null value");
        }
    }

    @Nullable
    public static <T> T assertNull(@Nullable T value) throws AssertionError {
        if (value != null) {
            throw new AssertionError((Object)value.toString());
        }
        return null;
    }

    public static <T> T assertNotNull(@Nullable T value) throws AssertionError {
        if (value == null) {
            throw new AssertionError();
        }
        return value;
    }

    public static boolean assertTrue(boolean value) throws AssertionError {
        if (!value) {
            throw new AssertionError();
        }
        return true;
    }

    public static boolean assertFalse(boolean value) throws AssertionError {
        if (value) {
            throw new AssertionError();
        }
        return false;
    }

    public static AssertionError fail() throws AssertionError {
        throw new AssertionError();
    }

    public static AssertionError fail(String msg) throws AssertionError {
        throw new AssertionError((Object)Assertions.assertNotNull(msg));
    }

    private Assertions() {
    }
}

