/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb;

import io.github.apfelcreme.SupportTickets.lib.mongodb.annotations.Immutable;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import java.util.Objects;

@Immutable
public final class LoggerSettings {
    private final int maxDocumentLength;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LoggerSettings loggerSettings) {
        return LoggerSettings.builder().applySettings(loggerSettings);
    }

    public int getMaxDocumentLength() {
        return this.maxDocumentLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoggerSettings that = (LoggerSettings)o;
        return this.maxDocumentLength == that.maxDocumentLength;
    }

    public int hashCode() {
        return Objects.hash(this.maxDocumentLength);
    }

    public String toString() {
        return "LoggerSettings{maxDocumentLength=" + this.maxDocumentLength + '}';
    }

    private LoggerSettings(Builder builder) {
        this.maxDocumentLength = builder.maxDocumentLength;
    }

    public static final class Builder {
        private int maxDocumentLength = 1000;

        private Builder() {
        }

        public Builder applySettings(LoggerSettings loggerSettings) {
            Assertions.notNull("loggerSettings", loggerSettings);
            this.maxDocumentLength = loggerSettings.maxDocumentLength;
            return this;
        }

        public Builder maxDocumentLength(int maxDocumentLength) {
            this.maxDocumentLength = maxDocumentLength;
            return this;
        }

        public LoggerSettings build() {
            return new LoggerSettings(this);
        }
    }
}

