/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb;

import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonTypeClassMap;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Codec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.DateCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecProvider;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecRegistry;
import io.github.apfelcreme.SupportTickets.lib.bson.types.BSONTimestamp;
import io.github.apfelcreme.SupportTickets.lib.mongodb.BSONTimestampCodec;
import io.github.apfelcreme.SupportTickets.lib.mongodb.DBObject;
import io.github.apfelcreme.SupportTickets.lib.mongodb.DBObjectCodec;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import java.util.Date;
import java.util.List;

public class DBObjectCodecProvider
implements CodecProvider {
    private final BsonTypeClassMap bsonTypeClassMap;

    public DBObjectCodecProvider() {
        this(DBObjectCodec.getDefaultBsonTypeClassMap());
    }

    public DBObjectCodecProvider(BsonTypeClassMap bsonTypeClassMap) {
        this.bsonTypeClassMap = Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (clazz == BSONTimestamp.class) {
            return new BSONTimestampCodec();
        }
        if (DBObject.class.isAssignableFrom(clazz) && !List.class.isAssignableFrom(clazz)) {
            return new DBObjectCodec(registry, this.bsonTypeClassMap);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new DateCodec();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "DBObjectCodecProvider{}";
    }
}

