/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.minedown;

import io.github.apfelcreme.SupportTickets.lib.minedown.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.KeybindComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.api.chat.hover.content.Text;

public class Replacer {
    private static final boolean HAS_KEYBIND_SUPPORT = Util.hasClass("net.md_5.bungee.api.chat.KeybindComponent");
    private static final boolean HAS_INSERTION_SUPPORT = Util.hasMethod(BaseComponent.class, "getInsertion", new Class[0]);
    private static final boolean HAS_HOVER_CONTENT_SUPPORT = Util.hasMethod(HoverEvent.class, "getContents", new Class[0]);
    private static final Method HOVER_GET_VALUE = Util.getMethod(HoverEvent.class, "getValue", new Class[0]);
    private static final Map<String, Pattern> PATTERN_CACHE = new ConcurrentHashMap<String, Pattern>();
    private static final Function<String, Pattern> PATTERN_CREATOR = p -> Pattern.compile(p, 16);
    private final Map<String, String> replacements = new LinkedHashMap<String, String>();
    private final Map<String, BaseComponent[]> componentReplacements = new LinkedHashMap<String, BaseComponent[]>();
    private String placeholderPrefix = "%";
    private String placeholderSuffix = "%";
    private boolean ignorePlaceholderCase = true;

    public static String replaceIn(String message, String ... replacements) {
        return new Replacer().replace(replacements).replaceIn(message);
    }

    public static BaseComponent[] replaceIn(BaseComponent[] message, String ... replacements) {
        return new Replacer().replace(replacements).replaceIn(message);
    }

    public static BaseComponent[] replaceIn(BaseComponent[] message, String placeholder, BaseComponent ... replacement) {
        return new Replacer().replace(placeholder, replacement).replaceIn(message);
    }

    public Replacer replace(String ... replacements) {
        Util.validate(replacements.length % 2 == 0, "The replacement length has to be even, mapping i % 2 == 0 to the placeholder and i % 2 = 1 to the placeholder's value");
        LinkedHashMap<String, String> replacementMap = new LinkedHashMap<String, String>();
        int i = 0;
        while (i + 1 < replacements.length) {
            replacementMap.put(replacements[i], replacements[i + 1]);
            i += 2;
        }
        return this.replace(replacementMap);
    }

    public Replacer replace(Map<String, ?> replacements) {
        if (replacements != null && !replacements.isEmpty()) {
            Object any = replacements.values().stream().filter(Objects::nonNull).findAny().orElse(null);
            if (any instanceof String) {
                this.replacements().putAll(replacements);
            } else if (any != null && any.getClass().isArray() && BaseComponent.class.isAssignableFrom(any.getClass().getComponentType())) {
                this.componentReplacements().putAll(replacements);
            } else {
                for (Map.Entry<String, ?> entry : replacements.entrySet()) {
                    this.replacements().put(entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
        }
        return this;
    }

    public Replacer replace(String placeholder, BaseComponent ... replacement) {
        this.componentReplacements().put(placeholder, replacement);
        return this;
    }

    public Replacer placeholderIndicator(String placeholderIndicator) {
        this.placeholderPrefix(placeholderIndicator);
        this.placeholderSuffix(placeholderIndicator);
        return this;
    }

    public BaseComponent[] replaceIn(BaseComponent ... components) {
        return this.replaceIn(Arrays.asList(components));
    }

    public BaseComponent[] replaceIn(List<BaseComponent> components) {
        ArrayList returnList = new ArrayList();
        for (int i = 0; i < components.size(); ++i) {
            BaseComponent component = components.get(i).duplicate();
            if (HAS_KEYBIND_SUPPORT && component instanceof KeybindComponent) {
                ((KeybindComponent)component).setKeybind(this.replaceIn(((KeybindComponent)component).getKeybind()));
            }
            if (component instanceof TextComponent) {
                String replaced = this.replaceIn(((TextComponent)component).getText());
                int sectionIndex = replaced.indexOf(167);
                if (sectionIndex > -1 && replaced.length() > sectionIndex + 1 && ChatColor.getByChar((char)replaced.charAt(sectionIndex + 1)) != null) {
                    BaseComponent[] replacedComponent = TextComponent.fromLegacyText((String)replaced);
                    ((TextComponent)component).setText("");
                    ArrayList extra = new ArrayList();
                    Collections.addAll(extra, replacedComponent);
                    if (component.getExtra() != null) {
                        Collections.addAll(extra, this.replaceIn(component.getExtra()));
                    }
                    component.setExtra(extra);
                } else {
                    ((TextComponent)component).setText(replaced);
                    if (component.getExtra() != null) {
                        component.setExtra(Arrays.asList(this.replaceIn(component.getExtra())));
                    }
                }
            } else if (component.getExtra() != null) {
                component.setExtra(Arrays.asList(this.replaceIn(component.getExtra())));
            }
            if (component instanceof TranslatableComponent) {
                ((TranslatableComponent)component).setTranslate(this.replaceIn(((TranslatableComponent)component).getTranslate()));
                ((TranslatableComponent)component).setWith(Arrays.asList(this.replaceIn(((TranslatableComponent)component).getWith())));
            }
            if (HAS_INSERTION_SUPPORT && component.getInsertion() != null) {
                component.setInsertion(this.replaceIn(component.getInsertion()));
            }
            if (component.getClickEvent() != null) {
                component.setClickEvent(new ClickEvent(component.getClickEvent().getAction(), this.replaceIn(component.getClickEvent().getValue())));
            }
            if (component.getHoverEvent() != null) {
                if (HAS_HOVER_CONTENT_SUPPORT) {
                    component.setHoverEvent(new HoverEvent(component.getHoverEvent().getAction(), this.replaceInContents(component.getHoverEvent().getContents())));
                } else if (HOVER_GET_VALUE != null) {
                    try {
                        component.setHoverEvent(new HoverEvent(component.getHoverEvent().getAction(), this.replaceIn((BaseComponent[])HOVER_GET_VALUE.invoke((Object)component.getHoverEvent(), new Object[0]))));
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
            ArrayList<BaseComponent> replacedComponents = new ArrayList<BaseComponent>();
            replacedComponents.add(component);
            for (Map.Entry<String, BaseComponent[]> replacement : this.componentReplacements().entrySet()) {
                ArrayList<Object> newReplacedComponents = new ArrayList<Object>();
                for (BaseComponent replaceComponent : replacedComponents) {
                    if (replaceComponent instanceof TextComponent) {
                        TextComponent textComponent = (TextComponent)replaceComponent;
                        String placeHolder = this.placeholderPrefix() + (this.ignorePlaceholderCase() ? replacement.getKey().toLowerCase(Locale.ROOT) : replacement.getKey()) + this.placeholderSuffix();
                        String text = this.ignorePlaceholderCase() ? textComponent.getText().toLowerCase(Locale.ROOT) : textComponent.getText();
                        int index = text.indexOf(placeHolder);
                        if (index > -1) {
                            do {
                                TextComponent startComponent = new TextComponent(textComponent);
                                if (index > 0) {
                                    startComponent.setText(textComponent.getText().substring(0, index));
                                } else {
                                    startComponent.setText("");
                                }
                                startComponent.setExtra(Arrays.asList(replacement.getValue()));
                                newReplacedComponents.add(startComponent);
                                if (index + placeHolder.length() < textComponent.getText().length()) {
                                    textComponent.setText(textComponent.getText().substring(index + placeHolder.length()));
                                } else {
                                    textComponent.setText("");
                                }
                                text = this.ignorePlaceholderCase() ? textComponent.getText().toLowerCase(Locale.ROOT) : textComponent.getText();
                                newReplacedComponents.add(textComponent);
                            } while (!text.isEmpty() && (index = text.indexOf(placeHolder)) > -1);
                            continue;
                        }
                    }
                    newReplacedComponents.add(replaceComponent);
                }
                replacedComponents = newReplacedComponents;
            }
            returnList.addAll(replacedComponents);
        }
        return returnList.toArray(new BaseComponent[0]);
    }

    private List<Content> replaceInContents(List<Content> contents) {
        ArrayList<Content> replacedContents = new ArrayList<Content>();
        for (Content content : contents) {
            String id;
            if (content instanceof Text) {
                Object value = ((Text)content).getValue();
                if (value instanceof BaseComponent[]) {
                    replacedContents.add((Content)new Text(this.replaceIn((BaseComponent[])value)));
                    continue;
                }
                if (value instanceof String) {
                    replacedContents.add((Content)new Text(this.replaceIn((String)value)));
                    continue;
                }
                throw new UnsupportedOperationException("Cannot replace in " + value.getClass() + "!");
            }
            if (content instanceof Entity) {
                Entity entity = (Entity)content;
                id = this.replaceIn(entity.getId());
                String type = entity.getType() != null ? this.replaceIn(entity.getType()) : "minecraft:pig";
                TextComponent name = null;
                if (entity.getName() != null) {
                    name = new TextComponent(this.replaceIn(TextComponent.toLegacyText((BaseComponent[])new BaseComponent[]{entity.getName()})));
                }
                replacedContents.add((Content)new Entity(type, id, name));
                continue;
            }
            if (content instanceof Item) {
                Item item = (Item)content;
                id = this.replaceIn(item.getId());
                ItemTag itemTag = item.getTag() != null ? ItemTag.ofNbt((String)this.replaceIn(item.getTag().getNbt())) : null;
                replacedContents.add((Content)new Item(id, item.getCount(), itemTag));
                continue;
            }
            replacedContents.add(content);
        }
        return replacedContents;
    }

    public String replaceIn(String string) {
        for (Map.Entry<String, String> replacement : this.replacements().entrySet()) {
            String placeholder;
            String replValue;
            String string2 = replValue = replacement.getValue() != null ? replacement.getValue() : "null";
            if (this.ignorePlaceholderCase()) {
                int startIndex;
                placeholder = this.placeholderPrefix() + replacement.getKey().toLowerCase(Locale.ROOT) + this.placeholderSuffix();
                int nextStart = 0;
                while (nextStart < string.length() && (startIndex = string.toLowerCase(Locale.ROOT).indexOf(placeholder, nextStart)) > -1) {
                    nextStart = startIndex + replValue.length();
                    string = string.substring(0, startIndex) + replValue + string.substring(startIndex + placeholder.length());
                }
                continue;
            }
            placeholder = this.placeholderPrefix() + replacement.getKey() + this.placeholderSuffix();
            Pattern pattern = PATTERN_CACHE.computeIfAbsent(placeholder, PATTERN_CREATOR);
            string = pattern.matcher(string).replaceAll(Matcher.quoteReplacement(replValue));
        }
        return string;
    }

    public Replacer copy() {
        return new Replacer().copy(this);
    }

    public Replacer copy(Replacer from) {
        this.replacements().clear();
        this.replacements().putAll(from.replacements());
        this.componentReplacements().clear();
        this.componentReplacements().putAll(from.componentReplacements());
        this.placeholderPrefix(from.placeholderPrefix());
        this.placeholderSuffix(from.placeholderSuffix());
        return this;
    }

    public Map<String, String> replacements() {
        return this.replacements;
    }

    public Map<String, BaseComponent[]> componentReplacements() {
        return this.componentReplacements;
    }

    public String placeholderPrefix() {
        return this.placeholderPrefix;
    }

    public Replacer placeholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
        return this;
    }

    public String placeholderSuffix() {
        return this.placeholderSuffix;
    }

    public Replacer placeholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
        return this;
    }

    public boolean ignorePlaceholderCase() {
        return this.ignorePlaceholderCase;
    }

    public Replacer ignorePlaceholderCase(boolean ignorePlaceholderCase) {
        this.ignorePlaceholderCase = ignorePlaceholderCase;
        return this;
    }
}

