/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.bson.codecs;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonReader;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonWriter;
import io.github.apfelcreme.SupportTickets.lib.bson.Transformer;
import io.github.apfelcreme.SupportTickets.lib.bson.UuidRepresentation;
import io.github.apfelcreme.SupportTickets.lib.bson.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.AbstractMapCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonTypeClassMap;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonTypeCodecMap;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Codec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.ContainerCodecHelper;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.DecoderContext;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.EncoderContext;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.OverridableUuidRepresentationCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Parameterizable;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.ParameterizedMapCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecConfigurationException;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecRegistry;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

final class MapCodecV2<M extends Map<String, Object>>
extends AbstractMapCodec<Object, M>
implements OverridableUuidRepresentationCodec<M>,
Parameterizable {
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final CodecRegistry registry;
    private final Transformer valueTransformer;
    private final UuidRepresentation uuidRepresentation;

    MapCodecV2(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer, Class<M> clazz) {
        this(registry, new BsonTypeCodecMap(Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap), registry), valueTransformer, UuidRepresentation.UNSPECIFIED, clazz);
    }

    private MapCodecV2(CodecRegistry registry, BsonTypeCodecMap bsonTypeCodecMap, Transformer valueTransformer, UuidRepresentation uuidRepresentation, Class<M> clazz) {
        super(clazz);
        this.registry = Assertions.notNull("registry", registry);
        this.bsonTypeCodecMap = bsonTypeCodecMap;
        this.valueTransformer = valueTransformer != null ? valueTransformer : value -> value;
        this.uuidRepresentation = uuidRepresentation;
    }

    @Override
    public Codec<M> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        if (this.uuidRepresentation.equals((Object)uuidRepresentation)) {
            return this;
        }
        return new MapCodecV2(this.registry, this.bsonTypeCodecMap, this.valueTransformer, uuidRepresentation, this.getEncoderClass());
    }

    @Override
    public Codec<?> parameterize(CodecRegistry codecRegistry, List<Type> types) {
        if (types.size() != 2) {
            throw new CodecConfigurationException("Expected two parameterized type for an Iterable, but found " + types.size());
        }
        Type genericTypeOfMapKey = types.get(0);
        if (!genericTypeOfMapKey.getTypeName().equals("java.lang.String")) {
            throw new CodecConfigurationException("Unsupported key type for Map: " + genericTypeOfMapKey.getTypeName());
        }
        return new ParameterizedMapCodec(ContainerCodecHelper.getCodec(codecRegistry, types.get(1)), this.getEncoderClass());
    }

    @Override
    Object readValue(BsonReader reader, DecoderContext decoderContext) {
        return ContainerCodecHelper.readValue(reader, decoderContext, this.bsonTypeCodecMap, this.uuidRepresentation, this.registry, this.valueTransformer);
    }

    @Override
    void writeValue(BsonWriter writer, Object value, EncoderContext encoderContext) {
        Codec<?> codec = this.registry.get(value.getClass());
        encoderContext.encodeWithChildContext(codec, writer, value);
    }
}

