/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.bson.codecs;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonInvalidOperationException;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonReader;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonWriter;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Codec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.DecoderContext;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.EncoderContext;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.NumberCodecHelper;

public class FloatCodec
implements Codec<Float> {
    @Override
    public void encode(BsonWriter writer, Float value, EncoderContext encoderContext) {
        writer.writeDouble(value.floatValue());
    }

    @Override
    public Float decode(BsonReader reader, DecoderContext decoderContext) {
        double value = NumberCodecHelper.decodeDouble(reader);
        if (value < -3.4028234663852886E38 || value > 3.4028234663852886E38) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Float.", value));
        }
        return Float.valueOf((float)value);
    }

    @Override
    public Class<Float> getEncoderClass() {
        return Float.class;
    }
}

