/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.bson.codecs;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocumentWriter;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonReader;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonType;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonValue;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonWriter;
import io.github.apfelcreme.SupportTickets.lib.bson.Document;
import io.github.apfelcreme.SupportTickets.lib.bson.Transformer;
import io.github.apfelcreme.SupportTickets.lib.bson.UuidRepresentation;
import io.github.apfelcreme.SupportTickets.lib.bson.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonTypeClassMap;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonTypeCodecMap;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonValueCodecProvider;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Codec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.CollectibleCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.CollectionCodecProvider;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.ContainerCodecHelper;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.DecoderContext;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.DocumentCodecProvider;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.EncoderContext;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.IdGenerator;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.IterableCodecProvider;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.MapCodecProvider;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.ObjectIdGenerator;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.OverridableUuidRepresentationCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.ValueCodecProvider;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecRegistries;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecRegistry;
import java.util.Arrays;
import java.util.Map;

public class DocumentCodec
implements CollectibleCodec<Document>,
OverridableUuidRepresentationCodec<Document> {
    private static final String ID_FIELD_NAME = "_id";
    private static final CodecRegistry DEFAULT_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new CollectionCodecProvider(), new IterableCodecProvider(), new BsonValueCodecProvider(), new DocumentCodecProvider(), new MapCodecProvider()));
    private static final BsonTypeCodecMap DEFAULT_BSON_TYPE_CODEC_MAP = new BsonTypeCodecMap(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP, DEFAULT_REGISTRY);
    private static final IdGenerator DEFAULT_ID_GENERATOR = new ObjectIdGenerator();
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final CodecRegistry registry;
    private final IdGenerator idGenerator;
    private final Transformer valueTransformer;
    private final UuidRepresentation uuidRepresentation;

    public DocumentCodec() {
        this(DEFAULT_REGISTRY, DEFAULT_BSON_TYPE_CODEC_MAP, null);
    }

    public DocumentCodec(CodecRegistry registry) {
        this(registry, BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public DocumentCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap) {
        this(registry, bsonTypeClassMap, null);
    }

    public DocumentCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer) {
        this(registry, new BsonTypeCodecMap(Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap), registry), valueTransformer);
    }

    private DocumentCodec(CodecRegistry registry, BsonTypeCodecMap bsonTypeCodecMap, Transformer valueTransformer) {
        this(registry, bsonTypeCodecMap, DEFAULT_ID_GENERATOR, valueTransformer, UuidRepresentation.UNSPECIFIED);
    }

    private DocumentCodec(CodecRegistry registry, BsonTypeCodecMap bsonTypeCodecMap, IdGenerator idGenerator, Transformer valueTransformer, UuidRepresentation uuidRepresentation) {
        this.registry = Assertions.notNull("registry", registry);
        this.bsonTypeCodecMap = bsonTypeCodecMap;
        this.idGenerator = idGenerator;
        this.valueTransformer = valueTransformer != null ? valueTransformer : value -> value;
        this.uuidRepresentation = uuidRepresentation;
    }

    @Override
    public Codec<Document> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        if (this.uuidRepresentation.equals((Object)uuidRepresentation)) {
            return this;
        }
        return new DocumentCodec(this.registry, this.bsonTypeCodecMap, this.idGenerator, this.valueTransformer, uuidRepresentation);
    }

    @Override
    public boolean documentHasId(Document document) {
        return document.containsKey(ID_FIELD_NAME);
    }

    @Override
    public BsonValue getDocumentId(Document document) {
        if (!this.documentHasId(document)) {
            throw new IllegalStateException("The document does not contain an _id");
        }
        Object id = document.get(ID_FIELD_NAME);
        if (id instanceof BsonValue) {
            return (BsonValue)id;
        }
        BsonDocument idHoldingDocument = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(idHoldingDocument);
        writer.writeStartDocument();
        writer.writeName(ID_FIELD_NAME);
        this.writeValue(writer, EncoderContext.builder().build(), id);
        writer.writeEndDocument();
        return idHoldingDocument.get(ID_FIELD_NAME);
    }

    @Override
    public Document generateIdIfAbsentFromDocument(Document document) {
        if (!this.documentHasId(document)) {
            document.put(ID_FIELD_NAME, this.idGenerator.generate());
        }
        return document;
    }

    @Override
    public void encode(BsonWriter writer, Document document, EncoderContext encoderContext) {
        writer.writeStartDocument();
        this.beforeFields(writer, encoderContext, document);
        for (Map.Entry entry : document.entrySet()) {
            if (this.skipField(encoderContext, (String)entry.getKey())) continue;
            writer.writeName((String)entry.getKey());
            this.writeValue(writer, encoderContext, entry.getValue());
        }
        writer.writeEndDocument();
    }

    @Override
    public Document decode(BsonReader reader, DecoderContext decoderContext) {
        Document document = new Document();
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            document.put(fieldName, ContainerCodecHelper.readValue(reader, decoderContext, this.bsonTypeCodecMap, this.uuidRepresentation, this.registry, this.valueTransformer));
        }
        reader.readEndDocument();
        return document;
    }

    @Override
    public Class<Document> getEncoderClass() {
        return Document.class;
    }

    private void beforeFields(BsonWriter bsonWriter, EncoderContext encoderContext, Map<String, Object> document) {
        if (encoderContext.isEncodingCollectibleDocument() && document.containsKey(ID_FIELD_NAME)) {
            bsonWriter.writeName(ID_FIELD_NAME);
            this.writeValue(bsonWriter, encoderContext, document.get(ID_FIELD_NAME));
        }
    }

    private boolean skipField(EncoderContext encoderContext, String key) {
        return encoderContext.isEncodingCollectibleDocument() && key.equals(ID_FIELD_NAME);
    }

    private void writeValue(BsonWriter writer, EncoderContext encoderContext, Object value) {
        if (value == null) {
            writer.writeNull();
        } else {
            Codec<?> codec = this.registry.get(value.getClass());
            encoderContext.encodeWithChildContext(codec, writer, value);
        }
    }
}

