/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.bson.codecs;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonReader;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonType;
import io.github.apfelcreme.SupportTickets.lib.bson.Transformer;
import io.github.apfelcreme.SupportTickets.lib.bson.UuidRepresentation;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonTypeCodecMap;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Codec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.DecoderContext;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecConfigurationException;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecRegistry;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.UUID;

final class ContainerCodecHelper {
    static Object readValue(BsonReader reader, DecoderContext decoderContext, BsonTypeCodecMap bsonTypeCodecMap, UuidRepresentation uuidRepresentation, CodecRegistry registry, Transformer valueTransformer) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        Codec<Object> codec = bsonTypeCodecMap.get(bsonType);
        if (bsonType == BsonType.BINARY && reader.peekBinarySize() == 16) {
            switch (reader.peekBinarySubType()) {
                case 3: {
                    if (uuidRepresentation != UuidRepresentation.JAVA_LEGACY && uuidRepresentation != UuidRepresentation.C_SHARP_LEGACY && uuidRepresentation != UuidRepresentation.PYTHON_LEGACY) break;
                    codec = registry.get(UUID.class);
                    break;
                }
                case 4: {
                    if (uuidRepresentation != UuidRepresentation.STANDARD) break;
                    codec = registry.get(UUID.class);
                    break;
                }
            }
        }
        return valueTransformer.transform(codec.decode(reader, decoderContext));
    }

    static Codec<?> getCodec(CodecRegistry codecRegistry, Type type) {
        if (type instanceof Class) {
            return codecRegistry.get((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return codecRegistry.get((Class)parameterizedType.getRawType(), Arrays.asList(parameterizedType.getActualTypeArguments()));
        }
        throw new CodecConfigurationException("Unsupported generic type of container: " + type);
    }

    private ContainerCodecHelper() {
    }
}

