/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.bson.codecs;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonReader;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonValue;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonWriter;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonValueCodecProvider;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Codec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.DecoderContext;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.EncoderContext;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecRegistries;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecRegistry;

public class BsonValueCodec
implements Codec<BsonValue> {
    private final CodecRegistry codecRegistry;

    public BsonValueCodec() {
        this(CodecRegistries.fromProviders(new BsonValueCodecProvider()));
    }

    public BsonValueCodec(CodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    @Override
    public BsonValue decode(BsonReader reader, DecoderContext decoderContext) {
        return (BsonValue)this.codecRegistry.get(BsonValueCodecProvider.getClassForBsonType(reader.getCurrentBsonType())).decode(reader, decoderContext);
    }

    @Override
    public void encode(BsonWriter writer, BsonValue value, EncoderContext encoderContext) {
        Codec<?> codec = this.codecRegistry.get(value.getClass());
        encoderContext.encodeWithChildContext(codec, writer, value);
    }

    @Override
    public Class<BsonValue> getEncoderClass() {
        return BsonValue.class;
    }
}

