/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee.Ticket;

import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Comment;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Location;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class Ticket
implements Comparable {
    private int ticketId = -1;
    private final UUID sender;
    private UUID closed = null;
    private final List<Comment> comments;
    private final Date date;
    private String assigned = null;
    private Date assignedDate = null;
    private Date closedDate = null;
    private final String message;
    private final Location location;
    private final TicketStatus ticketStatus;

    public Ticket(UUID sender, String message, Date date, Location location, TicketStatus ticketStatus) {
        this.sender = sender;
        this.message = message;
        this.date = date;
        this.location = location;
        this.ticketStatus = ticketStatus;
        this.comments = new ArrayList<Comment>();
    }

    public Ticket(int ticketId, UUID sender, UUID closed, List<Comment> comments, Date date, String assigned, Date assignedDate, Date closedDate, String message, Location location, TicketStatus ticketStatus) {
        this.ticketId = ticketId;
        this.sender = sender;
        this.closed = closed;
        this.comments = comments;
        this.date = date;
        this.assigned = assigned;
        this.assignedDate = assignedDate;
        this.closedDate = closedDate;
        this.message = message;
        this.location = location;
        this.ticketStatus = ticketStatus;
    }

    public int getTicketId() {
        return this.ticketId;
    }

    public void setTicketId(int ticketId) {
        this.ticketId = ticketId;
    }

    public UUID getSender() {
        return this.sender;
    }

    public String getAssigned() {
        return this.assigned;
    }

    public void setAssigned(String assigned) {
        this.assigned = assigned;
    }

    public UUID getClosed() {
        return this.closed;
    }

    public void setClosed(UUID closed) {
        this.closed = closed;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public Date getDate() {
        return this.date;
    }

    public Date getAssignedDate() {
        return this.assignedDate;
    }

    public void setAssignedDate(Date assignedDate) {
        this.assignedDate = assignedDate;
    }

    public Date getClosedDate() {
        return this.closedDate;
    }

    public void setClosedDate(Date closedDate) {
        this.closedDate = closedDate;
    }

    public String getMessage() {
        return this.message;
    }

    public Location getLocation() {
        return this.location;
    }

    public TicketStatus getTicketStatus() {
        return this.ticketStatus;
    }

    public int compareTo(Object o) {
        return Integer.compare(this.ticketId, ((Ticket)o).getTicketId());
    }

    public static enum TicketStatus {
        OPEN,
        CLOSED,
        REOPENED,
        ASSIGNED;


        public Integer toInt() {
            switch (this.ordinal()) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            return 0;
        }

        public static TicketStatus fromInt(Integer status) {
            switch (status) {
                case 0: {
                    return OPEN;
                }
                case 1: {
                    return CLOSED;
                }
                case 2: {
                    return REOPENED;
                }
                case 3: {
                    return ASSIGNED;
                }
            }
            return null;
        }
    }
}

