/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee;

import io.github.apfelcreme.SupportTickets.Bungee.SupportTickets;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class SupportTicketsConfig {
    private Configuration configuration;
    private Configuration languageConfiguration;
    private final ConfigurationProvider yamlProvider = ConfigurationProvider.getProvider(YamlConfiguration.class);

    public SupportTicketsConfig() {
        File configurationFile = new File(String.valueOf(SupportTickets.getInstance().getDataFolder().getAbsoluteFile()) + "/config.yml");
        try {
            if (!SupportTickets.getInstance().getDataFolder().exists()) {
                SupportTickets.getInstance().getDataFolder().mkdir();
            }
            if (!configurationFile.exists()) {
                this.createConfigFile("config.yml", configurationFile);
            }
            this.configuration = this.yamlProvider.load(configurationFile);
            for (ServerInfo serverInfo : ProxyServer.getInstance().getServers().values()) {
                if (this.configuration.get("disabledWorlds." + serverInfo.getAddress().getHostName() + "." + serverInfo.getAddress().getPort()) != null) continue;
                this.configuration.set("disabledWorlds." + serverInfo.getAddress().getHostName() + "." + serverInfo.getAddress().getPort(), (Object)"");
            }
            this.yamlProvider.save(this.configuration, configurationFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File languageConfigurationFile = new File(String.valueOf(SupportTickets.getInstance().getDataFolder().getAbsoluteFile()) + "/lang." + this.getLanguage() + ".yml");
        try {
            if (!languageConfigurationFile.exists()) {
                this.createConfigFile("lang.de.yml", languageConfigurationFile);
            }
            this.languageConfiguration = this.yamlProvider.load(languageConfigurationFile);
            this.yamlProvider.save(this.languageConfiguration, languageConfigurationFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        File configurationFile = new File(String.valueOf(SupportTickets.getInstance().getDataFolder().getAbsoluteFile()) + "/config.yml");
        File languageConfigurationFile = new File(String.valueOf(SupportTickets.getInstance().getDataFolder().getAbsoluteFile()) + "/lang." + this.getLanguage() + ".yml");
        try {
            this.yamlProvider.save(this.configuration, configurationFile);
            this.yamlProvider.save(this.languageConfiguration, languageConfigurationFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createConfigFile(String source, File dest) throws IOException {
        Configuration configuration = this.yamlProvider.load((Reader)new InputStreamReader(SupportTickets.getInstance().getResourceAsStream(source)));
        this.yamlProvider.save(configuration, dest);
    }

    public String getLanguage() {
        return this.configuration.getString("lang", "de");
    }

    public DB getDb() {
        if (this.configuration.getString("db").equalsIgnoreCase("MySQL")) {
            return DB.MySQL;
        }
        if (this.configuration.getString("db").equalsIgnoreCase("MongoDb")) {
            return DB.MongoDB;
        }
        return DB.MySQL;
    }

    public String getSqlUser() {
        return this.configuration.getString("sql.user");
    }

    public String getSqlPassword() {
        return this.configuration.getString("sql.password");
    }

    public String getSqlDatabase() {
        return this.configuration.getString("sql.database");
    }

    public String getSqlUrl() {
        return this.configuration.getString("sql.url");
    }

    public String getMongoHost() {
        return this.configuration.getString("mongo.host");
    }

    public int getMongoPort() {
        return this.configuration.getInt("mongo.port");
    }

    public String getMongoUser() {
        return this.configuration.getString("mongo.user");
    }

    public String getMongoPass() {
        return this.configuration.getString("mongo.pass");
    }

    public String getMongoAuthDb() {
        return this.configuration.getString("mongo.authdb");
    }

    public String getMongoDatabase() {
        return this.configuration.getString("mongo.database");
    }

    public String getMongoCollection() {
        return this.configuration.getString("mongo.collection");
    }

    public String getTicketTable() {
        return this.configuration.getString("sql.tables.tickets");
    }

    public String getCommentTable() {
        return this.configuration.getString("sql.tables.comments");
    }

    public String getPlayerTable() {
        return this.configuration.getString("sql.tables.players");
    }

    public int getPageSize() {
        return this.configuration.getInt("pageSize");
    }

    public int getTopListSize() {
        return this.configuration.getInt("topListSize");
    }

    public int getReminderTaskDelay() {
        return this.configuration.getInt("reminderTaskDelay");
    }

    public String getAPINameUrl() {
        return this.configuration.getString("apiUrlName");
    }

    public String getAPIUUIDUrl() {
        return this.configuration.getString("apiUrlUUID");
    }

    public Configuration getLanguageConfiguration() {
        return this.languageConfiguration;
    }

    public String getText(String key) {
        String ret = (String)this.languageConfiguration.get("texts." + key);
        if (ret != null && !ret.isEmpty()) {
            ret = ChatColor.translateAlternateColorCodes((char)'&', (String)ret);
            return ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)ret);
        }
        return "Missing text node: " + key;
    }

    public static enum DB {
        MySQL,
        MongoDB;

    }
}

