/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee;

import de.themoep.serverclusters.bungee.ServerClusters;
import io.github.apfelcreme.SupportTickets.Bungee.Command.AssignCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Command.CloseCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Command.ClosedCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Command.CommentCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Command.HelpCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Command.InfoCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Command.ListCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Command.MarkReadCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Command.NewCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Command.OpenedCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Command.RadiusCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Command.ReloadCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Command.ReopenCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Command.TopCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Command.UnassignCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Command.ViewCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Command.WarpCommand;
import io.github.apfelcreme.SupportTickets.Bungee.CommandExecutor;
import io.github.apfelcreme.SupportTickets.Bungee.Database.Controller.DatabaseController;
import io.github.apfelcreme.SupportTickets.Bungee.Database.Controller.MongoController;
import io.github.apfelcreme.SupportTickets.Bungee.Database.Controller.SQLController;
import io.github.apfelcreme.SupportTickets.Bungee.Listener.PlayerLoginListener;
import io.github.apfelcreme.SupportTickets.Bungee.Message.BukkitMessageListener;
import io.github.apfelcreme.SupportTickets.Bungee.SupportTicketsConfig;
import io.github.apfelcreme.SupportTickets.Bungee.Task.ReminderTask;
import io.github.apfelcreme.SupportTickets.lib.minedown.MineDown;
import io.github.apfelcreme.SupportTickets.lib.minedown.Replacer;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.zaiyers.UUIDDB.core.UUIDDBPlugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SupportTickets
extends Plugin {
    private DatabaseController databaseController = null;
    private Map<String, UUID> uuidCache = null;
    private UUIDDBPlugin uuidDb = null;
    private ServerClusters serverClusters = null;
    private SupportTicketsConfig config;
    private Map<String, Set<Integer>> shownTicketsCache = new HashMap<String, Set<Integer>>();

    public static SupportTickets getInstance() {
        return (SupportTickets)ProxyServer.getInstance().getPluginManager().getPlugin("SupportTickets");
    }

    public DatabaseController getDatabaseController() {
        return this.databaseController;
    }

    public void onEnable() {
        if (this.getProxy().getPluginManager().getPlugin("UUIDDB") != null) {
            this.uuidDb = (UUIDDBPlugin)this.getProxy().getPluginManager().getPlugin("UUIDDB");
        }
        if (this.getProxy().getPluginManager().getPlugin("ServerClusters") != null) {
            this.serverClusters = (ServerClusters)this.getProxy().getPluginManager().getPlugin("ServerClusters");
        }
        this.uuidCache = new HashMap<String, UUID>();
        this.loadConfig();
        CommandExecutor ticketCommand = new CommandExecutor(this, "ticket", null, "ti", "petition", "pe");
        ticketCommand.registerSubCommand(new AssignCommand(this, "assign", "<#> [<player>]", "SupportTickets.mod", new String[0]));
        ticketCommand.registerSubCommand(new CloseCommand(this, "close", "<#> [<reason>]", "SupportTickets.user", new String[0]));
        ticketCommand.registerSubCommand(new ClosedCommand(this, "closed", "<player> [<#page>]", "SupportTickets.mod", new String[0]));
        ticketCommand.registerSubCommand(new CommentCommand(this, "comment", "<#> <comment>", "SupportTickets.user", "log"));
        ticketCommand.registerSubCommand(new HelpCommand(this, "help"));
        ticketCommand.registerSubCommand(new InfoCommand(this, "info", "<#>", "SupportTickets.mod", new String[0]));
        ticketCommand.registerSubCommand(new ListCommand(this, "list", "[[<status>] [<#page>]]", "SupportTickets.user", "show"));
        ticketCommand.registerSubCommand(new MarkReadCommand(this, "markread", "", "SupportTickets.user", "markallread"));
        ticketCommand.registerSubCommand(new NewCommand(this, "new", "<text>", "SupportTickets.user", "open", "create", "neu"));
        ticketCommand.registerSubCommand(new OpenedCommand(this, "opened", "<player> [<#page>]", "SupportTickets.mod", new String[0]));
        ticketCommand.registerSubCommand(new RadiusCommand(this, "radius", "[<#radius>]", "SupportTickets.mod", new String[0]));
        ticketCommand.registerSubCommand(new ReloadCommand(this, "reload", "", "SupportTickets.mod", new String[0]));
        ticketCommand.registerSubCommand(new ReopenCommand(this, "reopen", "<#>", "SupportTickets.mod", new String[0]));
        ticketCommand.registerSubCommand(new TopCommand(this, "top", "", "SupportTickets.mod", new String[0]));
        ticketCommand.registerSubCommand(new UnassignCommand(this, "unassign", "<#>", "SupportTickets.mod", new String[0]));
        ticketCommand.registerSubCommand(new ViewCommand(this, "view", "<#>", "SupportTickets.user", new String[0]));
        ticketCommand.registerSubCommand(new WarpCommand(this, "warp", "<#> [<#comment>]", "SupportTickets.mod", "goto", "tp"));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)ticketCommand);
        this.getProxy().registerChannel("tickets:requestpos");
        this.getProxy().registerChannel("tickets:warp");
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new BukkitMessageListener(this));
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new PlayerLoginListener(this));
        this.getProxy().getScheduler().schedule((Plugin)this, (Runnable)new ReminderTask(this), (long)this.getConfig().getReminderTaskDelay(), TimeUnit.MINUTES);
    }

    public void loadConfig() {
        this.config = new SupportTicketsConfig();
        switch (this.getConfig().getDb()) {
            case MySQL: {
                this.databaseController = new SQLController(this);
                break;
            }
            case MongoDB: {
                this.databaseController = new MongoController(this);
            }
        }
    }

    public void onDisable() {
        this.databaseController.disable();
    }

    public BaseComponent[] getMessage(String key, String ... repl) {
        return this.getMessage(key, (Map<String, BaseComponent[]>)null, repl);
    }

    public BaseComponent[] getMessage(String key, Map<String, BaseComponent[]> compRepl, String ... repl) {
        return new MineDown(this.getConfig().getText(key)).placeholderPrefix("{").placeholderSuffix("}").replace(compRepl).replace("prefix", this.getPrefix()).replace(SupportTickets.getReplacementsWithIndexes(repl)).toComponent();
    }

    public void sendMessage(CommandSender receiver, String key, String ... repl) {
        this.sendMessage(receiver, key, (Map<String, BaseComponent[]>)null, repl);
    }

    public void sendMessage(CommandSender receiver, String key, Map<String, BaseComponent[]> compRepl, String ... repl) {
        if (receiver != null && key != null) {
            receiver.sendMessage(this.getMessage(key, compRepl, repl));
        }
    }

    public void sendMessage(CommandSender receiver, String key, Map<String, BaseComponent[]> repl) {
        if (receiver != null && key != null) {
            receiver.sendMessage(new MineDown(this.getConfig().getText(key)).placeholderPrefix("{").placeholderSuffix("}").replace("prefix", this.getPrefix()).replace(SupportTickets.getReplacementsWithIndexes(repl)).toComponent());
        }
    }

    public void sendMessage(UUID uuid, String key, String ... repl) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
        if (player != null) {
            this.sendMessage((CommandSender)player, key, repl);
        }
    }

    public void sendTeamMessage(String key, String ... repl) {
        this.sendMessage("SupportTickets.mod", key, repl);
    }

    public void sendMessage(String permission, String key, String ... repl) {
        for (ProxiedPlayer receiver : ProxyServer.getInstance().getPlayers()) {
            if (!receiver.hasPermission(permission)) continue;
            this.sendMessage((CommandSender)receiver, key, repl);
        }
    }

    public String getPrefix() {
        return this.getConfig().getText("prefix");
    }

    public boolean isPlayerOnline(UUID uuid) {
        for (ProxiedPlayer player : this.getProxy().getPlayers()) {
            if (!player.getUniqueId().equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public String getNameByUUID(UUID uuid) {
        if (uuid.equals(new UUID(0L, 0L))) {
            return "[Console]";
        }
        String name = null;
        if (this.uuidDb != null) {
            name = this.uuidDb.getStorage().getNameByUUID(uuid);
        } else if (this.uuidCache.containsValue(uuid)) {
            for (Map.Entry<String, UUID> entry : this.uuidCache.entrySet()) {
                if (!entry.getValue().equals(uuid)) continue;
                name = entry.getKey();
                break;
            }
        }
        if (name == null) {
            try {
                int read;
                URL url = new URL(this.getConfig().getAPINameUrl().replace("{0}", uuid.toString().replace("-", "")));
                BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                StringBuilder json = new StringBuilder();
                while ((read = in.read()) != -1) {
                    json.append((char)read);
                }
                Object obj = new JSONParser().parse(json.toString());
                JSONArray jsonArray = (JSONArray)obj;
                name = (String)((JSONObject)jsonArray.get(jsonArray.size() - 1)).get((Object)"name");
                if (this.uuidDb != null) {
                    this.uuidDb.getStorage().insert(uuid, name);
                } else {
                    this.uuidCache.put(name, uuid);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return name != null ? name : "Unknown Player";
    }

    public UUID getUUIDByName(String name) {
        if ("[Console]".equalsIgnoreCase(name)) {
            return new UUID(0L, 0L);
        }
        UUID uuid = null;
        if (this.uuidDb != null) {
            String uuidStr = this.uuidDb.getStorage().getUUIDByName(name, false);
            uuid = UUID.fromString(uuidStr);
        } else if (this.uuidCache.containsKey(name)) {
            uuid = this.uuidCache.get(name);
        } else {
            for (Map.Entry entry : this.uuidCache.entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase(name)) continue;
                uuid = (UUID)entry.getValue();
                break;
            }
        }
        if (uuid == null) {
            try {
                int read;
                URL url = new URL(this.getConfig().getAPIUUIDUrl().replace("{0}", name));
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
                StringBuilder json = new StringBuilder();
                while ((read = bufferedReader.read()) != -1) {
                    json.append((char)read);
                }
                if (json.length() == 0) {
                    return null;
                }
                JSONObject jsonObject = (JSONObject)new JSONParser().parse(json.toString());
                name = jsonObject.get((Object)"name").toString();
                String id = jsonObject.get((Object)"id").toString();
                uuid = UUID.fromString(id.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
                if (this.uuidDb != null) {
                    this.uuidDb.getStorage().insert(uuid, name);
                } else {
                    this.uuidCache.put(name, uuid);
                }
                return uuid;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return uuid;
    }

    public static String join(Object[] array, String separator, String lastSeparator) {
        int noOfItems;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        if (lastSeparator == null) {
            lastSeparator = separator;
        }
        if ((noOfItems = array.length) <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(noOfItems * 16);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                if (i < array.length - 1) {
                    buf.append(separator);
                } else {
                    buf.append(lastSeparator);
                }
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static boolean isNumeric(String string) {
        return Pattern.matches("([0-9])*", string);
    }

    public static String replace(String text, String ... repl) {
        return new Replacer().placeholderPrefix("{").placeholderSuffix("}").replace(SupportTickets.getReplacementsWithIndexes(repl)).replaceIn(text);
    }

    private static Map<String, String> getReplacementsWithIndexes(String ... repl) {
        LinkedHashMap<String, String> replacements = new LinkedHashMap<String, String>();
        int i = 0;
        while (i + 1 < repl.length) {
            replacements.put(repl[i], repl[i + 1]);
            replacements.put(String.valueOf(i / 2), repl[i + 1]);
            i += 2;
        }
        return replacements;
    }

    private static Map<String, BaseComponent[]> getReplacementsWithIndexes(Map<String, BaseComponent[]> repl) {
        LinkedHashMap<String, BaseComponent[]> replacements = new LinkedHashMap<String, BaseComponent[]>();
        int i = 0;
        for (Map.Entry<String, BaseComponent[]> entry : repl.entrySet()) {
            replacements.put(entry.getKey(), entry.getValue());
            replacements.put(String.valueOf(i), entry.getValue());
            ++i;
        }
        return replacements;
    }

    public static ServerInfo getServer(String server) {
        ServerInfo sInfo = ProxyServer.getInstance().getServerInfo(server);
        if (sInfo != null) {
            return sInfo;
        }
        try {
            InetSocketAddress address = new InetSocketAddress(server.split(":")[0], Integer.parseInt(server.split(":")[1]));
            for (ServerInfo serverInfo : ProxyServer.getInstance().getServers().values()) {
                if (!serverInfo.getAddress().equals(address)) continue;
                return serverInfo;
            }
        }
        catch (NumberFormatException e) {
            SupportTickets.getInstance().getLogger().log(Level.SEVERE, "Error while getting server '" + server + "'!", e);
        }
        return null;
    }

    public static String formatDate(Date date) {
        Calendar now = Calendar.getInstance();
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(date);
        Object format = "HH:mm";
        if (now.get(1) != dateCal.get(1)) {
            format = "dd.MM.yy " + (String)format;
        } else if (now.get(6) != dateCal.get(6)) {
            format = "dd.MM. " + (String)format;
        }
        return new SimpleDateFormat((String)format).format(date);
    }

    public SupportTicketsConfig getConfig() {
        return this.config;
    }

    public void addShownTicket(CommandSender sender, int ticketId) {
        Set<Integer> senderTickets = this.shownTicketsCache.get(sender.getName().toLowerCase());
        if (senderTickets == null) {
            senderTickets = new HashSet<Integer>();
        }
        if (senderTickets.size() > 100) {
            Iterator<Integer> ticketIt = senderTickets.iterator();
            while (senderTickets.size() > 100 && ticketIt.hasNext()) {
                ticketIt.next();
                ticketIt.remove();
            }
        }
        senderTickets.add(ticketId);
        this.shownTicketsCache.put(sender.getName().toLowerCase(), senderTickets);
    }

    public Set<Integer> getLastShownTickets(CommandSender sender) {
        HashSet senderTickets = this.shownTicketsCache.get(sender.getName().toLowerCase());
        return senderTickets != null ? senderTickets : new HashSet();
    }

    public ServerClusters getServerClusters() {
        return this.serverClusters;
    }
}

