/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee.Message;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.github.apfelcreme.SupportTickets.Bungee.SupportTickets;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Location;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class BukkitMessenger {
    private static Map<UUID, Consumer<Location>> queuedPositionRequests = new ConcurrentHashMap<UUID, Consumer<Location>>();

    public static void fetchPosition(CommandSender sender, Consumer<Location> answer) {
        if (sender instanceof ProxiedPlayer) {
            ProxiedPlayer player = (ProxiedPlayer)sender;
            ServerInfo target = player.getServer().getInfo();
            if (target != null) {
                queuedPositionRequests.put(player.getUniqueId(), answer);
                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                out.writeUTF(player.getUniqueId().toString());
                target.sendData("tickets:requestpos", out.toByteArray());
            } else {
                answer.accept(null);
            }
        } else {
            answer.accept(null);
        }
    }

    public static void warp(UUID uuid, Location location) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
        if (player != null) {
            try {
                ServerInfo serverInfo = SupportTickets.getServer(location.getServer());
                if (serverInfo != null) {
                    if (SupportTickets.getInstance().getServerClusters() != null) {
                        SupportTickets.getInstance().getServerClusters().getTeleportUtils().teleportToLocation(player, serverInfo, location.getWorldName(), location.getLocationX(), location.getLocationY(), location.getLocationZ(), (float)location.getYaw(), (float)location.getPitch());
                    } else {
                        if (!player.getServer().getInfo().equals((Object)serverInfo) && serverInfo.getAddress().getAddress().isReachable(2000)) {
                            player.connect(serverInfo);
                        }
                        ByteArrayDataOutput out = ByteStreams.newDataOutput();
                        out.writeUTF(uuid.toString());
                        out.writeUTF(location.getWorldName());
                        out.writeDouble(location.getLocationX());
                        out.writeDouble(location.getLocationY());
                        out.writeDouble(location.getLocationZ());
                        out.writeDouble(location.getYaw());
                        out.writeDouble(location.getPitch());
                        serverInfo.sendData("tickets:warp", out.toByteArray());
                    }
                } else {
                    SupportTickets.getInstance().getLogger().log(Level.WARNING, "No server found for '" + location.getServer() + "'!");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static Consumer<Location> getQueuedPositionAnswer(UUID uuid) {
        return queuedPositionRequests.get(uuid);
    }
}

