/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee.Message;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import io.github.apfelcreme.SupportTickets.Bungee.Message.BukkitMessenger;
import io.github.apfelcreme.SupportTickets.Bungee.SupportTickets;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Location;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Consumer;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class BukkitMessageListener
implements Listener {
    private final SupportTickets plugin;

    public BukkitMessageListener(SupportTickets plugin) {
        this.plugin = plugin;
        plugin.getProxy().registerChannel("tickets:position");
    }

    @EventHandler
    public void onPluginMessageReceived(PluginMessageEvent event) throws IOException {
        if (!event.getTag().startsWith("tickets:")) {
            return;
        }
        if (!(event.getSender() instanceof Server)) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])event.getData());
        if (event.getTag().equals("tickets:position")) {
            UUID uuid = UUID.fromString(in.readUTF());
            Consumer<Location> answer = BukkitMessenger.getQueuedPositionAnswer(uuid);
            if (answer == null) {
                return;
            }
            String server = in.readUTF();
            ServerInfo serverInfo = SupportTickets.getServer(server);
            if (serverInfo != null) {
                server = serverInfo.getName();
            } else {
                ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
                if (player != null && player.getServer() != null && player.getServer().getInfo() != null) {
                    server = player.getServer().getInfo().getName();
                }
            }
            Location location = new Location(server, in.readUTF(), in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble());
            answer.accept(location);
        }
    }
}

