/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee.Listener;

import com.google.common.collect.ImmutableMap;
import io.github.apfelcreme.SupportTickets.Bungee.SupportTickets;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Comment;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Ticket;
import io.github.apfelcreme.SupportTickets.lib.minedown.MineDown;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class PlayerLoginListener
implements Listener {
    private final SupportTickets plugin;

    public PlayerLoginListener(SupportTickets plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerLogin(PostLoginEvent event) {
        ProxyServer.getInstance().getScheduler().schedule((Plugin)SupportTickets.getInstance(), () -> {
            List<Ticket> tickets = this.plugin.getDatabaseController().getTicketsOpenedBy(event.getPlayer().getUniqueId());
            ArrayList<String> ticketEntries = new ArrayList<String>();
            String entry = this.plugin.getConfig().getText("info.login.ticketEntry");
            block0: for (Ticket ticket : tickets) {
                for (Comment comment : ticket.getComments()) {
                    if (comment.getSenderHasNoticed()) continue;
                    ticketEntries.add(SupportTickets.replace(entry, "ticket", String.valueOf(ticket.getTicketId())));
                    continue block0;
                }
            }
            if (ticketEntries.size() > 0) {
                if (ticketEntries.size() == 1) {
                    this.plugin.sendMessage((CommandSender)event.getPlayer(), "info.login.newCommentsSingular", (Map<String, BaseComponent[]>)ImmutableMap.of((Object)"ticket", (Object)MineDown.parse((String)ticketEntries.get(0), new String[0])));
                } else {
                    this.plugin.sendMessage((CommandSender)event.getPlayer(), "info.login.newCommentsPlural", (Map<String, BaseComponent[]>)ImmutableMap.of((Object)"tickets", (Object)MineDown.parse(SupportTickets.join(ticketEntries.toArray(), String.valueOf(ChatColor.WHITE) + ", ", String.valueOf(ChatColor.WHITE) + " & "), new String[0])));
                }
            }
        }, 2L, TimeUnit.SECONDS);
    }
}

