/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee.Database.Controller;

import io.github.apfelcreme.SupportTickets.Bungee.Database.Connector.MySQLConnector;
import io.github.apfelcreme.SupportTickets.Bungee.Database.Controller.DatabaseController;
import io.github.apfelcreme.SupportTickets.Bungee.SupportTickets;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Comment;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Location;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Ticket;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.plugin.Plugin;

public class SQLController
implements DatabaseController {
    private final SupportTickets plugin;
    private final MySQLConnector connector;

    public SQLController(SupportTickets plugin) {
        this.plugin = plugin;
        this.connector = new MySQLConnector(plugin);
        this.connector.initConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Ticket loadTicket(Integer ticketId) {
        try (Connection connection = this.connector.getConnection();){
            PreparedStatement statement = connection.prepareStatement("Select *, (Select uuid from " + this.plugin.getConfig().getPlayerTable() + " where player_id = t.closed_player_id) as uuidPlayerClosed  from " + this.plugin.getConfig().getTicketTable() + " t left join " + this.plugin.getConfig().getPlayerTable() + " p on p.player_id = t.player_id where t.ticket_id = ?");
            statement.setInt(1, ticketId);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.first()) return null;
            Ticket ticket = this.buildTicket(resultSet);
            return ticket;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int saveTicket(Ticket ticket) {
        try (Connection connection = this.connector.getConnection();){
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO " + this.plugin.getConfig().getPlayerTable() + " (uuid, name) VALUES (?, ?) ON DUPLICATE KEY UPDATE name = ?");
            preparedStatement.setString(1, ticket.getSender().toString());
            preparedStatement.setString(2, this.plugin.getNameByUUID(ticket.getSender()));
            preparedStatement.setString(3, this.plugin.getNameByUUID(ticket.getSender()));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement("INSERT INTO " + this.plugin.getConfig().getTicketTable() + " (player_id, message, time_stamp, status" + (ticket.getLocation() != null ? ", server, world, loc_X, loc_Y, loc_Z, yaw, pitch" : "") + ") VALUES ((Select player_id from " + this.plugin.getConfig().getPlayerTable() + " where uuid = ?), ?, ?, ?" + (ticket.getLocation() != null ? ", ?, ?, ?, ?, ?, ?, ?" : "") + ");", 1);
            preparedStatement.setString(1, ticket.getSender().toString());
            preparedStatement.setString(2, ticket.getMessage());
            preparedStatement.setLong(3, ticket.getDate().getTime());
            preparedStatement.setInt(4, ticket.getTicketStatus().toInt());
            if (ticket.getLocation() != null) {
                preparedStatement.setString(5, ticket.getLocation().getServer());
                preparedStatement.setString(6, ticket.getLocation().getWorldName());
                preparedStatement.setDouble(7, ticket.getLocation().getLocationX());
                preparedStatement.setDouble(8, ticket.getLocation().getLocationY());
                preparedStatement.setDouble(9, ticket.getLocation().getLocationZ());
                preparedStatement.setDouble(10, ticket.getLocation().getYaw());
                preparedStatement.setDouble(11, ticket.getLocation().getPitch());
            }
            preparedStatement.executeUpdate();
            ResultSet resultSet = preparedStatement.getGeneratedKeys();
            if (!resultSet.next()) return -1;
            int n = resultSet.getInt(1);
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return -1;
    }

    @Override
    public void assignTicket(Ticket ticket, String to) {
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE " + this.plugin.getConfig().getTicketTable() + " SET assigned = ?, assigned_time_stamp = ?, status = ? where ticket_id = ?");
                preparedStatement.setString(1, to);
                preparedStatement.setLong(2, new Date().getTime());
                preparedStatement.setInt(3, Ticket.TicketStatus.ASSIGNED.toInt());
                preparedStatement.setInt(4, ticket.getTicketId());
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void unassignTicket(Ticket ticket) {
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE " + this.plugin.getConfig().getTicketTable() + " SET assigned = null, assigned_time_stamp = null, status = ? where ticket_id = ?");
                preparedStatement.setInt(1, Ticket.TicketStatus.OPEN.toInt());
                preparedStatement.setInt(2, ticket.getTicketId());
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void closeTicket(Ticket ticket, UUID closer, String reason) {
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO " + this.plugin.getConfig().getPlayerTable() + " (uuid, name) VALUES (?, ?) ON DUPLICATE KEY UPDATE name = ?");
                preparedStatement.setString(1, ticket.getSender().toString());
                preparedStatement.setString(2, this.plugin.getNameByUUID(ticket.getSender()));
                preparedStatement.setString(3, this.plugin.getNameByUUID(ticket.getSender()));
                preparedStatement.executeUpdate();
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("UPDATE " + this.plugin.getConfig().getTicketTable() + " SET closed_player_id = (Select player_id from " + this.plugin.getConfig().getPlayerTable() + " where uuid = ?), closed_time_stamp = ?, closed_reason = ?, status = ? where ticket_id = ?");
                preparedStatement.setString(1, closer.toString());
                preparedStatement.setLong(2, new Date().getTime());
                preparedStatement.setString(3, reason);
                preparedStatement.setInt(4, Ticket.TicketStatus.CLOSED.toInt());
                preparedStatement.setInt(5, ticket.getTicketId());
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void reopenTicket(Ticket ticket) {
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                if (connection != null) {
                    PreparedStatement preparedStatement = connection.prepareStatement("UPDATE " + this.plugin.getConfig().getTicketTable() + " SET status = ?, closed_player_id = null, closed_reason = null, closed_time_stamp = null WHERE ticket_id = ?");
                    preparedStatement.setInt(1, Ticket.TicketStatus.REOPENED.toInt());
                    preparedStatement.setInt(2, ticket.getTicketId());
                    preparedStatement.executeUpdate();
                    preparedStatement.close();
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public List<Ticket> getTickets(Ticket.TicketStatus ... ticketStatus) {
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        try (Connection connection = this.connector.getConnection();){
            Object sqlReplace = "";
            for (int i = 0; i < ticketStatus.length; ++i) {
                sqlReplace = (String)sqlReplace + " t.status = " + ticketStatus[i].toInt();
                if (i >= ticketStatus.length - 1) continue;
                sqlReplace = (String)sqlReplace + " or ";
            }
            PreparedStatement statement = connection.prepareStatement("Select *, (Select uuid from " + this.plugin.getConfig().getPlayerTable() + " where player_id = t.closed_player_id) as uuidPlayerClosed  from " + this.plugin.getConfig().getTicketTable() + " t left join " + this.plugin.getConfig().getPlayerTable() + " p on p.player_id = t.player_id where " + (String)sqlReplace);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                tickets.add(this.buildTicket(resultSet));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tickets;
    }

    @Override
    public List<Ticket> getTicketsClosedBy(UUID closer) {
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        try (Connection connection = this.connector.getConnection();){
            PreparedStatement statement = connection.prepareStatement("Select *, (Select uuid from " + this.plugin.getConfig().getPlayerTable() + " where player_id = t.closed_player_id) as uuidPlayerClosed from " + this.plugin.getConfig().getTicketTable() + " t left join " + this.plugin.getConfig().getPlayerTable() + " p on p.player_id = t.closed_player_id where p.uuid = ?");
            statement.setString(1, closer.toString());
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                tickets.add(this.buildTicket(resultSet));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tickets;
    }

    @Override
    public List<Ticket> getTicketsOpenedBy(UUID opener) {
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        try (Connection connection = this.connector.getConnection();){
            PreparedStatement statement = connection.prepareStatement("Select *, (Select uuid from " + this.plugin.getConfig().getPlayerTable() + " where player_id = t.closed_player_id) as uuidPlayerClosed  from " + this.plugin.getConfig().getTicketTable() + " t left join " + this.plugin.getConfig().getPlayerTable() + " p on p.player_id = t.player_id where p.uuid = ?");
            statement.setString(1, opener.toString());
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                tickets.add(this.buildTicket(resultSet));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tickets;
    }

    @Override
    public List<Ticket> getPlayerTickets(UUID uuid, Ticket.TicketStatus ... ticketStatus) {
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        try (Connection connection = this.connector.getConnection();){
            Object sqlReplace = "";
            for (int i = 0; i < ticketStatus.length; ++i) {
                sqlReplace = (String)sqlReplace + " t.status = " + ticketStatus[i].toInt();
                if (i >= ticketStatus.length - 1) continue;
                sqlReplace = (String)sqlReplace + " or ";
            }
            PreparedStatement statement = connection.prepareStatement("Select *, (Select uuid from " + this.plugin.getConfig().getPlayerTable() + " where player_id = t.closed_player_id) as uuidPlayerClosed from " + this.plugin.getConfig().getTicketTable() + " t left join " + this.plugin.getConfig().getPlayerTable() + " p on p.player_id = t.player_id where p.uuid = ? and " + (String)sqlReplace);
            statement.setString(1, uuid.toString());
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                tickets.add(this.buildTicket(resultSet));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tickets;
    }

    @Override
    public List<Ticket> getTicketsInRadius(Location location, int radius) {
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        try (Connection connection = this.connector.getConnection();){
            PreparedStatement statement = connection.prepareStatement("Select *, (Select uuid from " + this.plugin.getConfig().getPlayerTable() + " where player_id = t.closed_player_id) as uuidPlayerClosed from " + this.plugin.getConfig().getTicketTable() + " t left join " + this.plugin.getConfig().getPlayerTable() + " p on p.player_id = t.player_id where server = ? and world = ? and (loc_X between ? and ?) and (loc_Y between ? and ?) and (loc_Z between ? and ?)");
            statement.setString(1, location.getServer());
            statement.setString(2, location.getWorldName());
            statement.setDouble(3, location.getLocationX() - (double)radius);
            statement.setDouble(4, location.getLocationX() + (double)radius);
            statement.setDouble(5, location.getLocationY() - (double)radius);
            statement.setDouble(6, location.getLocationY() + (double)radius);
            statement.setDouble(7, location.getLocationZ() - (double)radius);
            statement.setDouble(8, location.getLocationZ() + (double)radius);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                tickets.add(this.buildTicket(resultSet));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tickets;
    }

    @Override
    public void saveComment(Comment comment) {
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO " + this.plugin.getConfig().getPlayerTable() + " (uuid, name) VALUES (?, ?) ON DUPLICATE KEY UPDATE name = ?");
                preparedStatement.setString(1, comment.getSender().toString());
                preparedStatement.setString(2, this.plugin.getNameByUUID(comment.getSender()));
                preparedStatement.setString(3, this.plugin.getNameByUUID(comment.getSender()));
                preparedStatement.executeUpdate();
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("INSERT INTO " + this.plugin.getConfig().getCommentTable() + " (ticket_id, player_id, time_stamp, comment, sender_has_noticed" + (comment.getLocation() != null ? ", server, world, loc_X, loc_Y, loc_Z, yaw, pitch" : "") + ") VALUES(?, (Select player_id from " + this.plugin.getConfig().getPlayerTable() + " where uuid = ?), ?, ?, ?" + (comment.getLocation() != null ? ", ?, ?, ?, ?, ?, ?, ?" : "") + ")");
                preparedStatement.setInt(1, comment.getTicketId());
                preparedStatement.setString(2, comment.getSender().toString());
                preparedStatement.setLong(3, comment.getDate().getTime());
                preparedStatement.setString(4, comment.getComment());
                preparedStatement.setBoolean(5, comment.getSenderHasNoticed());
                if (comment.getLocation() != null) {
                    preparedStatement.setString(6, comment.getLocation().getServer());
                    preparedStatement.setString(7, comment.getLocation().getWorldName());
                    preparedStatement.setDouble(8, comment.getLocation().getLocationX());
                    preparedStatement.setDouble(9, comment.getLocation().getLocationY());
                    preparedStatement.setDouble(10, comment.getLocation().getLocationZ());
                    preparedStatement.setDouble(11, comment.getLocation().getYaw());
                    preparedStatement.setDouble(12, comment.getLocation().getPitch());
                }
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void setCommentRead(Comment comment) {
        if (comment.getCommentId() == -1) {
            return;
        }
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement statement = connection.prepareStatement("UPDATE " + this.plugin.getConfig().getCommentTable() + " SET sender_has_noticed = 1 WHERE comment_id = ?");
                statement.setInt(1, comment.getCommentId());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void disable() {
        this.connector.close();
    }

    private Ticket buildTicket(ResultSet resultSet) throws SQLException {
        Ticket ticket = new Ticket(UUID.fromString(resultSet.getString("uuid")), resultSet.getString("message"), new Date(resultSet.getLong("time_stamp")), SQLController.hasLocation(resultSet) ? new Location(resultSet.getString("server"), resultSet.getString("world"), resultSet.getDouble("loc_X"), resultSet.getDouble("loc_Y"), resultSet.getDouble("loc_Z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch")) : null, Ticket.TicketStatus.fromInt(resultSet.getInt("status")));
        ticket.setTicketId(resultSet.getInt("ticket_id"));
        if (resultSet.getString("assigned") != null) {
            ticket.setAssigned(resultSet.getString("assigned"));
            ticket.setAssignedDate(resultSet.getDate("assigned_time_stamp"));
        }
        if (resultSet.getString("uuidPlayerClosed") != null) {
            ticket.setClosed(UUID.fromString(resultSet.getString("uuidPlayerClosed")));
            ticket.setClosedDate(resultSet.getDate("closed_time_stamp"));
        }
        PreparedStatement statement = resultSet.getStatement().getConnection().prepareStatement("Select * from " + this.plugin.getConfig().getCommentTable() + " c left join " + this.plugin.getConfig().getPlayerTable() + " p on p.player_id = c.player_id where ticket_id = ? order by time_stamp asc");
        statement.setInt(1, resultSet.getInt("ticket_id"));
        resultSet = statement.executeQuery();
        while (resultSet.next()) {
            Location location = null;
            if (SQLController.hasLocation(resultSet)) {
                location = new Location(resultSet.getString("server"), resultSet.getString("world"), resultSet.getDouble("loc_X"), resultSet.getDouble("loc_Y"), resultSet.getDouble("loc_Z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"));
            }
            Comment comment = new Comment(resultSet.getInt("comment_id"), ticket.getTicketId(), UUID.fromString(resultSet.getString("uuid")), resultSet.getString("comment"), resultSet.getBoolean("sender_has_noticed"), new Date(resultSet.getLong("time_stamp")), location);
            ticket.getComments().add(comment);
        }
        return ticket;
    }

    private static boolean hasLocation(ResultSet resultSet) {
        try {
            return resultSet.getString("server") != null && resultSet.getString("world") != null && resultSet.getObject("loc_X") != null && resultSet.getObject("loc_Y") != null && resultSet.getObject("loc_Z") != null && resultSet.getObject("yaw") != null && resultSet.getObject("pitch") != null;
        }
        catch (SQLException e) {
            return false;
        }
    }
}

