/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee.Database.Controller;

import io.github.apfelcreme.SupportTickets.Bungee.Database.Connector.MongoConnector;
import io.github.apfelcreme.SupportTickets.Bungee.Database.Controller.DatabaseController;
import io.github.apfelcreme.SupportTickets.Bungee.SupportTickets;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Comment;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Location;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Ticket;
import io.github.apfelcreme.SupportTickets.lib.bson.Document;
import io.github.apfelcreme.SupportTickets.lib.bson.conversions.Bson;
import io.github.apfelcreme.SupportTickets.lib.mongodb.BasicDBObject;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.MongoCollection;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.MongoCursor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.Filters;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.Sorts;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.Updates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class MongoController
implements DatabaseController {
    private final SupportTickets plugin;
    private final MongoConnector connector;

    public MongoController(SupportTickets plugin) {
        this.plugin = plugin;
        this.connector = new MongoConnector(plugin);
    }

    @Override
    public Ticket loadTicket(Integer ticketId) {
        MongoCollection<Document> collection = this.connector.getCollection();
        MongoCursor dbCursor = collection.find(Filters.eq("ticket_id", ticketId)).cursor();
        if (dbCursor.hasNext()) {
            return this.buildTicket((Document)dbCursor.next());
        }
        return null;
    }

    @Override
    public int saveTicket(Ticket ticket) {
        MongoCollection<Document> collection = this.connector.getCollection();
        Document ticketObject = new Document();
        ticketObject.put("ticket_id", (Object)((int)collection.countDocuments()));
        ticketObject.put("sender", (Object)ticket.getSender().toString());
        ticketObject.put("message", (Object)ticket.getMessage());
        ticketObject.put("status", (Object)Ticket.TicketStatus.OPEN.toInt());
        ticketObject.put("time_stamp", (Object)ticket.getDate().getTime());
        if (ticket.getLocation() != null) {
            ticketObject.put("server", (Object)ticket.getLocation().getServer());
            ticketObject.put("world", (Object)ticket.getLocation().getWorldName());
            ticketObject.put("loc_X", (Object)ticket.getLocation().getLocationX());
            ticketObject.put("loc_Y", (Object)ticket.getLocation().getLocationY());
            ticketObject.put("loc_Z", (Object)ticket.getLocation().getLocationZ());
            ticketObject.put("yaw", (Object)ticket.getLocation().getYaw());
            ticketObject.put("pitch", (Object)ticket.getLocation().getPitch());
        }
        collection.insertOne(ticketObject);
        return ticketObject.getInteger("ticket_id");
    }

    @Override
    public void assignTicket(Ticket ticket, String to) {
        Bson query;
        MongoCollection<Document> collection = this.connector.getCollection();
        MongoCursor dbCursor = collection.find(query = Filters.eq("ticket_id", ticket.getTicketId())).cursor();
        if (dbCursor.hasNext()) {
            Document ticketObject = (Document)dbCursor.next();
            ticketObject.put("assigned", (Object)to);
            ticketObject.put("assigned_time_stamp", (Object)new Date().getTime());
            ticketObject.put("status", (Object)Ticket.TicketStatus.ASSIGNED.toInt());
            collection.replaceOne(query, ticketObject);
        }
    }

    @Override
    public void unassignTicket(Ticket ticket) {
        Bson query;
        MongoCollection<Document> collection = this.connector.getCollection();
        MongoCursor dbCursor = collection.find(query = Filters.eq("ticket_id", ticket.getTicketId())).cursor();
        if (dbCursor.hasNext()) {
            Document ticketObject = (Document)dbCursor.next();
            ticketObject.remove("assigned");
            ticketObject.remove("assigned_time_stamp");
            ticketObject.put("status", (Object)Ticket.TicketStatus.OPEN.toInt());
            collection.replaceOne(query, ticketObject);
        }
    }

    @Override
    public void closeTicket(Ticket ticket, UUID closer, String reason) {
        Bson query;
        MongoCollection<Document> collection = this.connector.getCollection();
        MongoCursor dbCursor = collection.find(query = Filters.eq("ticket_id", ticket.getTicketId())).cursor();
        if (dbCursor.hasNext()) {
            Document ticketObject = (Document)dbCursor.next();
            ticketObject.put("closer", (Object)closer.toString());
            ticketObject.put("closed_time_stamp", (Object)new Date().getTime());
            ticketObject.put("status", (Object)Ticket.TicketStatus.CLOSED.toInt());
            collection.replaceOne(query, ticketObject);
        }
    }

    @Override
    public void reopenTicket(Ticket ticket) {
        Bson query;
        MongoCollection<Document> collection = this.connector.getCollection();
        MongoCursor dbCursor = collection.find(query = Filters.eq("ticket_id", ticket.getTicketId())).cursor();
        if (dbCursor.hasNext()) {
            collection.updateOne(query, Updates.set("status", Ticket.TicketStatus.REOPENED.toInt()));
        }
    }

    @Override
    public List<Ticket> getTickets(Ticket.TicketStatus ... ticketStatus) {
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        MongoCollection<Document> collection = this.connector.getCollection();
        Bson query = Filters.or(Arrays.stream(ticketStatus).map(s -> Filters.eq("status", s.toInt())).collect(Collectors.toList()));
        MongoCursor dbCursor = collection.find(query).sort(Sorts.ascending("ticket_id")).cursor();
        while (dbCursor.hasNext()) {
            tickets.add(this.buildTicket((Document)dbCursor.next()));
        }
        return tickets;
    }

    @Override
    public List<Ticket> getTicketsClosedBy(UUID closer) {
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        MongoCollection<Document> collection = this.connector.getCollection();
        MongoCursor dbCursor = collection.find(Filters.eq("closer", closer.toString())).sort(Sorts.ascending("ticket_id")).cursor();
        while (dbCursor.hasNext()) {
            tickets.add(this.buildTicket((Document)dbCursor.next()));
        }
        return tickets;
    }

    @Override
    public List<Ticket> getTicketsOpenedBy(UUID opener) {
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        MongoCollection<Document> collection = this.connector.getCollection();
        MongoCursor dbCursor = collection.find(Filters.eq("sender", opener.toString())).sort(Sorts.ascending("ticket_id")).cursor();
        while (dbCursor.hasNext()) {
            tickets.add(this.buildTicket((Document)dbCursor.next()));
        }
        return tickets;
    }

    @Override
    public List<Ticket> getPlayerTickets(UUID uuid, Ticket.TicketStatus ... ticketStatus) {
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        MongoCollection<Document> collection = this.connector.getCollection();
        Bson query = Filters.and(Filters.eq("sender", uuid.toString()), Filters.or(Arrays.stream(ticketStatus).map(s -> Filters.eq("status", s.toInt())).collect(Collectors.toList())));
        MongoCursor dbCursor = collection.find(query).sort(Sorts.ascending("ticket_id")).cursor();
        while (dbCursor.hasNext()) {
            tickets.add(this.buildTicket((Document)dbCursor.next()));
        }
        return tickets;
    }

    @Override
    public List<Ticket> getTicketsInRadius(Location location, int radius) {
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        MongoCollection<Document> collection = this.connector.getCollection();
        Bson query = Filters.and(Filters.eq("server", location.getServer()), Filters.eq("world", location.getWorldName()), Filters.gt("loc_X", location.getLocationX() - (double)radius), Filters.lt("loc_X", location.getLocationX() + (double)radius), Filters.gt("loc_Y", location.getLocationY() - (double)radius), Filters.lt("loc_Y", location.getLocationY() + (double)radius), Filters.gt("loc_Z", location.getLocationZ() - (double)radius), Filters.lt("loc_Z", location.getLocationZ() + (double)radius));
        MongoCursor dbCursor = collection.find(query).sort(Sorts.ascending("ticket_id")).cursor();
        while (dbCursor.hasNext()) {
            tickets.add(this.buildTicket((Document)dbCursor.next()));
        }
        return tickets;
    }

    @Override
    public void saveComment(Comment comment) {
        Bson query;
        MongoCollection<Document> collection = this.connector.getCollection();
        MongoCursor dbCursor = collection.find(query = Filters.eq("ticket_id", comment.getTicketId())).cursor();
        if (dbCursor.hasNext()) {
            Document ticketObject = (Document)dbCursor.next();
            ArrayList<BasicDBObject> comments = (ArrayList<BasicDBObject>)ticketObject.get("comments");
            if (comments == null) {
                comments = new ArrayList<BasicDBObject>();
            }
            BasicDBObject commentObject = new BasicDBObject();
            commentObject.put("comment_id", comments.size());
            commentObject.put("sender", comment.getSender().toString());
            commentObject.put("comment", comment.getComment());
            commentObject.put("date", comment.getDate().getTime());
            if (comment.getLocation() != null) {
                commentObject.put("server", comment.getLocation().getServer());
                commentObject.put("world", comment.getLocation().getWorldName());
                commentObject.put("loc_X", comment.getLocation().getLocationX());
                commentObject.put("loc_Y", comment.getLocation().getLocationY());
                commentObject.put("loc_Z", comment.getLocation().getLocationZ());
                commentObject.put("yaw", comment.getLocation().getYaw());
                commentObject.put("pitch", comment.getLocation().getPitch());
            }
            commentObject.put("sender_has_noticed", comment.getSenderHasNoticed());
            comments.add(commentObject);
            collection.updateOne(query, Updates.set("comments", comments));
        }
    }

    @Override
    public void setCommentRead(Comment comment) {
        Document ticketObject;
        Bson query;
        if (comment.getCommentId() == -1) {
            return;
        }
        MongoCollection<Document> collection = this.connector.getCollection();
        MongoCursor dbCursor = collection.find(query = Filters.eq("ticket_id", comment.getCommentId())).cursor();
        if (dbCursor.hasNext() && (ticketObject = (Document)dbCursor.next()).get("comments") instanceof List) {
            List comments = (List)ticketObject.get("comments");
            for (Document commentObject : comments) {
                if (commentObject.getInteger("comment_id").intValue() != comment.getCommentId()) continue;
                commentObject.put("sender_has_noticed", (Object)true);
            }
            collection.updateOne(query, Updates.set("comments", comments));
        }
    }

    @Override
    public void disable() {
        this.connector.close();
    }

    private Ticket buildTicket(Document dbObject) {
        Ticket ticket = new Ticket(UUID.fromString((String)dbObject.get("sender")), (String)dbObject.get("message"), new Date((Long)dbObject.get("time_stamp")), MongoController.hasLocation(dbObject) ? new Location((String)dbObject.get("server"), (String)dbObject.get("world"), (Double)dbObject.get("loc_X"), (Double)dbObject.get("loc_Y"), (Double)dbObject.get("loc_Z"), (Double)dbObject.get("yaw"), (Double)dbObject.get("pitch")) : null, Ticket.TicketStatus.fromInt((Integer)dbObject.get("status")));
        ticket.setTicketId((Integer)dbObject.get("ticket_id"));
        if (dbObject.get("assigned") != null) {
            ticket.setAssigned((String)dbObject.get("assigned"));
            ticket.setAssignedDate(new Date((Long)dbObject.get("assigned_time_stamp")));
        }
        if (dbObject.get("closer") != null) {
            ticket.setClosed(UUID.fromString((String)dbObject.get("closer")));
            ticket.setClosedDate(new Date((Long)dbObject.get("closed_time_stamp")));
        }
        if (dbObject.get("comments") instanceof List) {
            List comments = (List)dbObject.get("comments");
            for (Document commentObject : comments) {
                Location location = null;
                if (MongoController.hasLocation(dbObject)) {
                    location = new Location((String)dbObject.get("server"), (String)dbObject.get("world"), (Double)dbObject.get("loc_X"), (Double)dbObject.get("loc_Y"), (Double)dbObject.get("loc_Z"), (Double)dbObject.get("yaw"), (Double)dbObject.get("pitch"));
                }
                Comment comment = new Comment(commentObject.getInteger("comment_id"), ticket.getTicketId(), UUID.fromString(commentObject.getString("sender")), commentObject.getString("comment"), commentObject.getBoolean("sender_has_noticed"), new Date(commentObject.getLong("date")), location);
                ticket.getComments().add(comment);
            }
        }
        return ticket;
    }

    private static boolean hasLocation(Document dbObject) {
        return dbObject.containsKey("server") && dbObject.containsKey("world") && dbObject.containsKey("loc_X") && dbObject.containsKey("loc_Y") && dbObject.containsKey("loc_Z") && dbObject.containsKey("yaw") && dbObject.containsKey("pitch");
    }
}

