/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee.Database.Connector;

import io.github.apfelcreme.SupportTickets.Bungee.SupportTickets;
import io.github.apfelcreme.SupportTickets.lib.hikari.HikariConfig;
import io.github.apfelcreme.SupportTickets.lib.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class MySQLConnector {
    private final SupportTickets plugin;
    private HikariDataSource dataSource;

    public MySQLConnector(SupportTickets plugin) {
        this.plugin = plugin;
    }

    public void initConnection() {
        if (this.plugin.getConfig().getSqlDatabase() != null && !this.plugin.getConfig().getSqlDatabase().isEmpty()) {
            HikariConfig hikariConfig = new HikariConfig();
            hikariConfig.setJdbcUrl("jdbc:mysql://" + this.plugin.getConfig().getSqlUrl() + "/" + this.plugin.getConfig().getSqlDatabase());
            hikariConfig.setUsername(this.plugin.getConfig().getSqlUser());
            hikariConfig.setPassword(this.plugin.getConfig().getSqlPassword());
            this.dataSource = new HikariDataSource(hikariConfig);
            this.initTables();
        }
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    protected void initTables() {
        try (Connection connection = this.getConnection();){
            PreparedStatement statement = connection.prepareStatement("CREATE DATABASE IF NOT EXISTS " + this.plugin.getConfig().getSqlDatabase());
            statement.executeUpdate();
            statement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.plugin.getConfig().getPlayerTable() + "(player_id INTEGER AUTO_INCREMENT, uuid VARCHAR(36) UNIQUE NOT NULL, name VARCHAR(50) NOT NULL, PRIMARY KEY (player_id, uuid))");
            statement.executeUpdate();
            statement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.plugin.getConfig().getTicketTable() + "(ticket_id INTEGER auto_increment, player_id INTEGER not null, message VARCHAR(255), time_stamp BIGINT, assigned VARCHAR(50), assigned_time_stamp BIGINT,closed_player_id INTEGER, closed_reason VARCHAR(255), closed_time_stamp BIGINT, status TINYINT, server VARCHAR(30), world VARCHAR(30), loc_X DOUBLE, loc_Y DOUBLE, loc_Z DOUBLE, yaw FLOAT, pitch FLOAT, PRIMARY KEY (ticket_id), FOREIGN KEY (player_id) references " + this.plugin.getConfig().getPlayerTable() + "(player_id), FOREIGN KEY (closed_player_id) references " + this.plugin.getConfig().getPlayerTable() + "(player_id) )");
            statement.executeUpdate();
            statement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.plugin.getConfig().getCommentTable() + "(comment_id INTEGER AUTO_INCREMENT, ticket_id INTEGER, player_id INTEGER, time_stamp BIGINT, server VARCHAR(30), world VARCHAR(30), loc_X DOUBLE, loc_Y DOUBLE, loc_Z DOUBLE, yaw FLOAT, pitch FLOAT, sender_has_noticed TINYINT(1) DEFAULT 0, comment VARCHAR(255) NOT NULL, FOREIGN KEY (ticket_id) references " + this.plugin.getConfig().getTicketTable() + " (ticket_id), FOREIGN KEY (player_id) references " + this.plugin.getConfig().getPlayerTable() + " (player_id), PRIMARY KEY (comment_id))");
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.dataSource.close();
    }
}

