/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee.Database.Connector;

import io.github.apfelcreme.SupportTickets.Bungee.SupportTickets;
import io.github.apfelcreme.SupportTickets.lib.bson.Document;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ConnectionString;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoClientSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoCredential;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerApi;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerApiVersion;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.MongoClient;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.MongoClients;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.MongoCollection;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.MongoDatabase;

public class MongoConnector {
    private final SupportTickets plugin;
    private MongoClient mongoClient;

    public MongoConnector(SupportTickets plugin) {
        this.plugin = plugin;
    }

    public MongoCollection<Document> getCollection() {
        ServerApi serverApi = ServerApi.builder().version(ServerApiVersion.V1).build();
        MongoClientSettings.Builder settings = MongoClientSettings.builder().applyConnectionString(new ConnectionString("mongodb://" + this.plugin.getConfig().getMongoHost() + ":" + this.plugin.getConfig().getMongoPort() + "/")).serverApi(serverApi);
        if (this.plugin.getConfig().getMongoUser() != null && this.plugin.getConfig().getMongoAuthDb() != null && !this.plugin.getConfig().getMongoUser().isEmpty()) {
            if (this.plugin.getConfig().getMongoPass() == null) {
                throw new MongoException("Invalid configuration for mongoauth! To not use mongoauth leave the user empty!");
            }
            settings.credential(MongoCredential.createPlainCredential(this.plugin.getConfig().getMongoUser(), this.plugin.getConfig().getMongoAuthDb(), this.plugin.getConfig().getMongoPass().toCharArray()));
        }
        try {
            this.mongoClient = MongoClients.create(settings.build());
            MongoDatabase db = this.mongoClient.getDatabase(this.plugin.getConfig().getMongoDatabase());
            return db.getCollection(this.plugin.getConfig().getMongoCollection());
        }
        catch (MongoException e) {
            e.printStackTrace();
            this.close();
            return null;
        }
    }

    public void close() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }
}

