/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee;

import io.github.apfelcreme.SupportTickets.Bungee.Command.SubCommand;
import io.github.apfelcreme.SupportTickets.Bungee.SupportTickets;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.TabCompleteEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class CommandExecutor
extends Command
implements Listener {
    private final SupportTickets plugin;
    private final Map<String, SubCommand> subCommands = new LinkedHashMap<String, SubCommand>();

    public CommandExecutor(SupportTickets plugin, String name, String permission, String ... aliases) {
        super(name, permission, aliases);
        this.plugin = plugin;
        plugin.getProxy().getPluginManager().registerListener((Plugin)plugin, (Listener)this);
    }

    public void execute(CommandSender commandSender, String[] strings) {
        SubCommand subCommand = strings.length > 0 ? this.getSubCommand(strings[0]) : this.getSubCommand("help");
        if (subCommand == null) {
            this.plugin.sendMessage(commandSender, "error.unknownCommand", "input", strings[0]);
            return;
        }
        if (!subCommand.checkPermission(commandSender)) {
            this.plugin.sendMessage(commandSender, "error.noPermission", new String[0]);
            return;
        }
        if (!subCommand.validateInput(strings)) {
            this.plugin.sendMessage(commandSender, "error.wrongUsage", "usage", "/" + this.getName() + " " + subCommand.getName() + " " + subCommand.getUsage());
            return;
        }
        SubCommand finalSubCommand = subCommand;
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, () -> finalSubCommand.execute(commandSender, strings));
    }

    public Map<String, SubCommand> getSubCommands() {
        return this.subCommands;
    }

    public void registerSubCommand(SubCommand subCommand) {
        this.subCommands.put(subCommand.getName().toLowerCase(), subCommand);
        for (String alias : subCommand.getAliases()) {
            this.subCommands.put(alias.toLowerCase(), subCommand);
        }
    }

    public void unregisterSubCommand(String name) {
        SubCommand subCommand = this.getSubCommand(name);
        if (subCommand != null) {
            this.subCommands.remove(subCommand.getName().toLowerCase());
            for (String alias : subCommand.getAliases()) {
                this.subCommands.remove(alias.toLowerCase());
            }
        }
    }

    private SubCommand getSubCommand(String name) {
        SubCommand subCommand = this.subCommands.get(name.toLowerCase());
        if (subCommand == null) {
            for (SubCommand subCommand2 : this.subCommands.values()) {
                if (!subCommand2.getName().startsWith(name.toLowerCase())) continue;
                subCommand = subCommand2;
            }
        }
        if (subCommand == null) {
            for (Map.Entry entry : this.subCommands.entrySet()) {
                if (!((String)entry.getKey()).startsWith(name.toLowerCase())) continue;
                subCommand = (SubCommand)entry.getValue();
            }
        }
        return subCommand;
    }

    @EventHandler
    public void onTabComplete(TabCompleteEvent event) {
        block17: {
            int i;
            String[] stringArray;
            SubCommand subCommand;
            String[] parts;
            String cursor;
            block18: {
                String[] stringArray2;
                block20: {
                    block19: {
                        block16: {
                            cursor = event.getCursor().toLowerCase();
                            if (!cursor.startsWith("/")) {
                                return;
                            }
                            if (("/" + this.getName()).startsWith(cursor)) {
                                event.getSuggestions().add(this.getName());
                                return;
                            }
                            String command = cursor.substring(1).split(" ", 2)[0];
                            if (!command.equalsIgnoreCase(this.getName())) {
                                boolean matches = false;
                                for (String alias : this.getAliases()) {
                                    if (!command.equalsIgnoreCase(alias)) continue;
                                    matches = true;
                                    break;
                                }
                                if (!matches) {
                                    return;
                                }
                            }
                            if (!(event.getSender() instanceof CommandSender)) {
                                return;
                            }
                            parts = cursor.split(" ");
                            if (parts.length != 1 || !cursor.endsWith(" ")) break block16;
                            LinkedHashSet suggestions = new LinkedHashSet();
                            for (SubCommand sub : this.getSubCommands().values()) {
                                if (!sub.checkPermission((CommandSender)event.getSender())) continue;
                                suggestions.add(sub.getName());
                            }
                            event.getSuggestions().addAll(suggestions);
                            break block17;
                        }
                        if (parts.length != 2) break block18;
                        if (cursor.endsWith(" ")) break block19;
                        for (Map.Entry entry : this.getSubCommands().entrySet()) {
                            if (!((String)entry.getKey()).startsWith(parts[1].toLowerCase()) || !((SubCommand)entry.getValue()).checkPermission((CommandSender)event.getSender())) continue;
                            event.getSuggestions().add((String)entry.getKey());
                        }
                        break block17;
                    }
                    subCommand = this.getSubCommand(parts[1]);
                    if (subCommand == null || subCommand.getUsage() == null || (stringArray2 = subCommand.getUsage().split(" ")).length <= 0) break block17;
                    if (!stringArray2[0].contains("player")) break block20;
                    for (ProxiedPlayer player : this.plugin.getProxy().getPlayers()) {
                        event.getSuggestions().add(player.getName());
                    }
                    break block17;
                }
                if (!stringArray2[0].contains("<#>")) break block17;
                for (Integer ticketId : this.plugin.getLastShownTickets((CommandSender)event.getSender())) {
                    event.getSuggestions().add(ticketId.toString());
                }
                break block17;
            }
            if (parts.length > 2 && (subCommand = this.getSubCommand(parts[1])) != null && subCommand.getUsage() != null && (stringArray = subCommand.getUsage().split(" ")).length > 0 && (i = parts.length - 3) < stringArray.length) {
                if (stringArray[i].contains("player")) {
                    for (ProxiedPlayer player : this.plugin.getProxy().getPlayers()) {
                        if (!cursor.endsWith(" ") && !player.getName().startsWith(parts[parts.length - 1])) continue;
                        event.getSuggestions().add(player.getName());
                    }
                } else if (stringArray[i].contains("<#>")) {
                    for (Integer ticketId : this.plugin.getLastShownTickets((CommandSender)event.getSender())) {
                        if (!cursor.endsWith(" ") && !ticketId.toString().startsWith(parts[parts.length - 1])) continue;
                        event.getSuggestions().add(ticketId.toString());
                    }
                }
            }
        }
    }
}

