/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee.Command;

import io.github.apfelcreme.SupportTickets.Bungee.Command.SubCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Message.BukkitMessenger;
import io.github.apfelcreme.SupportTickets.Bungee.SupportTickets;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Comment;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Location;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Ticket;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;

public class WarpCommand
extends SubCommand {
    public WarpCommand(SupportTickets plugin, String name, String usage, String permission, String ... aliases) {
        super(plugin, name, usage, permission, aliases);
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (!(sender instanceof ProxiedPlayer)) {
            this.plugin.sendMessage(sender, "error.playerCommand", new String[0]);
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)sender;
        Ticket ticket = this.plugin.getDatabaseController().loadTicket(Integer.parseInt(args[1]));
        if (ticket == null) {
            this.plugin.sendMessage((CommandSender)player, "error.unknownTicket", new String[0]);
            return;
        }
        if (!player.hasPermission("SupportTickets.mod.server." + ticket.getLocation().getServer())) {
            this.plugin.sendMessage((CommandSender)player, "error.noPermissionOnServer", "server", ticket.getLocation().getServer());
            return;
        }
        Location location = ticket.getLocation();
        if (args.length > 2) {
            int commentNumber = Integer.parseInt(args[2]);
            if (ticket.getComments().size() < commentNumber || commentNumber <= 0) {
                this.plugin.sendMessage((CommandSender)player, "error.unknownComment", new String[0]);
                return;
            }
            location = ticket.getComments().get(commentNumber - 1).getLocation();
        }
        if (location == null) {
            this.plugin.sendMessage(sender, "error.noLocation", new String[0]);
            return;
        }
        if (!sender.hasPermission("SupportTickets.mod.server." + location.getServer())) {
            this.plugin.sendMessage((CommandSender)player, "error.noPermissionOnServer", "server", location.getServer());
            return;
        }
        BukkitMessenger.warp(player.getUniqueId(), location);
        this.plugin.getProxy().getScheduler().schedule((Plugin)this.plugin, () -> {
            this.plugin.sendMessage((CommandSender)player, "info.warp.warped", "ticket", String.valueOf(ticket.getTicketId()), "date", SupportTickets.formatDate(ticket.getDate()), "new", "", "sender", this.plugin.getNameByUUID(ticket.getSender()), "message", ticket.getMessage(), "comments", String.valueOf(ticket.getComments().size()));
            this.plugin.sendMessage(sender, "info.view.comment", "ticket", String.valueOf(ticket.getTicketId()), "date", SupportTickets.formatDate(ticket.getDate()), "new", "", "sender", this.plugin.getNameByUUID(ticket.getSender()), "message", ticket.getMessage(), "number", "");
            int i = 1;
            for (Comment comment : ticket.getComments()) {
                this.plugin.sendMessage(sender, "info.view.comment", "ticket", String.valueOf(ticket.getTicketId()), "date", SupportTickets.formatDate(comment.getDate()), "new", comment.getSenderHasNoticed() ? "" : this.plugin.getConfig().getText("info.view.new"), "sender", this.plugin.getNameByUUID(comment.getSender()), "message", comment.getComment(), "number", String.valueOf(i));
                if (!comment.getSenderHasNoticed() && player.getUniqueId().equals(ticket.getSender())) {
                    this.plugin.getDatabaseController().setCommentRead(comment);
                }
                ++i;
            }
            if (sender.hasPermission("SupportTickets.mod")) {
                this.plugin.sendMessage(sender, "info.view.actions", "ticket", String.valueOf(ticket.getTicketId()));
            }
            this.plugin.addShownTicket(sender, ticket.getTicketId());
        }, 1L, TimeUnit.SECONDS);
    }
}

