/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee.Command;

import io.github.apfelcreme.SupportTickets.Bungee.Command.SubCommand;
import io.github.apfelcreme.SupportTickets.Bungee.SupportTickets;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Ticket;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.md_5.bungee.api.CommandSender;

public class TopCommand
extends SubCommand {
    public TopCommand(SupportTickets plugin, String name, String usage, String permission, String ... aliases) {
        super(plugin, name, usage, permission, aliases);
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        List<Ticket> tickets = this.plugin.getDatabaseController().getTickets(Ticket.TicketStatus.CLOSED);
        HashMap<UUID, Integer> playerCloses = new HashMap<UUID, Integer>();
        for (Ticket ticket : tickets) {
            if (!sender.hasPermission("SupportTickets.mod.server." + ticket.getLocation().getServer())) continue;
            if (!playerCloses.containsKey(ticket.getClosed())) {
                playerCloses.put(ticket.getClosed(), 0);
            }
            playerCloses.put(ticket.getClosed(), (Integer)playerCloses.get(ticket.getClosed()) + 1);
        }
        ValueComparator comparator = new ValueComparator(playerCloses);
        TreeMap<UUID, Integer> sortedMap = new TreeMap<UUID, Integer>(comparator);
        sortedMap.putAll(playerCloses);
        this.plugin.sendMessage(sender, "info.top.header", "amount", String.valueOf(this.plugin.getConfig().getTopListSize()));
        Iterator sortedIt = sortedMap.entrySet().iterator();
        for (int i = 1; sortedIt.hasNext() && i <= this.plugin.getConfig().getTopListSize(); ++i) {
            Map.Entry entry = sortedIt.next();
            this.plugin.sendMessage(sender, "info.top.element", "place", String.valueOf(i), "name", this.plugin.getNameByUUID(entry.getKey()), "tickets", String.valueOf(entry.getValue()));
        }
    }

    class ValueComparator
    implements Comparator<UUID> {
        Map<UUID, Integer> base;

        public ValueComparator(Map<UUID, Integer> base) {
            this.base = base;
        }

        @Override
        public int compare(UUID a, UUID b) {
            if (this.base.get(a) >= this.base.get(b)) {
                return -1;
            }
            return 1;
        }
    }
}

