/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee.Command;

import io.github.apfelcreme.SupportTickets.Bungee.Command.SubCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Message.BukkitMessenger;
import io.github.apfelcreme.SupportTickets.Bungee.SupportTickets;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Comment;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Location;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Ticket;
import java.util.Date;
import java.util.UUID;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class ReopenCommand
extends SubCommand {
    public ReopenCommand(SupportTickets plugin, String name, String usage, String permission, String ... aliases) {
        super(plugin, name, usage, permission, aliases);
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        Ticket ticket = this.plugin.getDatabaseController().loadTicket(Integer.parseInt(args[1]));
        if (ticket == null) {
            this.plugin.sendMessage(sender, "error.unknownTicket", new String[0]);
            return;
        }
        if (!sender.hasPermission("SupportTickets.mod.server." + ticket.getLocation().getServer())) {
            this.plugin.sendMessage(sender, "error.noPermissionOnServer", "server", ticket.getLocation().getServer());
            return;
        }
        BukkitMessenger.fetchPosition(sender, location -> {
            this.plugin.getDatabaseController().reopenTicket(ticket);
            UUID senderId = sender instanceof ProxiedPlayer ? ((ProxiedPlayer)sender).getUniqueId() : new UUID(0L, 0L);
            Comment comment = new Comment(ticket.getTicketId(), senderId, SupportTickets.replace(this.plugin.getConfig().getText("info.reopen.reopenComment"), "sender", sender.getName()), ticket.getSender().equals(senderId), new Date(), (Location)location);
            this.plugin.getDatabaseController().saveComment(comment);
            this.plugin.sendTeamMessage("info.reopen.reopened", "ticket", String.valueOf(ticket.getTicketId()), "sender", sender.getName());
            this.plugin.sendMessage(ticket.getSender(), "info.reopen.yourTicketGotReopened", "ticket", String.valueOf(ticket.getTicketId()), "sender", sender.getName());
            this.plugin.addShownTicket(sender, ticket.getTicketId());
        });
    }
}

