/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee.Command;

import com.google.common.collect.ImmutableMap;
import io.github.apfelcreme.SupportTickets.Bungee.Command.SubCommand;
import io.github.apfelcreme.SupportTickets.Bungee.SupportTickets;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Comment;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Ticket;
import io.github.apfelcreme.SupportTickets.lib.minedown.MineDown;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class MarkReadCommand
extends SubCommand {
    public MarkReadCommand(SupportTickets plugin, String name, String usage, String permission, String ... aliases) {
        super(plugin, name, usage, permission, aliases);
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        UUID target = sender instanceof ProxiedPlayer ? ((ProxiedPlayer)sender).getUniqueId() : new UUID(0L, 0L);
        List<Ticket> tickets = this.plugin.getDatabaseController().getTicketsOpenedBy(target);
        LinkedHashSet<Integer> ticketEntries = new LinkedHashSet<Integer>();
        int i = 0;
        for (Ticket ticket : tickets) {
            for (Comment comment : ticket.getComments()) {
                if (comment.getSenderHasNoticed()) continue;
                this.plugin.getDatabaseController().setCommentRead(comment);
                ++i;
                ticketEntries.add(ticket.getTicketId());
            }
        }
        if (i > 0) {
            String entry = this.plugin.getConfig().getText("info.markread.ticketEntry");
            this.plugin.sendMessage(sender, "info.markread.marked", (Map<String, BaseComponent[]>)ImmutableMap.of((Object)"comments", (Object)TextComponent.fromLegacyText((String)String.valueOf(i)), (Object)"tickets", (Object)MineDown.parse(ticketEntries.stream().map(id -> SupportTickets.replace(entry, "ticket", String.valueOf(id))).collect(Collectors.joining(String.valueOf(ChatColor.WHITE) + ", ")), new String[0])));
        } else {
            this.plugin.sendMessage(sender, "info.markread.none", new String[0]);
        }
    }
}

