/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee.Command;

import com.google.common.collect.ImmutableMap;
import io.github.apfelcreme.SupportTickets.Bungee.Command.SubCommand;
import io.github.apfelcreme.SupportTickets.Bungee.SupportTickets;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Ticket;
import io.github.apfelcreme.SupportTickets.lib.minedown.MineDown;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class ListCommand
extends SubCommand {
    public ListCommand(SupportTickets plugin, String name, String usage, String permission, String ... aliases) {
        super(plugin, name, usage, permission, aliases);
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        List<Object> tickets;
        int page = 0;
        if (SupportTickets.isNumeric(args[args.length - 1])) {
            page = Integer.parseInt(args[args.length - 1]) - 1;
        }
        if (page < 0) {
            page = 0;
        }
        Ticket.TicketStatus messageStatus = Ticket.TicketStatus.OPEN;
        Ticket.TicketStatus[] statuses = new Ticket.TicketStatus[]{Ticket.TicketStatus.OPEN, Ticket.TicketStatus.ASSIGNED, Ticket.TicketStatus.REOPENED};
        if (args.length > 1 && !SupportTickets.isNumeric(args[1])) {
            try {
                messageStatus = Ticket.TicketStatus.valueOf(args[1].toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                this.plugin.sendMessage(sender, "error.wrongEnumArgument", "input", args[1], "available", Arrays.stream(Ticket.TicketStatus.values()).map(Enum::toString).collect(Collectors.joining(", ")));
                return;
            }
            statuses = new Ticket.TicketStatus[]{messageStatus};
        }
        Order messageOrder = Order.ASC;
        if (args.length > 2 && !SupportTickets.isNumeric(args[2])) {
            try {
                messageOrder = switch (args[2].toUpperCase(Locale.ROOT)) {
                    case "ASC", "ASCENDING" -> Order.ASC;
                    case "DESC", "DESCENDING" -> Order.DESC;
                    default -> throw new IllegalArgumentException();
                };
            }
            catch (IllegalArgumentException e) {
                this.plugin.sendMessage(sender, "error.wrongEnumArgument", "input", args[1], "available", Arrays.stream(Order.values()).map(Enum::toString).collect(Collectors.joining(", ")));
                return;
            }
            statuses = new Ticket.TicketStatus[]{messageStatus};
        }
        if (sender.hasPermission("SupportTickets.mod")) {
            tickets = this.plugin.getDatabaseController().getTickets(statuses).stream().filter(t -> sender.hasPermission("SupportTickets.mod.server." + t.getLocation().getServer())).collect(Collectors.toList());
        } else {
            UUID senderId = sender instanceof ProxiedPlayer ? ((ProxiedPlayer)sender).getUniqueId() : new UUID(0L, 0L);
            tickets = this.plugin.getDatabaseController().getPlayerTickets(senderId, statuses);
        }
        if (messageOrder == Order.DESC) {
            tickets.sort(Comparator.comparing(Ticket::getTicketId));
        } else {
            tickets.sort(Comparator.comparing(Ticket::getTicketId).reversed());
        }
        int pageSize = this.plugin.getConfig().getPageSize();
        int maxPages = (int)Math.ceil((float)tickets.size() / (float)pageSize);
        if (maxPages > 0 && page >= maxPages - 1) {
            page = maxPages - 1;
        }
        this.plugin.sendMessage(sender, "info.list.header", "page", String.valueOf(page + 1), "maxpages", String.valueOf(maxPages), "status", messageStatus.toString());
        for (int i = page * pageSize; i < (page + 1) * pageSize && i < tickets.size(); ++i) {
            Ticket ticket = (Ticket)tickets.get(i);
            this.plugin.sendMessage(sender, "info.list.element", (Map<String, BaseComponent[]>)ImmutableMap.of((Object)"actions", (Object)(sender.hasPermission("SupportTickets.mod") ? this.plugin.getMessage("info.list.actions", "ticket", String.valueOf(ticket.getTicketId())) : new BaseComponent[]{})), "id", String.valueOf(ticket.getTicketId()), "date", SupportTickets.formatDate(ticket.getDate()), "online", this.plugin.isPlayerOnline(ticket.getSender()) ? this.plugin.getConfig().getText("info.list.online") : this.plugin.getConfig().getText("info.list.offline"), "sender", this.plugin.getNameByUUID(ticket.getSender()), "assigned", ticket.getAssigned() != null ? ticket.getAssigned() : "*", "message", ticket.getMessage(), "comments", Integer.toString(ticket.getComments().size()));
            this.plugin.addShownTicket(sender, ticket.getTicketId());
        }
        if (tickets.size() > pageSize) {
            String[] repl = new String[]{"status", messageStatus.toString().toLowerCase(Locale.ROOT), "order", messageOrder.toString().toLowerCase(Locale.ROOT), "previouspage", String.valueOf(page), "nextpage", String.valueOf(page + 2)};
            this.plugin.sendMessage(sender, "info.list.footer", (Map<String, BaseComponent[]>)ImmutableMap.of((Object)"previous", (Object)MineDown.parse(page > 0 ? SupportTickets.replace(this.plugin.getConfig().getText("info.list.previous"), repl) : "", new String[0]), (Object)"next", (Object)MineDown.parse((page + 1) * pageSize < tickets.size() ? SupportTickets.replace(this.plugin.getConfig().getText("info.list.next"), repl) : "", new String[0])), repl);
        }
    }

    @Override
    public boolean validateInput(String[] strings) {
        return strings.length > 0;
    }

    public static enum Order {
        ASC,
        DESC;

    }
}

