/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee.Command;

import io.github.apfelcreme.SupportTickets.Bungee.Command.SubCommand;
import io.github.apfelcreme.SupportTickets.Bungee.SupportTickets;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Ticket;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class ClosedCommand
extends SubCommand {
    public ClosedCommand(SupportTickets plugin, String name, String usage, String permission, String ... aliases) {
        super(plugin, name, usage, permission, aliases);
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        UUID target;
        UUID uUID = target = sender instanceof ProxiedPlayer ? ((ProxiedPlayer)sender).getUniqueId() : new UUID(0L, 0L);
        if (args.length > 1 && (target = this.plugin.getUUIDByName(args[1])) == null) {
            this.plugin.sendMessage(sender, "error.unknownPlayer", new String[0]);
            return;
        }
        int page = 0;
        if (args.length > 2 && SupportTickets.isNumeric(args[2])) {
            page = Integer.parseInt(args[2]) - 1;
        }
        List tickets = this.plugin.getDatabaseController().getTicketsClosedBy(target).stream().filter(t -> sender.hasPermission("SupportTickets.mod.server." + t.getLocation().getServer())).sorted(Collections.reverseOrder()).collect(Collectors.toList());
        int pageSize = this.plugin.getConfig().getPageSize();
        int maxPages = (int)Math.ceil((float)tickets.size() / (float)pageSize);
        if (page >= maxPages - 1) {
            page = maxPages - 1;
        }
        if (page < 0) {
            page = 0;
        }
        this.plugin.sendMessage(sender, "info.closed.header", "player", args[1], "page", String.valueOf(page + 1), "maxpages", String.valueOf(maxPages), "amount", String.valueOf(tickets.size()));
        for (int i = page * pageSize; i < (page + 1) * pageSize && i < tickets.size(); ++i) {
            Ticket ticket = (Ticket)tickets.get(i);
            this.plugin.sendMessage(sender, "info.list.element", "id", String.valueOf(ticket.getTicketId()), "date", SupportTickets.formatDate(ticket.getDate()), "online", this.plugin.isPlayerOnline(ticket.getSender()) ? this.plugin.getConfig().getText("info.list.online") : this.plugin.getConfig().getText("info.list.offline"), "sender", this.plugin.getNameByUUID(ticket.getSender()), "assigned", ticket.getAssigned() != null ? ticket.getAssigned() : "*", "message", ticket.getMessage(), "comments", Integer.toString(ticket.getComments().size()));
            this.plugin.addShownTicket(sender, ticket.getTicketId());
        }
        this.plugin.sendMessage(sender, "info.closed.footer", new String[0]);
    }
}

