/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bungee.Command;

import io.github.apfelcreme.SupportTickets.Bungee.Command.SubCommand;
import io.github.apfelcreme.SupportTickets.Bungee.Event.TicketCloseEvent;
import io.github.apfelcreme.SupportTickets.Bungee.Message.BukkitMessenger;
import io.github.apfelcreme.SupportTickets.Bungee.SupportTickets;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Comment;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Location;
import io.github.apfelcreme.SupportTickets.Bungee.Ticket.Ticket;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Event;

public class CloseCommand
extends SubCommand {
    public CloseCommand(SupportTickets plugin, String name, String usage, String permission, String ... aliases) {
        super(plugin, name, usage, permission, aliases);
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        UUID senderId;
        Ticket ticket = this.plugin.getDatabaseController().loadTicket(Integer.parseInt(args[1]));
        if (ticket == null) {
            this.plugin.sendMessage(sender, "error.unknownTicket", new String[0]);
            return;
        }
        if (ticket.getTicketStatus() == Ticket.TicketStatus.CLOSED) {
            this.plugin.sendMessage(sender, "error.ticketAlreadyClosed", new String[0]);
            return;
        }
        UUID uUID = senderId = sender instanceof ProxiedPlayer ? ((ProxiedPlayer)sender).getUniqueId() : new UUID(0L, 0L);
        if (!ticket.getSender().equals(senderId) && !sender.hasPermission("SupportTickets.mod.server." + ticket.getLocation().getServer())) {
            if (sender.hasPermission("SupportTickets.mod")) {
                this.plugin.sendMessage(sender, "error.noPermissionOnServer", "server", ticket.getLocation().getServer());
            } else {
                this.plugin.sendMessage(sender, "error.notYourTicket", new String[0]);
            }
            return;
        }
        BukkitMessenger.fetchPosition(sender, location -> {
            String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length)).trim();
            Comment comment = new Comment(ticket.getTicketId(), senderId, SupportTickets.replace(this.plugin.getConfig().getText("info.close.closeComment"), "sender", sender.getName(), "reason", reason), ticket.getSender().equals(senderId), new Date(), (Location)location);
            ticket.getComments().add(comment);
            this.plugin.getDatabaseController().saveComment(comment);
            this.plugin.getDatabaseController().closeTicket(ticket, senderId, reason);
            TicketCloseEvent closeEvent = new TicketCloseEvent(ticket, sender, reason);
            this.plugin.getProxy().getPluginManager().callEvent((Event)closeEvent);
            this.plugin.sendMessage(ticket.getSender(), "info.close.yourTicketGotClosed", "ticket", String.valueOf(ticket.getTicketId()), "sender", sender.getName(), "reason", reason);
            this.plugin.sendTeamMessage("info.close.closed", "ticket", String.valueOf(ticket.getTicketId()), "sender", sender.getName(), "reason", reason);
            this.plugin.addShownTicket(sender, ticket.getTicketId());
        });
    }
}

