/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.Bukkit.Listener;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import io.github.apfelcreme.SupportTickets.Bukkit.SupportTickets;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BungeeMessageListener
implements PluginMessageListener {
    private final SupportTickets plugin;

    public BungeeMessageListener(SupportTickets plugin) {
        this.plugin = plugin;
        plugin.getServer().getMessenger().registerIncomingPluginChannel((Plugin)plugin, "tickets:warp", (PluginMessageListener)this);
        plugin.getServer().getMessenger().registerIncomingPluginChannel((Plugin)plugin, "tickets:requestpos", (PluginMessageListener)this);
        plugin.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)plugin, "tickets:position");
    }

    public void onPluginMessageReceived(String s, Player p, byte[] bytes) {
        if (!s.startsWith("tickets:")) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes);
        if (s.equals("tickets:warp")) {
            UUID uuid = UUID.fromString(in.readUTF());
            Location location = new Location(this.plugin.getServer().getWorld(in.readUTF()), in.readDouble(), in.readDouble(), in.readDouble(), (float)in.readDouble(), (float)in.readDouble());
            this.warp(uuid, location);
        } else if (s.equals("tickets:requestpos")) {
            UUID uuid = UUID.fromString(in.readUTF());
            this.answerPositionRequest(uuid);
        }
    }

    private void answerPositionRequest(UUID uuid) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            Player player = this.plugin.getServer().getPlayer(uuid);
            if (player != null) {
                out.writeUTF(uuid.toString());
                out.writeUTF(this.plugin.getServer().getIp() + ":" + this.plugin.getServer().getPort());
                out.writeUTF(player.getWorld().getName());
                out.writeDouble(player.getLocation().getX());
                out.writeDouble(player.getLocation().getY());
                out.writeDouble(player.getLocation().getZ());
                out.writeDouble(player.getLocation().getYaw());
                out.writeDouble(player.getLocation().getPitch());
                player.sendPluginMessage((Plugin)this.plugin, "tickets:position", b.toByteArray());
                out.close();
                b.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void warp(UUID uuid, Location location) {
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Player player = this.plugin.getServer().getPlayer(uuid);
            if (player != null) {
                player.teleportAsync(location);
            } else {
                this.plugin.addToQueue(uuid, location);
            }
        }, 20L);
    }
}

