/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.worlds;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.components.config.value.AlmostBooleanWithOverride;
import fr.neatmonster.nocheatplus.components.config.value.OverrideType;
import fr.neatmonster.nocheatplus.components.data.IDataOnReload;
import fr.neatmonster.nocheatplus.components.data.IDataOnRemoveSubCheckData;
import fr.neatmonster.nocheatplus.components.data.IDataOnWorldUnload;
import fr.neatmonster.nocheatplus.components.data.checktype.BaseCheckNode;
import fr.neatmonster.nocheatplus.components.data.checktype.CheckNodeWithDebug;
import fr.neatmonster.nocheatplus.components.data.checktype.CheckTypeTree;
import fr.neatmonster.nocheatplus.components.registry.factory.IFactoryOneRegistry;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.utilities.ds.map.InstanceMapLOW;
import fr.neatmonster.nocheatplus.worlds.IWorldCheckNode;
import fr.neatmonster.nocheatplus.worlds.IWorldData;
import fr.neatmonster.nocheatplus.worlds.WorldFactoryArgument;
import fr.neatmonster.nocheatplus.worlds.WorldIdentifier;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.World;

public class WorldData
implements IWorldData {
    private final Lock lock = new ReentrantLock();
    WorldData parent = null;
    private final Collection<WorldData> children = new LinkedHashSet<WorldData>();
    private ConfigFile rawConfiguration = null;
    private final WorldCheckTypeTree checkTypeTree = new WorldCheckTypeTree();
    private final String worldNameLowerCase;
    private WorldIdentifier worldIdentifier = null;
    private IFactoryOneRegistry<WorldFactoryArgument> factoryRegistry;
    private final InstanceMapLOW dataCache = new InstanceMapLOW(this.lock, 25);

    WorldData(String worldName, IFactoryOneRegistry<WorldFactoryArgument> factoryRegistry) {
        this(worldName, null, factoryRegistry);
    }

    WorldData(String worldName, WorldData parent, IFactoryOneRegistry<WorldFactoryArgument> factoryRegistry) {
        this.parent = parent;
        this.worldNameLowerCase = worldName == null ? null : worldName.toLowerCase();
        this.factoryRegistry = factoryRegistry;
        if (parent == null) {
            this.checkTypeTree.setConfigOverrideType(OverrideType.SPECIFIC);
        } else {
            this.checkTypeTree.setConfigOverrideType(OverrideType.DEFAULT);
            this.adjustToParent(parent);
        }
    }

    void adjustToParent(WorldData parent) {
        this.parent = parent;
        this.rawConfiguration = parent.rawConfiguration;
        this.checkTypeTree.setConfigOverrideType(OverrideType.DEFAULT);
        for (CheckType checkType : CheckType.values()) {
            ((WorldCheckTypeTreeNode)this.checkTypeTree.getNode(checkType)).adjustToParent((WorldCheckTypeTreeNode)parent.checkTypeTree.getNode(checkType));
        }
        ((WorldCheckTypeTreeNode)this.checkTypeTree.getNode(CheckType.ALL)).update();
    }

    void addChild(WorldData childData) {
        this.children.add(childData);
    }

    void removeChild(WorldData childData) {
        this.children.remove(childData);
    }

    void clearChildren() {
        this.children.clear();
    }

    void update(ConfigFile rawConfiguration) {
        this.rawConfiguration = rawConfiguration;
        if (this.parent != null && rawConfiguration != this.parent.rawConfiguration) {
            this.parent.removeChild(this);
            this.parent = null;
            ((WorldCheckTypeTreeNode)this.checkTypeTree.getNode(CheckType.ALL)).setConfigOverrideType(OverrideType.SPECIFIC);
        }
        this.update();
    }

    void update() {
        ((WorldCheckTypeTreeNode)this.checkTypeTree.getNode(CheckType.ALL)).update(this.rawConfiguration);
    }

    @Override
    public void overrideCheckActivation(CheckType checkType, AlmostBoolean active, OverrideType overrideType, boolean overrideChildren) {
        ((WorldCheckTypeTreeNode)this.checkTypeTree.getNode(checkType)).overrideCheckActivation(active, overrideType, overrideChildren);
    }

    @Override
    public ConfigFile getRawConfiguration() {
        return this.rawConfiguration;
    }

    @Override
    public boolean isCheckActive(CheckType checkType) {
        return ((WorldCheckTypeTreeNode)this.checkTypeTree.getNode(checkType)).active;
    }

    @Override
    public boolean isDebugActive(CheckType checkType) {
        return this.getCheckNode(checkType).isDebugActive();
    }

    @Override
    public IWorldCheckNode getCheckNode(CheckType checkType) {
        return (IWorldCheckNode)this.checkTypeTree.getNode(checkType);
    }

    @Override
    public <T> T getGenericInstance(Class<T> registeredFor) {
        T instance = this.dataCache.get(registeredFor);
        if (instance == null && (instance = this.factoryRegistry.getNewInstance(registeredFor, new WorldFactoryArgument(this))) != null) {
            T newInstance = this.dataCache.putIfAbsent(registeredFor, instance);
            return newInstance == null ? instance : newInstance;
        }
        return instance;
    }

    @Override
    public String getWorldNameLowerCase() {
        return this.worldNameLowerCase;
    }

    public void updateWorldIdentifier(WorldIdentifier worldIdentifier) {
        if (this.worldNameLowerCase.equals(worldIdentifier.lowerCaseName)) {
            if (this.worldIdentifier == null || !this.worldIdentifier.equals(worldIdentifier)) {
                this.worldIdentifier = worldIdentifier;
            }
        } else {
            throw new IllegalArgumentException("Lower case names must match.");
        }
    }

    public void updateWorldIdentifier(World world) {
        this.updateWorldIdentifier(new WorldIdentifier(world.getName(), world.getUID()));
    }

    @Override
    public WorldIdentifier getWorldIdentifier() {
        return this.worldIdentifier;
    }

    @Override
    public boolean shouldAdjustToLag(CheckType checkType) {
        return this.getCheckNode(checkType).shouldAdjustToLag();
    }

    @Override
    public <T> void removeGenericInstance(Class<T> type) {
        this.dataCache.remove(type);
    }

    @Override
    public void removeAllGenericInstances(Collection<Class<?>> types) {
        if (this.dataCache.isEmpty()) {
            return;
        }
        this.dataCache.remove(types);
    }

    @Override
    public void removeSubCheckData(Collection<Class<? extends IDataOnRemoveSubCheckData>> types, Collection<CheckType> checkTypes) {
        LinkedList removeTypes = new LinkedList();
        for (Class<? extends IDataOnRemoveSubCheckData> type : types) {
            IDataOnRemoveSubCheckData impl = this.dataCache.get(type);
            if (impl == null || !impl.dataOnRemoveSubCheckData(checkTypes)) continue;
            removeTypes.add(type);
        }
        if (!removeTypes.isEmpty()) {
            this.dataCache.remove(removeTypes);
        }
    }

    public void onWorldUnload(World world, Collection<Class<? extends IDataOnWorldUnload>> types) {
        for (Class<? extends IDataOnWorldUnload> type : types) {
            IDataOnWorldUnload instance = this.dataCache.get(type);
            if (instance == null || !instance.dataOnWorldUnload(world, this)) continue;
            this.dataCache.remove(type);
        }
    }

    public void onReload(Collection<Class<? extends IDataOnReload>> types) {
        for (Class<? extends IDataOnReload> type : types) {
            IDataOnReload instance = this.dataCache.get(type);
            if (instance == null || !instance.dataOnReload(this)) continue;
            this.dataCache.remove(type);
        }
    }

    private static class WorldCheckTypeTree
    extends CheckTypeTree<WorldCheckTypeTreeNode> {
        private OverrideType configOverrideType = OverrideType.DEFAULT;

        private WorldCheckTypeTree() {
        }

        @Override
        protected WorldCheckTypeTreeNode newNode(CheckType checkType, WorldCheckTypeTreeNode parent, CheckTypeTree.CheckTypeTreeNodeFactory<WorldCheckTypeTreeNode> factory) {
            return new WorldCheckTypeTreeNode(checkType, parent, factory);
        }

        void setConfigOverrideType(OverrideType configOverrideType) {
            if (this.configOverrideType != configOverrideType) {
                this.configOverrideType = configOverrideType;
                ((WorldCheckTypeTreeNode)this.getNode(CheckType.ALL)).setConfigOverrideType(configOverrideType);
            }
        }
    }

    private static class WorldCheckTypeTreeNode
    extends CheckNodeWithDebug<WorldCheckTypeTreeNode>
    implements IWorldCheckNode {
        private static AccessActive accessActive = new AccessActive();
        private static AccessLag accessLag = new AccessLag();
        private final AlmostBooleanWithOverride configActivation = new AlmostBooleanWithOverride();
        private boolean active = true;
        private final AlmostBooleanWithOverride configLag = new AlmostBooleanWithOverride();
        private boolean lag = false;

        WorldCheckTypeTreeNode(CheckType checkType, WorldCheckTypeTreeNode parent, CheckTypeTree.CheckTypeTreeNodeFactory<WorldCheckTypeTreeNode> factory) {
            super(checkType, parent, factory);
        }

        void setConfigOverrideType(OverrideType configOverrideType) {
            this.configOverrideType = configOverrideType;
            for (WorldCheckTypeTreeNode child : this.getChildren()) {
                child.setConfigOverrideType(configOverrideType);
            }
        }

        void adjustToParent(WorldCheckTypeTreeNode parentNode) {
            this.configOverrideType = OverrideType.DEFAULT;
            if (this.configActivation.setValue((AlmostBoolean)((Object)parentNode.configActivation.getValue()), this.configOverrideType)) {
                this.active = parentNode.active;
            }
            if (this.configDebug.setValue((AlmostBoolean)((Object)parentNode.configDebug.getValue()), this.configOverrideType)) {
                this.debug = parentNode.debug;
            }
            if (this.configLag.setValue((AlmostBoolean)((Object)parentNode.configLag.getValue()), this.configOverrideType)) {
                this.lag = parentNode.lag;
            }
        }

        void update(ConfigFile rawConfiguration) {
            this.updateActivation(rawConfiguration, true);
            this.updateDebug(rawConfiguration, true);
            this.updateLag(rawConfiguration, true);
        }

        void update() {
            this.updateActivation(true);
            this.updateDebug(true);
            this.updateLag(true);
        }

        private void updateLag(ConfigFile rawConfiguration, boolean forceUpdateChildren) {
            this.update(rawConfiguration, forceUpdateChildren, accessLag);
        }

        private void updateLag(boolean forceUpdateChildren) {
            this.update(forceUpdateChildren, accessLag);
        }

        void overrideCheckActivation(AlmostBoolean active, OverrideType overrideType, boolean overrideChildren) {
            this.override(active, overrideType, overrideChildren, accessActive);
        }

        void updateActivation(ConfigFile rawConfiguration, boolean forceUpdateChildren) {
            this.update(rawConfiguration, forceUpdateChildren, accessActive);
        }

        void updateActivation(boolean forceUpdateChildren) {
            this.update(forceUpdateChildren, accessActive);
        }

        @Override
        public boolean isCheckActive() {
            return this.active;
        }

        @Override
        public OverrideType getOverrideTypeDebug() {
            return this.configDebug.getOverrideType();
        }

        @Override
        public boolean shouldAdjustToLag() {
            return this.lag;
        }

        private static class AccessLag<WorldTypeCheckTreeNode>
        implements BaseCheckNode.IConfigFlagAccess<WorldCheckTypeTreeNode> {
            private AccessLag() {
            }

            @Override
            public AlmostBooleanWithOverride getConfigState(WorldCheckTypeTreeNode node) {
                return node.configLag;
            }

            @Override
            public boolean getState(WorldCheckTypeTreeNode node) {
                return node.lag;
            }

            @Override
            public void setState(WorldCheckTypeTreeNode node, boolean state) {
                node.lag = state;
            }

            @Override
            public String getConfigPath(WorldCheckTypeTreeNode node) {
                return node.getCheckType().getConfigPathLag();
            }

            @Override
            public boolean getMissingParentState() {
                return true;
            }
        }

        private static class AccessActive<WorldTypeCheckTreeNode>
        implements BaseCheckNode.IConfigFlagAccess<WorldCheckTypeTreeNode> {
            private AccessActive() {
            }

            @Override
            public AlmostBooleanWithOverride getConfigState(WorldCheckTypeTreeNode node) {
                return node.configActivation;
            }

            @Override
            public boolean getState(WorldCheckTypeTreeNode node) {
                return node.active;
            }

            @Override
            public void setState(WorldCheckTypeTreeNode node, boolean state) {
                node.active = state;
            }

            @Override
            public String getConfigPath(WorldCheckTypeTreeNode node) {
                return node.getCheckType().getConfigPathActive();
            }

            @Override
            public boolean getMissingParentState() {
                return true;
            }
        }
    }
}

