/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.workaround;

import fr.neatmonster.nocheatplus.utilities.ds.count.acceptdeny.AcceptDenyCounter;
import fr.neatmonster.nocheatplus.utilities.ds.count.acceptdeny.IAcceptDenyCounter;
import fr.neatmonster.nocheatplus.utilities.ds.count.acceptdeny.ICounterWithParent;
import fr.neatmonster.nocheatplus.workaround.IWorkaround;
import fr.neatmonster.nocheatplus.workaround.IWorkaroundRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class SimpleWorkaroundRegistry
implements IWorkaroundRegistry {
    private final Map<String, IAcceptDenyCounter> counters = new HashMap<String, IAcceptDenyCounter>();
    private final Map<String, IWorkaround> bluePrints = new HashMap<String, IWorkaround>();
    private final Map<String, String[]> groups = new HashMap<String, String[]>();
    private final Map<String, String[]> workaroundSets = new HashMap<String, String[]>();
    private final Map<String, String[]> workaroundSetGroups = new HashMap<String, String[]>();

    @Override
    public void setWorkaroundBluePrint(IWorkaround ... bluePrints) {
        for (int i = 0; i < bluePrints.length; ++i) {
            ICounterWithParent bluePrintCopyWithParentCounter;
            IWorkaround bluePrintCopy = bluePrints[i].getNewInstance();
            this.bluePrints.put(bluePrintCopy.getId(), bluePrintCopy);
            IAcceptDenyCounter allTimeCounter = bluePrintCopy.getAllTimeCounter();
            if (!(allTimeCounter instanceof ICounterWithParent) || (bluePrintCopyWithParentCounter = (ICounterWithParent)((Object)allTimeCounter)).getParentCounter() != null) continue;
            bluePrintCopyWithParentCounter.setParentCounter(this.createGlobalCounter(bluePrintCopy.getId()));
        }
    }

    @Override
    public void setGroup(String groupId, Collection<String> workaroundIds) {
        for (String id : workaroundIds) {
            if (this.bluePrints.containsKey(id)) continue;
            throw new IllegalArgumentException("No blueprint for id '" + id + "' in group '" + groupId + "'.");
        }
        this.groups.put(groupId, workaroundIds.toArray(new String[workaroundIds.size()]));
    }

    @Override
    public void setGroup(String groupId, IWorkaround ... bluePrints) {
        this.setGroup(groupId, this.getCheckedIdSet(Arrays.asList(bluePrints)));
    }

    private void setWorkaroundSet(String workaroundSetId, Collection<IWorkaround> bluePrints, String ... groupIds) {
        String[] ids = new String[bluePrints.size()];
        int i = 0;
        for (IWorkaround bluePrint : bluePrints) {
            String id = bluePrint.getId();
            if (!this.bluePrints.containsKey(id)) {
                this.setWorkaroundBluePrint(bluePrint);
            }
            ids[i] = id;
            ++i;
        }
        this.workaroundSets.put(workaroundSetId, ids);
        if (groupIds != null && groupIds.length > 0) {
            for (i = 0; i < groupIds.length; ++i) {
                if (this.groups.containsKey(groupIds[i])) continue;
                throw new IllegalArgumentException("Group not registered: " + groupIds[i]);
            }
            this.workaroundSetGroups.put(workaroundSetId, groupIds);
        }
    }

    @Override
    public void setWorkaroundSetByIds(String workaroundSetId, Collection<String> bluePrintIds, String ... groupIds) {
        ArrayList<IWorkaround> bluePrints = new ArrayList<IWorkaround>(bluePrintIds.size());
        for (String id : bluePrintIds) {
            IWorkaround bluePrint = this.bluePrints.get(id);
            if (bluePrint == null) {
                throw new IllegalArgumentException("the blueprint is not registered: " + id);
            }
            bluePrints.add(bluePrint);
        }
        this.setWorkaroundSet(workaroundSetId, bluePrints, groupIds);
    }

    @Override
    public IWorkaroundRegistry.WorkaroundSet getWorkaroundSet(String workaroundSetId) {
        HashMap<String, String[]> groups;
        String[] workaroundIds = this.workaroundSets.get(workaroundSetId);
        if (workaroundIds == null) {
            throw new IllegalArgumentException("WorkaroundSet not registered: " + workaroundSetId);
        }
        IWorkaround[] bluePrints = new IWorkaround[workaroundIds.length];
        for (int i = 0; i < workaroundIds.length; ++i) {
            bluePrints[i] = this.bluePrints.get(workaroundIds[i]);
        }
        String[] groupIds = this.workaroundSetGroups.get(workaroundSetId);
        if (groupIds == null) {
            groups = null;
        } else {
            groups = new HashMap<String, String[]>();
            for (int i = 0; i < groupIds.length; ++i) {
                String groupId = groupIds[i];
                groups.put(groupId, this.groups.get(groupId));
            }
        }
        return new IWorkaroundRegistry.WorkaroundSet(bluePrints, groups);
    }

    @Override
    public IAcceptDenyCounter getGlobalCounter(String id) {
        return this.counters.get(id);
    }

    @Override
    public IAcceptDenyCounter createGlobalCounter(String id) {
        IAcceptDenyCounter counter = this.counters.get(id);
        if (counter == null) {
            counter = new AcceptDenyCounter();
            this.counters.put(id, counter);
        }
        return counter;
    }

    @Override
    public <C extends IWorkaround> C getWorkaround(String id, Class<C> workaroundClass) {
        IWorkaround workaround = this.getWorkaround(id);
        if (workaroundClass.isAssignableFrom(workaround.getClass())) {
            return (C)workaround;
        }
        throw new IllegalArgumentException("Unsupported class for id '" + id + "': " + workaroundClass.getName() + " (actual class is " + workaround.getClass().getName() + ")");
    }

    @Override
    public IWorkaround getWorkaround(String id) {
        IWorkaround bluePrint = this.bluePrints.get(id);
        if (bluePrint == null) {
            throw new IllegalArgumentException("Id not registered as blueprint: " + id);
        }
        return bluePrint.getNewInstance();
    }

    @Override
    public Map<String, IAcceptDenyCounter> getGlobalCounters() {
        return Collections.unmodifiableMap(this.counters);
    }

    @Override
    public String getCheckedWorkaroundId(String workaroundId) {
        IWorkaround bluePrint = this.bluePrints.get(workaroundId);
        if (bluePrint == null) {
            throw new IllegalArgumentException("No blueprint registered for: " + workaroundId);
        }
        return bluePrint.getId();
    }

    @Override
    public Set<String> getCheckedIdSet(Collection<? extends IWorkaround> workarounds) {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        for (IWorkaround iWorkaround : workarounds) {
            IWorkaround bluePrint = this.bluePrints.get(iWorkaround.getId());
            if (bluePrint == null) {
                throw new IllegalArgumentException("No blueprint registered for: " + iWorkaround.getId());
            }
            ids.add(bluePrint.getId());
        }
        return ids;
    }
}

