/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.math;

import fr.neatmonster.nocheatplus.compat.versions.ClientVersion;
import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.components.location.IGetPositionWithLook;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class TrigUtil {
    private static final Vector vec1 = new Vector();
    private static final Vector vec2 = new Vector();
    public static final double DIRECTION_PRECISION = 2.6;
    public static final double DIRECTION_LOOP_PRECISION = 0.5;
    public static final double PI2 = Math.PI * 2;
    public static final double PId2 = 1.5707963267948966;
    private static final double DEG_FULL = 360.0;
    public static final float toRadians = (float)Math.PI / 180;
    public static final float toDegrees = 57.295776f;
    public static final double fRadToGrad = 57.29577951308232;
    private static float[] SIN = new float[65536];
    private static float SIN_SCALE = 10430.378f;

    public static double sin(double value) {
        return SIN[(int)(value * (double)SIN_SCALE) & 0xFFFF];
    }

    public static double cos(double value) {
        return SIN[(int)(value * (double)SIN_SCALE + 16384.0) & 0xFFFF];
    }

    public static float sin(float value) {
        return SIN[(int)(value * SIN_SCALE) & 0xFFFF];
    }

    public static float cos(float value) {
        return SIN[(int)(value * SIN_SCALE + 16384.0f) & 0xFFFF];
    }

    public static final Vector getLookingDirection(float yaw, float pitch, Player player) {
        if (DataManager.getPlayerData(player).getClientVersion().isAtMost(ClientVersion.V_1_12_2)) {
            float f = TrigUtil.cos(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
            float f1 = TrigUtil.sin(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
            float f2 = -TrigUtil.cos(-pitch * ((float)Math.PI / 180));
            float f3 = TrigUtil.sin(-pitch * ((float)Math.PI / 180));
            return new Vector(f1 * f2, f3, f * f2);
        }
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = TrigUtil.cos(f1);
        float f3 = TrigUtil.sin(f1);
        float f4 = TrigUtil.cos(f);
        float f5 = TrigUtil.sin(f);
        return new Vector((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static final Vector getLookingDirection(IGetPositionWithLook loc, Player player) {
        return TrigUtil.getLookingDirection(loc.getYaw(), loc.getPitch(), player);
    }

    public static final Vector getLookingDirection(Location loc, Player player) {
        return TrigUtil.getLookingDirection(loc.getYaw(), loc.getPitch(), player);
    }

    public static final Vector getHorizontalLookingDirection(float yaw, Player player) {
        return TrigUtil.getLookingDirection(yaw, 0.0f, player);
    }

    public static final Vector getHorizontalLookingDirection(IGetPositionWithLook loc, Player player) {
        return TrigUtil.getHorizontalLookingDirection(loc.getYaw(), player);
    }

    public static final Vector getHorizontalLookingDirection(Location loc, Player player) {
        return TrigUtil.getHorizontalLookingDirection(loc.getYaw(), player);
    }

    public static final double lengthSquared(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public static final double length(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static double distanceToCenterSqr(int bX, int bY, int bZ, double pX, double pY, double pZ) {
        double dX = (double)bX + 0.5 - pX;
        double dY = (double)bY + 0.5 - pY;
        double dZ = (double)bZ + 0.5 - pZ;
        return TrigUtil.lengthSquared(dX, dY, dZ);
    }

    public static double distanceToCenterSqr(Location bLoc, Location loc) {
        return TrigUtil.distanceToCenterSqr(bLoc.getBlockX(), bLoc.getBlockY(), bLoc.getBlockZ(), loc.getX(), loc.getY(), loc.getZ());
    }

    public static final double distance(Location location1, Location location2) {
        return TrigUtil.distance(location1.getX(), location1.getY(), location1.getZ(), location2.getX(), location2.getY(), location2.getZ());
    }

    public static final double distance(PlayerLocation location1, PlayerLocation location2) {
        return TrigUtil.distance(location1.getX(), location1.getY(), location1.getZ(), location2.getX(), location2.getY(), location2.getZ());
    }

    public static final double distance(IGetPosition location1, Location location2) {
        return TrigUtil.distance(location1.getX(), location1.getY(), location1.getZ(), location2.getX(), location2.getY(), location2.getZ());
    }

    public static final double distance(IGetPosition location1, IGetPosition location2) {
        return TrigUtil.distance(location1.getX(), location1.getY(), location1.getZ(), location2.getX(), location2.getY(), location2.getZ());
    }

    public static final double distance(Location location, Block block) {
        return TrigUtil.distance(location.getX(), location.getY(), location.getZ(), 0.5 + (double)block.getX(), 0.5 + (double)block.getY(), 0.5 + (double)block.getZ());
    }

    public static final double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = Math.abs(x1 - x2);
        double dy = Math.abs(y1 - y2);
        double dz = Math.abs(z1 - z2);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static final double distanceSquared(Location location1, Location location2) {
        return TrigUtil.distanceSquared(location1.getX(), location1.getY(), location1.getZ(), location2.getX(), location2.getY(), location2.getZ());
    }

    public static final double distanceSquared(IGetPosition location1, IGetPosition location2) {
        return TrigUtil.distanceSquared(location1.getX(), location1.getY(), location1.getZ(), location2.getX(), location2.getY(), location2.getZ());
    }

    public static final double distanceSquared(IGetPosition location, double x, double z) {
        return TrigUtil.distanceSquared(location.getX(), location.getZ(), x, z);
    }

    public static final double distanceSquared(IGetPosition location1, Location location2) {
        return TrigUtil.distanceSquared(location1.getX(), location1.getY(), location1.getZ(), location2.getX(), location2.getY(), location2.getZ());
    }

    public static final double distanceSquared(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = Math.abs(x1 - x2);
        double dy = Math.abs(y1 - y2);
        double dz = Math.abs(z1 - z2);
        return dx * dx + dy * dy + dz * dz;
    }

    public static final double distanceSquared(double x1, double z1, double x2, double z2) {
        double dx = Math.abs(x1 - x2);
        double dz = Math.abs(z1 - z2);
        return dx * dx + dz * dz;
    }

    public static final double xzDistance(Location location1, Location location2) {
        return TrigUtil.distance(location1.getX(), location1.getZ(), location2.getX(), location2.getZ());
    }

    public static final double xzDistance(IGetPosition location1, IGetPosition location2) {
        return TrigUtil.distance(location1.getX(), location1.getZ(), location2.getX(), location2.getZ());
    }

    public static final double xzDistance(Location location1, IGetPosition location2) {
        return TrigUtil.distance(location1.getX(), location1.getZ(), location2.getX(), location2.getZ());
    }

    public static final double distance(double x1, double z1, double x2, double z2) {
        double dx = Math.abs(x1 - x2);
        double dz = Math.abs(z1 - z2);
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static double angle(double sourceX, double sourceY, double sourceZ, double dirX, double dirY, double dirZ, double targetX, double targetY, double targetZ) {
        double dirLength = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        if (dirLength == 0.0) {
            dirLength = 1.0;
        }
        double dX = targetX - sourceX;
        double dY = targetY - sourceY;
        double dZ = targetZ - sourceZ;
        vec1.setX(dX);
        vec1.setY(dY);
        vec1.setZ(dZ);
        vec2.setX(dirX);
        vec2.setY(dirY);
        vec2.setZ(dirZ);
        return TrigUtil.angle(vec2, vec1);
    }

    public static final double angle(double x, double z) {
        double a;
        if (x > 0.0) {
            a = Math.atan(z / x);
        } else if (x < 0.0) {
            a = Math.atan(z / x) + Math.PI;
        } else if (z < 0.0) {
            a = 4.71238898038469;
        } else if (z > 0.0) {
            a = 1.5707963267948966;
        } else {
            return Double.NaN;
        }
        if (a < 0.0) {
            return a + Math.PI * 2;
        }
        return a;
    }

    public static final double angle(Vector a, Vector b) {
        double theta = Math.min(1.0, Math.max(a.dot(b) / (a.length() * b.length()), -1.0));
        return Math.acos(theta);
    }

    public static final double angleDiff(double a1, double a2) {
        if (Double.isNaN(a1) || Double.isNaN(a2)) {
            return Double.NaN;
        }
        double diff = a2 - a1;
        if (diff < -Math.PI) {
            return diff + Math.PI * 2;
        }
        if (diff > Math.PI) {
            return diff - Math.PI * 2;
        }
        return diff;
    }

    public static final float yawDiff(float fromYaw, float toYaw) {
        if (fromYaw <= -360.0f) {
            fromYaw = -(-fromYaw % 360.0f);
        } else if (fromYaw >= 360.0f) {
            fromYaw %= 360.0f;
        }
        if (toYaw <= -360.0f) {
            toYaw = -(-toYaw % 360.0f);
        } else if (toYaw >= 360.0f) {
            toYaw %= 360.0f;
        }
        float yawDiff = toYaw - fromYaw;
        if (yawDiff < -180.0f) {
            yawDiff += 360.0f;
        } else if (yawDiff > 180.0f) {
            yawDiff -= 360.0f;
        }
        return yawDiff;
    }

    public static int manhattan(Location loc1, Location loc2) {
        return TrigUtil.manhattan(loc1.getBlockX(), loc1.getBlockY(), loc1.getBlockZ(), loc2.getBlockX(), loc2.getBlockY(), loc2.getBlockZ());
    }

    public static int manhattan(int x1, int y1, int z1, Block block) {
        return TrigUtil.manhattan(x1, y1, z1, block.getX(), block.getY(), block.getZ());
    }

    public static int manhattan(int x1, int y1, int z1, int x2, int y2, int z2) {
        return Math.abs(x1 - x2) + Math.abs(y1 - y2) + Math.abs(z1 - z2);
    }

    public static double manhattan(double x1, double y1, double z1, double x2, double y2, double z2) {
        return TrigUtil.manhattan(Location.locToBlock((double)x1), Location.locToBlock((double)y1), Location.locToBlock((double)z1), Location.locToBlock((double)x2), Location.locToBlock((double)y2), Location.locToBlock((double)z2));
    }

    public static int maxDistance(int x1, int y1, int z1, int x2, int y2, int z2) {
        return Math.max(Math.max(Math.abs(x1 - x2), Math.abs(y1 - y2)), Math.abs(z1 - z2));
    }

    public static double maxDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.max(Math.max(Math.abs(x1 - x2), Math.abs(y1 - y2)), Math.abs(z1 - z2));
    }

    public static boolean isMovingBackwards(double xDistance, double zDistance, float yaw) {
        return xDistance < 0.0 && zDistance > 0.0 && yaw > 180.0f && yaw < 270.0f || xDistance < 0.0 && zDistance < 0.0 && yaw > 270.0f && yaw < 360.0f || xDistance > 0.0 && zDistance < 0.0 && yaw > 0.0f && yaw < 90.0f || xDistance > 0.0 && zDistance > 0.0 && yaw > 90.0f && yaw < 180.0f;
    }

    public static boolean isSamePosAndLook(Location loc1, Location loc2) {
        return TrigUtil.isSamePos(loc1, loc2) && loc1.getPitch() == loc2.getPitch() && loc1.getYaw() == loc2.getYaw();
    }

    public static boolean isSamePos(Location loc1, Location loc2) {
        return loc1 != null && loc2 != null && loc1.getX() == loc2.getX() && loc1.getZ() == loc2.getZ() && loc1.getY() == loc2.getY();
    }

    public static boolean isSamePosAndLook(IGetPositionWithLook loc1, Location loc2) {
        return TrigUtil.isSamePos((IGetPosition)loc1, loc2) && loc1.getPitch() == loc2.getPitch() && loc1.getYaw() == loc2.getYaw();
    }

    public static boolean isSamePos(IGetPosition loc1, Location loc2) {
        return loc1 != null && loc2 != null && loc1.getX() == loc2.getX() && loc1.getZ() == loc2.getZ() && loc1.getY() == loc2.getY();
    }

    public static boolean isSamePosAndLook(IGetPositionWithLook loc1, IGetPositionWithLook loc2) {
        return TrigUtil.isSamePos((IGetPosition)loc1, loc2) && loc1.getPitch() == loc2.getPitch() && loc1.getYaw() == loc2.getYaw();
    }

    public static boolean isSamePos(IGetPosition loc1, IGetPosition loc2) {
        return loc1 != null && loc2 != null && loc1.getX() == loc2.getX() && loc1.getZ() == loc2.getZ() && loc1.getY() == loc2.getY();
    }

    public static boolean isSamePos(Location loc, double x, double y, double z) {
        if (loc == null) {
            return false;
        }
        return loc.getX() == x && loc.getZ() == z && loc.getY() == y;
    }

    public static boolean isSamePos(double x1, double y1, double z1, double x2, double y2, double z2) {
        return x1 == x2 && y1 == y2 && z1 == z2;
    }

    public static boolean isSamePos(double x1, double z1, double x2, double z2) {
        return x1 == x2 && z1 == z2;
    }

    public static boolean isSameBlock(Location loc, double x, double y, double z) {
        if (loc == null) {
            return false;
        }
        return loc.getBlockX() == Location.locToBlock((double)x) && loc.getBlockZ() == Location.locToBlock((double)z) && loc.getBlockY() == Location.locToBlock((double)y);
    }

    public static boolean isSameBlock(int x1, int y1, int z1, double x2, double y2, double z2) {
        return x1 == Location.locToBlock((double)x2) && z1 == Location.locToBlock((double)z2) && y1 == Location.locToBlock((double)y2);
    }

    public static boolean isSameBlock(int x, int y, int z, Block block) {
        return x == block.getX() && y == block.getY() && z == block.getZ();
    }

    public static double distanceSquared(Vector vector) {
        return vector.getX() * vector.getX() + vector.getZ() * vector.getZ();
    }

    static {
        for (int i = 0; i < SIN.length; ++i) {
            TrigUtil.SIN[i] = (float)StrictMath.sin((double)i * (Math.PI * 2) / 65536.0);
        }
    }
}

