/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.math;

import org.bukkit.util.Vector;

public class MathUtil {
    public static double clamp(double inputValue, double minParameter, double maxParameter) {
        return inputValue < minParameter ? minParameter : Math.min(inputValue, maxParameter);
    }

    public static float clamp(float inputValue, float minParameter, float maxParameter) {
        return inputValue < minParameter ? minParameter : Math.min(inputValue, maxParameter);
    }

    public static boolean between(double minThreshold, double inputValue, double maxThreshold) {
        return inputValue > minThreshold && inputValue < maxThreshold;
    }

    public static boolean inRange(double minThreshold, double inputValue, double maxThreshold) {
        return inputValue >= minThreshold && inputValue <= maxThreshold;
    }

    public static boolean equal(double a, double b, double c) {
        if (c < 0.0) {
            return false;
        }
        return Math.abs(a - b) <= c;
    }

    public static double dist(double xDistance, double zDistance) {
        return Math.sqrt(MathUtil.square(xDistance) + MathUtil.square(zDistance));
    }

    public static double square(double value) {
        return value * value;
    }

    public static double max3(double a, double b, double c) {
        return Math.max(a, Math.max(b, c));
    }

    public static boolean almostEqual(double a, double b, double c) {
        return Math.abs(a - b) < c;
    }

    public static int floor(double value) {
        int toInt = (int)value;
        return value < (double)toInt ? toInt - 1 : toInt;
    }

    public static int ceil(double value) {
        int toInt = (int)value;
        return value > (double)toInt ? toInt + 1 : toInt;
    }

    public static float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    public static int findClosestIndex(double[] arr, double target) {
        if (arr == null || arr.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty or null.");
        }
        double lastMinOffset = Double.POSITIVE_INFINITY;
        int closestIdx = -1;
        for (int i = 0; i < arr.length; ++i) {
            double thisOffSet = Math.abs(arr[i] - target);
            if (!(thisOffSet < lastMinOffset)) continue;
            lastMinOffset = thisOffSet;
            closestIdx = i;
        }
        return closestIdx;
    }

    public static long[] secToMs(double s1) {
        long v = (long)(s1 * 1000.0);
        return new long[]{v, v, v, v, v, v, v};
    }

    public static double toSeconds(long milliseconds) {
        return (double)milliseconds / 1000.0;
    }

    public static double getCoveredSpace(double sA, double eA, double sB, double eB) {
        return eA - sA + (eB - sB) - Math.max(0.0, Math.min(eA, eB) - Math.max(sA, sB));
    }

    public static boolean rangeContains(double lBMin, double nBMin, double lBMax, double nBMax) {
        boolean isLWithinN = nBMin <= lBMin && lBMax <= nBMax;
        boolean isNWithinL = lBMin <= nBMin && nBMax <= lBMax;
        return isLWithinN || isNWithinL;
    }

    public static float lerp(float factor, float startValue, float endValue) {
        return startValue + factor * (endValue - startValue);
    }

    public static double lerp(double factor, double startValue, double endValue) {
        return startValue + factor * (endValue - startValue);
    }

    public static Vector normalizedVectorWithoutNaN(Vector vector) {
        double var0 = vector.length();
        return var0 < 1.0E-4 ? new Vector() : vector.multiply(1.0 / var0);
    }

    public static int findBits(double min, double max) {
        if (!(min < -1.0E-7) && !(max > 1.0000001)) {
            for (int bitLevel = 0; bitLevel <= 3; ++bitLevel) {
                boolean isMaxCloseToInteger;
                int scaleFactor = 1 << bitLevel;
                double scaledMin = min * (double)scaleFactor;
                double scaledMax = max * (double)scaleFactor;
                boolean isMinCloseToInteger = Math.abs(scaledMin - (double)Math.round(scaledMin)) < 1.0E-7 * (double)scaleFactor;
                boolean bl = isMaxCloseToInteger = Math.abs(scaledMax - (double)Math.round(scaledMax)) < 1.0E-7 * (double)scaleFactor;
                if (!isMinCloseToInteger || !isMaxCloseToInteger) continue;
                return bitLevel;
            }
        }
        return -1;
    }

    public static boolean exceedsAllowedDistance(double distance, double allowedDistance) {
        return Math.abs(distance) > Math.abs(allowedDistance);
    }

    public static boolean isOffsetWithinPredictionEpsilon(double actual, double allowed) {
        return MathUtil.almostEqual(actual, allowed, 1.0E-4);
    }

    public static double absMax(double value1, double value2) {
        if (value1 < 0.0) {
            value1 = -value1;
        }
        if (value2 < 0.0) {
            value2 = -value2;
        }
        return Math.max(value1, value2);
    }
}

