/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.map;

import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeMaterial;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.entity.InventoryUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class MaterialUtil {
    private static final List<String> woodTypes = Arrays.asList("acacia", "birch", "dark_oak", "jungle", "oak", "spruce", "warped", "crimson", "mangrove", "bamboo", "cherry", "pale", "wood");
    public static final Set<Material> ALL_CAULDRONS = Collections.unmodifiableSet(BridgeMaterial.getBySuffix("cauldron", AlmostBoolean.YES, "legacy"));
    public static final Set<Material> ALL_BUTTONS = Collections.unmodifiableSet(BridgeMaterial.getBySuffix("_button", AlmostBoolean.YES, "legacy"));
    public static final Set<Material> ALL_DOORS = Collections.unmodifiableSet(BridgeMaterial.getByPrefixAndSuffix(null, Arrays.asList("_door"), AlmostBoolean.YES, "trap", "legacy"));
    public static final Set<Material> COPPER_BLOCKS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getBySuffix("_copper", AlmostBoolean.YES, new String[0]), "copper_block", "waxed_copper_block"));
    public static final Set<Material> ALL_REFINED_COPPER_BLOCKS = Collections.unmodifiableSet(BridgeMaterial.getByContains(AlmostBoolean.YES, Arrays.asList("copper"), "ore", "raw"));
    public static final Set<Material> COPPER_BULBS = Collections.unmodifiableSet(BridgeMaterial.getBySuffix("copper_bulb", AlmostBoolean.YES, new String[0]));
    public static final Set<Material> COPPER_GRATES = Collections.unmodifiableSet(BridgeMaterial.getBySuffix("copper_grate", AlmostBoolean.YES, new String[0]));
    public static final Set<Material> ALL_TUFF = Collections.unmodifiableSet(BridgeMaterial.getByContains(AlmostBoolean.YES, Arrays.asList("tuff"), new String[0]));
    public static final Set<Material> ALL_CANDLES = Collections.unmodifiableSet(BridgeMaterial.getBySuffix("candle", AlmostBoolean.YES, new String[0]));
    public static final Set<Material> LANTERNS = Collections.unmodifiableSet(BridgeMaterial.getAllBlocks("lantern", "soul_lantern"));
    public static final Set<Material> ALL_CANDLE_CAKE = Collections.unmodifiableSet(BridgeMaterial.getBySuffix("candle_cake", AlmostBoolean.YES, new String[0]));
    public static final Set<Material> ALL_WALLS = Collections.unmodifiableSet(BridgeMaterial.getBySuffix("_wall", AlmostBoolean.YES, "legacy"));
    public static final Set<Material> ALL_STAIRS = Collections.unmodifiableSet(BridgeMaterial.getBySuffix("_stairs", AlmostBoolean.YES, "legacy"));
    public static final Set<Material> ALL_SWORDS = Collections.unmodifiableSet(BridgeMaterial.getBySuffix("_sword", AlmostBoolean.YES, "legacy"));
    public static final Set<Material> ALL_TRAP_DOORS = Collections.unmodifiableSet(BridgeMaterial.getByPrefixAndSuffix(null, Arrays.asList("trapdoor", "trap_door"), AlmostBoolean.YES, "legacy"));
    public static final Set<Material> ALL_PRESSURE_PLATES = Collections.unmodifiableSet(BridgeMaterial.getBySuffix("_pressure_plate", AlmostBoolean.YES, "legacy"));
    public static final Set<Material> RODS = Collections.unmodifiableSet(BridgeMaterial.getBySuffix("_rod", AlmostBoolean.YES, "legacy"));
    public static final Set<Material> AMETHYST = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getByPrefixAndSuffix(null, Arrays.asList("_amethyst_bud", "_amethyst"), AlmostBoolean.YES, new String[0]), "amethyst_block", "amethyst_cluster"));
    public static final Set<Material> BANNERS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getByPrefixAndSuffix(null, Arrays.asList("_banner"), AlmostBoolean.YES, "legacy", "_wall"), "standing_banner"));
    public static final Set<Material> BEDS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getBySuffix("_bed", AlmostBoolean.YES, "legacy"), "bed_block"));
    public static final Set<Material> BOATS;
    public static final Set<Material> ALL_SEEDS;
    private static final List<EntityType> BOATS_TYPE;
    public static final Set<Material> CARPETS;
    public static final Set<Material> CAULDRON;
    public static final Set<Material> CONCRETE_BLOCKS;
    public static final Set<Material> CONCRETE_POWDER_BLOCKS;
    public static final Set<Material> CORAL_BLOCKS;
    public static final Set<Material> DEAD_CORAL_PARTS;
    public static final Set<Material> FLOWER_POTS;
    public static final Set<Material> GLASS_BLOCKS;
    public static final Set<Material> GLASS_PANES;
    public static final Set<Material> GLAZED_TERRACOTTA_BLOCKS;
    public static final Set<Material> HEADS_GROUND;
    public static final Set<Material> HEADS_WALL;
    public static final Set<Material> INFESTED_BLOCKS;
    public static final Set<Material> LAVA;
    public static final Set<Material> LEAVES;
    public static final Set<Material> LOGS;
    public static final Set<Material> MUSHROOM_BLOCKS;
    public static final Set<Material> PLANKS;
    public static final Set<Material> RAILS;
    public static final Set<Material> SHULKER_BOXES;
    public static final Set<Material> SLABS;
    public static final Set<Material> SPAWN_EGGS;
    public static final Set<Material> STRIPPED_LOGS;
    public static final Set<Material> STRIPPED_WOOD_BLOCKS;
    public static final Set<Material> TERRACOTTA_BLOCKS;
    public static final Set<Material> VARIOUS_FULLY_SOLID;
    public static final Set<Material> WALL_BANNERS;
    public static final Set<Material> WATER;
    public static final Set<Material> WATER_PLANTS;
    public static final Set<Material> WOOD_BLOCKS;
    public static final Set<Material> WOODEN_SIGNS;
    public static final Set<Material> WALL_HANGING_SIGNS;
    public static final Set<Material> WOODEN_BUTTONS;
    public static final Set<Material> WOODEN_DOORS;
    public static final Set<Material> WOODEN_FENCES;
    public static final Set<Material> WOODEN_FENCE_GATES;
    public static final Set<Material> WOODEN_PRESSURE_PLATES;
    public static final Set<Material> WOODEN_SLABS;
    public static final Set<Material> WOODEN_STAIRS;
    public static final Set<Material> WOODEN_TRAP_DOORS;
    public static final Set<Material> WOOL_BLOCKS;
    public static final Set<Material> INSTANT_PLANTS;
    public static final Set<Material> FARMABLE;
    public static final Set<Material> FULLY_SOLID_BLOCKS;
    public static final Set<Material> FULLY_PASSABLE_BLOCKS;
    public static final Set<Material> LIQUID_BLOCKS;

    private static List<EntityType> collectTypesBySuffix(String prefix) {
        prefix = prefix.toLowerCase();
        LinkedList<EntityType> res = new LinkedList<EntityType>();
        for (EntityType type : EntityType.values()) {
            if (!type.name().toLowerCase().endsWith(prefix)) continue;
            res.add(type);
        }
        return res;
    }

    private static Set<Material> add(Set<Material> set, String ... names) {
        LinkedHashSet<Material> res = new LinkedHashSet<Material>(set);
        res.addAll(BridgeMaterial.getAll(names));
        return res;
    }

    public static Set<Material> addBlocks(Set<Material> set, String ... names) {
        LinkedHashSet<Material> res = new LinkedHashSet<Material>(set);
        res.addAll(BridgeMaterial.getAllBlocks(names));
        return res;
    }

    public static Set<Material> addBlocks(Set<Material> set, Material ... materials) {
        LinkedHashSet<Material> res = new LinkedHashSet<Material>(set);
        for (Material mat : materials) {
            if (mat == null || !mat.isBlock()) continue;
            res.add(mat);
        }
        return res;
    }

    public static Set<Material> join(Set<Material> ... sets) {
        LinkedHashSet<Material> res = new LinkedHashSet<Material>();
        for (Set<Material> set : sets) {
            res.addAll(set);
        }
        return res;
    }

    public static void dumpStaticSets(Class<?> clazz, Level level) {
        StringBuilder builder = new StringBuilder(6000);
        for (Field field : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
            try {
                Object obj = field.get(clazz);
                if (!(obj instanceof Set)) continue;
                Set set = (Set)obj;
                builder.append(clazz.getName());
                builder.append('.');
                builder.append(field.getName());
                builder.append(": ");
                StringUtil.join(set, ", ", builder);
                builder.append('\n');
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        StaticLog.log(level, builder.toString());
    }

    public static boolean isSword(Material mat) {
        return ALL_SWORDS.contains(mat);
    }

    public static boolean isBoat(Material mat) {
        return BOATS.contains(mat);
    }

    public static boolean isSpawnEgg(Material mat) {
        return SPAWN_EGGS.contains(mat);
    }

    public static boolean isLog(Material mat) {
        return LOGS.contains(mat);
    }

    public static boolean isSign(Material mat) {
        return WOODEN_SIGNS.contains(mat);
    }

    public static boolean isSeedable(Material mat) {
        return mat == BridgeMaterial.CARROTS || ALL_SEEDS.contains(mat) || mat == BridgeMaterial.POTATOES || mat == BridgeMaterial.BEETROOTS;
    }

    public static boolean isBoat(EntityType entity) {
        return BOATS_TYPE.contains(entity);
    }

    public static boolean isFarmable(Material mat) {
        return MaterialUtil.isSeedable(mat) || FARMABLE.contains(mat);
    }

    public static boolean isAnySign(Material mat) {
        return WOODEN_SIGNS.contains(mat) || WALL_HANGING_SIGNS.contains(mat);
    }

    static {
        HashSet<Material> temp = new HashSet<Material>();
        HashSet<Material> seedsTemp = new HashSet<Material>();
        if (BridgeMaterial.get("boat") != null) {
            temp.add(BridgeMaterial.get("boat"));
        }
        seedsTemp.addAll(InventoryUtil.collectItemsBySuffix("_SEEDS"));
        temp.addAll(InventoryUtil.collectItemsByPrefix("BOAT_"));
        temp.addAll(InventoryUtil.collectItemsBySuffix("_BOAT"));
        BOATS = Collections.unmodifiableSet(temp);
        ALL_SEEDS = Collections.unmodifiableSet(seedsTemp);
        BOATS_TYPE = MaterialUtil.collectTypesBySuffix("BOAT");
        CARPETS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getBySuffix("_carpet", AlmostBoolean.YES, "legacy"), "carpet"));
        CAULDRON = Collections.unmodifiableSet(BridgeMaterial.getBySuffix("cauldron", AlmostBoolean.YES, "legacy"));
        CONCRETE_BLOCKS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getBySuffix("_concrete", AlmostBoolean.YES, "legacy"), "concrete"));
        CONCRETE_POWDER_BLOCKS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getBySuffix("_concrete_powder", AlmostBoolean.YES, "legacy"), "concrete_powder"));
        CORAL_BLOCKS = Collections.unmodifiableSet(BridgeMaterial.getBySuffix("coral_block", AlmostBoolean.YES, "legacy"));
        DEAD_CORAL_PARTS = Collections.unmodifiableSet(BridgeMaterial.getByPrefixAndSuffix(Arrays.asList("dead_"), Arrays.asList("coral_fan", "coral_wall_fan", "coral"), AlmostBoolean.YES, "block", "legacy"));
        FLOWER_POTS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getByPrefix("potted_", AlmostBoolean.YES), "flower_pot"));
        GLASS_BLOCKS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getBySuffix("_glass", AlmostBoolean.YES, "legacy", "thin"), "glass"));
        GLASS_PANES = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getBySuffix("_glass_pane", AlmostBoolean.YES, "legacy"), "glass_pane", "thin_glass"));
        GLAZED_TERRACOTTA_BLOCKS = Collections.unmodifiableSet(BridgeMaterial.getBySuffix("glazed_terracotta", AlmostBoolean.YES, "legacy"));
        HEADS_GROUND = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getByPrefixAndSuffix(null, Arrays.asList("_skull", "_head"), AlmostBoolean.YES, "legacy", "_wall_"), "skull"));
        HEADS_WALL = Collections.unmodifiableSet(BridgeMaterial.getByPrefixAndSuffix(null, Arrays.asList("_wall_skull", "_wall_head"), AlmostBoolean.YES, "legacy"));
        INFESTED_BLOCKS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getByPrefix("infested_", AlmostBoolean.YES), "monster_eggs"));
        LAVA = Collections.unmodifiableSet(BridgeMaterial.getAllBlocks("lava", "stationary_lava"));
        LEAVES = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getByPrefixAndSuffix(woodTypes, Arrays.asList("_leaves"), AlmostBoolean.YES, new String[0]), "leaves", "leaves_2", "azalea_leaves", "flowering_azalea_leaves"));
        LOGS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getByPrefixAndSuffix(woodTypes, Arrays.asList("_log"), AlmostBoolean.YES, "legacy"), "log", "log_2"));
        MUSHROOM_BLOCKS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getBySuffix("_mushroom_block", AlmostBoolean.YES, "legacy"), "mushroom_stem", "huge_mushroom_1", "huge_mushroom_2"));
        PLANKS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getBySuffix("_planks", AlmostBoolean.YES, "legacy"), "wood"));
        RAILS = Collections.unmodifiableSet(BridgeMaterial.getBySuffix(Arrays.asList("rail", "rails"), AlmostBoolean.YES, "legacy"));
        SHULKER_BOXES = Collections.unmodifiableSet(BridgeMaterial.getBySuffix("shulker_box", AlmostBoolean.YES, "legacy"));
        SLABS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getBySuffix(Arrays.asList("_slab", "_step"), AlmostBoolean.YES, "legacy"), "step"));
        SPAWN_EGGS = Collections.unmodifiableSet(MaterialUtil.add(BridgeMaterial.getBySuffix("_spawn_egg", AlmostBoolean.YES, "legacy"), "monster_egg"));
        STRIPPED_LOGS = Collections.unmodifiableSet(BridgeMaterial.getByPrefixAndSuffix(Arrays.asList("stripped_"), Arrays.asList("_log"), AlmostBoolean.YES, new String[0]));
        STRIPPED_WOOD_BLOCKS = Collections.unmodifiableSet(BridgeMaterial.getByPrefixAndSuffix(Arrays.asList("stripped_"), Arrays.asList("_wood"), AlmostBoolean.YES, new String[0]));
        TERRACOTTA_BLOCKS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getByPrefixAndSuffix(null, Arrays.asList("_terracotta"), AlmostBoolean.YES, "legacy", "glazed"), "terracotta", "hard_clay", "stained_clay"));
        VARIOUS_FULLY_SOLID = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getBySuffix(Arrays.asList("_bricks", "_ore", "prismarine", "andesite", "diorite", "granite", "sandstone", "command_block", "command"), AlmostBoolean.YES, "legacy"), "barrier", "structure_block", "note_block", "tnt", "jukebox", "jack_o_lantern", "dispenser", "dropper", "furnace", "observer", "beacon", "pumpkin", "melon_block", "hay_block", "bone_block", "dried_kelp_block", "nether_wart_block", "netherrack", "warped_wart_block", "snow_block", "ice", "magma_block", "diamond_block", "gold_block", "iron_block", "coal_block", "emerald_block", "lapis_block", "redstone_block", "purpur_block", "smooth_stone", "smooth_quartz", "quartz_block", "quartz_pillar", "bookshelf", "sand", "stone", "gravel", "dirt", "grass_block", "grass", "obsidian", "clay", "cobblestone", "mossy_cobblestone", "sea_lantern", "redstone_lamp", "glowstone", "sponge", "wet_sponge", "budding_amethyst", "amethyst_block", "calcite", "tuff", "moss_block", "rooted_dirt", "dripstone_block", "pale_moss_block"));
        WALL_BANNERS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getByPrefixAndSuffix(null, Arrays.asList("_wall_banner"), AlmostBoolean.YES, "legacy"), "wall_banner"));
        WATER = Collections.unmodifiableSet(BridgeMaterial.getAllBlocks("water", "stationary_water"));
        WATER_PLANTS = Collections.unmodifiableSet(BridgeMaterial.getAllBlocks("TALL_SEAGRASS", "KELP_PLANT", "SEAGRASS", "KELP"));
        WOOD_BLOCKS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getByPrefixAndSuffix(woodTypes, Arrays.asList("_wood"), AlmostBoolean.YES, new String[0]), "wood"));
        WOODEN_SIGNS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getByPrefixAndSuffix(woodTypes, Arrays.asList("_sign"), AlmostBoolean.YES, new String[0]), "sign", "wall_sign", "_wall_hanging_sign"));
        WALL_HANGING_SIGNS = Collections.unmodifiableSet(BridgeMaterial.getByPrefixAndSuffix(woodTypes, Arrays.asList("_wall_hanging_sign"), AlmostBoolean.YES, new String[0]));
        WOODEN_BUTTONS = Collections.unmodifiableSet(BridgeMaterial.getByPrefixAndSuffix(woodTypes, Arrays.asList("_button"), AlmostBoolean.YES, new String[0]));
        WOODEN_DOORS = Collections.unmodifiableSet(BridgeMaterial.getByPrefixAndSuffix(woodTypes, Arrays.asList("_door"), AlmostBoolean.YES, "trap"));
        WOODEN_FENCES = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getByPrefixAndSuffix(woodTypes, Arrays.asList("_fence"), AlmostBoolean.YES, new String[0]), "fence"));
        WOODEN_FENCE_GATES = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getByPrefixAndSuffix(woodTypes, Arrays.asList("_fence_gate"), AlmostBoolean.YES, new String[0]), "fence_gate"));
        WOODEN_PRESSURE_PLATES = Collections.unmodifiableSet(BridgeMaterial.getByPrefixAndSuffix(woodTypes, Arrays.asList("_plate"), AlmostBoolean.YES, new String[0]));
        WOODEN_SLABS = Collections.unmodifiableSet(BridgeMaterial.getByPrefixAndSuffix(woodTypes, Arrays.asList("_slab", "_step"), AlmostBoolean.YES, "double"));
        WOODEN_STAIRS = Collections.unmodifiableSet(BridgeMaterial.getByPrefixAndSuffix(woodTypes, Arrays.asList("_stairs"), AlmostBoolean.YES, new String[0]));
        WOODEN_TRAP_DOORS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getByPrefixAndSuffix(woodTypes, Arrays.asList("_trap_door", "_trapdoor"), AlmostBoolean.YES, new String[0]), "trap_door"));
        WOOL_BLOCKS = Collections.unmodifiableSet(MaterialUtil.addBlocks(BridgeMaterial.getBySuffix("_wool", AlmostBoolean.YES, "legacy"), "wool"));
        INSTANT_PLANTS = Collections.unmodifiableSet(MaterialUtil.join(BridgeMaterial.getBySuffix(Arrays.asList("bush", "sapling", "tulip", "orchid", "mushroom", "bluet", "fungus", "roots"), AlmostBoolean.YES, "legacy", "potted", "muddy", "mangrove"), BridgeMaterial.getByPrefixAndSuffix(null, Arrays.asList("coral_fan", "coral_wall_fan", "coral"), AlmostBoolean.YES, "dead", "legacy"), BridgeMaterial.getAllBlocks("attached_melon_stem", "attached_pumpkin_stem", "allium", "dandelion", "dandelion_yellow", "double_plant", "fern", "kelp", "kelp_plant", "large_fern", "lilac", "melon_stem", "nether_wart", "nether_warts", "oxeye_daisy", "peony", "poppy", "red_rose", "rose_red", "seagrass", "sunflower", "tall_seagrass", "yellow_flower", "spore_blossom", "small_dripleaf", "cave_vines", "cave_vines_plant", "weeping_vines", "weeping_vines_plant", "twisting_vines", "twisting_vines_plant", "mangrove_propagule", "pink_petals", "torchflower", "torchflower_crop", "pitcher_plant", "open_eyeblossom", "closed_eyeblossom", "pale_hanging_moss", "leaf_litter", "cactus_flower", "short_dry_grass", "tall_dry_grass", "wildflowers"), new HashSet<Material>(Arrays.asList(BridgeMaterial.TALL_GRASS, BridgeMaterial.WHEAT_CROPS, BridgeMaterial.CARROTS, BridgeMaterial.POTATOES, BridgeMaterial.GRASS, Material.PUMPKIN_STEM, Material.MELON_STEM, BridgeMaterial.SUGAR_CANE, BridgeMaterial.BEETROOTS))));
        FARMABLE = Collections.unmodifiableSet(MaterialUtil.join(new HashSet<Material>(Arrays.asList(BridgeMaterial.TALL_GRASS, BridgeMaterial.WHEAT_CROPS, BridgeMaterial.CARROTS, BridgeMaterial.POTATOES, BridgeMaterial.GRASS, Material.PUMPKIN_STEM, Material.MELON_STEM, BridgeMaterial.SUGAR_CANE, BridgeMaterial.BEETROOTS)), WATER_PLANTS, BridgeMaterial.getAllBlocks("peony", "sunflower", "lilac", "rose_bush", "sweet_berry_bush", "cocoa", "double_plant", "fern", "large_fern", "attached_melon_stem", "attached_pumpkin_stem", "bamboo", "bamboo_sapling", "wildflowers", "pink_petals", "mangrove_propagule")));
        FULLY_SOLID_BLOCKS = Collections.unmodifiableSet(MaterialUtil.join(CONCRETE_BLOCKS, CONCRETE_POWDER_BLOCKS, CORAL_BLOCKS, COPPER_BLOCKS, COPPER_GRATES, COPPER_BULBS, GLASS_BLOCKS, GLAZED_TERRACOTTA_BLOCKS, INFESTED_BLOCKS, LEAVES, LOGS, MUSHROOM_BLOCKS, PLANKS, STRIPPED_LOGS, STRIPPED_WOOD_BLOCKS, TERRACOTTA_BLOCKS, VARIOUS_FULLY_SOLID, WOOD_BLOCKS, WOOL_BLOCKS, new HashSet<Material>(Arrays.asList(BridgeMaterial.BRICKS, BridgeMaterial.MYCELIUM, BridgeMaterial.CRAFTING_TABLE, BridgeMaterial.END_STONE))));
        FULLY_PASSABLE_BLOCKS = Collections.unmodifiableSet(MaterialUtil.join(ALL_BUTTONS, ALL_PRESSURE_PLATES, BANNERS, RAILS, WALL_BANNERS, INSTANT_PLANTS, WATER_PLANTS, BridgeMaterial.getAllBlocks("structure_void", "end_gateway"), new HashSet<Material>(Arrays.asList(Material.LEVER, BridgeMaterial.END_PORTAL, BridgeMaterial.NETHER_PORTAL))));
        LIQUID_BLOCKS = Collections.unmodifiableSet(MaterialUtil.join(DEAD_CORAL_PARTS, WATER_PLANTS));
    }
}

