/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.map;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.collision.Axis;
import fr.neatmonster.nocheatplus.utilities.ds.map.BlockCoord;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class MapUtil {
    public static BlockFace matchBlockFace(int x, int y, int z) {
        for (BlockFace blockFace : BlockFace.values()) {
            if (blockFace.getModX() != x || blockFace.getModY() != y || blockFace.getModZ() != z) continue;
            return blockFace;
        }
        return null;
    }

    public static final boolean isFullBounds(double[] bounds) {
        if (bounds == null) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (bounds[i] > 0.0) {
                return false;
            }
            if (!(bounds[i + 3] < 1.0)) continue;
            return false;
        }
        return true;
    }

    public static int ensureChunksLoaded(World world, double x, double z, double xzMargin) {
        int loaded = 0;
        if (world == null) {
            return 0;
        }
        int minX = Location.locToBlock((double)(x - xzMargin)) / 16;
        int maxX = Location.locToBlock((double)(x + xzMargin)) / 16;
        int minZ = Location.locToBlock((double)(z - xzMargin)) / 16;
        int maxZ = Location.locToBlock((double)(z + xzMargin)) / 16;
        for (int cx = minX; cx <= maxX; ++cx) {
            for (int cz = minZ; cz <= maxZ; ++cz) {
                if (world.isChunkLoaded(cx, cz)) continue;
                try {
                    world.getChunkAt(cx, cz);
                    ++loaded;
                    continue;
                }
                catch (Exception ex) {
                    NCPAPIProvider.getNoCheatPlusAPI().getLogManager().severe(Streams.STATUS, "Failed to load chunk at " + cx * 16 + "," + cz * 16 + " (real coordinates):\n" + StringUtil.throwableToString(ex));
                }
            }
        }
        return loaded;
    }

    public static List<BlockCoord> getNeighborsInDirection(BlockCoord source, Vector direction, double eyeX, double eyeY, double eyeZ, Axis.RichAxisData axisData) {
        int stepX;
        int stepY;
        ArrayList<BlockCoord> neighbors = new ArrayList<BlockCoord>();
        int n = direction.getY() > 0.0 ? 1 : (stepY = direction.getY() < 0.0 ? -1 : 0);
        int n2 = direction.getX() > 0.0 ? 1 : (stepX = direction.getX() < 0.0 ? -1 : 0);
        int stepZ = direction.getZ() > 0.0 ? 1 : (direction.getZ() < 0.0 ? -1 : 0);
        Axis priorityAxis = Axis.NONE;
        BlockChangeTracker.Direction excludeDir = BlockChangeTracker.Direction.NONE;
        boolean allowX = true;
        boolean allowY = true;
        boolean allowZ = true;
        if (axisData != null) {
            priorityAxis = axisData.priority;
            excludeDir = axisData.dirExclusion;
            axisData.priority = Axis.NONE;
            axisData.dirExclusion = BlockChangeTracker.Direction.NONE;
            allowX = !(excludeDir == BlockChangeTracker.Direction.X_NEG && stepX < 0 || excludeDir == BlockChangeTracker.Direction.X_POS && stepX > 0);
            allowY = !(excludeDir == BlockChangeTracker.Direction.Y_NEG && stepY < 0 || excludeDir == BlockChangeTracker.Direction.Y_POS && stepY > 0);
            allowZ = !(excludeDir == BlockChangeTracker.Direction.Z_NEG && stepZ < 0 || excludeDir == BlockChangeTracker.Direction.Z_POS && stepZ > 0);
        }
        switch (priorityAxis) {
            case X_AXIS: {
                neighbors.add(new BlockCoord(source.getX() + stepX, source.getY(), source.getZ()));
                if (allowZ) {
                    neighbors.add(new BlockCoord(source.getX(), source.getY(), source.getZ() + stepZ));
                }
                if (allowY) {
                    neighbors.add(new BlockCoord(source.getX(), source.getY() + stepY, source.getZ()));
                }
                return neighbors;
            }
            case Y_AXIS: {
                neighbors.add(new BlockCoord(source.getX(), source.getY() + stepY, source.getZ()));
                if (allowX) {
                    neighbors.add(new BlockCoord(source.getX() + stepX, source.getY(), source.getZ()));
                }
                if (allowZ) {
                    neighbors.add(new BlockCoord(source.getX(), source.getY(), source.getZ() + stepZ));
                }
                return neighbors;
            }
            case Z_AXIS: {
                neighbors.add(new BlockCoord(source.getX(), source.getY(), source.getZ() + stepZ));
                if (allowX) {
                    neighbors.add(new BlockCoord(source.getX() + stepX, source.getY(), source.getZ()));
                }
                if (allowY) {
                    neighbors.add(new BlockCoord(source.getX(), source.getY() + stepY, source.getZ()));
                }
                return neighbors;
            }
        }
        double manhattanY = TrigUtil.manhattan((double)source.getX(), (double)(source.getY() + stepY), (double)source.getZ(), eyeX, eyeY, eyeZ);
        double manhattanZ = TrigUtil.manhattan((double)source.getX(), (double)source.getY(), (double)(source.getZ() + stepZ), eyeX, eyeY, eyeZ);
        double manhattanX = TrigUtil.manhattan((double)(source.getX() + stepX), (double)source.getY(), (double)source.getZ(), eyeX, eyeY, eyeZ);
        if (manhattanY <= manhattanX && manhattanY <= manhattanZ && Math.abs(direction.getY()) >= 0.5) {
            if (allowY) {
                neighbors.add(new BlockCoord(source.getX(), source.getY() + stepY, source.getZ()));
            }
            if (manhattanX < manhattanZ) {
                if (allowX) {
                    neighbors.add(new BlockCoord(source.getX() + stepX, source.getY(), source.getZ()));
                }
                if (allowZ) {
                    neighbors.add(new BlockCoord(source.getX(), source.getY(), source.getZ() + stepZ));
                }
            } else {
                if (allowZ) {
                    neighbors.add(new BlockCoord(source.getX(), source.getY(), source.getZ() + stepZ));
                }
                if (allowX) {
                    neighbors.add(new BlockCoord(source.getX() + stepX, source.getY(), source.getZ()));
                }
            }
            return neighbors;
        }
        if (manhattanX < manhattanZ) {
            if (allowX) {
                neighbors.add(new BlockCoord(source.getX() + stepX, source.getY(), source.getZ()));
            }
            if (allowZ) {
                neighbors.add(new BlockCoord(source.getX(), source.getY(), source.getZ() + stepZ));
            }
            if (allowY) {
                neighbors.add(new BlockCoord(source.getX(), source.getY() + stepY, source.getZ()));
            }
        } else {
            if (allowZ) {
                neighbors.add(new BlockCoord(source.getX(), source.getY(), source.getZ() + stepZ));
            }
            if (allowX) {
                neighbors.add(new BlockCoord(source.getX() + stepX, source.getY(), source.getZ()));
            }
            if (allowY) {
                neighbors.add(new BlockCoord(source.getX(), source.getY() + stepY, source.getZ()));
            }
        }
        return neighbors;
    }
}

