/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.map;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.blocks.BlockPropertiesSetup;
import fr.neatmonster.nocheatplus.compat.blocks.init.BlockInit;
import fr.neatmonster.nocheatplus.compat.blocks.init.vanilla.VanillaBlocksFactory;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeEnchant;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeMaterial;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgePotionEffect;
import fr.neatmonster.nocheatplus.compat.versions.ClientVersion;
import fr.neatmonster.nocheatplus.components.registry.event.IHandle;
import fr.neatmonster.nocheatplus.config.RawConfigFile;
import fr.neatmonster.nocheatplus.config.WorldConfigProvider;
import fr.neatmonster.nocheatplus.logging.LogManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.collision.AxisAlignedBBUtils;
import fr.neatmonster.nocheatplus.utilities.collision.BlockPositionContainer;
import fr.neatmonster.nocheatplus.utilities.collision.supportingblock.SupportingBlockUtils;
import fr.neatmonster.nocheatplus.utilities.collision.tracing.axis.ICollidePassable;
import fr.neatmonster.nocheatplus.utilities.collision.tracing.axis.PassableAxisTracing;
import fr.neatmonster.nocheatplus.utilities.collision.tracing.ray.PassableRayTracing;
import fr.neatmonster.nocheatplus.utilities.entity.PotionUtil;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.location.RichEntityLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import fr.neatmonster.nocheatplus.utilities.map.WrapBlockCache;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import fr.neatmonster.nocheatplus.utilities.moving.MovingUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Snow;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class BlockProperties {
    public static final double LIQUID_HEIGHT_LOWERED = 0.8888888955116272;
    protected static final Map<Material, BlockProps> blocks = new HashMap<Material, BlockProps>();
    protected static Map<Material, ToolProps> tools = new LinkedHashMap<Material, ToolProps>(50, 0.5f);
    private static Map<BlockBreakKey, Long> breakingTimeOverrides = new HashMap<BlockBreakKey, Long>();
    public static final long indestructible = Long.MAX_VALUE;
    public static final ToolProps noTool = new ToolProps(ToolType.NONE, MaterialBase.NONE);
    public static final ToolProps woodSword = new ToolProps(ToolType.SWORD, MaterialBase.WOOD);
    public static final ToolProps woodSpade = new ToolProps(ToolType.SPADE, MaterialBase.WOOD);
    public static final ToolProps woodPickaxe = new ToolProps(ToolType.PICKAXE, MaterialBase.WOOD);
    public static final ToolProps woodAxe = new ToolProps(ToolType.AXE, MaterialBase.WOOD);
    public static final ToolProps woodHoe = new ToolProps(ToolType.HOE, MaterialBase.WOOD);
    public static final ToolProps stonePickaxe = new ToolProps(ToolType.PICKAXE, MaterialBase.STONE);
    public static final ToolProps ironPickaxe = new ToolProps(ToolType.PICKAXE, MaterialBase.IRON);
    public static final ToolProps diamondPickaxe = new ToolProps(ToolType.PICKAXE, MaterialBase.DIAMOND);
    public static final long[] instantTimes = MathUtil.secToMs(0.0);
    private static final long[] indestructibleTimes = new long[]{Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE};
    public static final BlockProps instantType = new BlockProps(noTool, 0.0f, instantTimes);
    public static final BlockProps glassType = new BlockProps(noTool, 0.3f);
    public static final BlockProps gravelType = new BlockProps(woodSpade, 0.6f);
    public static final BlockProps stoneTypeI = new BlockProps(woodPickaxe, 1.5f, true);
    public static final BlockProps stoneTypeII = new BlockProps(woodPickaxe, 2.0f, true);
    public static final BlockProps woodType = new BlockProps(woodAxe, 2.0f);
    public static final BlockProps brickType = new BlockProps(woodPickaxe, 2.0f, true);
    public static final BlockProps coalType = new BlockProps(woodPickaxe, 3.0f, true);
    public static final BlockProps goldBlockType = new BlockProps(woodPickaxe, 3.0f, true);
    public static final BlockProps ironBlockType = new BlockProps(woodPickaxe, 5.0f, true);
    public static final BlockProps diamondBlockType = new BlockProps(woodPickaxe, 5.0f, true);
    public static final BlockProps hugeMushroomType = new BlockProps(woodAxe, 0.2f);
    public static final BlockProps leafType = new BlockProps(noTool, 0.2f);
    public static final BlockProps sandType = new BlockProps(woodSpade, 0.5f);
    public static final BlockProps leverType = new BlockProps(noTool, 0.5f);
    public static final BlockProps sandStoneType = new BlockProps(woodPickaxe, 0.8f, true);
    public static final BlockProps chestType = new BlockProps(woodAxe, 2.5f);
    public static final BlockProps woodDoorType = new BlockProps(woodAxe, 3.0f);
    public static final BlockProps dispenserType = new BlockProps(woodPickaxe, 3.5f, true);
    public static final BlockProps ironDoorType = new BlockProps(woodPickaxe, 5.0f, true);
    public static final BlockProps indestructibleType = new BlockProps(noTool, -1.0f, indestructibleTimes);
    private static BlockProps defaultBlockProps = instantType;
    private static ICollidePassable rtRay = null;
    private static ICollidePassable rtAxis = null;
    private static WrapBlockCache wrapBlockCache = null;
    private static RichEntityLocation eLoc = null;
    private static int minWorldY = 0;
    private static boolean specialCaseTrapDoorAboveLadder = false;
    protected static float breakPenaltyInWater = 5.0f;
    protected static float breakPenaltyOffGround = 5.0f;
    private static final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public static final double getVerticalFrictionFactor(LivingEntity entity, Location location, double yOnGround, PlayerMoveData thisMove) {
        double friction;
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(location.getWorld());
        eLoc.setBlockCache(blockCache);
        Location loc = new Location(location.getWorld(), thisMove.from.getX(), thisMove.from.getY(), thisMove.from.getZ());
        eLoc.set(loc, (Entity)entity, yOnGround);
        if (eLoc.isInWater()) {
            thisMove.submergedWaterHeight = eLoc.getSubmergedLiquidHeight(BlockFlags.F_WATER);
            friction = 0.8;
        } else if (eLoc.isInLava()) {
            double liquidHeight;
            thisMove.submergedLavaHeight = liquidHeight = eLoc.getSubmergedLiquidHeight(BlockFlags.F_LAVA);
            friction = liquidHeight <= (eLoc.getEyeHeight() < 0.4 ? 0.0 : 0.4) ? 0.8 : 0.5;
        } else {
            friction = 0.98;
        }
        blockCache.cleanup();
        eLoc.cleanup();
        return friction;
    }

    public static final float getHorizontalFrictionFactor(LivingEntity entity, Location rawLoc, double yOnGround, PlayerMoveData thisMove) {
        Material blockBelow;
        double yBelow;
        if (entity instanceof Player && ((Player)entity).isFlying() || Bridge1_9.isGliding(entity)) {
            return 1.0f;
        }
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(rawLoc.getWorld());
        eLoc.setBlockCache(blockCache);
        Location correctedLoc = new Location(rawLoc.getWorld(), thisMove.from.getX(), thisMove.from.getY(), thisMove.from.getZ());
        eLoc.set(correctedLoc, (Entity)entity, yOnGround);
        IPlayerData pData = DataManager.getPlayerData((Player)entity);
        double d = yBelow = pData.getClientVersion().isAtLeast(ClientVersion.V_1_15) ? 0.5000001 : 1.0;
        if (pData.getClientVersion().isAtLeast(ClientVersion.V_1_20)) {
            Vector supportingBlock = SupportingBlockUtils.getOnPos(blockCache, eLoc.getLocation(), pData.getSupportingBlockData(), (float)yBelow);
            blockBelow = eLoc.getBlockType((int)supportingBlock.getX(), (int)supportingBlock.getY(), (int)supportingBlock.getZ());
        } else {
            blockBelow = eLoc.getBlockType(eLoc.getBlockX(), Location.locToBlock((double)(eLoc.getY() - yBelow)), eLoc.getBlockZ());
        }
        float friction = 0.6f;
        if (BlockProperties.isBlueIce(blockBelow)) {
            friction = 0.989f;
        } else if (BlockProperties.isIce(blockBelow)) {
            friction = 0.98f;
        } else if (BlockProperties.isSlime(blockBelow)) {
            friction = 0.8f;
        }
        blockCache.cleanup();
        eLoc.cleanup();
        return friction;
    }

    public static final double getStuckInBlockVerticalFactor(LivingEntity entity, Location location, double yOnGround, PlayerMoveData thisMove) {
        if (entity instanceof Player && ((Player)entity).isFlying()) {
            return 1.0;
        }
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(location.getWorld());
        eLoc.setBlockCache(blockCache);
        Location loc = new Location(location.getWorld(), thisMove.from.getX(), thisMove.from.getY(), thisMove.from.getZ());
        eLoc.set(loc, (Entity)entity, yOnGround);
        double stuckInFactor = 1.0;
        if (eLoc.isInBerryBush()) {
            stuckInFactor = 0.75;
        } else if (eLoc.isInPowderSnow()) {
            stuckInFactor = 1.5;
        } else if (eLoc.isInWeb()) {
            stuckInFactor = BridgePotionEffect.WEAVING != null && entity.hasPotionEffect(PotionEffectType.WEAVING) ? 0.25 : 0.05;
        }
        blockCache.cleanup();
        eLoc.cleanup();
        return stuckInFactor;
    }

    public static final double getStuckInBlockHorizontalFactor(LivingEntity entity, Location rawLoc, double yOnGround, PlayerMoveData thisMove) {
        if (entity instanceof Player && ((Player)entity).isFlying()) {
            return 1.0;
        }
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(rawLoc.getWorld());
        Location loc = new Location(rawLoc.getWorld(), thisMove.from.getX(), thisMove.from.getY(), thisMove.from.getZ());
        eLoc.setBlockCache(blockCache);
        eLoc.set(loc, (Entity)entity, yOnGround);
        double stuckInFactor = 1.0;
        if (eLoc.isInWeb()) {
            stuckInFactor = BridgePotionEffect.WEAVING != null && entity.hasPotionEffect(PotionEffectType.WEAVING) ? 0.5 : 0.25;
        } else if (eLoc.isInBerryBush()) {
            stuckInFactor = 0.8;
        } else if (eLoc.isInPowderSnow()) {
            stuckInFactor = 0.9f;
        }
        blockCache.cleanup();
        eLoc.cleanup();
        return stuckInFactor;
    }

    public static final float getBlockSpeedFactor(LivingEntity entity, Location rawLoc, double yOnGround, PlayerMoveData thisMove) {
        if (entity instanceof Player && ((Player)entity).isFlying() || Bridge1_9.isGliding(entity)) {
            return 1.0f;
        }
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        IPlayerData pData = DataManager.getPlayerData((Player)entity);
        blockCache.setAccess(rawLoc.getWorld());
        eLoc.setBlockCache(blockCache);
        Location correctedLoc = new Location(rawLoc.getWorld(), thisMove.from.getX(), thisMove.from.getY(), thisMove.from.getZ());
        eLoc.set(correctedLoc, (Entity)entity, yOnGround);
        float speedFactor = 1.0f;
        Material blockBelow = eLoc.getBlockType();
        if (blockBelow == Material.SOUL_SAND) {
            speedFactor = BridgeEnchant.hasSoulSpeed((Player)entity) ? 1.0f : 0.4f;
        } else if ((BlockFlags.getBlockFlags(blockBelow) & BlockFlags.F_STICKY) != 0L) {
            speedFactor = 0.4f;
        }
        if (!BlockProperties.isWater(blockBelow) && !BlockProperties.isBubbleColumn(blockBelow) && speedFactor == 1.0f) {
            Material blockBelow2;
            double yBelow;
            double d = yBelow = pData.getClientVersion().isAtLeast(ClientVersion.V_1_15) ? 0.5000001 : 1.0;
            if (pData.getClientVersion().isAtLeast(ClientVersion.V_1_20)) {
                Vector supportingBlock = SupportingBlockUtils.getOnPos(blockCache, eLoc.getLocation(), pData.getSupportingBlockData(), (float)yBelow);
                blockBelow2 = eLoc.getBlockType((int)supportingBlock.getX(), (int)supportingBlock.getY(), (int)supportingBlock.getZ());
            } else {
                blockBelow2 = eLoc.getBlockType(eLoc.getBlockX(), Location.locToBlock((double)(eLoc.getY() - yBelow)), eLoc.getBlockZ());
            }
            if (blockBelow2 == Material.SOUL_SAND) {
                speedFactor = BridgeEnchant.hasSoulSpeed((Player)entity) ? 1.0f : 0.4f;
            } else if ((BlockFlags.getBlockFlags(blockBelow2) & BlockFlags.F_STICKY) != 0L) {
                speedFactor = 0.4f;
            }
        }
        blockCache.cleanup();
        eLoc.cleanup();
        return speedFactor;
    }

    public static boolean isInLiquid(Player player, Location location, double yOnGround) {
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(location.getWorld());
        eLoc.setBlockCache(blockCache);
        eLoc.set(location, (Entity)player, yOnGround);
        boolean res = eLoc.isInLiquid();
        blockCache.cleanup();
        eLoc.cleanup();
        return res;
    }

    public static boolean isInWater(Player player, Location location, double yOnGround) {
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(location.getWorld());
        eLoc.setBlockCache(blockCache);
        eLoc.set(location, (Entity)player, yOnGround);
        boolean res = eLoc.isInWater();
        blockCache.cleanup();
        eLoc.cleanup();
        return res;
    }

    public static boolean isInWeb(Player player, Location location, double yOnGround) {
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(location.getWorld());
        eLoc.setBlockCache(blockCache);
        eLoc.set(location, (Entity)player, yOnGround);
        boolean res = eLoc.isInWeb();
        blockCache.cleanup();
        eLoc.cleanup();
        return res;
    }

    public static boolean isOnGround(Player player, Location location, double yOnGround) {
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(location.getWorld());
        eLoc.setBlockCache(blockCache);
        eLoc.set(location, (Entity)player, yOnGround);
        boolean res = eLoc.isOnGround();
        blockCache.cleanup();
        eLoc.cleanup();
        return res;
    }

    public static boolean isOnGroundOrResetCond(Player player, Location location, double yOnGround) {
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(location.getWorld());
        eLoc.setBlockCache(blockCache);
        eLoc.set(location, (Entity)player, yOnGround);
        boolean res = eLoc.isOnGroundOrResetCond();
        blockCache.cleanup();
        eLoc.cleanup();
        return res;
    }

    public static boolean isResetCond(Player player, Location location, double yOnGround) {
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(location.getWorld());
        eLoc.setBlockCache(blockCache);
        eLoc.set(location, (Entity)player, yOnGround);
        boolean res = eLoc.isResetCond();
        blockCache.cleanup();
        eLoc.cleanup();
        return res;
    }

    public static final boolean isActuallyAir(Material mat) {
        return mat != null && BlockProperties.isAir(mat);
    }

    public static final boolean isAir(Material mat) {
        return mat == null || mat == Material.AIR || mat == BridgeMaterial.VOID_AIR || mat == BridgeMaterial.CAVE_AIR;
    }

    public static final boolean isAir(ItemStack stack) {
        return stack == null || BlockProperties.isAir(stack.getType());
    }

    public static final boolean isAscendingRails(Material mat, int data) {
        return BlockProperties.isRails(mat) && (data & 7) > 1;
    }

    public static final boolean isBlueIce(Material mat) {
        return (BlockFlags.getBlockFlags(mat) & BlockFlags.F_BLUE_ICE) != 0L;
    }

    public static final boolean isBubbleColumn(Material mat) {
        return (BlockFlags.getBlockFlags(mat) & BlockFlags.F_BUBBLE_COLUMN) != 0L;
    }

    public static final boolean isCarpet(Material mat) {
        return (BlockFlags.getBlockFlags(mat) & BlockFlags.F_CARPET) != 0L;
    }

    public static final boolean isChest(Material mat) {
        return mat != null && (mat == Material.CHEST || mat == Material.TRAPPED_CHEST || mat == Material.ENDER_CHEST);
    }

    public static final boolean isClimbable(Material mat) {
        return (BlockFlags.getBlockFlags(mat) & BlockFlags.F_CLIMBABLE) != 0L;
    }

    public static final boolean isCobweb(Material mat) {
        return (BlockFlags.getBlockFlags(mat) & BlockFlags.F_COBWEB) != 0L;
    }

    public static boolean isContainer(Material mat) {
        if (mat == null) {
            return false;
        }
        if (MaterialUtil.SHULKER_BOXES.contains(mat) || mat == BridgeMaterial.BARREL) {
            return true;
        }
        switch (mat) {
            case CHEST: 
            case ENDER_CHEST: 
            case DISPENSER: 
            case DROPPER: 
            case TRAPPED_CHEST: 
            case HOPPER: {
                return true;
            }
        }
        return false;
    }

    public static final boolean isGround(Material mat) {
        return (BlockFlags.getBlockFlags(mat) & BlockFlags.F_GROUND) != 0L;
    }

    public static final boolean isGround(Material mat, long ignoreFlags) {
        long flags = BlockFlags.getBlockFlags(mat);
        return (flags & BlockFlags.F_GROUND) != 0L && (flags & ignoreFlags) == 0L;
    }

    public static final boolean isIce(Material mat) {
        return (BlockFlags.getBlockFlags(mat) & BlockFlags.F_ICE) != 0L;
    }

    public static final boolean isLeaves(Material mat) {
        return (BlockFlags.getBlockFlags(mat) & BlockFlags.F_LEAVES) != 0L;
    }

    public static final boolean isLiquid(Material mat) {
        return (BlockFlags.getBlockFlags(mat) & BlockFlags.F_LIQUID) != 0L;
    }

    public static final boolean needsToBeAttachedToABlock(Material mat) {
        if ((BlockFlags.getBlockFlags(mat) & BlockFlags.F_CLIMBUPABLE) != 0L) {
            return false;
        }
        return mat == Material.VINE;
    }

    public static final boolean isPowderSnow(Material mat) {
        return (BlockFlags.getBlockFlags(mat) & BlockFlags.F_POWDER_SNOW) != 0L;
    }

    public static final boolean isRails(Material mat) {
        return (BlockFlags.getBlockFlags(mat) & BlockFlags.F_RAILS) != 0L;
    }

    public static final boolean isScaffolding(Material mat) {
        return mat != null && mat == BridgeMaterial.SCAFFOLDING;
    }

    public static final boolean isScaffolding(ItemStack stack) {
        return stack != null && BlockProperties.isScaffolding(stack.getType());
    }

    public static final boolean isSolid(Material mat) {
        return (BlockFlags.getBlockFlags(mat) & BlockFlags.F_SOLID) != 0L;
    }

    public static final boolean isSlime(Material mat) {
        return (BlockFlags.getBlockFlags(mat) & BlockFlags.F_SLIME) != 0L;
    }

    public static final boolean isStairs(Material mat) {
        return (BlockFlags.getBlockFlags(mat) & BlockFlags.F_STAIRS) != 0L;
    }

    public static final boolean isWater(Material mat) {
        return (BlockFlags.getBlockFlags(mat) & BlockFlags.F_WATER) != 0L;
    }

    public static final boolean isWaterPlant(Material mat) {
        return (BlockFlags.getBlockFlags(mat) & BlockFlags.F_WATER_PLANT) != 0L;
    }

    public static final boolean isDoor(Material mat) {
        return MaterialUtil.ALL_DOORS.contains(mat);
    }

    public static void init(IHandle<MCAccess> mcAccess, WorldConfigProvider<?> worldConfigProvider) {
        wrapBlockCache = new WrapBlockCache();
        rtRay = new PassableRayTracing();
        rtAxis = new PassableAxisTracing();
        eLoc = new RichEntityLocation(mcAccess, null);
        LinkedHashSet<String> blocksFeatures = new LinkedHashSet<String>();
        try {
            BlockProperties.initTools(mcAccess, worldConfigProvider);
            BlockProperties.initBlocks(mcAccess, worldConfigProvider);
            blocksFeatures.add("BlocksMC1_4");
            try {
                blocksFeatures.addAll(new VanillaBlocksFactory().setupVanillaBlocks(worldConfigProvider));
            }
            catch (Throwable t) {
                StaticLog.logSevere("Could not initialize vanilla blocks: " + t.getClass().getSimpleName() + " - " + t.getMessage());
                StaticLog.logSevere(t);
            }
            MCAccess handle = mcAccess.getHandle();
            if (handle instanceof BlockPropertiesSetup) {
                try {
                    ((BlockPropertiesSetup)((Object)handle)).setupBlockProperties(worldConfigProvider);
                    blocksFeatures.add(handle.getClass().getSimpleName());
                }
                catch (Throwable t) {
                    StaticLog.logSevere("McAccess.setupBlockProperties (" + handle.getClass().getSimpleName() + ") could not execute properly: " + t.getClass().getSimpleName() + " - " + t.getMessage());
                    StaticLog.logSevere(t);
                }
            }
        }
        catch (Throwable t) {
            StaticLog.logSevere(t);
        }
        NCPAPIProvider.getNoCheatPlusAPI().setFeatureTags("blocks", blocksFeatures);
    }

    private static void initTools(IHandle<MCAccess> mcAccess, WorldConfigProvider<?> worldConfigProvider) {
        tools.clear();
        tools.put(BridgeMaterial.WOODEN_SWORD, new ToolProps(ToolType.SWORD, MaterialBase.WOOD));
        tools.put(BridgeMaterial.WOODEN_SHOVEL, new ToolProps(ToolType.SPADE, MaterialBase.WOOD));
        tools.put(BridgeMaterial.WOODEN_PICKAXE, new ToolProps(ToolType.PICKAXE, MaterialBase.WOOD));
        tools.put(BridgeMaterial.WOODEN_AXE, new ToolProps(ToolType.AXE, MaterialBase.WOOD));
        tools.put(BridgeMaterial.WOODEN_HOE, new ToolProps(ToolType.HOE, MaterialBase.WOOD));
        tools.put(Material.STONE_SWORD, new ToolProps(ToolType.SWORD, MaterialBase.STONE));
        tools.put(BridgeMaterial.STONE_SHOVEL, new ToolProps(ToolType.SPADE, MaterialBase.STONE));
        tools.put(Material.STONE_PICKAXE, new ToolProps(ToolType.PICKAXE, MaterialBase.STONE));
        tools.put(Material.STONE_AXE, new ToolProps(ToolType.AXE, MaterialBase.STONE));
        tools.put(Material.STONE_HOE, new ToolProps(ToolType.HOE, MaterialBase.STONE));
        tools.put(Material.IRON_SWORD, new ToolProps(ToolType.SWORD, MaterialBase.IRON));
        tools.put(BridgeMaterial.IRON_SHOVEL, new ToolProps(ToolType.SPADE, MaterialBase.IRON));
        tools.put(Material.IRON_PICKAXE, new ToolProps(ToolType.PICKAXE, MaterialBase.IRON));
        tools.put(Material.IRON_AXE, new ToolProps(ToolType.AXE, MaterialBase.IRON));
        tools.put(Material.IRON_HOE, new ToolProps(ToolType.HOE, MaterialBase.IRON));
        tools.put(Material.DIAMOND_SWORD, new ToolProps(ToolType.SWORD, MaterialBase.DIAMOND));
        tools.put(BridgeMaterial.DIAMOND_SHOVEL, new ToolProps(ToolType.SPADE, MaterialBase.DIAMOND));
        tools.put(Material.DIAMOND_PICKAXE, new ToolProps(ToolType.PICKAXE, MaterialBase.DIAMOND));
        tools.put(Material.DIAMOND_AXE, new ToolProps(ToolType.AXE, MaterialBase.DIAMOND));
        tools.put(Material.DIAMOND_HOE, new ToolProps(ToolType.HOE, MaterialBase.DIAMOND));
        tools.put(BridgeMaterial.GOLDEN_SWORD, new ToolProps(ToolType.SWORD, MaterialBase.GOLD));
        tools.put(BridgeMaterial.GOLDEN_SHOVEL, new ToolProps(ToolType.SPADE, MaterialBase.GOLD));
        tools.put(BridgeMaterial.GOLDEN_PICKAXE, new ToolProps(ToolType.PICKAXE, MaterialBase.GOLD));
        tools.put(BridgeMaterial.GOLDEN_AXE, new ToolProps(ToolType.AXE, MaterialBase.GOLD));
        tools.put(BridgeMaterial.GOLDEN_HOE, new ToolProps(ToolType.HOE, MaterialBase.GOLD));
        if (BridgeMaterial.NETHERITE_SWORD != null) {
            tools.put(BridgeMaterial.NETHERITE_SWORD, new ToolProps(ToolType.SWORD, MaterialBase.NETHERITE));
            tools.put(BridgeMaterial.NETHERITE_SHOVEL, new ToolProps(ToolType.SPADE, MaterialBase.NETHERITE));
            tools.put(BridgeMaterial.NETHERITE_PICKAXE, new ToolProps(ToolType.PICKAXE, MaterialBase.NETHERITE));
            tools.put(BridgeMaterial.NETHERITE_AXE, new ToolProps(ToolType.AXE, MaterialBase.NETHERITE));
            tools.put(BridgeMaterial.NETHERITE_HOE, new ToolProps(ToolType.HOE, MaterialBase.NETHERITE));
        }
        tools.put(Material.SHEARS, new ToolProps(ToolType.SHEARS, MaterialBase.NONE));
    }

    private static void setBlock(Material material, BlockProps props) {
        try {
            if (!material.isBlock()) {
                StaticLog.logWarning("Attempt to set block breaking properties for a non-block: " + material);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        blocks.put(material, props);
    }

    private static void initBlocks(IHandle<MCAccess> mcAccessHandle, WorldConfigProvider<?> worldConfigProvider) {
        MCAccess mcAccess = mcAccessHandle.getHandle();
        blocks.clear();
        for (Material mat : Material.values()) {
            BlockFlags.blockFlags.put(mat, 0L);
            if (mcAccess.isBlockLiquid(mat).decide()) {
                BlockFlags.setFlag(mat, BlockFlags.F_LIQUID);
                if (!mcAccess.isBlockSolid(mat).decide()) continue;
                BlockFlags.setFlag(mat, BlockFlags.F_SOLID);
                continue;
            }
            if (!mcAccess.isBlockSolid(mat).decide()) continue;
            BlockFlags.setFlag(mat, BlockFlags.F_SOLID | BlockFlags.F_GROUND);
        }
        long stairFlags = BlockFlags.F_STAIRS | BlockFlags.F_GROUND | BlockFlags.F_SOLID;
        for (Material mat : MaterialUtil.ALL_STAIRS) {
            BlockFlags.setFlag(mat, stairFlags);
        }
        long stepFlags = BlockFlags.F_GROUND | BlockFlags.F_XZ100;
        for (Object mat : new Material[]{BridgeMaterial.STONE_SLAB}) {
            BlockFlags.setFlag(mat, stepFlags);
        }
        for (Material mat : MaterialUtil.SLABS) {
            BlockFlags.setFlag(mat, stepFlags);
        }
        for (Material mat : MaterialUtil.RAILS) {
            BlockFlags.setFlag(mat, BlockFlags.F_RAILS);
        }
        for (Material mat : MaterialUtil.WATER) {
            BlockFlags.setFlag(mat, BlockFlags.F_LIQUID | BlockFlags.F_HEIGHT_8SIM_DEC | BlockFlags.F_WATER | BlockFlags.F_FALLDIST_ZERO);
        }
        for (Material mat : MaterialUtil.LAVA) {
            BlockFlags.setFlag(mat, BlockFlags.F_LIQUID | BlockFlags.F_LAVA | BlockFlags.F_FALLDIST_HALF | BlockFlags.F_HEIGHT_8SIM_DEC);
        }
        for (Object mat : new Material[]{Material.VINE, Material.LADDER}) {
            BlockFlags.setFlag(mat, BlockFlags.F_CLIMBABLE);
        }
        for (Object mat : new Material[]{Material.COCOA, Material.SNOW, Material.LADDER, Material.BREWING_STAND, BridgeMaterial.get("DIODE_BLOCK_OFF"), BridgeMaterial.get("DIODE_BLOCK_ON"), BridgeMaterial.getBlock("comparator"), BridgeMaterial.getBlock("daylight_detector"), BridgeMaterial.LILY_PAD, BridgeMaterial.PISTON_HEAD, BridgeMaterial.STONE_SLAB, BridgeMaterial.REPEATER}) {
            if (mat == null) continue;
            BlockFlags.setFlag(mat, BlockFlags.F_GROUND);
        }
        BlockProperties.setBlockProps(BridgeMaterial.MOVING_PISTON, indestructibleType);
        BlockFlags.setFlag(BridgeMaterial.MOVING_PISTON, BlockFlags.F_IGN_PASSABLE | BlockFlags.F_GROUND | BlockFlags.F_GROUND_HEIGHT | BlockFlags.FULL_BOUNDS);
        for (Object mat : new Material[]{BridgeMaterial.FARMLAND}) {
            BlockFlags.setFlag(mat, BlockFlags.F_HEIGHT100);
        }
        BlockFlags.maskFlag(BridgeMaterial.SIGN, (BlockFlags.F_GROUND | BlockFlags.F_SOLID) ^ 0xFFFFFFFFFFFFFFFFL);
        for (Object mat : new Material[]{BridgeMaterial.STONE_PRESSURE_PLATE, BridgeMaterial.WOODEN_PRESSURE_PLATE, BridgeMaterial.SIGN, BridgeMaterial.get("DIODE_BLOCK_ON"), BridgeMaterial.get("DIODE_BLOCK_OFF")}) {
            if (mat == null) continue;
            BlockFlags.setFlag(mat, BlockFlags.F_IGN_PASSABLE);
        }
        long flags150 = BlockFlags.F_HEIGHT150 | BlockFlags.F_VARIABLE | BlockFlags.F_THICK_FENCE;
        for (Object mat : new Material[]{BridgeMaterial.NETHER_BRICK_FENCE, BridgeMaterial.COBBLESTONE_WALL}) {
            BlockFlags.setFlag(mat, flags150);
        }
        for (Material mat : MaterialUtil.WOODEN_FENCES) {
            BlockFlags.setFlag(mat, flags150);
        }
        for (Material mat : MaterialUtil.WOODEN_FENCE_GATES) {
            BlockFlags.setFlag(mat, flags150);
        }
        for (Material mat : MaterialUtil.WOODEN_FENCE_GATES) {
            BlockFlags.setFlag(mat, BlockFlags.F_PASSABLE_X4 | BlockFlags.F_VARIABLE);
        }
        for (Material mat : MaterialUtil.WOODEN_TRAP_DOORS) {
            BlockFlags.setFlag(mat, BlockFlags.F_VARIABLE);
        }
        for (Material material : Material.values()) {
            if (!material.isBlock()) continue;
            String name = material.name().toLowerCase();
            if (name.endsWith("_door") || name.endsWith("_trapdoor") || name.endsWith("fence_gate")) {
                BlockFlags.setFlag(material, BlockFlags.F_VARIABLE_REDSTONE);
                if (!name.contains("iron")) {
                    BlockFlags.setFlag(material, BlockFlags.F_VARIABLE_USE);
                }
            }
            if (!name.equals("iron_door_block")) continue;
            BlockFlags.setFlag(material, BlockFlags.F_VARIABLE_REDSTONE);
        }
        for (Object mat : new Material[]{Material.LADDER}) {
            BlockFlags.setFlag(mat, BlockFlags.F_FACING_LOW3D2_NSWE);
        }
        for (Material mat : MaterialUtil.WOODEN_TRAP_DOORS) {
            BlockFlags.setFlag(mat, BlockFlags.F_ATTACHED_LOW2_SNEW);
        }
        long paneFlags = BlockFlags.F_THIN_FENCE | BlockFlags.F_VARIABLE;
        for (Object mat : new Material[]{BridgeMaterial.IRON_BARS}) {
            BlockFlags.setFlag(mat, paneFlags);
        }
        for (Material mat : MaterialUtil.GLASS_PANES) {
            BlockFlags.setFlag(mat, paneFlags);
        }
        for (Object mat : new Material[]{BridgeMaterial.FARMLAND}) {
            BlockFlags.setFlag(mat, BlockFlags.F_GROUND_HEIGHT);
        }
        BlockFlags.setFlag(BridgeMaterial.END_PORTAL_FRAME, BlockFlags.SOLID_GROUND);
        BlockFlags.setFlag(BridgeMaterial.COBWEB, BlockFlags.F_COBWEB | BlockFlags.FULL_BOUNDS | BlockFlags.F_IGN_PASSABLE);
        BlockFlags.setFlag(Material.SOUL_SAND, BlockFlags.F_SOULSAND | BlockFlags.SOLID_GROUND);
        BlockFlags.setFlag(Material.ICE, BlockFlags.F_ICE);
        BlockFlags.setFlag(BridgeMaterial.CAKE, BlockFlags.F_GROUND);
        BlockFlags.setFlag(BridgeMaterial.COBBLESTONE_WALL, BlockFlags.F_HEIGHT150);
        BlockProperties.setBlock(Material.LADDER, new BlockProps(noTool, 0.4f));
        BlockProperties.setBlock(Material.CACTUS, new BlockProps(noTool, 0.4f));
        BlockProperties.setBlock(Material.BEACON, new BlockProps(noTool, 3.0f));
        BlockProperties.setBlock(Material.DRAGON_EGG, new BlockProps(noTool, 3.0f));
        BlockProperties.setBlock(BridgeMaterial.MELON, new BlockProps(noTool, 1.0f));
        BlockProperties.setBlock(Material.SPONGE, new BlockProps(noTool, 0.6f));
        BlockProperties.setBlock(Material.NETHERRACK, new BlockProps(woodPickaxe, 0.4f, true));
        BlockProperties.setBlock(Material.STONE_BUTTON, new BlockProps(woodPickaxe, 0.5f, true));
        BlockProperties.setBlock(Material.ICE, new BlockProps(woodPickaxe, 0.5f));
        BlockProperties.setBlock(Material.BREWING_STAND, new BlockProps(woodPickaxe, 0.5f, true));
        BlockProperties.setBlock(Material.ENDER_CHEST, new BlockProps(woodPickaxe, 22.5f, true));
        BlockProperties.setBlock(Material.SNOW, new BlockProps(BlockProperties.getToolProps(BridgeMaterial.WOODEN_SHOVEL), 0.1f));
        BlockProperties.setBlock(Material.SNOW_BLOCK, new BlockProps(BlockProperties.getToolProps(BridgeMaterial.WOODEN_SHOVEL), 0.2f));
        BlockProperties.setBlock(Material.NOTE_BLOCK, new BlockProps(woodAxe, 0.8f));
        BlockProperties.setBlock(Material.BOOKSHELF, new BlockProps(woodAxe, 1.5f));
        BlockProperties.setBlock(BridgeMaterial.COBWEB, new BlockProps(woodSword, 4.0f, true));
        BlockProperties.setBlock(Material.OBSIDIAN, new BlockProps(diamondPickaxe, 50.0f, true));
        for (Object mat : new Material[]{Material.TNT, BridgeMaterial.get("DIODE_BLOCK_ON"), BridgeMaterial.get("DIODE_BLOCK_OFF"), BridgeMaterial.get("repeater"), BridgeMaterial.get("sea_pickle"), BridgeMaterial.LILY_PAD, BridgeMaterial.COMMAND_BLOCK}) {
            if (mat == null) continue;
            BlockProperties.setBlock(mat, instantType);
        }
        for (Material mat : MaterialUtil.INSTANT_PLANTS) {
            BlockProperties.setBlock(mat, instantType);
        }
        for (Object mat : new Material[]{Material.REDSTONE_WIRE, BridgeMaterial.get("REDSTONE_TORCH_ON"), BridgeMaterial.get("REDSTONE_TORCH_OFF"), BridgeMaterial.get("redstone_torch"), BridgeMaterial.get("redstone_wall_torch"), Material.TRIPWIRE, Material.TRIPWIRE_HOOK, Material.TORCH, Material.FIRE}) {
            if (mat == null) continue;
            BlockProperties.setBlock(mat, instantType);
            BlockFlags.addFlags(mat, BlockFlags.F_IGN_PASSABLE);
        }
        for (Material mat : MaterialUtil.LEAVES) {
            BlockProperties.setBlock(mat, leafType);
            BlockFlags.setFlag(mat, BlockFlags.F_LEAVES);
        }
        for (Material mat : MaterialUtil.BEDS) {
            BlockProperties.setBlock(mat, leafType);
            BlockFlags.setFlag(mat, BlockFlags.F_GROUND | BlockFlags.F_SOLID | BlockFlags.F_BED);
        }
        for (Object mat : new Material[]{Material.VINE, Material.COCOA}) {
            BlockProperties.setBlock(mat, hugeMushroomType);
        }
        for (Material mat : MaterialUtil.MUSHROOM_BLOCKS) {
            BlockProperties.setBlock(mat, hugeMushroomType);
        }
        for (Object mat : new Material[]{BridgeMaterial.get("REDSTONE_LAMP_ON"), BridgeMaterial.get("REDSTONE_LAMP_OFF"), BridgeMaterial.get("REDSTONE_LAMP"), Material.GLOWSTONE}) {
            if (mat == null) continue;
            BlockProperties.setBlock(mat, glassType);
        }
        for (Material mat : MaterialUtil.GLASS_BLOCKS) {
            BlockProperties.setBlock(mat, glassType);
        }
        for (Material mat : MaterialUtil.GLASS_PANES) {
            BlockProperties.setBlock(mat, glassType);
        }
        for (Material mat : MaterialUtil.WOODEN_PRESSURE_PLATES) {
            BlockProperties.setBlockProps(mat, new BlockProps(woodAxe, 0.5f));
        }
        BlockProperties.setBlock(BridgeMaterial.STONE_PRESSURE_PLATE, new BlockProps(woodPickaxe, 0.5f, true));
        BlockProperties.setBlock(Material.SAND, sandType);
        BlockProperties.setBlock(Material.SOUL_SAND, sandType);
        BlockProperties.setBlock(Material.DIRT, sandType);
        for (Material mat : MaterialUtil.CONCRETE_POWDER_BLOCKS) {
            BlockInit.setAs(mat, Material.DIRT);
        }
        for (Object mat : new Material[]{Material.LEVER, BridgeMaterial.PISTON, BridgeMaterial.PISTON_HEAD, BridgeMaterial.STICKY_PISTON, BridgeMaterial.PISTON}) {
            BlockProperties.setBlock(mat, leverType);
        }
        BlockProperties.setBlock(BridgeMaterial.CAKE, leverType);
        for (Object mat : new Material[]{BridgeMaterial.MYCELIUM, BridgeMaterial.FARMLAND, BridgeMaterial.GRASS_BLOCK, Material.GRAVEL, Material.CLAY}) {
            BlockProperties.setBlock(mat, gravelType);
        }
        for (Material mat : MaterialUtil.RAILS) {
            BlockProperties.setBlock(mat, new BlockProps(woodPickaxe, 0.7f));
        }
        for (Material mat : MaterialUtil.INFESTED_BLOCKS) {
            BlockProperties.setBlock(mat, new BlockProps(noTool, 0.75f));
        }
        for (Material mat : MaterialUtil.WOOD_BLOCKS) {
            BlockProperties.setBlock(mat, new BlockProps(noTool, 0.8f));
        }
        BlockProperties.setBlock(Material.SANDSTONE, sandStoneType);
        BlockProperties.setBlock(Material.SANDSTONE_STAIRS, sandStoneType);
        for (Object mat : new Material[]{Material.STONE, BridgeMaterial.STONE_BRICKS, BridgeMaterial.STONE_BRICK_STAIRS}) {
            BlockProperties.setBlock(mat, stoneTypeI);
        }
        BlockProps pumpkinType = new BlockProps(woodAxe, 1.0f);
        BlockProperties.setBlock(BridgeMaterial.SIGN, pumpkinType);
        BlockProperties.setBlock(Material.PUMPKIN, pumpkinType);
        BlockProperties.setBlock(Material.JACK_O_LANTERN, pumpkinType);
        List<Set> woodTypes = Arrays.asList(MaterialUtil.WOODEN_FENCE_GATES, MaterialUtil.WOODEN_FENCES, MaterialUtil.WOODEN_STAIRS, MaterialUtil.WOODEN_SLABS, MaterialUtil.LOGS, MaterialUtil.WOOD_BLOCKS, MaterialUtil.PLANKS);
        for (Set set : woodTypes) {
            for (Object mat : set) {
                BlockProperties.setBlock(mat, woodType);
            }
        }
        for (Object mat : new Material[]{Material.JUKEBOX, BridgeMaterial.get("wood_double_step")}) {
            if (mat == null) continue;
            BlockProperties.setBlock(mat, woodType);
        }
        for (Material mat : MaterialUtil.STRIPPED_LOGS) {
            BlockInit.setAs(mat, BridgeMaterial.OAK_LOG);
        }
        for (Material mat : MaterialUtil.STRIPPED_WOOD_BLOCKS) {
            BlockInit.setAs(mat, BridgeMaterial.OAK_WOOD);
        }
        for (Object mat : new Material[]{Material.CAULDRON, Material.COBBLESTONE_STAIRS, Material.COBBLESTONE, Material.NETHER_BRICK_STAIRS, Material.MOSSY_COBBLESTONE, Material.BRICK_STAIRS, Material.BRICK_STAIRS, BridgeMaterial.NETHER_BRICK_FENCE, BridgeMaterial.BRICK_SLAB, BridgeMaterial.STONE_SLAB, BridgeMaterial.NETHER_BRICKS, BridgeMaterial.BRICKS, BridgeMaterial.get("double_step")}) {
            if (mat == null) continue;
            BlockProperties.setBlock(mat, brickType);
        }
        BlockFlags.setBlockFlags(Material.CAULDRON, BlockFlags.SOLID_GROUND | BlockFlags.F_GROUND_HEIGHT | BlockFlags.F_MIN_HEIGHT16_5);
        BlockProperties.setBlock(BridgeMaterial.COBBLESTONE_WALL, brickType);
        BlockProperties.setBlock(BridgeMaterial.CRAFTING_TABLE, chestType);
        BlockProperties.setBlock(Material.CHEST, chestType);
        if (BridgeMaterial.has("locked_chest")) {
            BlockFlags.setFlagsAs("LOCKED_CHEST", Material.CHEST);
            BlockProperties.setBlockProps("LOCKED_CHEST", chestType);
        }
        for (Material mat : MaterialUtil.WOODEN_DOORS) {
            BlockProperties.setBlock(mat, woodDoorType);
        }
        for (Material mat : MaterialUtil.WOODEN_TRAP_DOORS) {
            BlockProperties.setBlock(mat, woodDoorType);
        }
        for (Object mat : new Material[]{BridgeMaterial.END_STONE, Material.COAL_ORE}) {
            BlockProperties.setBlock(mat, coalType);
        }
        BlockProps ironType = new BlockProps(stonePickaxe, 3.0f, true);
        for (Material mat : new Material[]{Material.LAPIS_ORE, Material.LAPIS_BLOCK, Material.IRON_ORE}) {
            BlockProperties.setBlock(mat, ironType);
        }
        BlockProps diamondType = new BlockProps(ironPickaxe, 3.0f, true);
        for (Object mat : new Material[]{Material.REDSTONE_ORE, Material.EMERALD_ORE, Material.GOLD_ORE, Material.DIAMOND_ORE, BridgeMaterial.get("glowing_redstone_ore")}) {
            if (mat == null) continue;
            BlockProperties.setBlock(mat, diamondType);
        }
        BlockProperties.setBlock(Material.GOLD_BLOCK, goldBlockType);
        BlockProperties.setBlock(Material.FURNACE, dispenserType);
        if (BridgeMaterial.has("burning_furnace")) {
            BlockProperties.setBlock(BridgeMaterial.get("burning_furnace"), dispenserType);
        }
        BlockProperties.setBlock(Material.DISPENSER, dispenserType);
        for (Object mat : new Material[]{Material.EMERALD_BLOCK, BridgeMaterial.SPAWNER, BridgeMaterial.IRON_DOOR, BridgeMaterial.IRON_BARS, BridgeMaterial.ENCHANTING_TABLE}) {
            BlockProperties.setBlock(mat, ironDoorType);
        }
        BlockProperties.setBlock(Material.IRON_BLOCK, ironBlockType);
        BlockProperties.setBreakingTimeOverridesByEfficiency(new BlockBreakKey().blockType(Material.IRON_BLOCK).toolType(ToolType.PICKAXE).materialBase(MaterialBase.WOOD), BlockProperties.ironBlockType.breakingTimes[1], 6200L, 3500L, 2050L, 1350L, 900L, 500L);
        BlockProperties.setBlock(Material.DIAMOND_BLOCK, diamondBlockType);
        for (Material mat : MaterialUtil.WOODEN_BUTTONS) {
            BlockProperties.setBlock(mat, new BlockProps(woodAxe, 0.5f));
        }
        BlockProps props = new BlockProps(noTool, 1.0f);
        for (Material mat : MaterialUtil.HEADS_GROUND) {
            BlockProperties.setBlock(mat, props);
            BlockFlags.setFlag(mat, BlockFlags.F_SOLID | BlockFlags.F_GROUND);
        }
        BlockProperties.setBlock(Material.ANVIL, new BlockProps(woodPickaxe, 5.0f, true));
        for (Material mat : MaterialUtil.FLOWER_POTS) {
            BlockFlags.addFlags(mat, BlockFlags.F_SOLID | BlockFlags.F_GROUND);
            BlockProperties.setBlockProps(mat, instantType);
        }
        for (Object mat : new Material[]{Material.AIR, Material.BEDROCK, BridgeMaterial.END_PORTAL, BridgeMaterial.END_PORTAL_FRAME, BridgeMaterial.NETHER_PORTAL, BridgeMaterial.get("void_air")}) {
            if (mat == null) continue;
            BlockProperties.setBlock(mat, indestructibleType);
        }
        LinkedList<Set> indestructible = new LinkedList<Set>(Arrays.asList(MaterialUtil.LAVA, MaterialUtil.WATER));
        for (Set set : indestructible) {
            for (Material mat : set) {
                BlockProperties.setBlock(mat, indestructibleType);
            }
        }
        BlockFlags.setBlockFlags(Material.BEDROCK, BlockFlags.FULLY_SOLID_BOUNDS);
        props = new BlockProps(woodPickaxe, 1.25f, true);
        for (Material mat : MaterialUtil.TERRACOTTA_BLOCKS) {
            if (mat == null) continue;
            BlockProperties.setBlockProps(mat, props);
            BlockFlags.setFlagsAs(mat, Material.STONE);
        }
        props = new BlockProps(woodPickaxe, 1.4f, true);
        for (Material mat : MaterialUtil.GLAZED_TERRACOTTA_BLOCKS) {
            if (mat == null) continue;
            BlockProperties.setBlockProps(mat, props);
            BlockFlags.setFlagsAs(mat, BridgeMaterial.TERRACOTTA);
        }
        BlockProps carpetProps = new BlockProps(noTool, 0.1f);
        long carpetFlags = BlockFlags.F_GROUND | BlockFlags.F_CARPET;
        for (Material mat : MaterialUtil.CARPETS) {
            BlockProperties.setBlockProps(mat, carpetProps);
            BlockFlags.setBlockFlags(mat, carpetFlags);
        }
        props = new BlockProps(woodAxe, 1.0f);
        for (Material mat : MaterialUtil.BANNERS) {
            BlockFlags.setBlockFlags(mat, 0L);
            BlockProperties.setBlockProps(mat, props);
        }
        for (Material mat : MaterialUtil.WALL_BANNERS) {
            BlockProperties.setBlockProps(mat, props);
        }
        for (Material mat : MaterialUtil.SHULKER_BOXES) {
            BlockProperties.setBlockProps(mat, new BlockProps(woodPickaxe, 2.0f));
            BlockFlags.setBlockFlags(mat, BlockFlags.F_SOLID | BlockFlags.F_GROUND);
        }
        props = new BlockProps(woodPickaxe, 1.8f, true);
        for (Material mat : MaterialUtil.CONCRETE_BLOCKS) {
            BlockProperties.setBlockProps(mat, props);
            BlockFlags.setFlagsAs(mat, Material.COBBLESTONE);
        }
        props = new BlockProps(tools.get(Material.SHEARS), 0.8f);
        for (Material mat : MaterialUtil.WOOL_BLOCKS) {
            BlockFlags.setFlagsAs(mat, Material.STONE);
            BlockProperties.setBlockProps(mat, props);
        }
        for (Material mat : MaterialUtil.FULLY_SOLID_BLOCKS) {
            BlockFlags.addFlags(mat, BlockFlags.FULL_BOUNDS | BlockFlags.F_SOLID);
        }
        for (Material mat : MaterialUtil.FULLY_PASSABLE_BLOCKS) {
            BlockFlags.addFlags(mat, BlockFlags.F_IGN_PASSABLE);
            BlockFlags.removeFlags(mat, BlockFlags.F_SOLID | BlockFlags.F_GROUND);
        }
    }

    public static void setBreakingTimeOverridesByEfficiency(BlockBreakKey baseKey, long ... times) {
        for (int i = 0; i < times.length; ++i) {
            BlockProperties.setBreakingTimeOverride(new BlockBreakKey(baseKey).efficiency(i), times[i]);
        }
    }

    public static void dumpBlocks(boolean all) {
        LogManager logManager = NCPAPIProvider.getNoCheatPlusAPI().getLogManager();
        LinkedList<String> missing = new LinkedList<String>();
        LinkedList<String> allBlocks = new LinkedList<String>();
        if (all) {
            allBlocks.add("Dump block properties:");
            allBlocks.add("--- Present entries -------------------------------");
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (Material temp : Material.values()) {
            String tagsJoined;
            String mat;
            try {
                if (!temp.isBlock()) continue;
                mat = temp.toString();
            }
            catch (Exception e) {
                mat = "?";
            }
            tags.clear();
            BlockFlags.addFlagNames(BlockFlags.getBlockFlags(temp), tags);
            String string = tagsJoined = tags.isEmpty() ? "" : " / " + StringUtil.join(tags, "+");
            if (blocks.get(temp) == null) {
                if (mat.equals("?")) continue;
                missing.add("* BLOCK BREAKING (" + mat + tagsJoined + ") ");
                continue;
            }
            if (BlockFlags.getBlockFlags(temp) == 0L && !BlockProperties.isAir(temp)) {
                missing.add("* FLAGS (" + mat + tagsJoined + ") " + BlockProperties.getBlockProps(temp).toString());
            }
            if (!all) continue;
            allBlocks.add(": (" + mat + tagsJoined + ") " + BlockProperties.getBlockProps(temp).toString());
        }
        if (all) {
            logManager.info(Streams.DEFAULT_FILE, StringUtil.join(allBlocks, "\n"));
        }
        if (!missing.isEmpty()) {
            missing.add(0, "--- Missing entries -------------------------------");
            missing.add(0, "The block data is incomplete:");
            logManager.warning(Streams.INIT, StringUtil.join(missing, "\n"));
        }
    }

    public static ToolProps getToolProps(ItemStack stack) {
        if (stack == null) {
            return noTool;
        }
        return BlockProperties.getToolProps(stack.getType());
    }

    public static ToolProps getToolProps(Material mat) {
        ToolProps props = tools.get(mat);
        if (props == null) {
            return noTool;
        }
        return props;
    }

    public static BlockProps getBlockProps(ItemStack stack) {
        if (stack == null) {
            return defaultBlockProps;
        }
        return BlockProperties.getBlockProps(stack.getType());
    }

    public static BlockProps getBlockProps(Material mat) {
        if (mat == null || !blocks.containsKey(mat)) {
            return defaultBlockProps;
        }
        return blocks.get(mat);
    }

    public static BlockProps getBlockProps(String blockId) {
        return BlockProperties.getBlockProps(BlockProperties.getMaterial(blockId));
    }

    public static void setBreakingTimeOverride(BlockBreakKey key, long breakingTime) {
        breakingTimeOverrides.put(new BlockBreakKey(key), breakingTime);
    }

    public static Long getBreakingTimeOverride(BlockBreakKey key) {
        return breakingTimeOverrides.get(key);
    }

    public static long getBreakingDuration(Material BlockType, Player player) {
        long res = BlockProperties.getBreakingDuration(BlockType, Bridge1_9.getItemInMainHand(player), player.getInventory().getHelmet(), player, player.getLocation(useLoc));
        useLoc.setWorld(null);
        return res;
    }

    public static long getBreakingDuration(Material blockId, ItemStack itemInHand, ItemStack helmet, Player player, Location location) {
        return BlockProperties.getBreakingDuration(blockId, itemInHand, helmet, player, MovingUtil.getEyeHeight(player), location);
    }

    public static long getBreakingDuration(Material blockId, ItemStack itemInHand, ItemStack helmet, Player player, double eyeHeight, Location location) {
        boolean inWater;
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(location.getWorld());
        eLoc.setBlockCache(blockCache);
        eLoc.set(location, (Entity)player, 0.3);
        boolean onGround = eLoc.isOnGround();
        int bx = eLoc.getBlockX();
        int bz = eLoc.getBlockZ();
        double y = eLoc.getY() + eyeHeight;
        int by = Location.locToBlock((double)y);
        Material headId = blockCache.getType(bx, by, bz);
        long headFlags = BlockFlags.getBlockFlags(headId);
        if ((headFlags & BlockFlags.F_WATER) == 0L) {
            inWater = false;
        } else {
            int data8 = (blockCache.getData(bx, by, bz) & 0xF) % 8;
            double level = (data8 & 8) != 0 ? 1.0 : 1.0 - 0.125 * (1.0 + (double)data8);
            inWater = y - (double)by < level;
        }
        blockCache.cleanup();
        eLoc.cleanup();
        double haste = PotionUtil.getPotionEffectAmplifier(player, BridgePotionEffect.HASTE);
        double fatigue = PotionUtil.getPotionEffectAmplifier(player, BridgePotionEffect.MINING_FATIGUE);
        double conduit = Bridge1_13.getConduitPowerAmplifier((LivingEntity)player);
        return BlockProperties.getBreakingDuration(blockId, itemInHand, onGround, inWater, helmet != null && helmet.containsEnchantment(BridgeEnchant.AQUA_AFFINITY), Double.isInfinite(haste) ? 0 : 1 + (int)haste, Double.isInfinite(fatigue) ? 0 : 1 + (int)fatigue, Double.isInfinite(conduit) ? 0 : 1 + (int)conduit);
    }

    public static long getBreakingDuration(Material blockId, ItemStack itemInHand, boolean onGround, boolean inWater, boolean aquaAffinity, int haste, int fatigue, int conduit) {
        if (BlockProperties.isAir(itemInHand)) {
            return BlockProperties.getBreakingDuration(blockId, BlockProperties.getBlockProps(blockId), noTool, onGround, inWater, aquaAffinity, 0, haste, fatigue, conduit);
        }
        int efficiency = 0;
        if (itemInHand.containsEnchantment(BridgeEnchant.EFFICIENCY)) {
            efficiency = itemInHand.getEnchantmentLevel(BridgeEnchant.EFFICIENCY);
        }
        return BlockProperties.getBreakingDuration(blockId, BlockProperties.getBlockProps(blockId), BlockProperties.getToolProps(itemInHand.getType()), onGround, inWater, aquaAffinity, efficiency, haste, fatigue, conduit);
    }

    public static long getBreakingDuration(Material blockId, BlockProps blockProps, ToolProps toolProps, boolean onGround, boolean inWater, boolean aquaAffinity, int efficiency, int haste, int fatigue, int conduit) {
        long duration;
        BlockBreakKey bbKey = new BlockBreakKey();
        bbKey.blockType(blockId).toolType(toolProps.toolType).materialBase(toolProps.materialBase).efficiency(efficiency);
        Long override = breakingTimeOverrides.get(bbKey);
        if (override != null) {
            float mult = BlockProperties.getBlockBreakingPenaltyMultiplier(onGround, inWater, aquaAffinity);
            return mult == 1.0f ? override : (long)(mult * (float)override.longValue());
        }
        boolean isValidTool = BlockProperties.isValidTool(blockId, blockProps, toolProps, efficiency);
        boolean isRightTool = BlockProperties.isRightToolMaterial(blockId, blockProps, toolProps, isValidTool);
        if (isValidTool) {
            duration = blockProps.breakingTimes[toolProps.materialBase.index];
            if (efficiency > 0) {
                duration = (long)((float)duration / blockProps.efficiencyMod);
            }
        } else {
            duration = blockProps.breakingTimes[0];
        }
        boolean pureHardness = blockProps.pureHardness;
        if (toolProps.toolType == ToolType.SHEARS) {
            if (blockId == BridgeMaterial.COBWEB) {
                duration = 400L;
                isValidTool = true;
                isRightTool = true;
                pureHardness = false;
            } else if (MaterialUtil.WOOL_BLOCKS.contains(blockId)) {
                duration = 240L;
                isValidTool = true;
                isRightTool = true;
                pureHardness = false;
            } else if (BlockProperties.isLeaves(blockId)) {
                duration = 0L;
                isValidTool = true;
            }
        }
        if (toolProps.toolType == ToolType.SWORD) {
            if (blockId == Material.JACK_O_LANTERN || blockId.name().endsWith("PUMPKIN") || blockId == Material.MELON) {
                isValidTool = true;
                isRightTool = true;
                duration = 1000L;
                pureHardness = false;
            } else if (blockId == Material.COCOA || blockId == Material.VINE || BlockProperties.isLeaves(blockId)) {
                isValidTool = true;
                isRightTool = true;
                duration = 200L;
                pureHardness = false;
            } else if (blockId.name().equals("BAMBOO")) {
                isValidTool = true;
                duration = 0L;
            }
        }
        if (duration > 0L) {
            double damage;
            double hardness = blockProps.hardness;
            if (!pureHardness) {
                float tick = duration / 50L;
                damage = 1.0f / tick;
                hardness = 1.0 / damage / ((double)(isRightTool || !blockProps.requireCorrectTool ? 30 : 100) / (isValidTool ? (double)BlockProperties.getToolMultiplier(blockId, blockProps, toolProps) : 1.0));
            }
            if (hardness > 0.0) {
                double speed;
                double d = speed = isValidTool ? (double)BlockProperties.getToolMultiplier(blockId, blockProps, toolProps) : 1.0;
                if (isValidTool && efficiency > 0) {
                    speed += (double)(efficiency * efficiency + 1);
                }
                if (haste > 0 || conduit > 0) {
                    speed *= 1.0 + 0.2 * (double)Math.max(haste, conduit);
                }
                if (fatigue > 0) {
                    switch (fatigue) {
                        case 1: {
                            speed *= 0.3;
                            break;
                        }
                        case 2: {
                            speed *= 0.09;
                            break;
                        }
                        case 3: {
                            speed *= 0.027;
                            break;
                        }
                        default: {
                            speed *= 8.1E-4;
                        }
                    }
                }
                damage = (speed /= (double)BlockProperties.getBlockBreakingPenaltyMultiplier(onGround, inWater, aquaAffinity)) / hardness;
                if ((damage /= isRightTool || !blockProps.requireCorrectTool ? 30.0 : 100.0) > 1.0) {
                    return 0L;
                }
                return Math.round(1.0 / damage) * 50L;
            }
        }
        return Math.max(0L, duration);
    }

    private static float getBlockBreakingPenaltyMultiplier(boolean onGround, boolean inWater, boolean aquaAffinity) {
        float mult = 1.0f;
        if (inWater && !aquaAffinity) {
            mult *= breakPenaltyInWater;
        }
        if (!onGround) {
            mult *= breakPenaltyOffGround;
        }
        return mult;
    }

    public static boolean isValidTool(Material blockId, BlockProps blockProps, ToolProps toolProps, int efficiency) {
        return blockProps.tool.toolType == toolProps.toolType && blockProps.tool != noTool;
    }

    public static boolean isRightToolMaterial(Material blockId, BlockProps blockProps, ToolProps toolProps, boolean isValidTool) {
        return BlockProperties.isRightToolMaterial(blockId, blockProps.tool.materialBase, toolProps.materialBase, isValidTool);
    }

    public static boolean isRightToolMaterial(Material blockId, MaterialBase blockMat, MaterialBase toolMat, boolean isValidTool) {
        if (blockMat == MaterialBase.WOOD) {
            switch (toolMat.ordinal()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return isValidTool;
                }
            }
            return false;
        }
        if (blockMat == MaterialBase.STONE) {
            switch (toolMat.ordinal()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return isValidTool;
                }
            }
            return false;
        }
        if (blockMat == MaterialBase.IRON) {
            switch (toolMat.ordinal()) {
                case 3: 
                case 4: 
                case 5: {
                    return isValidTool;
                }
            }
            return false;
        }
        if (blockMat == MaterialBase.DIAMOND) {
            switch (toolMat.ordinal()) {
                case 4: 
                case 5: {
                    return isValidTool;
                }
            }
            return false;
        }
        return isValidTool;
    }

    public static float getToolMultiplier(Material blockId, BlockProps blockProps, ToolProps toolProps) {
        if (toolProps.toolType == ToolType.SWORD) {
            if (blockId == BridgeMaterial.COBWEB) {
                return 15.0f;
            }
            return 1.5f;
        }
        if (toolProps.toolType == ToolType.SHEARS) {
            if (blockId == BridgeMaterial.COBWEB) {
                return 15.0f;
            }
            if (MaterialUtil.WOOL_BLOCKS.contains(blockId)) {
                return 5.0f;
            }
            return 1.5f;
        }
        return toolProps.materialBase.breakMultiplier;
    }

    public static void setToolProps(Material itemId, ToolProps toolProps) {
        if (toolProps == null) {
            throw new NullPointerException("ToolProps must not be null");
        }
        toolProps.validate();
        tools.put(itemId, toolProps);
    }

    public static void setBlockProps(String blockId, BlockProps blockProps) {
        BlockProperties.setBlockProps(BlockProperties.getMaterial(blockId), blockProps);
    }

    public static void setBlockProps(Material blockId, BlockProps blockProps) {
        if (blockProps == null) {
            throw new NullPointerException("BlockProps must not be null");
        }
        blockProps.validate();
        BlockProperties.setBlock(blockId, blockProps);
    }

    public static boolean isValidTool(Material blockType, ItemStack itemInHand) {
        BlockProps blockProps = BlockProperties.getBlockProps(blockType);
        ToolProps toolProps = BlockProperties.getToolProps(itemInHand);
        int efficiency = itemInHand == null ? 0 : itemInHand.getEnchantmentLevel(BridgeEnchant.EFFICIENCY);
        return BlockProperties.isValidTool(blockType, blockProps, toolProps, efficiency);
    }

    public static BlockProps getDefaultBlockProps() {
        return defaultBlockProps;
    }

    public static void setDefaultBlockProps(BlockProps blockProps) {
        blockProps.validate();
        defaultBlockProps = blockProps;
    }

    public static int getData(Block block) {
        return block.getData();
    }

    public static Material getMaterial(String id) {
        return Material.valueOf((String)id);
    }

    public static boolean canSeeSky(Player player, Location location, double yOnGround) {
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(location.getWorld());
        eLoc.setBlockCache(blockCache);
        eLoc.set(location, (Entity)player, yOnGround);
        IPlayerData pData = DataManager.getPlayerData(player);
        PlayerMoveData thisMove = pData.getGenericInstance(MovingData.class).playerMoves.getCurrentMove();
        boolean res = eLoc.getWorld().getBlockAt(Location.locToBlock((double)thisMove.to.getX()), Location.locToBlock((double)thisMove.to.getY()), Location.locToBlock((double)thisMove.to.getZ())).getLightFromSky() >= 15;
        blockCache.cleanup();
        eLoc.cleanup();
        return res;
    }

    public static boolean affectsFlow(BlockCache access, int x, int y, int z, int x1, int y1, int z1, long liquidTypeFlag) {
        return BlockProperties.getLiquidHeightAt(access, x1, y1, z1, liquidTypeFlag, true) == 0.0 || BlockProperties.getLiquidHeightAt(access, x, y, z, liquidTypeFlag, true) > 0.0 && BlockProperties.getLiquidHeightAt(access, x1, y1, z1, liquidTypeFlag, true) > 0.0;
    }

    public static boolean isSame(BlockCache access, long liquidTypeFlag, Player player, int x1, int y1, int z1, int x2, int y2, int z2) {
        return BlockProperties.getLiquidHeightAt(access, x1, y1, z1, liquidTypeFlag, true) > 0.0 && BlockProperties.getLiquidHeightAt(access, x2, y2, z2, liquidTypeFlag, true) > 0.0;
    }

    public static boolean isSolidFace(BlockCache blockCache, Player player, int x, int y, int z, BlockFace direction, long liquidTypeFlag, Location location) {
        int modX = x + direction.getModX();
        int modZ = z + direction.getModZ();
        BlockCache.IBlockCacheNode node = blockCache.getOrCreateBlockCacheNode(modX, y, modZ, false);
        Material mat = node.getType();
        BlockData data = location.getWorld().getBlockAt(modX, y, modZ).getBlockData();
        IPlayerData pData = DataManager.getPlayerData(player);
        if (BlockProperties.isSame(blockCache, liquidTypeFlag, player, modX, y, modZ, x, y, z)) {
            return false;
        }
        if (BlockProperties.isIce(mat)) {
            return false;
        }
        if (pData.getClientVersion().isAtLeast(ClientVersion.V_1_12)) {
            if (mat == BridgeMaterial.PISTON || mat == BridgeMaterial.STICKY_PISTON) {
                return ((Directional)data).getFacing().getOppositeFace() == direction || AxisAlignedBBUtils.isFullBounds(node.getBounds(blockCache, modX, y, modZ));
            }
            if (mat == BridgeMaterial.PISTON_HEAD) {
                return ((Directional)data).getFacing() == direction;
            }
        }
        if (pData.getClientVersion().isLowerThan(ClientVersion.V_1_12)) {
            if (MaterialUtil.BANNERS.contains(mat)) {
                return pData.getClientVersion().isAtLeast(ClientVersion.V_1_13) && pData.getClientVersion().isLowerThan(ClientVersion.V_1_16);
            }
            if (BlockProperties.isSolid(mat)) {
                return true;
            }
        }
        if (pData.getClientVersion().isAtLeast(ClientVersion.V_1_12) && pData.getClientVersion().isAtMost(ClientVersion.V_1_13_2)) {
            if (BlockProperties.isStairs(mat) || BlockProperties.isLeaves(mat) || MaterialUtil.SHULKER_BOXES.contains(mat) || MaterialUtil.INSTANT_PLANTS.contains(mat) || MaterialUtil.ALL_TRAP_DOORS.contains(mat)) {
                return false;
            }
            if (mat == Material.BEACON || MaterialUtil.ALL_CAULDRONS.contains(mat) || mat == Material.GLOWSTONE || mat == BridgeMaterial.SEA_LANTERN || mat == BridgeMaterial.CONDUIT) {
                return false;
            }
            if (mat == BridgeMaterial.PISTON || mat == BridgeMaterial.STICKY_PISTON || mat == BridgeMaterial.PISTON_HEAD) {
                return false;
            }
            return mat == Material.SOUL_SAND || AxisAlignedBBUtils.isFullBounds(node.getBounds(blockCache, modX, y, modZ));
        }
        if (BlockProperties.isLeaves(mat)) {
            return pData.getClientVersion().isAtLeast(ClientVersion.V_1_14) && pData.getClientVersion().isAtMost(ClientVersion.V_1_15_2);
        }
        if (mat == Material.SNOW) {
            return ((Snow)data).getLayers() == 8;
        }
        if (BlockProperties.isStairs(mat)) {
            return ((Directional)data).getFacing() == direction;
        }
        if (mat == BridgeMaterial.COMPOSTER) {
            return true;
        }
        if (mat == Material.SOUL_SAND) {
            return pData.getClientVersion().isAtMost(ClientVersion.V_1_12_2) || pData.getClientVersion().isAtLeast(ClientVersion.V_1_16);
        }
        if (mat == Material.LADDER) {
            return ((Directional)data).getFacing().getOppositeFace() == direction;
        }
        if (MaterialUtil.ALL_TRAP_DOORS.contains(mat)) {
            return ((Directional)data).getFacing().getOppositeFace() == direction && ((Openable)data).isOpen();
        }
        if (MaterialUtil.ALL_DOORS.contains(mat)) {
            return ((Directional)data).getFacing().getOppositeFace() == direction;
        }
        return AxisAlignedBBUtils.isFullBounds(node.getBounds(blockCache, modX, y, modZ));
    }

    public static double getLiquidHeightAt(BlockCache access, int x, int y, int z, long liquidTypeFlag, boolean clearDefinition) {
        double liquidHeight;
        BlockCache.IBlockCacheNode node = access.getOrCreateBlockCacheNode(x, y, z, false);
        BlockCache.IBlockCacheNode nodeAbove = access.getOrCreateBlockCacheNode(x, y + 1, z, false);
        long flags = BlockFlags.getBlockFlags(node.getType());
        long aboveFlags = BlockFlags.getBlockFlags(nodeAbove.getType());
        if ((flags & liquidTypeFlag) != 0L) {
            if (nodeAbove != null && (aboveFlags & liquidTypeFlag) != 0L) {
                liquidHeight = 1.0;
                if (clearDefinition) {
                    liquidHeight = 0.8888888955116272;
                }
            } else {
                int data = node.getData(access, x, y, z);
                liquidHeight = data >= 8 ? 0.8888888955116272 : (double)(1.0f - (float)(data + 1) / 9.0f);
            }
        } else {
            liquidHeight = 0.0;
        }
        return liquidHeight;
    }

    public static final boolean canBeClimbedUp(BlockCache cache, int x, int y, int z) {
        Material id = cache.getType(x, y, z);
        if ((BlockFlags.getBlockFlags(id) & BlockFlags.F_CLIMBABLE) == 0L) {
            return false;
        }
        if (id == Material.LADDER) {
            return true;
        }
        if ((BlockFlags.getBlockFlags(cache.getType(x + 1, y, z)) & BlockFlags.F_SOLID) != 0L) {
            return true;
        }
        if ((BlockFlags.getBlockFlags(cache.getType(x - 1, y, z)) & BlockFlags.F_SOLID) != 0L) {
            return true;
        }
        if ((BlockFlags.getBlockFlags(cache.getType(x, y, z + 1)) & BlockFlags.F_SOLID) != 0L) {
            return true;
        }
        return (BlockFlags.getBlockFlags(cache.getType(x, y, z - 1)) & BlockFlags.F_SOLID) != 0L;
    }

    public static final BlockFace getFacing(long flags, int data) {
        if ((flags & BlockFlags.F_FACING_LOW3D2_NSWE) != 0L) {
            switch (data & 7) {
                case 3: {
                    return BlockFace.SOUTH;
                }
                case 4: {
                    return BlockFace.WEST;
                }
                case 5: {
                    return BlockFace.EAST;
                }
            }
            return BlockFace.NORTH;
        }
        if ((flags & BlockFlags.F_ATTACHED_LOW2_SNEW) != 0L) {
            switch (data & 3) {
                case 0: {
                    return BlockFace.NORTH;
                }
                case 1: {
                    return BlockFace.SOUTH;
                }
                case 2: {
                    return BlockFace.WEST;
                }
                case 3: {
                    return BlockFace.EAST;
                }
            }
        }
        return null;
    }

    public static final boolean isTrapDoorAboveLadderSpecialCase(BlockCache access, int x, int y, int z) {
        int data2;
        if (!BlockProperties.isSpecialCaseTrapDoorAboveLadder()) {
            return false;
        }
        long flags1 = BlockFlags.getBlockFlags(access.getType(x, y, z));
        if (!MaterialUtil.ALL_TRAP_DOORS.contains(access.getType(x, y, z))) {
            return false;
        }
        int data1 = access.getData(x, y, z);
        if (data1 == 0) {
            return false;
        }
        BlockFace face1 = BlockProperties.getFacing(flags1, data1);
        if (face1 == null) {
            return false;
        }
        Material belowId = access.getType(x, y - 1, z);
        if (belowId != Material.LADDER) {
            return false;
        }
        long flags2 = BlockFlags.getBlockFlags(belowId);
        BlockFace face2 = BlockProperties.getFacing(flags2, data2 = access.getData(x, y - 1, z));
        return face1 == face2;
    }

    public static final boolean isPassable(Material blockType) {
        long flags = BlockFlags.getBlockFlags(blockType);
        if ((flags & (BlockFlags.F_LIQUID | BlockFlags.F_IGN_PASSABLE)) != 0L) {
            return true;
        }
        return (flags & BlockFlags.F_GROUND) == 0L;
    }

    public static final boolean isPassable(BlockCache access, double x, double y, double z, BlockCache.IBlockCacheNode node, BlockCache.IBlockCacheNode nodeAbove) {
        Material id = node.getType();
        if (BlockProperties.isPassable(id)) {
            return true;
        }
        int bx = Location.locToBlock((double)x);
        int by = Location.locToBlock((double)y);
        int bz = Location.locToBlock((double)z);
        if (node.hasNonNullBounds() == AlmostBoolean.NO || !BlockProperties.collidesBlock(access, x, y, z, x, y, z, bx, by, bz, node, nodeAbove, BlockFlags.getBlockFlags(id))) {
            return true;
        }
        double fx = x - (double)bx;
        double fy = y - (double)by;
        double fz = z - (double)bz;
        return BlockProperties.isPassableWorkaround(access, bx, by, bz, fx, fy, fz, node, 0.0, 0.0, 0.0, 0.0);
    }

    public static final boolean isPassableH150(BlockCache access, double x, double y, double z) {
        int by = Location.locToBlock((double)y) - 1;
        double fy = y - (double)by;
        if (fy >= 1.5) {
            return true;
        }
        int bx = Location.locToBlock((double)x);
        int bz = Location.locToBlock((double)z);
        BlockCache.IBlockCacheNode nodeBelow = access.getOrCreateBlockCacheNode(x, y, z, false);
        Material belowId = nodeBelow.getType();
        long belowFlags = BlockFlags.getBlockFlags(belowId);
        if ((belowFlags & BlockFlags.F_HEIGHT150) == 0L || BlockProperties.isPassable(belowId)) {
            return true;
        }
        double[] belowBounds = nodeBelow.getBounds(access, bx, by, bz);
        if (belowBounds == null) {
            return true;
        }
        if (!BlockProperties.collidesBlock(access, x, y, z, x, y, z, bx, by, bz, nodeBelow, null, belowFlags)) {
            return true;
        }
        double fx = x - (double)bx;
        double fz = z - (double)bz;
        return BlockProperties.isPassableWorkaround(access, bx, by, bz, fx, fy, fz, nodeBelow, 0.0, 0.0, 0.0, 0.0);
    }

    public static final boolean isPassableExact(BlockCache access, double x, double y, double z) {
        return BlockProperties.isPassable(access, x, y, z, access.getOrCreateBlockCacheNode(x, y, z, false), null) && BlockProperties.isPassableH150(access, x, y, z);
    }

    public static final boolean isPassableExact(BlockCache access, Location loc) {
        return BlockProperties.isPassableExact(access, loc.getX(), loc.getY(), loc.getZ());
    }

    public static final boolean isPassableWorkaround(BlockCache access, int bx, int by, int bz, double fx, double fy, double fz, BlockCache.IBlockCacheNode node, double dX, double dY, double dZ, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, double dT) {
        Material id = node.getType();
        long flags = BlockFlags.getBlockFlags(id);
        if ((flags & BlockFlags.F_PASSABLE_X4) != 0L && (access.getData(bx, by, bz) & 4) != 0) {
            return true;
        }
        if ((flags & BlockFlags.F_THICK_FENCE) != 0L) {
            if (!BlockProperties.collidesFence(fx, fz, dX, dZ, dT, 0.125)) {
                return true;
            }
        } else {
            if ((flags & BlockFlags.F_THIN_FENCE) != 0L) {
                if (!BlockProperties.collidesFence(fx, fz, dX, dZ, dT, 0.0625)) {
                    return true;
                }
                return Math.min(fy, fy + dY * dT) < 0.974 && !BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, maxY, maxZ, bx, by, bz, node, null, flags | BlockFlags.F_FAKEBOUNDS);
            }
            if (id == Material.CAULDRON || id == Material.HOPPER) {
                if (Math.min(fy, fy + dY * dT) >= BlockProperties.getGroundMinHeight(access, bx, by, bz, node, flags)) {
                    return BlockProperties.isInsideCenter(fx, fz, dX, dZ, dT, 0.125);
                }
            } else {
                if ((flags & BlockFlags.F_GROUND_HEIGHT) != 0L && BlockProperties.getGroundMinHeight(access, bx, by, bz, node, flags) <= Math.min(fy, fy + dY * dT)) {
                    return true;
                }
                if (id.toString().equals("CHORUS_PLANT") && !BlockProperties.collidesFence(fx, fz, dX, dZ, dT, 0.3)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean isPassableWorkaround(BlockCache access, int bx, int by, int bz, double fx, double fy, double fz, BlockCache.IBlockCacheNode node, double dX, double dY, double dZ, double dT) {
        return BlockProperties.isPassableWorkaround(access, bx, by, bz, fx, fy, fz, node, dX, dY, dZ, fx + (double)bx, fy + (double)by, fz + (double)bz, fx + (double)bx, fy + (double)by, fz + (double)bz, dT);
    }

    public static boolean collidesFence(double fx, double fz, double dX, double dZ, double dT, double d) {
        double dFx = 0.5 - fx;
        double dFz = 0.5 - fz;
        if (Math.abs(dFx) > d && Math.abs(dFz) > d) {
            double dFx2 = 0.5 - (fx + dX * dT);
            double dFz2 = 0.5 - (fz + dZ * dT);
            if (Math.abs(dFx2) > d && Math.abs(dFz2) > d && dFx * dFx2 > 0.0 && dFz * dFz2 > 0.0) {
                return false;
            }
        }
        return true;
    }

    public static final boolean collidesCenter(double fx, double fz, double dX, double dZ, double dT, double inset) {
        double low = inset;
        double high = 1.0 - inset;
        double xEnd = fx + dX * dT;
        if (xEnd < low && fx < low) {
            return false;
        }
        if (xEnd >= high && fx >= high) {
            return false;
        }
        double zEnd = fz + dZ * dT;
        if (zEnd < low && fz < low) {
            return false;
        }
        return !(zEnd >= high) || !(fz >= high);
    }

    public static final boolean isInsideCenter(double fx, double fz, double dX, double dZ, double dT, double inset) {
        double low = inset;
        double high = 1.0 - inset;
        double xEnd = fx + dX * dT;
        if (xEnd < low || fx < low) {
            return false;
        }
        if (xEnd >= high || fx >= high) {
            return false;
        }
        double zEnd = fz + dZ * dT;
        if (zEnd < low || fz < low) {
            return false;
        }
        return !(zEnd >= high) && !(fz >= high);
    }

    public static double getGroundMinHeight(BlockCache access, int x, int y, int z, BlockCache.IBlockCacheNode node, long flags) {
        Material id = node.getType();
        double[] bounds = node.getBounds(access, x, y, z);
        if ((flags & BlockFlags.F_HEIGHT_8_INC) != 0L) {
            int data = (node.getData(access, x, y, z) & 0xF) % 8;
            return 0.125 * (double)data;
        }
        if ((flags & BlockFlags.F_HEIGHT150) != 0L) {
            return 1.5;
        }
        if ((flags & BlockFlags.F_THICK_FENCE) != 0L) {
            return Math.min(1.0, bounds[4]);
        }
        if (bounds == null) {
            return 0.0;
        }
        if ((flags & BlockFlags.F_GROUND_HEIGHT) != 0L) {
            if ((flags & BlockFlags.F_MIN_HEIGHT16_1) != 0L) {
                return 0.0625;
            }
            if ((flags & BlockFlags.F_MIN_HEIGHT8_1) != 0L) {
                return 0.125;
            }
            if ((flags & BlockFlags.F_MIN_HEIGHT4_1) != 0L) {
                return 0.25;
            }
            if ((flags & BlockFlags.F_MIN_HEIGHT16_5) != 0L) {
                return 0.3125;
            }
            if ((flags & BlockFlags.F_MIN_HEIGHT16_7) != 0L) {
                return 0.4375;
            }
            if ((flags & BlockFlags.F_MIN_HEIGHT16_9) != 0L) {
                return 0.5625;
            }
            if ((flags & BlockFlags.F_MIN_HEIGHT8_5) != 0L) {
                return 0.625;
            }
            if ((flags & BlockFlags.F_MIN_HEIGHT16_11) != 0L) {
                return 0.6875;
            }
            if ((flags & BlockFlags.F_MIN_HEIGHT16_13) != 0L) {
                return 0.8125;
            }
            if ((flags & BlockFlags.F_MIN_HEIGHT16_14) != 0L) {
                return 0.875;
            }
            if ((flags & BlockFlags.F_MIN_HEIGHT16_15) != 0L) {
                return 0.9375;
            }
            if (id == BridgeMaterial.FARMLAND) {
                return bounds[4];
            }
            if ((flags & BlockFlags.F_PASSABLE_X4) != 0L && (node.getData(access, x, y, z) & 4) != 0) {
                return bounds[4];
            }
            return 0.0;
        }
        double minHeight = bounds[4];
        for (int i = 2; i <= AxisAlignedBBUtils.getNumberOfAABBs(bounds); ++i) {
            minHeight = Math.min(minHeight, bounds[i * 6 - 2]);
        }
        return minHeight;
    }

    public static final boolean isPassable(PlayerLocation loc) {
        return BlockProperties.isPassable(loc.getBlockCache(), loc.getX(), loc.getY(), loc.getZ(), loc.getOrCreateBlockCacheNode(), null);
    }

    public static final boolean isPassable(Location loc) {
        return BlockProperties.isPassable(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ());
    }

    public static final boolean isPassable(World world, double x, double y, double z) {
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(world);
        boolean res = BlockProperties.isPassable(blockCache, x, y, z, blockCache.getOrCreateBlockCacheNode(x, y, z, false), null);
        blockCache.cleanup();
        return res;
    }

    public static final boolean isPassable(Location from, Location to) {
        return BlockProperties.isPassable(rtRay, from, to);
    }

    public static final boolean isPassableAxisWise(Location from, Location to) {
        return BlockProperties.isPassable(rtAxis, from, to);
    }

    private static boolean isPassable(ICollidePassable rt, Location from, Location to) {
        BlockCache blockCache = wrapBlockCache.getBlockCache();
        blockCache.setAccess(from.getWorld());
        rt.setMaxSteps(60);
        rt.setBlockCache(blockCache);
        rt.set(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ());
        rt.loop();
        boolean collides = rt.collides();
        blockCache.cleanup();
        rt.cleanup();
        return !collides;
    }

    public static final boolean isPassable(BlockCache access, Location loc) {
        return BlockProperties.isPassable(access, loc.getX(), loc.getY(), loc.getZ(), access.getOrCreateBlockCacheNode(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), false), null);
    }

    public static void applyConfig(RawConfigFile config, String pathPrefix) {
        ConfigurationSection section = config.getConfigurationSection(pathPrefix + "breaking-time");
        if (section != null) {
            for (String input : section.getKeys(false)) {
                try {
                    BlockProperties.setBreakingTimeOverride(new BlockBreakKey().fromString(input.trim()), section.getLong(input));
                }
                catch (Exception e) {
                    StaticLog.logWarning("Bad breaking time override (" + pathPrefix + "breaking-time" + "): " + input);
                    StaticLog.logWarning(e);
                }
            }
            for (String input : config.getStringList(pathPrefix + "allow-instant-break")) {
                Material id = RawConfigFile.parseMaterial(input);
                if (id == null) {
                    StaticLog.logWarning("Bad block id (" + pathPrefix + "allow-instant-break" + "): " + input);
                    continue;
                }
                BlockProperties.setBlockProps(id, instantType);
            }
        }
        if ((section = config.getConfigurationSection(pathPrefix + "override-flags")) != null) {
            Map entries = section.getValues(false);
            boolean hasErrors = false;
            for (Map.Entry entry : entries.entrySet()) {
                String key = (String)entry.getKey();
                Material id = RawConfigFile.parseMaterial(key);
                if (id == null) {
                    StaticLog.logWarning("Bad block id (" + pathPrefix + "override-flags" + "): " + key);
                    continue;
                }
                Object obj = entry.getValue();
                if (!(obj instanceof String)) {
                    StaticLog.logWarning("Bad flags at " + pathPrefix + "override-flags" + " for key: " + key);
                    hasErrors = true;
                    continue;
                }
                List<String> split = StringUtil.split((String)obj, Character.valueOf(' '), Character.valueOf(','), Character.valueOf('/'), Character.valueOf('|'), Character.valueOf('+'), Character.valueOf(';'), Character.valueOf('\t'));
                long flags = 0L;
                boolean error = false;
                for (String input : split) {
                    if ((input = input.trim()).isEmpty()) continue;
                    if (input.equalsIgnoreCase("default")) {
                        flags |= BlockFlags.getBlockFlags(id);
                        continue;
                    }
                    try {
                        flags |= BlockFlags.parseFlag(input);
                    }
                    catch (InputMismatchException e) {
                        StaticLog.logWarning("Bad flag at " + pathPrefix + "override-flags" + " for key " + key + " (skip setting flags for this block): " + input);
                        error = true;
                        hasErrors = true;
                        break;
                    }
                }
                if (error) continue;
                BlockFlags.setBlockFlags(id, flags);
            }
            if (hasErrors) {
                StaticLog.logInfo("Overriding block-flags was not entirely successful, all available flags: \n" + StringUtil.join(BlockFlags.flagNameMap.values(), "|"));
            }
        }
        minWorldY = config.getInt(pathPrefix + "block-cache.minimal-world-Y");
    }

    public static final boolean hasAnyFlags(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, long flags) {
        return BlockProperties.hasAnyFlags(access, Location.locToBlock((double)minX), Location.locToBlock((double)minY), Location.locToBlock((double)minZ), Location.locToBlock((double)maxX), Location.locToBlock((double)maxY), Location.locToBlock((double)maxZ), flags);
    }

    public static final boolean hasAnyFlags(BlockCache access, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, long flags) {
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    if ((BlockFlags.getBlockFlags(access.getType(x, y, z)) & flags) == 0L) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean containsAnyLiquid(BlockCache access, double[] AABB, long liquidFlag) {
        int iMinX = MathUtil.floor(AABB[0]);
        int iMaxX = MathUtil.ceil(AABB[3]);
        int iMinY = MathUtil.floor(AABB[1]);
        int iMaxY = MathUtil.ceil(AABB[4]);
        int iMinZ = MathUtil.floor(AABB[2]);
        int iMaxZ = MathUtil.ceil(AABB[5]);
        for (int x = iMinX; x < iMaxX; ++x) {
            for (int y = iMinY; y < iMaxY; ++y) {
                for (int z = iMinZ; z < iMaxZ; ++z) {
                    if ((BlockFlags.getBlockFlags(access.getType(x, y, z)) & liquidFlag) == 0L) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean collides(BlockCache access, double[] bounds, long flags) {
        return BlockProperties.collides(access, bounds[0], bounds[1], bounds[2], bounds[3], bounds[4], bounds[5], flags);
    }

    public static final boolean collides(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, long flags) {
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)(minY - ((flags & BlockFlags.F_HEIGHT150) != 0L ? 0.5625 : 0.0)));
        int iMaxY = Math.min(Location.locToBlock((double)maxY), access.getMaxBlockY());
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                BlockCache.IBlockCacheNode nodeAbove = null;
                for (int y = iMaxY; y >= iMinY; --y) {
                    BlockCache.IBlockCacheNode node = access.getOrCreateBlockCacheNode(x, y, z, false);
                    Material id = node.getType();
                    long collectedFlags = BlockFlags.getBlockFlags(id);
                    if ((collectedFlags & flags) != 0L && node.hasNonNullBounds().decideOptimistically() && BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, maxY, maxZ, x, y, z, node, nodeAbove, collectedFlags)) {
                        return true;
                    }
                    nodeAbove = node;
                }
            }
        }
        return false;
    }

    public static final boolean collidesId(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Material mat) {
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)(minY - ((BlockFlags.getBlockFlags(mat) & BlockFlags.F_HEIGHT150) != 0L ? 0.5625 : 0.0)));
        int iMaxY = Location.locToBlock((double)maxY);
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    if (mat != access.getType(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean isWaterlogged(World world, BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!Bridge1_13.hasIsSwimming()) {
            return false;
        }
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)minY);
        int iMaxY = Math.min(Location.locToBlock((double)maxY), access.getMaxBlockY());
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMaxY; y >= iMinY; --y) {
                    BlockData bd = world.getBlockAt(x, y, z).getBlockData();
                    if (!(bd instanceof Waterlogged) || !((Waterlogged)bd).isWaterlogged() || minX > 1.0 + (double)x || maxX < 0.0 + (double)x || minY > 0.8888888955116272 + (double)y || maxY < 0.0 + (double)y || minZ > 1.0 + (double)z || maxZ < 0.0 + (double)z || minX == 1.0 + (double)x || minY == 0.8888888955116272 + (double)y || minZ == 1.0 + (double)z) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean collidesBlock(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Material id) {
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)(minY - ((BlockFlags.getBlockFlags(id) & BlockFlags.F_HEIGHT150) != 0L ? 0.5625 : 0.0)));
        int iMaxY = Math.min(Location.locToBlock((double)maxY), access.getMaxBlockY());
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        long flags = BlockFlags.getBlockFlags(id);
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                BlockCache.IBlockCacheNode nodeAbove = null;
                for (int y = iMaxY; y >= iMinY; --y) {
                    BlockCache.IBlockCacheNode node = access.getOrCreateBlockCacheNode(x, y, z, false);
                    if (id != node.getType() || !node.hasNonNullBounds().decideOptimistically() || !BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, maxY, maxZ, x, y, z, node, nodeAbove, flags)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean collidesBlock(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int x, int y, int z, BlockCache.IBlockCacheNode node, BlockCache.IBlockCacheNode nodeAbove, long flags) {
        boolean allowEdge;
        double bMaxY;
        int data;
        double bMinY;
        double bMaxX;
        double bMaxZ;
        double bMinX;
        double bMinZ;
        double[] blockBounds = node.getBounds(access, x, y, z);
        if (blockBounds == null) {
            return false;
        }
        if ((flags & BlockFlags.F_XZ100) != 0L) {
            bMinZ = 0.0;
            bMinX = 0.0;
            bMaxZ = 1.0;
            bMaxX = 1.0;
        } else {
            bMinX = blockBounds[0];
            bMinZ = blockBounds[2];
            bMaxX = blockBounds[3];
            bMaxZ = blockBounds[5];
        }
        if ((flags & BlockFlags.F_HEIGHT_8_INC) != 0L) {
            bMinY = 0.0;
            data = (node.getData(access, x, y, z) & 0xF) % 8;
            bMaxY = 0.125 * (double)data;
        } else if ((flags & BlockFlags.F_HEIGHT150) != 0L) {
            bMinY = 0.0;
            bMaxY = 1.5;
        } else if ((flags & BlockFlags.F_HEIGHT100) != 0L) {
            bMinY = 0.0;
            bMaxY = 1.0;
        } else if ((flags & BlockFlags.F_HEIGHT_8SIM_DEC) != 0L) {
            bMinY = 0.0;
            bMaxY = (flags & BlockFlags.F_LAVA) != 0L ? (nodeAbove != null && (BlockFlags.getBlockFlags(nodeAbove.getType()) & BlockFlags.F_LAVA) != 0L ? 1.0 : ((data = node.getData(access, x, y, z)) >= 8 ? 0.8888888955116272 : (double)(1.0f - (float)(data + 1) / 9.0f))) : ((flags & BlockFlags.F_WATER) != 0L ? (nodeAbove != null && (BlockFlags.getBlockFlags(nodeAbove.getType()) & BlockFlags.F_WATER) != 0L ? 1.0 : (((data = node.getData(access, x, y, z)) & 8) == 8 ? Math.max(0.8888888955116272, blockBounds[4]) : (double)(1.0f - (float)(data + 1) / 9.0f))) : 0.8888888955116272);
        } else if ((flags & BlockFlags.F_HEIGHT8_1) != 0L) {
            bMinY = 0.0;
            bMaxY = 0.125;
        } else {
            bMinY = blockBounds[1];
            bMaxY = blockBounds[4];
        }
        if ((flags & BlockFlags.F_FAKEBOUNDS) != 0L) {
            double aaBBLengthZ = bMaxZ - bMinZ;
            double aaBBLengthX = bMaxX - bMinX;
            if (aaBBLengthZ == 0.125 && aaBBLengthX != 1.0) {
                if (bMinX == 0.0) {
                    bMaxX = 0.5;
                }
                if (bMaxX == 1.0) {
                    bMinX = 0.5;
                }
            } else if (aaBBLengthX == 0.125 && aaBBLengthZ != 1.0) {
                if (bMinZ == 0.0) {
                    bMaxZ = 0.5;
                }
                if (bMaxZ == 1.0) {
                    bMinZ = 0.5;
                }
            } else if (aaBBLengthX == aaBBLengthZ && aaBBLengthX != 1.0) {
                if (bMaxX == 0.5625) {
                    bMaxX = 0.5;
                } else if (bMaxZ == 0.5625) {
                    bMaxZ = 0.5;
                } else if (bMinX == 0.4375) {
                    bMinX = 0.5;
                } else if (bMinZ == 0.4375) {
                    bMinZ = 0.5;
                }
            }
        }
        boolean bl = allowEdge = (flags & BlockFlags.F_COLLIDE_EDGES) == 0L;
        if (AxisAlignedBBUtils.isCollided(new double[]{bMinX, bMinY, bMinZ, bMaxX, bMaxY, bMaxZ}, x, y, z, new double[]{minX, minY, minZ, maxX, maxY, maxZ}, allowEdge)) {
            return true;
        }
        return !AxisAlignedBBUtils.isSimpleShape(blockBounds) && AxisAlignedBBUtils.isCollided(blockBounds, x, y, z, new double[]{minX, minY, minZ, maxX, maxY, maxZ}, allowEdge, 2);
    }

    public static final boolean isOnGroundShuffled(World world, BlockCache access, double x1, double y1, double z1, double x2, double y2, double z2, double xzMargin, double yBelow, double yAbove) {
        return BlockProperties.isOnGroundShuffled(world, access, x1, y1, z1, x2, y2, z2, xzMargin, yBelow, yAbove, 0L);
    }

    public static final boolean isOnGround(World world, BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return BlockProperties.isOnGround(access, minX, minY, minZ, maxX, maxY, maxZ, 0L);
    }

    public static final boolean isOnGroundShuffled(World world, BlockCache access, double x1, double y1, double z1, double x2, double y2, double z2, double xzMargin, double yBelow, double yAbove, long ignoreFlags) {
        return BlockProperties.isOnGround(access, Math.min(x1, x2) - xzMargin, Math.min(y1, y2) - yBelow, Math.min(z1, z2) - xzMargin, Math.max(x1, x2) + xzMargin, Math.max(y1, y2) + yAbove, Math.max(z1, z2) + xzMargin, ignoreFlags);
    }

    public static final boolean isOnGround(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, long ignoreFlags) {
        int maxBlockY = access.getMaxBlockY();
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)(minY - 0.5626));
        if (iMinY > maxBlockY) {
            return false;
        }
        int iMaxY = Math.min(Location.locToBlock((double)maxY), maxBlockY);
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        for (int x = iMinX; x <= iMaxX; ++x) {
            block5: for (int z = iMinZ; z <= iMaxZ; ++z) {
                BlockCache.IBlockCacheNode nodeAbove = null;
                block6: for (int y = iMaxY; y >= iMinY; --y) {
                    BlockCache.IBlockCacheNode node = access.getOrCreateBlockCacheNode(x, y, z, false);
                    switch (BlockProperties.isOnGround(access, minX, minY, minZ, maxX, maxY, maxZ, ignoreFlags, x, y, z, node, nodeAbove)) {
                        case YES: {
                            return true;
                        }
                        case MAYBE: {
                            nodeAbove = node;
                            continue block6;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
        }
        return false;
    }

    public static final AlmostBoolean isOnGround(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, long ignoreFlags, int x, int y, int z, BlockCache.IBlockCacheNode node, BlockCache.IBlockCacheNode nodeAbove) {
        Material aboveMat;
        long aboveFlags;
        double[] blockAABB;
        Material id = node.getType();
        long flags = BlockFlags.getBlockFlags(id);
        if ((flags & BlockFlags.F_GROUND) == 0L) {
            return AlmostBoolean.MAYBE;
        }
        if ((flags & ignoreFlags) != 0L && (blockAABB = node.getBounds(access, x, y, z)) != null && (blockAABB[3] == 0.0 || blockAABB[5] == 0.0)) {
            return AlmostBoolean.MAYBE;
        }
        blockAABB = node.getBounds(access, x, y, z);
        if (blockAABB == null) {
            return AlmostBoolean.YES;
        }
        if (!BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, maxY, maxZ, x, y, z, node, nodeAbove, flags)) {
            return AlmostBoolean.MAYBE;
        }
        IPlayerData pData = access.getPlayerData();
        if (pData != null) {
            boolean hasBoots = pData.getGenericInstance(MovingData.class).hasLeatherBoots;
            if ((flags & BlockFlags.F_POWDER_SNOW) != 0L && !hasBoots) {
                return AlmostBoolean.NO;
            }
        }
        if (BlockProperties.isPassableWorkaround(access, x, y, z, minX - (double)x, minY - (double)y, minZ - (double)z, node, maxX - minX, maxY - minY, maxZ - minZ, minX, minY, minZ, maxX, maxY, maxZ, 1.0) && ((flags & BlockFlags.F_GROUND_HEIGHT) == 0L || BlockProperties.getGroundMinHeight(access, x, y, z, node, flags) > maxY - (double)y)) {
            return AlmostBoolean.MAYBE;
        }
        if (BlockProperties.getGroundMinHeight(access, x, y, z, node, flags) > maxY - (double)y) {
            if (AxisAlignedBBUtils.isFullBounds(blockAABB)) {
                return AlmostBoolean.NO;
            }
            return AlmostBoolean.MAYBE;
        }
        if (maxY - (double)y < 1.0) {
            return AlmostBoolean.YES;
        }
        if (y >= access.getMaxBlockY()) {
            return AlmostBoolean.YES;
        }
        if (nodeAbove == null) {
            nodeAbove = access.getOrCreateBlockCacheNode(x, y + 1, z, false);
        }
        if (((aboveFlags = BlockFlags.getBlockFlags(aboveMat = nodeAbove.getType())) & BlockFlags.F_IGN_PASSABLE) != 0L) {
            return AlmostBoolean.YES;
        }
        if ((aboveFlags & BlockFlags.F_GROUND) == 0L || (aboveFlags & BlockFlags.F_LIQUID) != 0L || (aboveFlags & ignoreFlags) != 0L) {
            return AlmostBoolean.YES;
        }
        boolean variable = (flags & BlockFlags.F_VARIABLE) != 0L;
        if (!(variable |= (aboveFlags & BlockFlags.F_VARIABLE) != 0L) && id == aboveMat) {
            if (AxisAlignedBBUtils.isFullBounds(blockAABB)) {
                return AlmostBoolean.NO;
            }
            return AlmostBoolean.MAYBE;
        }
        double[] blockAABB_Above = nodeAbove.getBounds(access, x, y + 1, z);
        if (blockAABB_Above == null) {
            return AlmostBoolean.YES;
        }
        if (!BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, Math.max(maxY, 1.49 + (double)y), maxZ, x, y + 1, z, nodeAbove, null, aboveFlags)) {
            return AlmostBoolean.YES;
        }
        if (BlockProperties.isPassableWorkaround(access, x, y + 1, z, minX - (double)x, minY - (double)(y + 1), minZ - (double)z, nodeAbove, maxX - minX, maxY - minY, maxZ - minZ, minX, minY, minZ, maxX, maxY, maxZ, 1.0)) {
            return AlmostBoolean.YES;
        }
        if (AxisAlignedBBUtils.isFullBounds(blockAABB_Above)) {
            return AlmostBoolean.NO;
        }
        if (variable) {
            if (AxisAlignedBBUtils.isSameShape(blockAABB, blockAABB_Above)) {
                return AlmostBoolean.MAYBE;
            }
            return AlmostBoolean.YES;
        }
        return AlmostBoolean.MAYBE;
    }

    public static final long collectFlagsSimple(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)minY);
        int iMaxY = Location.locToBlock((double)maxY);
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        long flags = 0L;
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    flags |= BlockFlags.getBlockFlags(access.getType(x, y, z));
                }
            }
        }
        return flags;
    }

    public static float getBreakPenaltyInWater() {
        return breakPenaltyInWater;
    }

    public static void setBreakPenaltyInWater(float breakPenaltyInWater) {
        BlockProperties.breakPenaltyInWater = breakPenaltyInWater;
    }

    public static float getBreakPenaltyOffGround() {
        return breakPenaltyOffGround;
    }

    public static void setBreakPenaltyOffGround(float breakPenaltyOffGround) {
        BlockProperties.breakPenaltyOffGround = breakPenaltyOffGround;
    }

    public static void cleanup() {
        if (eLoc != null) {
            eLoc.cleanup();
            eLoc = null;
        }
        if (wrapBlockCache != null) {
            wrapBlockCache.cleanup();
            wrapBlockCache = null;
        }
    }

    public static final boolean isPassableRay(BlockCache access, int blockX, int blockY, int blockZ, double oX, double oY, double oZ, double dX, double dY, double dZ, double dT) {
        double maxZ;
        double minZ;
        double maxY;
        double minY;
        double maxX;
        double minX;
        BlockCache.IBlockCacheNode node = access.getOrCreateBlockCacheNode(blockX, blockY, blockZ, false);
        if (BlockProperties.isPassable(node.getType())) {
            return true;
        }
        double[] bounds = access.getBounds(blockX, blockY, blockZ);
        if (bounds == null) {
            return true;
        }
        if (dX < 0.0) {
            minX = dX * dT + oX + (double)blockX;
            maxX = oX + (double)blockX;
        } else {
            maxX = dX * dT + oX + (double)blockX;
            minX = oX + (double)blockX;
        }
        if (dY < 0.0) {
            minY = dY * dT + oY + (double)blockY;
            maxY = oY + (double)blockY;
        } else {
            maxY = dY * dT + oY + (double)blockY;
            minY = oY + (double)blockY;
        }
        if (dZ < 0.0) {
            minZ = dZ * dT + oZ + (double)blockZ;
            maxZ = oZ + (double)blockZ;
        } else {
            maxZ = dZ * dT + oZ + (double)blockZ;
            minZ = oZ + (double)blockZ;
        }
        if (!BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, maxY, maxZ, blockX, blockY, blockZ, node, null, BlockFlags.getBlockFlags(node.getType()) | BlockFlags.F_COLLIDE_EDGES)) {
            return true;
        }
        return BlockProperties.isPassableWorkaround(access, blockX, blockY, blockZ, oX, oY, oZ, node, dX, dY, dZ, minX, minY, minZ, maxX, maxY, maxZ, dT);
    }

    public static final boolean isPassableBox(BlockCache access, int blockX, int blockY, int blockZ, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        BlockCache.IBlockCacheNode node = access.getOrCreateBlockCacheNode(blockX, blockY, blockZ, false);
        Material id = node.getType();
        if (BlockProperties.isPassable(id)) {
            return true;
        }
        double[] bounds = access.getBounds(blockX, blockY, blockZ);
        if (bounds == null) {
            return true;
        }
        if (!BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, maxY, maxZ, blockX, blockY, blockZ, node, null, BlockFlags.getBlockFlags(id) | BlockFlags.F_COLLIDE_EDGES)) {
            return true;
        }
        return BlockProperties.isPassableWorkaround(access, blockX, blockY, blockZ, minX - (double)blockX, minY - (double)blockY, minZ - (double)blockZ, node, maxX - minX, maxY - minY, maxZ - minZ, minX, minY, minZ, maxX, maxY, maxZ, 1.0);
    }

    public static final boolean isPassableBox(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)minY);
        int iMaxY = Location.locToBlock((double)maxY);
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    if (BlockProperties.isPassableBox(access, x, y, z, minX, minY, minZ, maxX, maxY, maxZ)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static final int collectInitiallyCollidingBlocks(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, BlockPositionContainer results) {
        int added = 0;
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)minY);
        int iMaxY = Location.locToBlock((double)maxY);
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    if (BlockProperties.isPassableBox(access, x, y, z, minX, minY, minZ, maxX, maxY, maxZ)) continue;
                    results.addBlockPosition(x, y, z);
                    ++added;
                }
            }
        }
        int iMinY2 = Location.locToBlock((double)(minY - 0.5));
        if (iMinY != iMinY2) {
            for (int x = iMinX; x <= iMaxX; ++x) {
                for (int z = iMinZ; z <= iMaxZ; ++z) {
                    BlockCache.IBlockCacheNode node = access.getOrCreateBlockCacheNode(x, iMinY2, z, false);
                    if ((BlockFlags.getBlockFlags(node.getType()) & BlockFlags.F_HEIGHT150) == 0L || BlockProperties.isPassableBox(access, x, iMinY2, z, minX, minY, minZ, maxX, maxY, maxZ)) continue;
                    results.addBlockPosition(x, iMinY2, z);
                    ++added;
                }
            }
        }
        return added;
    }

    public static boolean isSpecialCaseTrapDoorAboveLadder() {
        return specialCaseTrapDoorAboveLadder;
    }

    public static void setSpecialCaseTrapDoorAboveLadder(boolean specialCaseTrapDoorAboveLadder) {
        BlockProperties.specialCaseTrapDoorAboveLadder = specialCaseTrapDoorAboveLadder;
    }

    public static int getMinWorldY() {
        return minWorldY;
    }

    public static class ToolProps {
        public final ToolType toolType;
        public final MaterialBase materialBase;

        public ToolProps(ToolType toolType, MaterialBase materialBase) {
            this.toolType = toolType;
            this.materialBase = materialBase;
        }

        public String toString() {
            return "ToolProps(" + (Object)((Object)this.toolType) + "/" + (Object)((Object)this.materialBase) + ")";
        }

        public void validate() {
            if (this.toolType == null) {
                throw new IllegalArgumentException("ToolType must not be null.");
            }
            if (this.materialBase == null) {
                throw new IllegalArgumentException("MaterialBase must not be null");
            }
        }
    }

    public static enum ToolType {
        NONE,
        SWORD,
        SHEARS,
        SPADE,
        AXE,
        PICKAXE,
        HOE;

    }

    public static enum MaterialBase {
        NONE(0, 1.0f),
        WOOD(1, 2.0f),
        STONE(2, 4.0f),
        IRON(3, 6.0f),
        DIAMOND(4, 8.0f),
        NETHERITE(5, 9.0f),
        GOLD(6, 12.0f);

        public final int index;
        public final float breakMultiplier;

        private MaterialBase(int index, float breakMultiplier) {
            this.index = index;
            this.breakMultiplier = breakMultiplier;
        }

        public static final MaterialBase getByIndex(int index) {
            for (MaterialBase base : MaterialBase.values()) {
                if (base.index != index) continue;
                return base;
            }
            throw new IllegalArgumentException("Bad index: " + index);
        }
    }

    public static class BlockProps {
        public final ToolProps tool;
        public final long[] breakingTimes;
        public final float hardness;
        public final float efficiencyMod;
        public final boolean requireCorrectTool;
        public final boolean pureHardness;

        public BlockProps(ToolProps tool, float hardness) {
            this(tool, hardness, 1.0f, false);
        }

        public BlockProps(ToolProps tool, float hardness, boolean requireCorrectTool) {
            this(tool, hardness, 1.0f, requireCorrectTool);
        }

        public BlockProps(ToolProps tool, float hardness, float efficiencyMod, boolean requireCorrectTool) {
            boolean noTool;
            this.pureHardness = true;
            this.tool = tool;
            this.hardness = hardness;
            this.requireCorrectTool = requireCorrectTool;
            this.breakingTimes = new long[7];
            this.breakingTimes[0] = (long)(5000.0f * hardness);
            boolean bl = noTool = tool.materialBase == null || tool.toolType == null || tool.toolType == ToolType.NONE;
            if (noTool || !requireCorrectTool) {
                this.breakingTimes[0] = (long)((double)this.breakingTimes[0] * 0.3);
            }
            for (int i = 1; i < 7; ++i) {
                if (noTool) {
                    this.breakingTimes[i] = this.breakingTimes[0];
                    continue;
                }
                if ((double)hardness > 0.0) {
                    float speed = MaterialBase.getByIndex((int)i).breakMultiplier;
                    float damage = speed / hardness;
                    this.breakingTimes[i] = damage >= 1.0f ? 0L : (long)(Math.round(1.0f / (damage /= BlockProperties.isRightToolMaterial(null, tool.materialBase, MaterialBase.getByIndex(i), true) ? 30.0f : 100.0f)) * 50);
                    continue;
                }
                this.breakingTimes[i] = 0L;
            }
            this.efficiencyMod = efficiencyMod;
        }

        public BlockProps(ToolProps tool, float hardness, long[] breakingTimes) {
            this(tool, hardness, breakingTimes, 1.0f);
        }

        public BlockProps(ToolProps tool, float hardness, long[] breakingTimes, float efficiencyMod) {
            this.pureHardness = false;
            this.requireCorrectTool = false;
            this.tool = tool;
            this.breakingTimes = breakingTimes;
            this.hardness = hardness;
            this.efficiencyMod = efficiencyMod;
        }

        public String toString() {
            return "BlockProps(" + this.hardness + " / " + this.tool.toString() + " / " + Arrays.toString(this.breakingTimes) + ")";
        }

        public void validate() {
            if (this.breakingTimes == null) {
                throw new IllegalArgumentException("Breaking times must not be null.");
            }
            if (this.breakingTimes.length != 7) {
                throw new IllegalArgumentException("Breaking times length must match the number of available tool types (7).");
            }
            if (this.tool == null) {
                throw new IllegalArgumentException("Tool must not be null.");
            }
            this.tool.validate();
        }
    }

    public static class BlockBreakKey {
        private Material blockType = null;
        private ToolType toolType = null;
        private MaterialBase materialBase = null;
        private Integer efficiency = null;

        public BlockBreakKey() {
        }

        public BlockBreakKey(BlockBreakKey key) {
            this.blockType = key.blockType;
            this.toolType = key.toolType;
            this.materialBase = key.materialBase;
            this.efficiency = key.efficiency;
        }

        public BlockBreakKey blockType(Material blockType) {
            this.blockType = blockType;
            return this;
        }

        public Material blockType() {
            return this.blockType;
        }

        public BlockBreakKey toolType(ToolType toolType) {
            this.toolType = toolType;
            return this;
        }

        public ToolType toolType() {
            return this.toolType;
        }

        public BlockBreakKey materialBase(MaterialBase materialBase) {
            this.materialBase = materialBase;
            return this;
        }

        public MaterialBase materialBase() {
            return this.materialBase;
        }

        public BlockBreakKey efficiency(int efficiency) {
            this.efficiency = efficiency;
            return this;
        }

        public int efficiency() {
            return this.efficiency;
        }

        public BlockBreakKey fromString(String def) {
            String[] parts = def.split(":");
            if (parts.length != 4) {
                throw new IllegalArgumentException("Accept key definition with 4 parts only, input: " + def);
            }
            Material blockType = Material.matchMaterial((String)parts[0]);
            ToolType toolType = ToolType.valueOf(parts[1].toUpperCase());
            MaterialBase materialBase = MaterialBase.valueOf(parts[2].toUpperCase());
            int efficiency = Integer.parseInt(parts[3]);
            return this.blockType(blockType).toolType(toolType).materialBase(materialBase).efficiency(efficiency);
        }

        public int hashCode() {
            return (this.blockType == null ? 0 : this.blockType.hashCode() * 11) ^ (this.toolType == null ? 0 : this.toolType.hashCode() * 137) ^ (this.materialBase == null ? 0 : this.materialBase.hashCode() * 1193) ^ (this.efficiency == null ? 0 : this.efficiency.hashCode() * 12791);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof BlockBreakKey) {
                BlockBreakKey other = (BlockBreakKey)obj;
                return this.blockType == other.blockType && this.efficiency == other.efficiency && this.toolType == other.toolType && this.materialBase == other.materialBase;
            }
            return false;
        }

        public String toString() {
            return "BlockBreakKey(blockType=" + this.blockType + "toolType=" + (Object)((Object)this.toolType) + "materialBase=" + (Object)((Object)this.materialBase) + " efficiency=" + this.efficiency + ")";
        }
    }
}

