/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.map;

import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.bukkit.Material;

public class BlockFlags {
    protected static final Map<Material, Long> blockFlags = new HashMap<Material, Long>();
    static final Map<Long, String> flagNameMap = new LinkedHashMap<Long, String>();
    private static final Map<String, Long> nameFlagMap = new LinkedHashMap<String, Long>();
    private static long f_next = 1L;
    public static final long F_STAIRS = BlockFlags.f_flag();
    public static final long F_BED = BlockFlags.f_flag();
    public static final long F_LIQUID = BlockFlags.f_flag();
    public static final long F_WATER_PLANT = BlockFlags.f_flag();
    public static final long F_SOLID = BlockFlags.f_flag();
    public static final long F_IGN_PASSABLE = BlockFlags.f_flag();
    public static final long F_WATER = BlockFlags.f_flag();
    public static final long F_LAVA = BlockFlags.f_flag();
    public static final long F_HEIGHT150 = BlockFlags.f_flag();
    public static final long F_GROUND = BlockFlags.f_flag();
    public static final long F_HEIGHT100 = BlockFlags.f_flag();
    public static final long F_CLIMBABLE = BlockFlags.f_flag();
    public static final long F_CLIMBUPABLE = BlockFlags.f_flag();
    public static final long F_VARIABLE = BlockFlags.f_flag();
    public static final long F_XZ100 = BlockFlags.f_flag();
    public static final long F_GROUND_HEIGHT = BlockFlags.f_flag();
    public static final long F_HEIGHT_8SIM_DEC = BlockFlags.f_flag();
    public static final long F_HEIGHT_8_INC = BlockFlags.f_flag();
    public static final long F_RAILS = BlockFlags.f_flag();
    public static final long F_ICE = BlockFlags.f_flag();
    public static final long F_BLUE_ICE = BlockFlags.f_flag();
    public static final long F_LEAVES = BlockFlags.f_flag();
    public static final long F_THIN_FENCE = BlockFlags.f_flag();
    public static final long F_COLLIDE_EDGES = BlockFlags.f_flag();
    public static final long F_THICK_FENCE = BlockFlags.f_flag();
    public static final long F_PASSABLE_X4 = BlockFlags.f_flag();
    public static final long F_BOUNCE25 = BlockFlags.f_flag();
    public static final long F_STICKY = BlockFlags.f_flag();
    public static final long F_FACING_LOW3D2_NSWE = BlockFlags.f_flag();
    public static final long F_ATTACHED_LOW2_SNEW = BlockFlags.f_flag();
    public static final long F_HEIGHT8_1 = BlockFlags.f_flag();
    public static final long F_FALLDIST_HALF = BlockFlags.f_flag();
    public static final long F_FALLDIST_ZERO = BlockFlags.f_flag();
    public static final long F_MIN_HEIGHT16_15 = BlockFlags.f_flag();
    public static final long F_MIN_HEIGHT16_14 = BlockFlags.f_flag();
    public static final long F_MIN_HEIGHT16_13 = BlockFlags.f_flag();
    public static final long F_MIN_HEIGHT16_11 = BlockFlags.f_flag();
    public static final long F_MIN_HEIGHT8_5 = BlockFlags.f_flag();
    public static final long F_MIN_HEIGHT16_9 = BlockFlags.f_flag();
    public static final long F_MIN_HEIGHT16_7 = BlockFlags.f_flag();
    public static final long F_MIN_HEIGHT16_5 = BlockFlags.f_flag();
    public static final long F_MIN_HEIGHT4_1 = BlockFlags.f_flag();
    public static final long F_MIN_HEIGHT8_1 = BlockFlags.f_flag();
    public static final long F_MIN_HEIGHT16_1 = BlockFlags.f_flag();
    public static final long F_CARPET = BlockFlags.f_flag();
    public static final long F_COBWEB = BlockFlags.f_flag();
    public static final long F_BERRY_BUSH = BlockFlags.f_flag();
    public static final long F_SOULSAND = BlockFlags.f_flag();
    public static final long F_SLIME = BlockFlags.f_flag();
    public static final long F_VARIABLE_USE = BlockFlags.f_flag();
    public static final long F_VARIABLE_REDSTONE = BlockFlags.f_flag();
    public static final long F_BUBBLE_COLUMN = BlockFlags.f_flag();
    public static final long F_FAKEBOUNDS = BlockFlags.f_flag();
    public static final long F_POWDER_SNOW = BlockFlags.f_flag();
    public static final long FULL_BOUNDS = F_XZ100 | F_HEIGHT100;
    public static final long SOLID_GROUND = F_SOLID | F_GROUND;
    public static final long FULLY_SOLID_BOUNDS = FULL_BOUNDS | SOLID_GROUND;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long f_flag() {
        Class<BlockFlags> clazz = BlockFlags.class;
        synchronized (BlockFlags.class) {
            if (f_next <= 0L) {
                throw new IllegalStateException("No more flags available.");
            }
            long flag = f_next;
            f_next *= 2L;
            // ** MonitorExit[var2] (shouldn't be in output)
            return flag;
        }
    }

    public static void setFlag(Material material, long addFlag) {
        try {
            if (!material.isBlock()) {
                StaticLog.logWarning("Attempt to set flag for a non-block: " + material);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        blockFlags.put(material, blockFlags.get(material) | addFlag);
    }

    public static void maskFlag(Material material, long addFlag) {
        try {
            if (!material.isBlock()) {
                StaticLog.logWarning("Attempt to mask flag for a non-block: " + material);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        blockFlags.put(material, blockFlags.get(material) & addFlag);
    }

    public static void addFlagNames(long flags, Collection<String> tags) {
        String tag = flagNameMap.get(flags);
        if (tag != null) {
            tags.add(tag);
            return;
        }
        for (Long flag : flagNameMap.keySet()) {
            if ((flags & flag) == 0L) continue;
            tags.add(flagNameMap.get(flag));
        }
    }

    public static Collection<String> getFlagNames(Long flags) {
        ArrayList<String> tags = new ArrayList<String>(flagNameMap.size());
        if (flags == null) {
            return tags;
        }
        BlockFlags.addFlagNames(flags, tags);
        return tags;
    }

    public static Collection<String> getAllFlagNames() {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        for (String name : nameFlagMap.keySet()) {
            if (name.startsWith("F_")) continue;
            res.add(name);
        }
        return res;
    }

    public static long parseFlag(String input) {
        String ucInput = input.trim().toUpperCase();
        Long flag = nameFlagMap.get(ucInput);
        if (flag != null) {
            return flag;
        }
        try {
            Long altFlag = Long.parseLong(input);
            return altFlag;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InputMismatchException();
        }
    }

    public static final long getBlockFlags(Material mat) {
        return blockFlags.containsKey(mat) ? blockFlags.get(mat) : 0L;
    }

    public static final long getBlockFlags(String id) {
        return BlockFlags.getBlockFlags(BlockProperties.getMaterial(id));
    }

    public static final void setBlockFlags(Material material, long flags) {
        try {
            if (!material.isBlock()) {
                StaticLog.logWarning("Attempt to set flags for a non-block: " + material);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        blockFlags.put(material, flags);
    }

    public static final void setBlockFlags(String id, long flags) {
        BlockFlags.setBlockFlags(BlockProperties.getMaterial(id), flags);
    }

    public static void setFlagsAs(String id, Material mat) {
        BlockFlags.setBlockFlags(id, BlockFlags.getBlockFlags(mat));
    }

    public static void setFlagsAs(String id, String otherId) {
        BlockFlags.setBlockFlags(id, BlockFlags.getBlockFlags(otherId));
    }

    public static void setFlagsAs(Material newMat, Material mat) {
        BlockFlags.setBlockFlags(newMat, BlockFlags.getBlockFlags(mat));
    }

    public static void addFlags(String id, long flags) {
        BlockFlags.setBlockFlags(id, BlockFlags.getBlockFlags(id) | flags);
    }

    public static void addFlags(Material mat, long flags) {
        BlockFlags.setBlockFlags(mat, BlockFlags.getBlockFlags(mat) | flags);
    }

    public static void removeFlags(String id, long flags) {
        BlockFlags.setBlockFlags(id, BlockFlags.getBlockFlags(id) & (flags ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public static void removeFlags(Material mat, long flags) {
        BlockFlags.setBlockFlags(mat, BlockFlags.getBlockFlags(mat) & (flags ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public static boolean hasAnyFlag(long flags, long testFlags) {
        return (flags & testFlags) != 0L;
    }

    public static boolean hasAllFlags(long flags, long testFlags) {
        return (flags & testFlags) == testFlags;
    }

    public static boolean hasNoFlags(long flags, long testFlags) {
        return (flags & testFlags) == 0L;
    }

    public static void setFullySolidFlags(String blockId) {
        BlockFlags.setBlockFlags(blockId, FULL_BOUNDS | SOLID_GROUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<BlockFlags> clazz = BlockFlags.class;
        synchronized (BlockFlags.class) {
            for (Field field : BlockFlags.class.getDeclaredFields()) {
                String name = field.getName();
                if (!name.startsWith("F_")) continue;
                try {
                    Long value = field.getLong(BlockFlags.class);
                    if (flagNameMap.containsKey(value)) {
                        throw new IllegalStateException("Same value for flag names: " + name + " + " + flagNameMap.get(value));
                    }
                    flagNameMap.put(value, name.substring(2));
                    nameFlagMap.put(name, value);
                    nameFlagMap.put(name.substring(2), value);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

