/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.location;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.VehicleMoveData;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.versions.GenericVersion;
import fr.neatmonster.nocheatplus.components.modifier.IAttributeAccess;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.components.registry.event.IHandle;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.collision.AxisAlignedBBUtils;
import fr.neatmonster.nocheatplus.utilities.collision.CollisionUtil;
import fr.neatmonster.nocheatplus.utilities.collision.supportingblock.SupportingBlockUtils;
import fr.neatmonster.nocheatplus.utilities.entity.PassengerUtil;
import fr.neatmonster.nocheatplus.utilities.location.RichBoundsLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class RichEntityLocation
extends RichBoundsLocation {
    private final IHandle<MCAccess> mcAccess;
    private static final IGenericInstanceHandle<IAttributeAccess> attributeAccess = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(IAttributeAccess.class);
    private final PassengerUtil passengerUtil = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(PassengerUtil.class);
    private double width;
    private double height;
    private boolean isLiving;
    private double eyeHeight;
    private boolean standsOnEntity = false;
    private Entity entity = null;

    public RichEntityLocation(IHandle<MCAccess> mcAccess, BlockCache blockCache) {
        super(blockCache);
        this.mcAccess = mcAccess;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getEyeHeight() {
        return this.eyeHeight;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public boolean isLiving() {
        return this.isLiving;
    }

    public MCAccess getMCAccess() {
        return this.mcAccess.getHandle();
    }

    public IHandle<MCAccess> getMCAccessHandle() {
        return this.mcAccess;
    }

    public boolean isSupportedBy(long flag) {
        IPlayerData pData = DataManager.getPlayerDataForEntity(this.entity, this.passengerUtil);
        Vector supportingBlockPos = SupportingBlockUtils.getOnPos(this.blockCache, this.getLocation(), pData.getSupportingBlockData(), 0.5000001f);
        Material supportingBlock = this.getBlockType((int)supportingBlockPos.getX(), (int)supportingBlockPos.getY(), (int)supportingBlockPos.getZ());
        double[] AABB = this.getBoundingBox();
        return (BlockFlags.getBlockFlags(supportingBlock) & flag) != 0L && BlockProperties.collidesBlock(this.blockCache, AABB[0], AABB[1], AABB[2], AABB[3], AABB[4], AABB[5], (int)supportingBlockPos.getX(), (int)supportingBlockPos.getY(), (int)supportingBlockPos.getZ(), this.getOrCreateBlockCacheNode(), null, flag);
    }

    @Override
    public boolean isOnBouncyBlock() {
        if (this.onBouncyBlock != null) {
            return this.onBouncyBlock;
        }
        if (GenericVersion.isLowerThan(this.entity, "1.12") && this.onBouncyBlock != null && this.onBouncyBlock.booleanValue() && this.onSlimeBlock != null && !this.onSlimeBlock.booleanValue()) {
            this.onBouncyBlock = false;
            return this.onBouncyBlock;
        }
        return super.isOnBouncyBlock();
    }

    @Override
    public boolean isOnSlimeBlock() {
        if (this.onSlimeBlock != null) {
            return this.onSlimeBlock;
        }
        if (GenericVersion.isLowerThan(this.entity, "1.8")) {
            this.onSlimeBlock = false;
            return this.onSlimeBlock;
        }
        if (GenericVersion.isAtLeast(this.entity, "1.20")) {
            this.onSlimeBlock = this.isSupportedBy(BlockFlags.F_SLIME);
            return this.onSlimeBlock;
        }
        return super.isOnSlimeBlock();
    }

    @Override
    public boolean isOnIce() {
        if (this.onIce != null) {
            return this.onIce;
        }
        if (GenericVersion.isAtLeast(this.entity, "1.20")) {
            this.onIce = this.isSupportedBy(BlockFlags.F_ICE);
            return this.onIce;
        }
        return super.isOnIce();
    }

    @Override
    public boolean isOnBlueIce() {
        if (this.onBlueIce != null) {
            return this.onBlueIce;
        }
        if (GenericVersion.isLowerThan(this.entity, "1.13")) {
            if (this.onBlueIce.booleanValue()) {
                this.onIce = true;
            }
            this.onBlueIce = false;
            return this.onBlueIce;
        }
        if (GenericVersion.isAtLeast(this.entity, "1.20")) {
            this.onBlueIce = this.isSupportedBy(BlockFlags.F_BLUE_ICE);
            return this.onBlueIce;
        }
        return super.isOnBlueIce();
    }

    @Override
    public boolean isInWaterLogged() {
        if (this.inWaterLogged != null) {
            return this.inWaterLogged;
        }
        if (GenericVersion.isLowerThan(this.entity, "1.13")) {
            this.inWaterLogged = false;
            return this.inWaterLogged;
        }
        return super.isInWaterLogged();
    }

    @Override
    public boolean isInBubbleStream() {
        if (this.inBubbleStream != null) {
            return this.inBubbleStream;
        }
        if (GenericVersion.isLowerThan(this.entity, "1.13")) {
            this.inBubbleStream = false;
            return this.inBubbleStream;
        }
        return super.isInBubbleStream();
    }

    @Override
    public boolean isInPowderSnow() {
        if (this.inPowderSnow != null) {
            return this.inPowderSnow;
        }
        if (GenericVersion.isLowerThan(this.entity, "1.17")) {
            this.inPowderSnow = false;
            return this.inPowderSnow;
        }
        return super.isInPowderSnow();
    }

    @Override
    public boolean isInLava() {
        if (this.inLava != null) {
            return this.inLava;
        }
        if (GenericVersion.isLowerThan(this.entity, "1.14")) {
            this.inLava = false;
            double[] aaBB = this.getBoundingBox();
            int iMinX = MathUtil.floor(aaBB[0] + 0.1);
            int iMaxX = MathUtil.floor(aaBB[3] - 0.1 + 1.0);
            int iMinY = MathUtil.floor(aaBB[1] + 0.4);
            int iMaxY = MathUtil.floor(aaBB[4] - 0.4 + 1.0);
            int iMinZ = MathUtil.floor(aaBB[2] + 0.1);
            int iMaxZ = MathUtil.floor(aaBB[5] - 0.1 + 1.0);
            for (int x = iMinX; x < iMaxX; ++x) {
                for (int y = iMinY; y < iMaxY; ++y) {
                    for (int z = iMinZ; z < iMaxZ; ++z) {
                        BlockCache.IBlockCacheNode node = this.blockCache.getOrCreateBlockCacheNode(x, y, z, false);
                        if ((BlockFlags.getBlockFlags(node.getType()) & BlockFlags.F_LAVA) == 0L) continue;
                        this.inLava = true;
                        return this.inLava;
                    }
                }
            }
            return this.inLava;
        }
        if (GenericVersion.isAtLeast(this.entity, "1.14") && GenericVersion.isLowerThan(this.entity, "1.16")) {
            this.inLava = false;
            this.inLava = this.isInside(BlockFlags.F_LAVA);
            return this.inLava;
        }
        return super.isInLava();
    }

    @Override
    public boolean isInWater() {
        if (this.inWater != null) {
            return this.inWater;
        }
        if (GenericVersion.isLowerThan(this.entity, "1.13")) {
            this.inWater = false;
            double extraContraction = 0.4;
            int iMinX = MathUtil.floor(this.minX + 0.001);
            int iMaxX = MathUtil.ceil(this.maxX - 0.001);
            int iMinY = MathUtil.floor(this.minY + 0.001 + extraContraction);
            int iMaxY = MathUtil.ceil(this.maxY - 0.001 - extraContraction);
            int iMinZ = MathUtil.floor(this.minZ + 0.001);
            int iMaxZ = MathUtil.ceil(this.maxZ - 0.001);
            for (int x = iMinX; x < iMaxX; ++x) {
                for (int y = iMinY; y < iMaxY; ++y) {
                    for (int z = iMinZ; z < iMaxZ; ++z) {
                        double liquidHeight = BlockProperties.getLiquidHeightAt(this.blockCache, x, y, z, BlockFlags.F_WATER, true);
                        double liquidHeightToWorld = (double)y + liquidHeight;
                        if (!(liquidHeightToWorld >= this.minY + 0.001 + extraContraction) || liquidHeight == 0.0) continue;
                        this.inWater = true;
                        return this.inWater;
                    }
                }
            }
            return this.inWater;
        }
        return super.isInWater();
    }

    @Override
    public boolean isOnHoneyBlock() {
        if (this.onHoneyBlock != null) {
            return this.onHoneyBlock;
        }
        if (GenericVersion.isLowerThan(this.entity, "1.15")) {
            this.onHoneyBlock = false;
            return this.onHoneyBlock;
        }
        if (GenericVersion.isAtLeast(this.entity, "1.20")) {
            this.onHoneyBlock = this.isSupportedBy(BlockFlags.F_STICKY);
            return this.onHoneyBlock;
        }
        return super.isOnHoneyBlock();
    }

    @Override
    public boolean isInSoulSand() {
        if (this.inSoulSand != null) {
            return this.inSoulSand;
        }
        if (GenericVersion.isAtLeast(this.entity, "1.20")) {
            this.inSoulSand = this.isSupportedBy(BlockFlags.F_SOULSAND);
            return this.inSoulSand;
        }
        return super.isInSoulSand();
    }

    @Override
    public boolean isInBerryBush() {
        if (this.inBerryBush != null) {
            return this.inBerryBush;
        }
        if (GenericVersion.isLowerThan(this.entity, "1.14")) {
            this.inBerryBush = false;
            return this.inBerryBush;
        }
        return super.isInBerryBush();
    }

    public boolean isSlidingDown() {
        double yDistance;
        IPlayerData pData = DataManager.getPlayerDataForEntity(this.entity, this.passengerUtil);
        MovingData data = pData.getGenericInstance(MovingData.class);
        PlayerMoveData playerMove = data.playerMoves.getCurrentMove();
        VehicleMoveData vehicleMove = data.vehicleMoves.getCurrentMove();
        double d = yDistance = this.entity instanceof Player ? playerMove.yDistance : vehicleMove.yDistance;
        if (GenericVersion.isLowerThan(this.entity, "1.15")) {
            return false;
        }
        if (this.isOnGround()) {
            return false;
        }
        if (yDistance >= -0.08) {
            return false;
        }
        this.collectBlockFlags();
        if ((this.blockFlags & BlockFlags.F_STICKY) == 0L) {
            return false;
        }
        return this.isNextTo(0.01, BlockFlags.F_STICKY);
    }

    public boolean standsOnEntity(double yOnGround, double xzMargin, double yMargin) {
        return this.blockCache.standsOnEntity(this.entity, this.minX - xzMargin, this.minY - yOnGround - yMargin, this.minZ - xzMargin, this.maxX + xzMargin, this.minY + yMargin, this.maxZ + xzMargin);
    }

    @Override
    public boolean isOnGround() {
        if (this.onGround != null) {
            return this.onGround;
        }
        double d1 = 0.25;
        if (this.blockCache.standsOnEntity(this.entity, this.minX - 0.25, this.minY - this.yOnGround, this.minZ - 0.25, this.maxX + 0.25, this.minY, this.maxZ + 0.25)) {
            this.standsOnEntity = true;
            this.onGround = true;
            return this.onGround;
        }
        return super.isOnGround();
    }

    public boolean isOnGroundDueToStandingOnAnEntity() {
        return this.isOnGround() && this.standsOnEntity;
    }

    public boolean isUnobstructed(double xOffset, double yOffset, double zOffset, long flag) {
        return this.isUnobstructed(AxisAlignedBBUtils.move(this.getBoundingBox(), xOffset, yOffset, zOffset), flag);
    }

    public boolean isUnobstructed() {
        IPlayerData pData = DataManager.getPlayerDataForEntity(this.entity, this.passengerUtil);
        MovingData data = pData.getGenericInstance(MovingData.class);
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        return this.isUnobstructed(thisMove.xAllowedDistance, thisMove.yAllowedDistance + 0.6 - lastMove.to.getY() + lastMove.from.getY(), thisMove.zAllowedDistance, this.isInWater() ? BlockFlags.F_WATER : BlockFlags.F_LAVA);
    }

    public boolean isUnobstructed(double[] AABB, long flag) {
        return CollisionUtil.isEmpty(this.blockCache, this.entity, AABB) && !BlockProperties.containsAnyLiquid(this.blockCache, AABB, flag);
    }

    public Vector collide(Vector wantedInput, boolean onGround, double[] AABB) {
        double allowedStepHeight;
        boolean touchGround;
        if (wantedInput.getX() == 0.0 && wantedInput.getY() == 0.0 && wantedInput.getZ() == 0.0) {
            return new Vector();
        }
        double[] tAABB = AABB == null ? AxisAlignedBBUtils.createBoundingBoxFor(this.entity) : (double[])AABB.clone();
        ArrayList<double[]> collisionBoxes = new ArrayList<double[]>();
        CollisionUtil.getCollisionBoxes(this.blockCache, this.entity, AxisAlignedBBUtils.expandTowards(tAABB, wantedInput.getX(), wantedInput.getY(), wantedInput.getZ()), collisionBoxes, false);
        Vector allowedMovement = wantedInput.lengthSquared() == 0.0 ? wantedInput : CollisionUtil.collideBoundingBox(wantedInput, tAABB, collisionBoxes);
        boolean collideX = wantedInput.getX() != allowedMovement.getX();
        boolean collideY = wantedInput.getY() != allowedMovement.getY();
        boolean collideZ = wantedInput.getZ() != allowedMovement.getZ();
        boolean bl = touchGround = onGround || collideY && allowedMovement.getY() < 0.0;
        double d = this.entity instanceof Player ? attributeAccess.getHandle().getMaxStepUp((Player)this.entity) : (allowedStepHeight = this.entity instanceof Boat ? 0.0 : 1.0);
        if (allowedStepHeight > 0.0 && touchGround && (collideX || collideZ)) {
            boolean EntityIsAtLeast1_21 = GenericVersion.isAtLeast(this.entity, "1.21");
            boolean EntityIsAtLeast1_8 = GenericVersion.isAtLeast(this.entity, "1.8");
            if (EntityIsAtLeast1_21) {
                float[] stepHeights;
                double[] groundCollisionAABB = collideY && wantedInput.getY() < 0.0 ? AxisAlignedBBUtils.move(tAABB, 0.0, allowedMovement.getY(), 0.0) : tAABB;
                double[] stepUpAttemptAABB = AxisAlignedBBUtils.expandTowards(groundCollisionAABB, allowedMovement.getX(), allowedStepHeight, allowedMovement.getZ());
                if (!collideY || !(wantedInput.getY() < 0.0)) {
                    stepUpAttemptAABB = AxisAlignedBBUtils.expandTowards(stepUpAttemptAABB, 0.0, -1.0E-5f, 0.0);
                }
                ArrayList<double[]> collisionBoxes_1 = new ArrayList<double[]>();
                CollisionUtil.getCollisionBoxes(this.blockCache, this.entity, stepUpAttemptAABB, collisionBoxes_1, false);
                for (float stepHeight : stepHeights = CollisionUtil.collectCandidateStepUpHeights(groundCollisionAABB, collisionBoxes_1, (float)allowedStepHeight, (float)allowedMovement.getY())) {
                    Vector stepUpVector = CollisionUtil.collideBoundingBox(new Vector(wantedInput.getX(), (double)stepHeight, wantedInput.getZ()), groundCollisionAABB, collisionBoxes_1);
                    if (!(TrigUtil.distanceSquared(stepUpVector) > TrigUtil.distanceSquared(allowedMovement))) continue;
                    double diff = tAABB[1] - groundCollisionAABB[1];
                    allowedMovement = stepUpVector.add(new Vector(0.0, -diff, 0.0));
                    break;
                }
            } else {
                Vector stepUpAttempt2;
                Vector stepFix;
                Vector stepUpVector = CollisionUtil.collideBoundingBox(new Vector(wantedInput.getX(), allowedStepHeight, wantedInput.getZ()), tAABB, collisionBoxes);
                if (EntityIsAtLeast1_8 && (stepFix = CollisionUtil.collideBoundingBox(new Vector(0.0, allowedStepHeight, 0.0), AxisAlignedBBUtils.expandTowards(tAABB, wantedInput.getX(), 0.0, wantedInput.getZ()), collisionBoxes)).getY() < allowedStepHeight && TrigUtil.distanceSquared(stepUpAttempt2 = CollisionUtil.collideBoundingBox(new Vector(wantedInput.getX(), 0.0, wantedInput.getZ()), AxisAlignedBBUtils.move(tAABB, stepFix.getX(), stepFix.getY(), stepFix.getZ()), collisionBoxes).add(stepFix)) > TrigUtil.distanceSquared(stepUpVector)) {
                    stepUpVector = stepUpAttempt2;
                }
                if (TrigUtil.distanceSquared(stepUpVector) > TrigUtil.distanceSquared(allowedMovement)) {
                    return stepUpVector.add(CollisionUtil.collideBoundingBox(new Vector(0.0, -stepUpVector.getY() + wantedInput.getY(), 0.0), AxisAlignedBBUtils.move(tAABB, stepUpVector.getX(), stepUpVector.getY(), stepUpVector.getZ()), collisionBoxes));
                }
            }
        }
        return allowedMovement;
    }

    public Vector getLiquidPushingVector(double xDistance, double zDistance, long liquidTypeFlag) {
        if (this.isInLava() && GenericVersion.isLowerThan(this.entity, "1.16")) {
            return new Vector();
        }
        double extraContraction = GenericVersion.isLowerThan(this.entity, "1.13") ? 0.4 : 0.0;
        int iMinX = MathUtil.floor(this.minX + 0.001);
        int iMaxX = MathUtil.ceil(this.maxX - 0.001);
        int iMinY = MathUtil.floor(this.minY + 0.001 + extraContraction);
        int iMaxY = MathUtil.ceil(this.maxY - 0.001 - extraContraction);
        int iMinZ = MathUtil.floor(this.minZ + 0.001);
        int iMaxZ = MathUtil.ceil(this.maxZ - 0.001);
        double maxSubmersionDepth = 0.0;
        Vector pushingVector = new Vector();
        int liquidCollisionCount = 0;
        for (int x = iMinX; x < iMaxX; ++x) {
            for (int y = iMinY; y < iMaxY; ++y) {
                for (int z = iMinZ; z < iMaxZ; ++z) {
                    Vector flowVector;
                    double liquidHeight;
                    if (GenericVersion.isLowerThan(this.entity, "1.13")) {
                        double liquidSurfaceHeight;
                        liquidHeight = BlockProperties.getLiquidHeightAt(this.blockCache, x, y, z, liquidTypeFlag, false);
                        if (liquidHeight == 0.0 || !((double)iMaxY >= (liquidSurfaceHeight = (double)(y + 1) - liquidHeight)) || this.entity instanceof Player && ((Player)this.entity).isFlying()) continue;
                        flowVector = this.getFlowForceVector(x, y, z, liquidTypeFlag);
                        pushingVector.add(flowVector);
                        continue;
                    }
                    liquidHeight = BlockProperties.getLiquidHeightAt(this.blockCache, x, y, z, liquidTypeFlag, false);
                    double liquidHeightToWorld = (double)y + liquidHeight;
                    if (!(liquidHeightToWorld >= this.minY + 0.001) || liquidHeight == 0.0 || this.entity instanceof Player && ((Player)this.entity).isFlying()) continue;
                    maxSubmersionDepth = Math.max(liquidHeightToWorld - this.minY + 0.001, maxSubmersionDepth);
                    flowVector = this.getFlowForceVector(x, y, z, liquidTypeFlag);
                    if (maxSubmersionDepth < 0.4) {
                        flowVector = flowVector.multiply(maxSubmersionDepth);
                    }
                    pushingVector = pushingVector.add(flowVector);
                    ++liquidCollisionCount;
                }
            }
        }
        if (GenericVersion.isLowerThan(this.entity, "1.13")) {
            if (this.isInWater() && pushingVector.lengthSquared() > 0.0) {
                pushingVector.normalize();
                pushingVector.multiply(0.014);
            }
        } else {
            double flowSpeedMultiplier;
            double d = this.isInWater() ? 0.014 : (flowSpeedMultiplier = this.world.isUltraWarm() ? 0.007 : 0.0023333333333333335);
            if (pushingVector.lengthSquared() > 0.0) {
                if (liquidCollisionCount > 0) {
                    pushingVector = pushingVector.multiply(1.0 / (double)liquidCollisionCount);
                }
                if (!(this.entity instanceof Player)) {
                    pushingVector = pushingVector.normalize();
                }
                pushingVector = pushingVector.multiply(flowSpeedMultiplier);
                if (Math.abs(xDistance) < 0.003 && Math.abs(zDistance) < 0.003 && pushingVector.length() < 0.0045000000000000005) {
                    pushingVector = pushingVector.normalize().multiply(0.0045000000000000005);
                }
            }
        }
        return pushingVector;
    }

    public double getSubmergedLiquidHeight(long liquidTypeFlag) {
        if (this.isInLava() && GenericVersion.isLowerThan(this.entity, "1.16")) {
            return 0.0;
        }
        double extraContraction = GenericVersion.isLowerThan(this.entity, "1.13") ? 0.4 : 0.0;
        int iMinX = MathUtil.floor(this.minX + 0.001);
        int iMaxX = MathUtil.ceil(this.maxX - 0.001);
        int iMinY = MathUtil.floor(this.minY + 0.001 + extraContraction);
        int iMaxY = MathUtil.ceil(this.maxY - 0.001 - extraContraction);
        int iMinZ = MathUtil.floor(this.minZ + 0.001);
        int iMaxZ = MathUtil.ceil(this.maxZ - 0.001);
        double maxSubmersionDepth = 0.0;
        for (int x = iMinX; x < iMaxX; ++x) {
            for (int y = iMinY; y < iMaxY; ++y) {
                for (int z = iMinZ; z < iMaxZ; ++z) {
                    double liquidHeight = BlockProperties.getLiquidHeightAt(this.blockCache, x, y, z, liquidTypeFlag, false);
                    double liquidHeightToWorld = (double)y + liquidHeight;
                    if (!(liquidHeightToWorld >= this.minY + 0.001) || liquidHeight == 0.0 || this.entity instanceof Player && ((Player)this.entity).isFlying()) continue;
                    maxSubmersionDepth = Math.max(liquidHeightToWorld - this.minY + 0.001, maxSubmersionDepth);
                }
            }
        }
        return maxSubmersionDepth;
    }

    public Vector getFlowForceVector(int x, int y, int z, long liquidTypeFlag) {
        double xModifier = 0.0;
        double zModifier = 0.0;
        float liquidHeight = (float)BlockProperties.getLiquidHeightAt(this.blockCache, x, y, z, liquidTypeFlag, true);
        for (BlockFace hDirection : new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST}) {
            int modZ;
            int modX = x + hDirection.getModX();
            if (!BlockProperties.affectsFlow(this.blockCache, x, y, z, modX, y, modZ = z + hDirection.getModZ(), liquidTypeFlag)) continue;
            float modLiquidHeight = (float)BlockProperties.getLiquidHeightAt(this.blockCache, modX, y, modZ, liquidTypeFlag, true);
            float flowForce = 0.0f;
            if (modLiquidHeight == 0.0f) {
                BlockCache.IBlockCacheNode node = this.blockCache.getOrCreateBlockCacheNode(modX, y, modZ, false);
                Material matAtThisLoc = node.getType();
                if (!matAtThisLoc.isSolid() && BlockProperties.affectsFlow(this.blockCache, x, y, z, modX, y - 1, modZ, liquidTypeFlag) && (modLiquidHeight = (float)BlockProperties.getLiquidHeightAt(this.blockCache, modX, y - 1, modZ, liquidTypeFlag, true)) > 0.0f) {
                    flowForce = liquidHeight - (modLiquidHeight - 0.8888889f);
                }
            } else if (modLiquidHeight > 0.0f) {
                flowForce = liquidHeight - modLiquidHeight;
            }
            if (flowForce == 0.0f) continue;
            xModifier += (double)((float)hDirection.getModX() * flowForce);
            zModifier += (double)((float)hDirection.getModZ() * flowForce);
        }
        Vector flowingVector = new Vector(xModifier, 0.0, zModifier);
        BlockCache.IBlockCacheNode originalNode = this.blockCache.getOrCreateBlockCacheNode(x, y, z, false);
        if (BlockProperties.isLiquid(originalNode.getType()) && originalNode.getData(this.blockCache, x, y, z) >= 8) {
            for (BlockFace hDirection : new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST}) {
                if (!BlockProperties.isSolidFace(this.blockCache, (Player)this.entity, x, y, z, hDirection, liquidTypeFlag, this.getLocation()) && !BlockProperties.isSolidFace(this.blockCache, (Player)this.entity, x, y + 1, z, hDirection, liquidTypeFlag, this.getLocation())) continue;
                flowingVector = MathUtil.normalizedVectorWithoutNaN(flowingVector).add(new Vector(0.0, -6.0, 0.0));
                break;
            }
        }
        return MathUtil.normalizedVectorWithoutNaN(flowingVector);
    }

    public Vector doPush(Vector movementVec) {
        IPlayerData pData = DataManager.getPlayerDataForEntity(this.entity, this.passengerUtil);
        MovingData data = pData.getGenericInstance(MovingData.class);
        PlayerMoveData lastMove = data.playerMoves.getCurrentMove();
        if (data.lastCollidingEntitiesLocations != null && !data.lastCollidingEntitiesLocations.isEmpty()) {
            for (Location eLoc : data.lastCollidingEntitiesLocations) {
                double zDistToEntity;
                double xDistToEntity = eLoc.getX() - lastMove.from.getX();
                double absDist = MathUtil.absMax(xDistToEntity, zDistToEntity = eLoc.getZ() - lastMove.from.getZ());
                if (!(absDist >= (double)0.01f)) continue;
                absDist = Math.sqrt(absDist);
                xDistToEntity /= absDist;
                zDistToEntity /= absDist;
                double var8 = 1.0 / absDist;
                if (var8 > 1.0) {
                    var8 = 1.0;
                }
                xDistToEntity *= var8;
                zDistToEntity *= var8;
                movementVec.add(new Vector(-(xDistToEntity *= (double)0.05f), 0.0, -(zDistToEntity *= (double)0.05f)));
            }
        }
        return movementVec;
    }

    public Vector getFluidFallingAdjustedMovement(double gravity, boolean isFalling, Vector vec, boolean isSprinting) {
        if (BridgeMisc.hasGravity((LivingEntity)this.entity) && !isSprinting) {
            double liquidFallMovement = isFalling && Math.abs(vec.getY() - 0.005) >= 0.003 && Math.abs(vec.getY() - gravity / 16.0) < 0.003 ? -0.003 : vec.getY() - gravity / 16.0;
            return new Vector(vec.getX(), liquidFallMovement, vec.getZ());
        }
        return vec;
    }

    public boolean canClimbUp(double jumpHeight) {
        if (GenericVersion.isAtLeast(this.entity, "1.14")) {
            return true;
        }
        if (BlockProperties.needsToBeAttachedToABlock(this.getBlockType())) {
            if (BlockProperties.canBeClimbedUp(this.blockCache, this.blockX, this.blockY, this.blockZ)) {
                return true;
            }
            int headY = Location.locToBlock((double)this.maxY);
            if (headY > this.blockY) {
                for (int cy = this.blockY + 1; cy <= headY; ++cy) {
                    if (!BlockProperties.canBeClimbedUp(this.blockCache, this.blockX, cy, this.blockZ)) continue;
                    return true;
                }
            }
            return this.isOnGround(jumpHeight);
        }
        return true;
    }

    public boolean seekCollisionAbove(double marginAboveEyeHeight) {
        return this.seekCollisionAbove(marginAboveEyeHeight, true);
    }

    public boolean seekCollisionAbove(double marginAboveEyeHeight, boolean stepCorrection) {
        if (marginAboveEyeHeight < 0.0) {
            throw new IllegalArgumentException("marginAboveEyeHeight must be greater than 0.");
        }
        if (stepCorrection) {
            double obstrDistance = this.maxY + marginAboveEyeHeight;
            obstrDistance = obstrDistance - (double)Location.locToBlock((double)obstrDistance) + 0.35;
            for (double bound = 1.0; bound > 0.0; bound -= 0.25) {
                if (!(obstrDistance >= bound)) continue;
                marginAboveEyeHeight += bound + 0.35 - obstrDistance;
                break;
            }
        }
        return BlockProperties.collides(this.blockCache, this.minX, this.maxY, this.minZ, this.maxX, this.maxY + marginAboveEyeHeight, this.maxZ, BlockFlags.F_GROUND | BlockFlags.F_SOLID) && !this.isNextTo(0.01, BlockFlags.F_STICKY);
    }

    public boolean seekCollisionAbove() {
        return this.seekCollisionAbove(0.0, true);
    }

    public void set(Location location, Entity entity, double yOnGround) {
        MCAccess mcAccess = this.mcAccess.getHandle();
        this.doSet(location, entity, mcAccess.getWidth(entity), mcAccess.getHeight(entity), yOnGround);
    }

    public void set(Location location, Entity entity, double fullHeight, double yOnGround) {
        MCAccess mcAccess = this.mcAccess.getHandle();
        this.doSet(location, entity, mcAccess.getWidth(entity), fullHeight, yOnGround);
    }

    public void set(Location location, Entity entity, double fullWidth, double fullHeight, double yOnGround) {
        this.doSet(location, entity, fullWidth, fullHeight, yOnGround);
    }

    protected void doSet(Location location, Entity entity, double fullWidth, double fullHeight, double yOnGround) {
        double eyeHeight;
        boolean isLiving;
        if (entity instanceof LivingEntity) {
            isLiving = true;
            LivingEntity living = (LivingEntity)entity;
            eyeHeight = living.getEyeHeight();
            fullHeight = Math.max(fullHeight, eyeHeight);
        } else {
            isLiving = false;
            eyeHeight = fullHeight;
        }
        this.doSetExactHeight(location, entity, isLiving, fullWidth, eyeHeight, fullHeight, fullHeight, yOnGround);
    }

    protected void doSetExactHeight(Location location, Entity entity, boolean isLiving, double fullWidth, double eyeHeight, double height, double fullHeight, double yOnGround) {
        this.entity = entity;
        this.isLiving = isLiving;
        MCAccess mcAccess = this.mcAccess.getHandle();
        this.width = mcAccess.getWidth(entity);
        this.eyeHeight = eyeHeight;
        this.height = mcAccess.getHeight(entity);
        this.standsOnEntity = false;
        super.set(location, fullWidth, fullHeight, yOnGround);
    }

    @Override
    public void set(Location location, double fullWidth, double fullHeight, double yOnGround) {
        throw new UnsupportedOperationException("Set must specify an instance of Entity.");
    }

    public void prepare(RichEntityLocation other) {
        super.prepare(other);
        this.standsOnEntity = other.standsOnEntity;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.entity = null;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("RichEntityLocation(");
        builder.append(this.world == null ? "null" : this.world.getName());
        builder.append('/');
        builder.append(Double.toString(this.x));
        builder.append(", ");
        builder.append(Double.toString(this.y));
        builder.append(", ");
        builder.append(Double.toString(this.z));
        builder.append(')');
        return builder.toString();
    }
}

