/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.location;

import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeReference;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.components.location.IGetBlockPosition;
import fr.neatmonster.nocheatplus.components.location.IGetBox3D;
import fr.neatmonster.nocheatplus.components.location.IGetBukkitLocation;
import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.collision.CollisionUtil;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MapUtil;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.BubbleColumn;
import org.bukkit.util.Vector;

public class RichBoundsLocation
implements IGetBukkitLocation,
IGetBlockPosition,
IGetBox3D {
    double yOnGround = 0.001;
    int blockX;
    int blockY;
    int blockZ;
    double x;
    double y;
    double z;
    float yaw;
    float pitch;
    double minX;
    double maxX;
    double minY;
    double maxY;
    double minZ;
    double maxZ;
    double boxMarginHorizontal;
    double boxMarginVertical;
    double onGroundMinY = Double.MAX_VALUE;
    double notOnGroundMaxY = Double.MIN_VALUE;
    BlockCache.IBlockCacheNode node = null;
    BlockCache.IBlockCacheNode nodeBelow = null;
    Long blockFlags = null;
    Boolean onClimbable = null;
    Boolean passable = null;
    Boolean passableBox = null;
    Boolean inLava = null;
    Boolean inWater = null;
    Boolean inWaterLogged = null;
    Boolean inWeb = null;
    Boolean onIce = null;
    Boolean onBlueIce = null;
    Boolean onGround = null;
    Boolean inSoulSand = null;
    Boolean onHoneyBlock = null;
    Boolean onSlimeBlock = null;
    Boolean inBerryBush = null;
    Boolean inPowderSnow = null;
    Boolean onBouncyBlock = null;
    Boolean inBubbleStream = null;
    BlockCache blockCache = null;
    World world = null;

    public RichBoundsLocation(BlockCache blockCache) {
        this.blockCache = blockCache;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public String getWorldName() {
        return this.world.getName();
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    public Vector getVector() {
        return new Vector(this.x, this.y, this.z);
    }

    public Location getLocation() {
        if (this.world == null) {
            throw new NullPointerException("World is null.");
        }
        return new Location(this.world, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    @Override
    public int getBlockX() {
        return this.blockX;
    }

    @Override
    public int getBlockY() {
        return this.blockY;
    }

    @Override
    public int getBlockZ() {
        return this.blockZ;
    }

    public double[] getBoundingBox() {
        return new double[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ};
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMinZ() {
        return this.minZ;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMaxZ() {
        return this.maxZ;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    public double getBoxMarginHorizontal() {
        return this.boxMarginHorizontal;
    }

    public double getBoxMarginVertical() {
        return this.boxMarginVertical;
    }

    public final boolean isSameBlock(IGetBlockPosition other) {
        return this.blockX == other.getBlockX() && this.blockZ == other.getBlockZ() && this.blockY == other.getBlockY();
    }

    public final boolean isSameBlock(int x, int y, int z) {
        return this.blockX == x && this.blockZ == z && this.blockY == y;
    }

    public final boolean isSameBlock(Location loc) {
        return this.blockX == loc.getBlockX() && this.blockZ == loc.getBlockZ() && this.blockY == loc.getBlockY();
    }

    public boolean isBlockAbove(IGetBlockPosition loc) {
        return this.blockY == loc.getBlockY() + 1 && this.blockX == loc.getBlockX() && this.blockZ == loc.getBlockZ();
    }

    public boolean isBlockAbove(Location loc) {
        return this.blockY == loc.getBlockY() + 1 && this.blockX == loc.getBlockX() && this.blockZ == loc.getBlockZ();
    }

    public boolean isSamePos(IGetPosition loc) {
        return this.x == loc.getX() && this.z == loc.getZ() && this.y == loc.getY();
    }

    public boolean isSamePos(Location loc) {
        return this.x == loc.getX() && this.z == loc.getZ() && this.y == loc.getY();
    }

    public int manhattan(IGetBlockPosition other) {
        return TrigUtil.manhattan(this.blockX, this.blockY, this.blockZ, other.getBlockX(), other.getBlockY(), other.getBlockZ());
    }

    public int maxBlockDist(IGetBlockPosition other) {
        return TrigUtil.maxDistance(this.blockX, this.blockY, this.blockZ, other.getBlockX(), other.getBlockY(), other.getBlockZ());
    }

    public boolean hasIllegalCoords() {
        return LocUtil.isBadCoordinate(this.minX, this.maxX, this.minY, this.maxY, this.minZ, this.maxZ);
    }

    public Long getBlockFlags() {
        return this.blockFlags;
    }

    public void setBlockFlags(Long blockFlags) {
        this.blockFlags = blockFlags;
    }

    public Material getBlockTypeAbove() {
        return this.blockCache.getType(this.blockX, this.blockY + 1, this.blockZ);
    }

    public BlockCache.IBlockCacheNode getOrCreateBlockCacheNode() {
        if (this.node == null) {
            this.node = this.blockCache.getOrCreateBlockCacheNode(this.blockX, this.blockY, this.blockZ, false);
        }
        return this.node;
    }

    public BlockCache.IBlockCacheNode getOrCreateBlockCacheNodeBelow() {
        if (this.nodeBelow == null) {
            this.nodeBelow = this.blockCache.getOrCreateBlockCacheNode(this.blockX, this.blockY - 1, this.blockZ, false);
        }
        return this.nodeBelow;
    }

    public Material getBlockType() {
        if (this.node == null) {
            this.getOrCreateBlockCacheNode();
        }
        return this.node.getType();
    }

    public Material getBlockTypeBelow() {
        if (this.nodeBelow == null) {
            this.getOrCreateBlockCacheNodeBelow();
        }
        return this.nodeBelow.getType();
    }

    public Integer getData() {
        if (this.node == null) {
            this.node = this.blockCache.getOrCreateBlockCacheNode(this.blockX, this.blockY, this.blockZ, false);
            return this.node.getData(this.blockCache, this.blockX, this.blockY, this.blockZ);
        }
        return this.node.getData();
    }

    public final Material getBlockType(int x, int y, int z) {
        return this.blockCache.getType(x, y, z);
    }

    public final int getData(int x, int y, int z) {
        return this.blockCache.getData(x, y, z);
    }

    public void setBlockCache(BlockCache cache) {
        this.blockCache = cache;
    }

    public final BlockCache getBlockCache() {
        return this.blockCache;
    }

    public boolean isNextTo(double xzMargin, long flags) {
        return BlockProperties.collides(this.blockCache, this.minX - xzMargin, this.minY, this.minZ - xzMargin, this.maxX + xzMargin, this.maxY, this.maxZ + xzMargin, flags);
    }

    public boolean isInside(long flags) {
        return BlockProperties.collides(this.blockCache, this.minX + 0.001, this.minY + 0.001, this.minZ + 0.001, this.maxX - 0.001, this.maxY - 0.001, this.maxZ - 0.001, flags);
    }

    public boolean standsOn(long flags) {
        if (!this.isOnGround()) {
            return false;
        }
        return BlockProperties.collides(this.blockCache, this.minX, this.minY - this.yOnGround, this.minZ, this.maxX, this.minY, this.maxZ, flags);
    }

    public boolean isInLava() {
        if (this.inLava == null) {
            if (this.blockFlags != null && (this.blockFlags & BlockFlags.F_LAVA) == 0L) {
                this.inLava = false;
                return this.inLava;
            }
            this.inLava = false;
            int iMinX = MathUtil.floor(this.minX + 0.001);
            int iMaxX = MathUtil.ceil(this.maxX - 0.001);
            int iMinY = MathUtil.floor(this.minY + 0.001);
            int iMaxY = MathUtil.ceil(this.maxY - 0.001);
            int iMinZ = MathUtil.floor(this.minZ + 0.001);
            int iMaxZ = MathUtil.ceil(this.maxZ - 0.001);
            for (int x = iMinX; x < iMaxX; ++x) {
                for (int y = iMinY; y < iMaxY; ++y) {
                    for (int z = iMinZ; z < iMaxZ; ++z) {
                        double liquidHeight = BlockProperties.getLiquidHeightAt(this.blockCache, x, y, z, BlockFlags.F_LAVA, true);
                        double liquidHeightToWorld = (double)y + liquidHeight;
                        if (!(liquidHeightToWorld > this.minY + 0.001) || liquidHeight == 0.0) continue;
                        this.inLava = true;
                        return this.inLava;
                    }
                }
            }
        }
        return this.inLava;
    }

    public Vector tryApplyBubbleColumnMotion(Vector vector) {
        if (!this.isInBubbleStream()) {
            return vector;
        }
        boolean airAbove = BlockProperties.isAir(this.node.getType());
        boolean isDrag = false;
        BlockCache.IBlockCacheNode node = this.blockCache.getBlockCacheNode(this.blockX, this.blockY + 1, this.blockZ);
        BlockData data = this.world.getBlockAt(this.blockX, this.blockY, this.blockZ).getBlockData();
        if (data instanceof BubbleColumn) {
            isDrag = ((BubbleColumn)data).isDrag();
        }
        double yMotion = airAbove ? (isDrag ? Math.max(-0.9, vector.getY() - 0.03) : Math.min(1.8, vector.getY() + 0.1)) : (isDrag ? Math.max(-0.3, vector.getY() - 0.03) : Math.min(0.7, vector.getY() + 0.06));
        vector = new Vector(vector.getX(), yMotion, vector.getZ());
        return vector;
    }

    public boolean isInWater() {
        if (this.inWater == null) {
            if (!this.isInWaterLogged() && this.blockFlags != null && (this.blockFlags & BlockFlags.F_WATER) == 0L) {
                this.inWater = false;
                return false;
            }
            this.inWater = this.isInWaterLogged();
            if (this.inWater.booleanValue()) {
                return true;
            }
            int iMinX = MathUtil.floor(this.minX + 0.001);
            int iMaxX = MathUtil.ceil(this.maxX - 0.001);
            int iMinY = MathUtil.floor(this.minY + 0.001);
            int iMaxY = MathUtil.ceil(this.maxY - 0.001);
            int iMinZ = MathUtil.floor(this.minZ + 0.001);
            int iMaxZ = MathUtil.ceil(this.maxZ - 0.001);
            for (int x = iMinX; x < iMaxX; ++x) {
                for (int y = iMinY; y < iMaxY; ++y) {
                    for (int z = iMinZ; z < iMaxZ; ++z) {
                        double liquidHeight = BlockProperties.getLiquidHeightAt(this.blockCache, x, y, z, BlockFlags.F_WATER, true);
                        double liquidHeightToWorld = (double)y + liquidHeight;
                        if (!(liquidHeightToWorld >= this.minY + 0.001) || liquidHeight == 0.0) continue;
                        this.inWater = true;
                        return this.inWater;
                    }
                }
            }
        }
        return this.inWater;
    }

    public boolean isInWaterLogged() {
        if (this.inWaterLogged == null) {
            this.inWaterLogged = BlockProperties.isWaterlogged(this.world, this.blockCache, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
        return this.inWaterLogged;
    }

    public boolean isInLiquid() {
        if (!this.isInWaterLogged() && this.blockFlags != null && (this.blockFlags & BlockFlags.F_LIQUID) == 0L) {
            return false;
        }
        return this.isInWater() || this.isInLava();
    }

    public boolean isOnClimbable() {
        if (this.onClimbable == null) {
            Material typeId = this.getBlockType();
            if (this.blockFlags != null && (this.blockFlags & BlockFlags.F_CLIMBABLE) == 0L && !MaterialUtil.ALL_TRAP_DOORS.contains(typeId)) {
                this.onClimbable = false;
                return false;
            }
            long thisFlags = BlockFlags.getBlockFlags(typeId);
            this.onClimbable = (thisFlags & BlockFlags.F_CLIMBABLE) != 0L;
            if (!this.onClimbable.booleanValue() && MaterialUtil.ALL_TRAP_DOORS.contains(typeId) && BlockProperties.isTrapDoorAboveLadderSpecialCase(this.blockCache, this.blockX, this.blockY, this.blockZ)) {
                this.onClimbable = true;
            }
        }
        return this.onClimbable;
    }

    public boolean isResetCond() {
        return this.isInLiquid() || this.isOnClimbable() || this.isInWeb() || this.isInBerryBush() || this.isInPowderSnow() || this.isInBubbleStream();
    }

    public boolean isAboveLadder() {
        if (this.blockFlags != null && (this.blockFlags & BlockFlags.F_CLIMBABLE) == 0L) {
            return false;
        }
        return (BlockFlags.getBlockFlags(this.getBlockTypeBelow()) & BlockFlags.F_CLIMBABLE) != 0L;
    }

    public boolean isInWeb() {
        if (this.inWeb == null) {
            this.inWeb = this.blockFlags != null && (this.blockFlags & BlockFlags.F_COBWEB) == 0L ? Boolean.valueOf(false) : Boolean.valueOf(this.isInside(BlockFlags.F_COBWEB));
        }
        return this.inWeb;
    }

    public boolean isInPowderSnow() {
        if (this.inPowderSnow == null) {
            if (this.blockFlags != null && (this.blockFlags & BlockFlags.F_POWDER_SNOW) == 0L) {
                this.inPowderSnow = false;
            } else {
                this.inPowderSnow = false;
                int iMinX = Location.locToBlock((double)(this.minX + 0.001));
                int iMaxX = Location.locToBlock((double)(this.maxX - 0.001));
                int iMinY = Location.locToBlock((double)(this.minY + 0.001));
                int iMaxY = Math.min(Location.locToBlock((double)(this.maxY - 0.001)), this.blockCache.getMaxBlockY());
                int iMinZ = Location.locToBlock((double)(this.minZ + 0.001));
                int iMaxZ = Location.locToBlock((double)(this.maxZ - 0.001));
                for (int x = iMinX; x < iMaxX; ++x) {
                    for (int y = iMinY; y < iMaxY; ++y) {
                        for (int z = iMinZ; z < iMaxZ; ++z) {
                            if ((double)x != Math.floor(this.getX()) || (double)y != Math.floor(this.getY()) || (double)z != Math.floor(this.getZ()) || !BlockProperties.collidesBlock(this.blockCache, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, x, y, z, this.getOrCreateBlockCacheNode(), null, BlockFlags.F_POWDER_SNOW)) continue;
                            this.inPowderSnow = true;
                            return this.inPowderSnow;
                        }
                    }
                }
            }
        }
        return this.inPowderSnow;
    }

    public boolean isInBerryBush() {
        if (this.inBerryBush == null) {
            this.inBerryBush = this.blockFlags != null && (this.blockFlags & BlockFlags.F_BERRY_BUSH) == 0L ? Boolean.valueOf(false) : Boolean.valueOf(this.isInside(BlockFlags.F_BERRY_BUSH));
        }
        return this.inBerryBush;
    }

    public boolean isOnIce() {
        if (this.onIce == null) {
            if (this.blockFlags != null && (this.blockFlags & BlockFlags.F_ICE) == 0L) {
                this.onIce = false;
            } else {
                Material typeId = this.getBlockTypeBelow();
                long theseFlags = BlockFlags.getBlockFlags(typeId);
                this.onIce = this.isOnGround() && (theseFlags & BlockFlags.F_ICE) != 0L;
            }
        }
        return this.onIce;
    }

    public boolean isOnBlueIce() {
        if (this.onBlueIce == null) {
            if (this.blockFlags != null && (this.blockFlags & BlockFlags.F_BLUE_ICE) == 0L) {
                this.onBlueIce = false;
            } else {
                Material typeId = this.getBlockTypeBelow();
                long theseFlags = BlockFlags.getBlockFlags(typeId);
                this.onBlueIce = this.isOnGround() && (theseFlags & BlockFlags.F_BLUE_ICE) != 0L;
            }
        }
        return this.onBlueIce;
    }

    public boolean isInSoulSand() {
        if (this.inSoulSand == null) {
            this.inSoulSand = this.blockFlags != null && (this.blockFlags & BlockFlags.F_SOULSAND) == 0L ? Boolean.valueOf(false) : Boolean.valueOf((BlockFlags.getBlockFlags(this.getBlockType()) & BlockFlags.F_SOULSAND) != 0L);
        }
        return this.inSoulSand;
    }

    public boolean isOnSlimeBlock() {
        if (this.onSlimeBlock == null) {
            if (this.blockFlags != null && (this.blockFlags & BlockFlags.F_SLIME) == 0L) {
                this.onSlimeBlock = false;
            } else {
                Material typeId = this.getBlockTypeBelow();
                long theseFlags = BlockFlags.getBlockFlags(typeId);
                this.onSlimeBlock = this.isOnGround() && (theseFlags & BlockFlags.F_SLIME) != 0L;
            }
        }
        return this.onSlimeBlock;
    }

    public boolean isOnBouncyBlock() {
        if (this.onBouncyBlock == null) {
            this.onBouncyBlock = this.isOnSlimeBlock() ? Boolean.valueOf(true) : (this.blockFlags != null && (this.blockFlags & BlockFlags.F_BED) == 0L ? Boolean.valueOf(false) : Boolean.valueOf(this.standsOn(BlockFlags.F_BED)));
        }
        return this.onBouncyBlock;
    }

    public boolean isOnHoneyBlock() {
        if (this.onHoneyBlock == null) {
            this.onHoneyBlock = this.blockFlags != null && (this.blockFlags & BlockFlags.F_STICKY) == 0L ? Boolean.valueOf(false) : Boolean.valueOf((BlockFlags.getBlockFlags(this.getBlockType()) & BlockFlags.F_STICKY) != 0L);
        }
        return this.onHoneyBlock;
    }

    public boolean isInBubbleStream() {
        if (this.inBubbleStream == null) {
            this.inBubbleStream = this.blockFlags != null && (this.blockFlags & BlockFlags.F_BUBBLE_COLUMN) == 0L ? Boolean.valueOf(false) : Boolean.valueOf(this.isInside(BlockFlags.F_BUBBLE_COLUMN));
        }
        return this.inBubbleStream;
    }

    public boolean isOnRails() {
        return BlockProperties.isRails(this.getBlockType()) || this.y - (double)this.blockY < 0.3625 && BlockProperties.isAscendingRails(this.getBlockTypeBelow(), this.getData(this.blockX, this.blockY - 1, this.blockZ));
    }

    public boolean isOnGround() {
        if (this.onGround != null) {
            return this.onGround;
        }
        if (this.notOnGroundMaxY >= this.yOnGround) {
            this.onGround = false;
        } else if (this.onGroundMinY <= this.yOnGround) {
            this.onGround = true;
        } else if (this.blockFlags == null || (this.blockFlags & BlockFlags.F_GROUND) != 0L) {
            double[] bounds;
            int bY = Location.locToBlock((double)(this.y - this.yOnGround));
            BlockCache.IBlockCacheNode useNode = bY == this.blockY ? this.getOrCreateBlockCacheNode() : (bY == this.blockY - 1 ? this.getOrCreateBlockCacheNodeBelow() : this.blockCache.getOrCreateBlockCacheNode(this.blockX, bY, this.blockZ, false));
            Material id = useNode.getType();
            long flags = BlockFlags.getBlockFlags(id);
            if ((flags & BlockFlags.F_GROUND) != 0L && (flags & BlockFlags.F_VARIABLE) == 0L && (bounds = useNode.getBounds(this.blockCache, this.blockX, bY, this.blockZ)) != null && this.y - (double)bY >= bounds[4] && BlockProperties.collidesBlock(this.blockCache, this.x, this.minY - this.yOnGround, this.z, this.x, this.minY, this.z, this.blockX, bY, this.blockZ, useNode, null, flags) && (!BlockProperties.isPassableWorkaround(this.blockCache, this.blockX, bY, this.blockZ, this.minX - (double)this.blockX, this.minY - this.yOnGround - (double)bY, this.minZ - (double)this.blockZ, useNode, this.maxX - this.minX, this.yOnGround, this.maxZ - this.minZ, 1.0) || (flags & BlockFlags.F_GROUND_HEIGHT) != 0L && BlockProperties.getGroundMinHeight(this.blockCache, this.blockX, bY, this.blockZ, useNode, flags) <= this.y - (double)bY)) {
                this.onGround = true;
            }
            if (this.onGround == null) {
                this.onGround = BlockProperties.isOnGround(this.blockCache, this.minX, this.minY - this.yOnGround, this.minZ, this.maxX, this.minY, this.maxZ, BlockFlags.F_POWDER_SNOW);
            }
        } else {
            this.onGround = false;
        }
        if (this.onGround.booleanValue()) {
            this.onGroundMinY = Math.min(this.onGroundMinY, this.yOnGround);
        } else {
            this.notOnGroundMaxY = Math.max(this.notOnGroundMaxY, this.yOnGround);
        }
        return this.onGround;
    }

    public boolean isOnGround(double yOnGround) {
        if (this.onGround != null) {
            return this.onGround;
        }
        if (this.notOnGroundMaxY >= yOnGround) {
            return false;
        }
        if (this.onGroundMinY <= yOnGround) {
            return true;
        }
        return this.isOnGround(yOnGround, 0.0, 0.0, 0L);
    }

    public boolean isOnGround(long ignoreFlags) {
        if (this.onGround != null) {
            return this.onGround;
        }
        return BlockProperties.isOnGround(this.blockCache, this.minX, this.minY - this.yOnGround, this.minZ, this.maxX, this.minY, this.maxZ, ignoreFlags);
    }

    public boolean isOnGround(double yOnGround, long ignoreFlags) {
        if (this.onGround != null) {
            return this.onGround;
        }
        if (ignoreFlags == 0L) {
            if (this.notOnGroundMaxY >= yOnGround) {
                return false;
            }
            if (this.onGroundMinY <= yOnGround) {
                return true;
            }
        }
        return this.isOnGround(yOnGround, 0.0, 0.0, ignoreFlags);
    }

    public boolean isOnGround(double yOnGround, double xzMargin, double yMargin) {
        if (this.onGround != null) {
            return this.onGround;
        }
        if (xzMargin >= 0.0 && this.onGroundMinY <= yOnGround) {
            return true;
        }
        if (xzMargin <= 0.0 && yMargin == 0.0 && this.notOnGroundMaxY >= yOnGround) {
            return false;
        }
        return this.isOnGround(yOnGround, xzMargin, yMargin, 0L);
    }

    public boolean isOnGround(double yOnGround, double xzMargin, double yMargin, long ignoreFlags) {
        if (this.onGround != null) {
            return this.onGround;
        }
        if (ignoreFlags == 0L) {
            if (xzMargin >= 0.0 && this.onGroundMinY <= yOnGround) {
                return true;
            }
            if (xzMargin <= 0.0 && yMargin == 0.0 && this.notOnGroundMaxY >= yOnGround) {
                return false;
            }
        }
        boolean onGround = BlockProperties.isOnGround(this.blockCache, this.minX - xzMargin, this.minY - yOnGround - yMargin, this.minZ - xzMargin, this.maxX + xzMargin, this.minY + yMargin, this.maxZ + xzMargin, ignoreFlags);
        if (ignoreFlags == 0L) {
            if (onGround) {
                if (xzMargin <= 0.0 && yMargin == 0.0) {
                    this.onGroundMinY = Math.min(this.onGroundMinY, yOnGround);
                }
            } else if (xzMargin >= 0.0) {
                this.notOnGroundMaxY = Math.max(this.notOnGroundMaxY, yOnGround);
            }
        }
        return onGround;
    }

    public final boolean isOnGroundOpportune(double yOnGround, long ignoreFlags, BlockChangeTracker blockChangeTracker, BlockChangeReference blockChangeRef, int tick) {
        return blockChangeTracker.isOnGround(this.blockCache, blockChangeRef, tick, this.world.getUID(), this.minX, this.minY - yOnGround, this.minZ, this.maxX, this.maxY, this.maxZ, ignoreFlags);
    }

    public boolean isOnGroundOrResetCond() {
        return this.isOnGround() || this.isResetCond();
    }

    public double getyOnGround() {
        return this.yOnGround;
    }

    public void setyOnGround(double yOnGround) {
        this.yOnGround = yOnGround;
        this.onGround = null;
        this.blockFlags = null;
    }

    public boolean isPassable() {
        if (this.passable == null) {
            if (this.isBlockFlagsPassable()) {
                this.passable = true;
            } else {
                if (this.node == null) {
                    this.node = this.blockCache.getOrCreateBlockCacheNode(this.blockX, this.blockY, this.blockZ, false);
                }
                this.passable = BlockProperties.isPassable(this.blockCache, this.x, this.y, this.z, this.node, null);
            }
        }
        return this.passable;
    }

    public boolean isPassableBox() {
        if (this.passableBox == null) {
            this.passableBox = this.isBlockFlagsPassable() ? Boolean.valueOf(true) : (this.passable != null && this.passable == false ? Boolean.valueOf(false) : Boolean.valueOf(BlockProperties.isPassableBox(this.blockCache, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ)));
        }
        return this.passableBox;
    }

    private boolean isBlockFlagsPassable() {
        return this.blockFlags != null && (this.blockFlags & (BlockFlags.F_SOLID | BlockFlags.F_GROUND)) == 0L;
    }

    public void collectBlockFlags() {
        if (this.blockFlags == null) {
            this.collectBlockFlags(this.yOnGround);
        }
    }

    public void collectBlockFlags(double maxYonGround) {
        maxYonGround = Math.max(this.yOnGround, maxYonGround);
        double yExtra = 0.6;
        double xzM = 0.0;
        this.blockFlags = BlockProperties.collectFlagsSimple(this.blockCache, this.minX - 0.0, this.minY - 0.6 - maxYonGround, this.minZ - 0.0, this.maxX + 0.0, Math.max(this.maxY, this.minY + 1.5), this.maxZ + 0.0);
    }

    public int ensureChunksLoaded() {
        return this.ensureChunksLoaded(1.0);
    }

    public int ensureChunksLoaded(double xzMargin) {
        return MapUtil.ensureChunksLoaded(this.world, this.x, this.z, xzMargin);
    }

    public boolean matchBlockChange(BlockChangeTracker blockChangeTracker, BlockChangeReference ref, BlockChangeTracker.Direction direction, double coverDistance) {
        int tick = TickTask.getTick();
        UUID worldId = this.world.getUID();
        int iMinX = Location.locToBlock((double)this.minX);
        int iMaxX = Location.locToBlock((double)this.maxX);
        int iMinY = Location.locToBlock((double)this.minY);
        int iMaxY = Location.locToBlock((double)this.maxY);
        int iMinZ = Location.locToBlock((double)this.minZ);
        int iMaxZ = Location.locToBlock((double)this.maxZ);
        BlockChangeTracker.BlockChangeEntry minEntry = null;
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    BlockChangeTracker.BlockChangeEntry entry = blockChangeTracker.getBlockChangeEntry(ref, tick, worldId, x, y, z, direction);
                    if (entry == null || minEntry != null && entry.id >= minEntry.id || !(coverDistance > 0.0) || !this.coversDistance(x, y, z, direction, coverDistance)) continue;
                    minEntry = entry;
                }
            }
        }
        if (minEntry == null) {
            return false;
        }
        ref.updateSpan(minEntry);
        return true;
    }

    public boolean matchBlockChangeMatchResultingFlags(BlockChangeTracker blockChangeTracker, BlockChangeReference ref, BlockChangeTracker.Direction direction, double coverDistance, long matchFlags) {
        int tick = TickTask.getTick();
        UUID worldId = this.world.getUID();
        BlockFace blockFace = direction == null ? BlockFace.SELF : direction.blockFace;
        int iMinX = Location.locToBlock((double)this.minX) - blockFace.getModX();
        int iMaxX = Location.locToBlock((double)this.maxX) - blockFace.getModX();
        int iMinY = Location.locToBlock((double)this.minY) - blockFace.getModY();
        int iMaxY = Location.locToBlock((double)this.maxY) - blockFace.getModY();
        int iMinZ = Location.locToBlock((double)this.minZ) - blockFace.getModZ();
        int iMaxZ = Location.locToBlock((double)this.maxZ) - blockFace.getModZ();
        BlockChangeTracker.BlockChangeEntry minEntry = null;
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    BlockChangeTracker.BlockChangeEntry entry = blockChangeTracker.getBlockChangeEntryMatchFlags(ref, tick, worldId, x, y, z, direction, matchFlags);
                    if (entry == null || minEntry != null && entry.id >= minEntry.id || !(coverDistance > 0.0) || !this.coversDistance(x + blockFace.getModX(), y + blockFace.getModY(), z + blockFace.getModZ(), direction, coverDistance)) continue;
                    minEntry = entry;
                }
            }
        }
        if (minEntry == null) {
            return false;
        }
        ref.updateSpan(minEntry);
        return true;
    }

    public boolean isBlockIntersecting(int x, int y, int z) {
        return CollisionUtil.intersectsBlock(this.minX, this.maxX, x) && CollisionUtil.intersectsBlock(this.minY, this.maxY, y) && CollisionUtil.intersectsBlock(this.minZ, this.maxZ, z);
    }

    public boolean isBlockIntersecting(int x, int y, int z, BlockFace blockFace) {
        return this.isBlockIntersecting(x, y, z) || this.isBlockIntersecting(x + blockFace.getModX(), y + blockFace.getModY(), z + blockFace.getModZ());
    }

    private boolean coversDistance(int x, int y, int z, BlockChangeTracker.Direction direction, double coverDistance) {
        switch (direction) {
            case Y_POS: {
                return (double)y + 1.0 - Math.max(this.minY, (double)y) >= coverDistance;
            }
            case Y_NEG: {
                return Math.min(this.maxY, (double)y + 1.0) - (double)y >= coverDistance;
            }
            case X_POS: {
                return (double)x + 1.0 - Math.max(this.minX, (double)x) >= coverDistance;
            }
            case X_NEG: {
                return Math.min(this.maxX, (double)x + 1.0) - (double)x >= coverDistance;
            }
            case Z_POS: {
                return (double)z + 1.0 - Math.max(this.minZ, (double)z) >= coverDistance;
            }
            case Z_NEG: {
                return Math.min(this.maxZ, (double)z + 1.0) - (double)z >= coverDistance;
            }
        }
        return true;
    }

    public void prepare(RichBoundsLocation other) {
        this.blockFlags = other.blockFlags;
        this.notOnGroundMaxY = other.notOnGroundMaxY;
        this.onGroundMinY = other.onGroundMinY;
        this.passable = other.passable;
        this.passableBox = other.passableBox;
        this.node = other.node;
        this.nodeBelow = other.nodeBelow;
        this.onGround = other.isOnGround();
        this.inWater = other.isInWater();
        this.inWaterLogged = other.isInWaterLogged();
        this.inLava = other.isInLava();
        this.inWeb = other.isInWeb();
        this.inBerryBush = other.isInBerryBush();
        this.inBubbleStream = other.isInBubbleStream();
        this.onHoneyBlock = other.isOnHoneyBlock();
        this.onSlimeBlock = other.isOnSlimeBlock();
        this.onIce = other.isOnIce();
        this.onBlueIce = other.isOnBlueIce();
        this.inSoulSand = other.isInSoulSand();
        this.inPowderSnow = other.isInPowderSnow();
        this.onClimbable = other.isOnClimbable();
        this.onBouncyBlock = other.isOnBouncyBlock();
    }

    public void set(Location location, double fullWidth, double fullHeight, double yOnGround) {
        this.doSet(location, fullWidth, fullHeight, yOnGround);
    }

    protected void doSet(Location location, double fullWidth, double fullHeight, double yOnGround) {
        this.blockX = location.getBlockX();
        this.blockY = location.getBlockY();
        this.blockZ = location.getBlockZ();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
        double dxz = (double)Math.round(fullWidth * 500.0) / 1000.0;
        this.minX = this.x - dxz;
        this.minY = this.y;
        this.minZ = this.z - dxz;
        this.maxX = this.x + dxz;
        this.maxY = this.y + fullHeight;
        this.maxZ = this.z + dxz;
        this.boxMarginHorizontal = dxz;
        this.boxMarginVertical = fullHeight;
        this.world = location.getWorld();
        if (this.world == null) {
            throw new NullPointerException("World is null.");
        }
        this.nodeBelow = null;
        this.node = null;
        this.inBubbleStream = null;
        this.passableBox = null;
        this.passable = null;
        this.onBouncyBlock = null;
        this.onClimbable = null;
        this.onGround = null;
        this.inPowderSnow = null;
        this.inBerryBush = null;
        this.onSlimeBlock = null;
        this.onHoneyBlock = null;
        this.inSoulSand = null;
        this.onBlueIce = null;
        this.onIce = null;
        this.inWeb = null;
        this.inWaterLogged = null;
        this.inWater = null;
        this.inLava = null;
        this.onGroundMinY = Double.MAX_VALUE;
        this.notOnGroundMaxY = Double.MIN_VALUE;
        this.blockFlags = null;
        this.yOnGround = yOnGround;
    }

    public void cleanup() {
        this.world = null;
        this.blockCache = null;
    }

    public int hashCode() {
        return LocUtil.hashCode(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("RichBoundsLocation(");
        builder.append(this.world == null ? "null" : this.world.getName());
        builder.append('/');
        builder.append(Double.toString(this.x));
        builder.append(", ");
        builder.append(Double.toString(this.y));
        builder.append(", ");
        builder.append(Double.toString(this.z));
        builder.append(')');
        return builder.toString();
    }
}

