/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.location;

import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeEnchant;
import fr.neatmonster.nocheatplus.compat.versions.ClientVersion;
import fr.neatmonster.nocheatplus.components.registry.event.IHandle;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.collision.CollisionUtil;
import fr.neatmonster.nocheatplus.utilities.location.RichEntityLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class PlayerLocation
extends RichEntityLocation {
    private Player player = null;

    public PlayerLocation(IHandle<MCAccess> mcAccess, BlockCache blockCache) {
        super(mcAccess, blockCache);
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isAboveGround() {
        IPlayerData pData = DataManager.getPlayerData(this.player);
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        double yBelow = (double)this.player.getFallDistance() - cc.sfStepHeight;
        double extraExpansion = pData.getClientVersion().isHigherThan(ClientVersion.V_1_20_3) ? (double)1.0E-5f : 0.0;
        double[] AABB = new double[]{this.minX, this.minY + yBelow - extraExpansion, this.minZ, this.maxX, this.minY, this.maxZ};
        return this.isOnGround() || pData.getClientVersion().isAtLeast(ClientVersion.V_1_16_2) && (double)this.player.getFallDistance() < cc.sfStepHeight && !CollisionUtil.isEmpty(this.blockCache, (Entity)this.player, AABB);
    }

    public Vector getTridentPropellingForce(boolean onGround) {
        IPlayerData pData = DataManager.getPlayerData(this.player);
        if (pData.getClientVersion().isLowerThan(ClientVersion.V_1_13)) {
            return new Vector();
        }
        double RiptideLevel = BridgeEnchant.getRiptideLevel(this.player);
        if (RiptideLevel > 0.0) {
            float x = -TrigUtil.sin(this.getYaw() * ((float)Math.PI / 180)) * TrigUtil.cos(this.getPitch() * ((float)Math.PI / 180));
            float y = -TrigUtil.sin(this.getPitch() * ((float)Math.PI / 180));
            float z = TrigUtil.cos(this.getYaw() * ((float)Math.PI / 180)) * TrigUtil.cos(this.getPitch() * ((float)Math.PI / 180));
            float distance = MathUtil.sqrt(x * x + y * y + z * z);
            float force = 3.0f * ((1.0f + (float)RiptideLevel) / 4.0f);
            x *= force / distance;
            y *= force / distance;
            z *= force / distance;
            if (onGround) {
                y += 1.1999999f;
            }
            return new Vector(x, y, z);
        }
        return new Vector();
    }

    public Vector maybeBackOffFromEdge(Vector vector) {
        double xDistance;
        double yBelow;
        IPlayerData pData = DataManager.getPlayerData(this.player);
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        double zDistance = vector.getZ();
        double d = yBelow = pData.getClientVersion().isAtLeast(ClientVersion.V_1_11) ? -cc.sfStepHeight : -0.9999999;
        if (pData.getClientVersion().isLowerThan(ClientVersion.V_1_20_6)) {
            double[] offsetAABB_X = new double[]{this.minX + xDistance, this.minY + yBelow, this.minZ, this.maxX + xDistance, this.minY, this.maxZ};
            while (xDistance != 0.0 && CollisionUtil.isEmpty(this.blockCache, (Entity)this.player, offsetAABB_X)) {
                xDistance = xDistance < 0.05 && xDistance >= -0.05 ? 0.0 : (xDistance > 0.0 ? (xDistance -= 0.05) : (xDistance += 0.05));
                offsetAABB_X = new double[]{this.minX + xDistance, this.minY + yBelow, this.minZ, this.maxX + xDistance, this.minY, this.maxZ};
            }
            double[] offsetAABB_Z = new double[]{this.minX, this.minY + yBelow, this.minZ + zDistance, this.maxX, this.minY, this.maxZ + zDistance};
            while (zDistance != 0.0 && CollisionUtil.isEmpty(this.blockCache, (Entity)this.player, offsetAABB_Z)) {
                zDistance = zDistance < 0.05 && zDistance >= -0.05 ? 0.0 : (zDistance > 0.0 ? (zDistance -= 0.05) : (zDistance += 0.05));
                offsetAABB_Z = new double[]{this.minX, this.minY + yBelow, this.minZ + zDistance, this.maxX, this.minY, this.maxZ + zDistance};
            }
            double[] offsetAABB_XZ = new double[]{this.minX + xDistance, this.minY + yBelow, this.minZ + zDistance, this.maxX + xDistance, this.minY, this.maxZ + zDistance};
            while (xDistance != 0.0 && zDistance != 0.0 && CollisionUtil.isEmpty(this.blockCache, (Entity)this.player, offsetAABB_XZ)) {
                xDistance = xDistance < 0.05 && xDistance >= -0.05 ? 0.0 : (xDistance > 0.0 ? (xDistance -= 0.05) : (xDistance += 0.05));
                zDistance = zDistance < 0.05 && zDistance >= -0.05 ? 0.0 : (zDistance > 0.0 ? (zDistance -= 0.05) : (zDistance += 0.05));
                offsetAABB_XZ = new double[]{this.minX + xDistance, this.minY + yBelow, this.minZ + zDistance, this.maxX + xDistance, this.minY, this.maxZ + zDistance};
            }
        } else {
            double signumX = Math.signum(xDistance) * 0.05;
            double[] offsetAABB_X = new double[]{this.minX + xDistance, this.minY + yBelow - (double)1.0E-5f, this.minZ, this.maxX + xDistance, this.minY, this.maxZ};
            double signumZ = Math.signum(zDistance) * 0.05;
            for (xDistance = vector.getX(); xDistance != 0.0 && CollisionUtil.isEmpty(this.blockCache, (Entity)this.player, offsetAABB_X); xDistance -= signumX) {
                if (Math.abs(xDistance) <= 0.05) {
                    xDistance = 0.0;
                    break;
                }
                offsetAABB_X = new double[]{this.minX + xDistance, this.minY + yBelow - (double)1.0E-5f, this.minZ, this.maxX + xDistance, this.minY, this.maxZ};
            }
            double[] offsetAABB_Z = new double[]{this.minX, this.minY + yBelow - (double)1.0E-5f, this.minZ + zDistance, this.maxX, this.minY, this.maxZ + zDistance};
            while (zDistance != 0.0 && CollisionUtil.isEmpty(this.blockCache, (Entity)this.player, offsetAABB_Z)) {
                if (Math.abs(zDistance) <= 0.05) {
                    zDistance = 0.0;
                    break;
                }
                offsetAABB_Z = new double[]{this.minX, this.minY + yBelow - (double)1.0E-5f, this.minZ + (zDistance -= signumZ), this.maxX, this.minY, this.maxZ + zDistance};
            }
            double[] offsetAABB_XZ = new double[]{this.minX + xDistance, this.minY + yBelow - (double)1.0E-5f, this.minZ + zDistance, this.maxX + xDistance, this.minY, this.maxZ + zDistance};
            while (xDistance != 0.0 && zDistance != 0.0 && CollisionUtil.isEmpty(this.blockCache, (Entity)this.player, offsetAABB_XZ)) {
                xDistance = Math.abs(xDistance) <= 0.05 ? 0.0 : (xDistance -= signumX);
                zDistance = Math.abs(zDistance) <= 0.05 ? 0.0 : (zDistance -= signumZ);
                offsetAABB_XZ = new double[]{this.minX + xDistance, this.minY + yBelow - (double)1.0E-5f, this.minZ + zDistance, this.maxX + xDistance, this.minY, this.maxZ + zDistance};
            }
        }
        vector = new Vector(xDistance, 0.0, zDistance);
        return vector;
    }

    public void set(Location location, Player player) {
        this.set(location, player, 0.001);
    }

    public void set(Location location, Player player, double yOnGround) {
        super.set(location, (Entity)player, yOnGround);
        this.player = player;
    }

    public void set(Location location, Player player, double width, double eyeHeight, double height, double fullHeight, double yOnGround) {
        super.doSetExactHeight(location, (Entity)player, true, width, eyeHeight, height, fullHeight, yOnGround);
        this.player = player;
    }

    @Override
    public void set(Location location, Entity entity, double yOnGround) {
        throw new UnsupportedOperationException("Set must specify an instance of Player.");
    }

    @Override
    public void set(Location location, Entity entity, double fullHeight, double yOnGround) {
        throw new UnsupportedOperationException("Set must specify an instance of Player.");
    }

    @Override
    public void set(Location location, Entity entity, double fullWidth, double fullHeight, double yOnGround) {
        throw new UnsupportedOperationException("Set must specify an instance of Player.");
    }

    public void prepare(PlayerLocation other) {
        super.prepare(other);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.player = null;
    }

    public boolean hasIllegalStance() {
        return this.getMCAccess().isIllegalBounds(this.player).decide();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("PlayerLocation(");
        builder.append(this.world == null ? "null" : this.world.getName());
        builder.append('/');
        builder.append(Double.toString(this.x));
        builder.append(", ");
        builder.append(Double.toString(this.y));
        builder.append(", ");
        builder.append(Double.toString(this.z));
        builder.append(')');
        return builder.toString();
    }
}

