/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.entity;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeBukkitAPI;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class InventoryUtil {
    private static final IGenericInstanceHandle<MCAccess> mcAccess = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(MCAccess.class);
    private static final Map<String, InventoryType> all = new HashMap<String, InventoryType>();
    public static final Set<InventoryType> CONTAINER_LIST;

    public static InventoryType get(String name) {
        return all.get(name.toLowerCase());
    }

    public static Set<InventoryType> getAll(String ... names) {
        LinkedHashSet<InventoryType> res = new LinkedHashSet<InventoryType>();
        for (String name : names) {
            InventoryType mat = InventoryUtil.get(name);
            if (mat == null) continue;
            res.add(mat);
        }
        return res;
    }

    public static List<Material> collectItemsBySuffix(String suffix) {
        suffix = suffix.toLowerCase();
        LinkedList<Material> res = new LinkedList<Material>();
        for (Material mat : Material.values()) {
            if (mat.isBlock() || !mat.name().toLowerCase().endsWith(suffix)) continue;
            res.add(mat);
        }
        return res;
    }

    public static List<Material> collectItemsByPrefix(String prefix) {
        prefix = prefix.toLowerCase();
        LinkedList<Material> res = new LinkedList<Material>();
        for (Material mat : Material.values()) {
            if (mat.isBlock() || !mat.name().toLowerCase().startsWith(prefix)) continue;
            res.add(mat);
        }
        return res;
    }

    public static int getFreeSlots(Inventory inventory) {
        ItemStack[] contents = inventory.getContents();
        int count = 0;
        for (int i = 0; i < contents.length; ++i) {
            if (!BlockProperties.isAir(contents[i])) continue;
            ++count;
        }
        return count;
    }

    public static int getStackCount(Inventory inventory, ItemStack reference) {
        if (inventory == null) {
            return 0;
        }
        if (reference == null) {
            return InventoryUtil.getFreeSlots(inventory);
        }
        Material mat = reference.getType();
        short durability = reference.getDurability();
        ItemStack[] contents = inventory.getContents();
        int count = 0;
        for (int i = 0; i < contents.length; ++i) {
            ItemStack stack = contents[i];
            if (stack == null || stack.getType() != mat || stack.getDurability() != durability) continue;
            ++count;
        }
        return count;
    }

    public static int getStackCount(InventoryView view, ItemStack reference) {
        return InventoryUtil.getStackCount(view.getBottomInventory(), reference) + InventoryUtil.getStackCount(view.getTopInventory(), reference);
    }

    public static boolean hasInventoryOpenOwnExcluded(Player player) {
        return BridgeBukkitAPI.hasInventoryOpenOwnExcluded(player);
    }

    public static boolean hasInventoryOpen(Player player) {
        IPlayerData pData = DataManager.getPlayerData(player);
        InventoryData data = pData.getGenericInstance(InventoryData.class);
        return InventoryUtil.hasInventoryOpenOwnExcluded(player) || data.inventoryOpenTime != 0L;
    }

    public static boolean hasOpenedInvRecently(Player player, long timeAge) {
        if (timeAge < 0L) {
            throw new IllegalArgumentException("timeAge cannot be negative.");
        }
        long now = System.currentTimeMillis();
        IPlayerData pData = DataManager.getPlayerData(player);
        InventoryData data = pData.getGenericInstance(InventoryData.class);
        return InventoryUtil.hasInventoryOpen(player) && now - data.inventoryOpenTime <= timeAge;
    }

    public static boolean isContainerInteractionRecent(Player player, long timeAge) {
        if (timeAge < 0L) {
            throw new IllegalArgumentException("timeAge cannot be negative.");
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        InventoryData data = pData.getGenericInstance(InventoryData.class);
        if (data.containerInteractTime == 0L || data.lastClickTime == 0L) {
            return false;
        }
        return Math.abs(data.lastClickTime - data.containerInteractTime) < timeAge;
    }

    public static ItemStack getFirstConsumableItemInHand(Player player) {
        ItemStack actualStack = Bridge1_9.getItemInMainHand(player);
        if (!(!Bridge1_9.hasGetItemInOffHand() || actualStack != null && InventoryUtil.isConsumable(actualStack.getType()) || (actualStack = Bridge1_9.getItemInOffHand(player)) != null && InventoryUtil.isConsumable(actualStack.getType()))) {
            actualStack = null;
        }
        return actualStack;
    }

    public static boolean isConsumable(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return InventoryUtil.isConsumable(stack.getType());
    }

    public static boolean isContainerInventory(InventoryType type) {
        if (type == null) {
            return false;
        }
        return CONTAINER_LIST.contains(type);
    }

    public static boolean isConsumable(Material type) {
        return type != null && (type.isEdible() || type == Material.POTION || type == Material.MILK_BUCKET);
    }

    public static boolean isItemBroken(ItemStack stack) {
        if (stack == null) {
            return true;
        }
        Material mat = stack.getType();
        return stack.getDurability() >= mat.getMaxDurability();
    }

    public static boolean hasArrow(PlayerInventory i, boolean fw) {
        if (Bridge1_9.hasElytra()) {
            Material m = i.getItemInOffHand().getType();
            return fw && m == Material.FIREWORK_ROCKET || m.toString().endsWith("ARROW") || i.contains(Material.ARROW) || i.contains(Material.TIPPED_ARROW) || i.contains(Material.SPECTRAL_ARROW);
        }
        return i.contains(Material.ARROW);
    }

    public static void itemResyncTask(Player player, IPlayerData pData) {
        ItemStack stack;
        CombinedData data = pData.getGenericInstance(CombinedData.class);
        boolean ServerIsAtLeast1_13 = ServerVersion.isAtLeast("1.13");
        if (mcAccess.getHandle().resetActiveItem(player)) {
            InventoryUtil.tryResetItemUsageStatus(pData);
            pData.requestUpdateInventory();
            return;
        }
        if (Bridge1_9.hasGetItemInOffHand() && data.offHandUse) {
            ItemStack stack2 = Bridge1_9.getItemInOffHand(player);
            if (stack2 != null) {
                if (ServerIsAtLeast1_13) {
                    if (!player.isHandRaised()) {
                        InventoryUtil.tryResetItemUsageStatus(pData);
                    }
                } else {
                    player.getInventory().setItemInOffHand(stack2);
                    InventoryUtil.tryResetItemUsageStatus(pData);
                }
            }
            return;
        }
        if (!data.offHandUse && (stack = Bridge1_9.getItemInMainHand(player)) != null) {
            if (ServerIsAtLeast1_13) {
                if (!player.isHandRaised()) {
                    InventoryUtil.tryResetItemUsageStatus(pData);
                }
            } else {
                Bridge1_9.setItemInMainHand(player, stack);
                InventoryUtil.tryResetItemUsageStatus(pData);
            }
        }
    }

    private static void tryResetItemUsageStatus(IPlayerData pData) {
        if (BridgeMisc.hasGetItemInUseMethod()) {
            return;
        }
        pData.setItemInUse(null);
    }

    static {
        for (InventoryType type : InventoryType.values()) {
            String name = type.name().toLowerCase(Locale.ROOT);
            all.put(name, type);
        }
        CONTAINER_LIST = Collections.unmodifiableSet(InventoryUtil.getAll("chest", "ender_chest", "dispenser", "dropper", "hopper", "barrel", "shulker_box", "chiseled_bookshelf"));
    }
}

