/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.ds.map;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class ManagedMap<K, V> {
    protected final LinkedHashMap<K, ValueWrap> map;

    public ManagedMap(int defaultCapacity, float loadFactor) {
        this.map = new LinkedHashMap(defaultCapacity, loadFactor, true);
    }

    public V put(K key, V value) {
        ValueWrap wrap = this.map.get(key);
        if (wrap == null) {
            this.map.put(key, new ValueWrap(value));
            return null;
        }
        Object res = wrap.value;
        wrap.value = value;
        wrap.ts = System.currentTimeMillis();
        return res;
    }

    public V get(K key) {
        ValueWrap wrap = this.map.get(key);
        if (wrap == null) {
            return null;
        }
        wrap.ts = System.currentTimeMillis();
        return wrap.value;
    }

    public V remove(K key) {
        ValueWrap wrap = (ValueWrap)this.map.remove(key);
        if (wrap == null) {
            return null;
        }
        return wrap.value;
    }

    public void clear() {
        this.map.clear();
    }

    public Collection<K> expire(long ts) {
        LinkedList<K> rem = new LinkedList<K>();
        for (Map.Entry<K, ValueWrap> entry : this.map.entrySet()) {
            ValueWrap wrap = entry.getValue();
            if (wrap.ts >= ts) break;
            rem.add(entry.getKey());
        }
        for (Map.Entry<K, ValueWrap> key : rem) {
            this.map.remove(key);
        }
        return rem;
    }

    protected class ValueWrap {
        public long ts = System.currentTimeMillis();
        public V value;

        public ValueWrap(V value) {
            this.value = value;
        }
    }
}

