/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.ds.map;

import fr.neatmonster.nocheatplus.utilities.ds.map.CoordHash;
import fr.neatmonster.nocheatplus.utilities.ds.map.CoordMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractCoordHashMap<V, E extends HashEntry<V>>
implements CoordMap<V> {
    private final float loadFactor;
    protected List<E>[] entries;
    protected int size = 0;

    public AbstractCoordHashMap() {
        this(10, 0.75f);
    }

    public AbstractCoordHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public AbstractCoordHashMap(int initialCapacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.entries = new List[initialCapacity];
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return this.get(x, y, z) != null;
    }

    @Override
    public V get(int x, int y, int z) {
        E entry = this.getEntry(x, y, z);
        return entry == null ? null : (V)((HashEntry)entry).value;
    }

    protected E getEntry(int x, int y, int z) {
        int hash = CoordHash.hashCode3DPrimes(x, y, z);
        int slot = Math.abs(hash) % this.entries.length;
        List<E> bucket = this.entries[slot];
        if (bucket == null) {
            return null;
        }
        for (HashEntry entry : bucket) {
            if (hash != entry.hash || x != entry.x || z != entry.z || y != entry.y) continue;
            return (E)entry;
        }
        return null;
    }

    @Override
    public V put(int x, int y, int z, V value) {
        int hash = CoordHash.hashCode3DPrimes(x, y, z);
        int absHash = Math.abs(hash);
        int slot = absHash % this.entries.length;
        List<E> bucket = this.entries[slot];
        if (bucket != null) {
            for (HashEntry entry : bucket) {
                if (hash != entry.hash || x != entry.x || z != entry.z || y != entry.y) continue;
                Object previousValue = entry.value;
                entry.value = value;
                return previousValue;
            }
        } else if ((float)(this.size + 1) > (float)this.entries.length * this.loadFactor) {
            this.resize(this.size + 1);
            slot = absHash % this.entries.length;
            bucket = this.entries[slot];
        }
        if (bucket == null) {
            bucket = new LinkedList();
            this.entries[slot] = bucket;
        }
        bucket.add(this.newEntry(x, y, z, value, hash));
        ++this.size;
        return null;
    }

    @Override
    public V remove(int x, int y, int z) {
        int hash = CoordHash.hashCode3DPrimes(x, y, z);
        int absHash = Math.abs(hash);
        int slot = absHash % this.entries.length;
        List<E> bucket = this.entries[slot];
        if (bucket == null) {
            return null;
        }
        Iterator<E> it = bucket.iterator();
        while (it.hasNext()) {
            HashEntry entry = (HashEntry)it.next();
            if (entry.hash != hash || x != entry.x || z != entry.z || y != entry.y) continue;
            it.remove();
            --this.size;
            if (bucket.isEmpty()) {
                this.entries[slot] = null;
            }
            this.removeEntry(entry);
            return entry.value;
        }
        return null;
    }

    private void resize(int size) {
        int newCapacity = Math.min(Math.max((int)((float)(size + 4) / this.loadFactor), this.entries.length + this.entries.length / 4), 4);
        List[] newEntries = new List[newCapacity];
        int used = -1;
        for (int oldSlot = 0; oldSlot < this.entries.length; ++oldSlot) {
            List<E> oldBucket = this.entries[oldSlot];
            if (oldBucket == null) continue;
            for (HashEntry entry : oldBucket) {
                int newSlot = Math.abs(entry.hash) % newCapacity;
                List<HashEntry<Object>> newBucket = newEntries[newSlot];
                if (newBucket == null) {
                    if (used < 0) {
                        newBucket = new LinkedList<HashEntry>();
                    } else {
                        newBucket = this.entries[used];
                        this.entries[used] = null;
                        --used;
                    }
                    newEntries[newSlot] = newBucket;
                }
                newBucket.add(entry);
            }
            oldBucket.clear();
            this.entries[oldSlot] = null;
            this.entries[++used] = oldBucket;
        }
        this.entries = newEntries;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            this.size = 0;
            Arrays.fill(this.entries, null);
        }
    }

    protected abstract E newEntry(int var1, int var2, int var3, V var4, int var5);

    protected void removeEntry(E entry) {
    }

    public static class HashEntry<V>
    implements CoordMap.Entry<V> {
        protected final int x;
        protected final int y;
        protected final int z;
        protected V value;
        protected final int hash;

        public HashEntry(int x, int y, int z, V value, int hash) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.value = value;
            this.hash = hash;
        }

        @Override
        public final int getX() {
            return this.x;
        }

        @Override
        public final int getY() {
            return this.y;
        }

        @Override
        public final int getZ() {
            return this.z;
        }

        @Override
        public final V getValue() {
            return this.value;
        }
    }
}

