/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.ds.count;

import fr.neatmonster.nocheatplus.utilities.StringUtil;

public class ActionAccumulator {
    private final int[] valueCounter;
    private final float[] buckets;
    private final int bucketCapacity;

    public ActionAccumulator(int nBuckets, int bucketCapacity) {
        this.valueCounter = new int[nBuckets];
        this.buckets = new float[nBuckets];
        this.bucketCapacity = bucketCapacity;
    }

    public void add(float value) {
        if (this.valueCounter[0] >= this.bucketCapacity) {
            this.shift();
        }
        this.valueCounter[0] = this.valueCounter[0] + 1;
        this.buckets[0] = this.buckets[0] + value;
    }

    private void shift() {
        for (int bucketIndex = this.buckets.length - 1; bucketIndex > 0; --bucketIndex) {
            this.valueCounter[bucketIndex] = this.valueCounter[bucketIndex - 1];
            this.buckets[bucketIndex] = this.buckets[bucketIndex - 1];
        }
        this.valueCounter[0] = 0;
        this.buckets[0] = 0.0f;
    }

    public float score() {
        float score = 0.0f;
        for (int i = 0; i < this.buckets.length; ++i) {
            score += this.buckets[i];
        }
        return score;
    }

    public int count() {
        int globalCounter = 0;
        for (int i = 0; i < this.valueCounter.length; ++i) {
            globalCounter += this.valueCounter[i];
        }
        return globalCounter;
    }

    public void clear() {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.valueCounter[i] = 0;
            this.buckets[i] = 0.0f;
        }
    }

    public int bucketCount(int bucket) {
        return this.valueCounter[bucket];
    }

    public float bucketScore(int bucket) {
        return this.buckets[bucket];
    }

    public float mean(int bucket) {
        return this.bucketScore(bucket) / (float)this.bucketCount(bucket);
    }

    public float mean() {
        return this.score() / (float)this.count();
    }

    public int numberOfBuckets() {
        return this.buckets.length;
    }

    public int bucketCapacity() {
        return this.bucketCapacity;
    }

    public String toInformalString() {
        StringBuilder b = new StringBuilder(this.buckets.length * 10);
        b.append("|");
        for (int i = 0; i < this.buckets.length; ++i) {
            b.append(StringUtil.fdec3.format(this.buckets[i]) + "/" + this.valueCounter[i] + "|");
        }
        return b.toString();
    }
}

