/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.collision.tracing.axis;

import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeReference;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.utilities.collision.Axis;
import fr.neatmonster.nocheatplus.utilities.collision.BlockPositionContainer;
import fr.neatmonster.nocheatplus.utilities.collision.tracing.axis.AxisTracing;
import fr.neatmonster.nocheatplus.utilities.collision.tracing.axis.ICollidePassable;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.util.UUID;

public class PassableAxisTracing
extends AxisTracing
implements ICollidePassable {
    private BlockCache blockCache;
    private BlockChangeTracker blockChangeTracker = null;
    private BlockChangeReference blockChangeRef = null;
    private int tick;
    private UUID worldId;

    @Override
    public BlockCache getBlockCache() {
        return this.blockCache;
    }

    @Override
    public void setBlockCache(BlockCache blockCache) {
        this.blockCache = blockCache;
    }

    @Override
    public void setBlockChangeTracker(BlockChangeTracker blockChangeTracker, BlockChangeReference blockChangeReference, int tick, UUID worldId) {
        this.blockChangeTracker = blockChangeTracker;
        this.blockChangeRef = blockChangeReference;
        this.tick = tick;
        this.worldId = worldId;
    }

    @Override
    protected void collectInitiallyCollidingBlocks(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, BlockPositionContainer results) {
        BlockProperties.collectInitiallyCollidingBlocks(this.blockCache, minX, minY, minZ, maxX, maxY, maxZ, results);
    }

    @Override
    protected boolean step(int blockX, int blockY, int blockZ, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Axis axis, int increment) {
        if (BlockProperties.isPassableBox(this.blockCache, blockX, blockY, blockZ, minX, minY, minZ, maxX, maxY, maxZ)) {
            return true;
        }
        if (this.blockChangeTracker != null) {
            BlockChangeTracker.BlockChangeEntry entry = this.blockChangeTracker.getBlockChangeEntry(this.blockChangeRef, this.tick, this.worldId, blockX, blockY + 1, blockZ, null);
            if (entry == null) {
                entry = this.blockChangeTracker.getBlockChangeEntry(this.blockChangeRef, this.tick, this.worldId, blockX, blockY, blockZ, null);
            }
            if (entry != null) {
                this.blockChangeRef.updateSpan(entry);
                return true;
            }
        }
        this.collides = true;
        return false;
    }

    @Override
    public void set(PlayerLocation from, PlayerLocation to) {
        this.set(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ());
        this.setBlockCache(from.getBlockCache());
    }

    @Override
    public boolean mightNeedSplitAxisHandling() {
        return false;
    }

    @Override
    public void cleanup() {
        this.blockCache = null;
        this.blockChangeTracker = null;
        this.blockChangeRef = null;
        this.worldId = null;
    }
}

