/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.collision.tracing.axis;

import fr.neatmonster.nocheatplus.utilities.collision.Axis;
import fr.neatmonster.nocheatplus.utilities.collision.BlockPositionContainer;
import fr.neatmonster.nocheatplus.utilities.collision.tracing.axis.AxisTracing;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;

public class InteractAxisTracing
extends AxisTracing {
    protected BlockCache blockCache = null;
    protected final boolean strict;

    public InteractAxisTracing() {
        this(false);
    }

    public InteractAxisTracing(boolean strict) {
        this.strict = strict;
    }

    public BlockCache getBlockCache() {
        return this.blockCache;
    }

    public void setBlockCache(BlockCache blockCache) {
        this.blockCache = blockCache;
    }

    @Override
    public void set(double x0, double y0, double z0, double x1, double y1, double z1) {
        super.set(x0, y0, z0, x1, y1, z1);
        this.collides = false;
    }

    public void cleanup() {
        if (this.blockCache != null) {
            this.blockCache = null;
        }
    }

    @Override
    protected boolean step(int blockX, int blockY, int blockZ, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Axis axis, int increment) {
        if (BlockProperties.isPassableBox(this.blockCache, blockX, blockY, blockZ, minX, minY, minZ, maxX, maxY, maxZ)) {
            return true;
        }
        this.collides = true;
        return false;
    }

    @Override
    protected void collectInitiallyCollidingBlocks(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, BlockPositionContainer results) {
        BlockProperties.collectInitiallyCollidingBlocks(this.blockCache, minX, minY, minZ, maxX, maxY, maxZ, results);
    }
}

