/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.collision.tracing.axis;

import fr.neatmonster.nocheatplus.utilities.collision.Axis;
import fr.neatmonster.nocheatplus.utilities.collision.BlockPositionContainer;
import fr.neatmonster.nocheatplus.utilities.collision.tracing.ICollideBlocks;
import fr.neatmonster.nocheatplus.utilities.collision.tracing.ISetMargins;
import java.util.List;
import org.bukkit.Location;

public abstract class AxisTracing
implements ICollideBlocks,
ISetMargins {
    private final Axis[] axisOrder = new Axis[3];
    private double x0;
    private double y0;
    private double z0;
    private double x1;
    private double y1;
    private double z1;
    private double marginXpos;
    private double marginXneg;
    private double marginYpos;
    private double marginYneg;
    private double marginZpos;
    private double marginZneg;
    private boolean cutOppositeDirectionMargin = false;
    private boolean ignoreInitiallyColliding = false;
    private final BlockPositionContainer ignoredBlocks = new BlockPositionContainer();
    protected boolean collides;
    protected Axis collidesAxis;
    protected int step = 0;
    protected int axisStep = 0;
    private int maxSteps = 0;

    public AxisTracing() {
        this.setDefaultAxisOrder();
    }

    @Override
    public int getMaxSteps() {
        return this.maxSteps;
    }

    @Override
    public void setMaxSteps(int maxSteps) {
        this.maxSteps = maxSteps;
    }

    @Override
    public int getStepsDone() {
        return this.step;
    }

    public int getAxisStepsDone() {
        return this.axisStep;
    }

    @Override
    public void setIgnoreInitiallyColliding(boolean ignoreInitiallyColliding) {
        this.ignoreInitiallyColliding = ignoreInitiallyColliding;
    }

    @Override
    public boolean getIgnoreInitiallyColliding() {
        return this.ignoreInitiallyColliding;
    }

    @Override
    public Axis[] getAxisOrder() {
        Axis[] out = new Axis[this.axisOrder.length];
        System.arraycopy(this.axisOrder, 0, out, 0, this.axisOrder.length);
        return out;
    }

    @Override
    public boolean collides() {
        return this.collides;
    }

    @Override
    public Axis getCollidingAxis() {
        return this.collidesAxis;
    }

    public void setDefaultAxisOrder() {
        this.setAxisOrder(Axis.AXIS_ORDER_YXZ);
    }

    public void setAxisOrder(Axis first, Axis second, Axis third) {
        this.axisOrder[0] = first;
        this.axisOrder[1] = second;
        this.axisOrder[2] = third;
    }

    public void setAxisOrder(List<Axis> axisOrder) {
        if (axisOrder.size() != 3) {
            throw new IllegalArgumentException("Size must be three.");
        }
        this.setAxisOrder(axisOrder.get(0), axisOrder.get(1), axisOrder.get(2));
    }

    @Override
    public void setMargins(double height, double xzMargin) {
        this.marginZneg = this.marginZpos = xzMargin;
        this.marginXpos = this.marginZpos;
        this.marginXneg = this.marginZpos;
        this.marginYneg = 0.0;
        this.marginYpos = height;
    }

    @Override
    public void setCutOppositeDirectionMargin(boolean cutOppositeDirectionMargin) {
        this.cutOppositeDirectionMargin = cutOppositeDirectionMargin;
    }

    @Override
    public void set(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.collides = false;
        this.step = 0;
        this.x0 = x0;
        this.y0 = y0;
        this.z0 = z0;
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
    }

    @Override
    public void loop() {
        double x = this.x0;
        double y = this.y0;
        double z = this.z0;
        if (this.ignoreInitiallyColliding) {
            this.collectInitiallyCollidingBlocks(this.x0 - this.marginXneg, this.y0 - this.marginYneg, this.z0 - this.marginZneg, this.x0 + this.marginXpos, this.y0 + this.marginYpos, this.z0 + this.marginZpos, this.ignoredBlocks);
        }
        for (int i = 0; i < 3; ++i) {
            Axis axis;
            this.collidesAxis = axis = this.axisOrder[i];
            if (axis == Axis.Y_AXIS) {
                this.runAxisY(x, y, z);
                y = this.y1;
            } else if (axis == Axis.X_AXIS) {
                this.runAxisX(x, y, z);
                x = this.x1;
            } else if (axis == Axis.Z_AXIS) {
                this.runAxisZ(x, y, z);
                z = this.z1;
            } else if (axis != Axis.NONE) {
                throw new IllegalStateException("Can not ");
            }
            if (this.collides) break;
        }
        if (this.ignoreInitiallyColliding) {
            this.ignoredBlocks.clear();
        }
    }

    protected boolean shouldCheckForIgnoredBlocks() {
        return this.ignoreInitiallyColliding && !this.ignoredBlocks.isEmpty();
    }

    protected boolean isBlockIgnored(int x, int y, int z) {
        return this.ignoredBlocks.containsBlockPosition(x, y, z);
    }

    private void runAxisY(double xIn, double yIn, double zIn) {
        int iEndY;
        double yEnd;
        double yStart;
        int increment;
        if (yIn == this.y1) {
            return;
        }
        double xMin = xIn - this.marginXneg;
        double xMax = xIn + this.marginXpos;
        double zMin = zIn - this.marginZneg;
        double zMax = zIn + this.marginZpos;
        if (yIn < this.y1) {
            increment = 1;
            yStart = this.cutOppositeDirectionMargin ? yIn : yIn - this.marginYneg;
            yEnd = this.y1 + this.marginYpos;
            iEndY = Location.locToBlock((double)yEnd) + 1;
        } else {
            increment = -1;
            yStart = this.cutOppositeDirectionMargin ? yIn : yIn + this.marginYpos;
            yEnd = this.y1 - this.marginYneg;
            iEndY = Location.locToBlock((double)yEnd) - 1;
        }
        int iMinX = Location.locToBlock((double)xMin);
        int iMaxX = Location.locToBlock((double)xMax);
        int iMinZ = Location.locToBlock((double)zMin);
        int iMaxZ = Location.locToBlock((double)zMax);
        int iStartY = Location.locToBlock((double)yStart);
        this.axisStep = 0;
        for (int y = iStartY; y != iEndY; y += increment) {
            ++this.step;
            ++this.axisStep;
            if (this.step > this.maxSteps) {
                return;
            }
            boolean checkInitiallyColliding = this.shouldCheckForIgnoredBlocks();
            for (int x = iMinX; x <= iMaxX; ++x) {
                for (int z = iMinZ; z <= iMaxZ; ++z) {
                    if (checkInitiallyColliding && this.isBlockIgnored(x, y, z) || this.step(x, y, z, xMin, increment == 1 ? yStart : yEnd, zMin, xMax, increment == 1 ? yEnd : yStart, zMax, Axis.Y_AXIS, increment)) continue;
                    this.collides = true;
                    return;
                }
            }
        }
    }

    private void runAxisX(double xIn, double yIn, double zIn) {
        int iEndX;
        double xEnd;
        double xStart;
        int increment;
        if (xIn == this.x1) {
            return;
        }
        double yMin = yIn - this.marginYneg;
        double yMax = yIn + this.marginYpos;
        double zMin = zIn - this.marginZneg;
        double zMax = zIn + this.marginZpos;
        if (xIn < this.x1) {
            increment = 1;
            xStart = this.cutOppositeDirectionMargin ? xIn : xIn - this.marginXneg;
            xEnd = this.x1 + this.marginXpos;
            iEndX = Location.locToBlock((double)xEnd) + 1;
        } else {
            increment = -1;
            xStart = this.cutOppositeDirectionMargin ? xIn : xIn + this.marginXpos;
            xEnd = this.x1 - this.marginXneg;
            iEndX = Location.locToBlock((double)xEnd) - 1;
        }
        int iMinY = Location.locToBlock((double)yMin);
        int iMaxY = Location.locToBlock((double)yMax);
        int iMinZ = Location.locToBlock((double)zMin);
        int iMaxZ = Location.locToBlock((double)zMax);
        int iStartX = Location.locToBlock((double)xStart);
        this.axisStep = 0;
        for (int x = iStartX; x != iEndX; x += increment) {
            ++this.step;
            ++this.axisStep;
            if (this.step > this.maxSteps) {
                return;
            }
            boolean checkInitiallyColliding = this.shouldCheckForIgnoredBlocks();
            for (int y = iMinY; y <= iMaxY; ++y) {
                for (int z = iMinZ; z <= iMaxZ; ++z) {
                    if (checkInitiallyColliding && this.isBlockIgnored(x, y, z) || this.step(x, y, z, increment == 1 ? xStart : xEnd, yMin, zMin, increment == 1 ? xEnd : xStart, yMax, zMax, Axis.X_AXIS, increment)) continue;
                    this.collides = true;
                    return;
                }
            }
        }
    }

    private void runAxisZ(double xIn, double yIn, double zIn) {
        int iEndZ;
        double zEnd;
        double zStart;
        int increment;
        if (zIn == this.z1) {
            return;
        }
        double yMin = yIn - this.marginYneg;
        double yMax = yIn + this.marginYpos;
        double xMin = xIn - this.marginXneg;
        double xMax = xIn + this.marginXpos;
        if (zIn < this.z1) {
            increment = 1;
            zStart = this.cutOppositeDirectionMargin ? zIn : zIn - this.marginZneg;
            zEnd = this.z1 + this.marginZpos;
            iEndZ = Location.locToBlock((double)(zEnd + 1.0));
        } else {
            increment = -1;
            zStart = this.cutOppositeDirectionMargin ? zIn : zIn + this.marginZpos;
            zEnd = this.z1 - this.marginZneg;
            iEndZ = Location.locToBlock((double)(zEnd - 1.0));
        }
        int iMinY = Location.locToBlock((double)yMin);
        int iMaxY = Location.locToBlock((double)yMax);
        int iMinX = Location.locToBlock((double)xMin);
        int iMaxX = Location.locToBlock((double)xMax);
        int iStartZ = Location.locToBlock((double)zStart);
        this.axisStep = 0;
        boolean checkInitiallyColliding = this.shouldCheckForIgnoredBlocks();
        for (int z = iStartZ; z != iEndZ; z += increment) {
            ++this.step;
            ++this.axisStep;
            if (this.step > this.maxSteps) {
                return;
            }
            for (int y = iMinY; y <= iMaxY; ++y) {
                for (int x = iMinX; x <= iMaxX; ++x) {
                    if (checkInitiallyColliding && this.isBlockIgnored(x, y, z) || this.step(x, y, z, xMin, yMin, increment == 1 ? zStart : zEnd, xMax, yMax, increment == 1 ? zEnd : zStart, Axis.Z_AXIS, increment)) continue;
                    this.collides = true;
                    return;
                }
            }
        }
    }

    protected abstract void collectInitiallyCollidingBlocks(double var1, double var3, double var5, double var7, double var9, double var11, BlockPositionContainer var13);

    protected abstract boolean step(int var1, int var2, int var3, double var4, double var6, double var8, double var10, double var12, double var14, Axis var16, int var17);
}

