/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.collision.supportingblock;

import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeMaterial;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.utilities.collision.AxisAlignedBBUtils;
import fr.neatmonster.nocheatplus.utilities.collision.supportingblock.SupportingBlockData;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class SupportingBlockUtils {
    public static List<Vector> getCollisionsLoc(BlockCache blockCache, double[] eAABB) {
        ArrayList<Vector> collisionsLoc = new ArrayList<Vector>();
        int minBlockX = (int)Math.floor(eAABB[0] - 1.0E-7) - 1;
        int maxBlockX = (int)Math.floor(eAABB[3] + 1.0E-7) + 1;
        int minBlockY = (int)Math.max(Math.floor(eAABB[1] - 1.0E-7) - 1.0, (double)blockCache.getMinBlockY());
        int maxBlockY = (int)Math.min(Math.floor(eAABB[4] + 1.0E-7) + 1.0, (double)blockCache.getMaxBlockY());
        int minBlockZ = (int)Math.floor(eAABB[2] - 1.0E-7) - 1;
        int maxBlockZ = (int)Math.floor(eAABB[5] + 1.0E-7) + 1;
        for (int y = minBlockY; y < maxBlockY; ++y) {
            for (int x = minBlockX; x <= maxBlockX; ++x) {
                for (int z = minBlockZ; z <= maxBlockZ; ++z) {
                    int edgeCount;
                    Material mat = blockCache.getType(x, y, z);
                    if (BlockProperties.isAir(mat) || BlockProperties.isPassable(mat) || (edgeCount = (x == minBlockX || x == maxBlockX ? 1 : 0) + (y == minBlockY || y == maxBlockY ? 1 : 0) + (z == minBlockZ || z == maxBlockZ ? 1 : 0)) == 3 || edgeCount == 1 && (BlockFlags.getBlockFlags(mat) & BlockFlags.F_HEIGHT150) == 0L || edgeCount == 2 && mat != BridgeMaterial.MOVING_PISTON || !AxisAlignedBBUtils.isIntersected(blockCache.getBounds(x, y, z), eAABB)) continue;
                    collisionsLoc.add(new Vector(x, y, z));
                }
            }
        }
        return collisionsLoc;
    }

    public static Vector getOnPos(BlockCache access, Location eLoc, SupportingBlockData data, float yBelow) {
        Vector supportingBlockLoc = data.getBlockPos();
        if (supportingBlockLoc != null) {
            boolean isSpecialCond;
            BlockCache.IBlockCacheNode node = access.getOrCreateBlockCacheNode(supportingBlockLoc.getX(), supportingBlockLoc.getY(), supportingBlockLoc.getZ(), false);
            long flags = BlockFlags.getBlockFlags(node.getType());
            Material mat = node.getType();
            boolean bl = isSpecialCond = !((double)yBelow <= 0.5 && (flags & BlockFlags.F_HEIGHT150) != 0L || MaterialUtil.ALL_WALLS.contains(mat) || MaterialUtil.WOODEN_FENCE_GATES.contains(mat));
            if (isSpecialCond) {
                return new Vector(supportingBlockLoc.getX(), (double)MathUtil.floor(eLoc.getY() - (double)yBelow), supportingBlockLoc.getZ());
            }
            return supportingBlockLoc;
        }
        return new Vector(MathUtil.floor(eLoc.getX()), MathUtil.floor(eLoc.getY() - (double)yBelow), MathUtil.floor(eLoc.getZ()));
    }

    public static SupportingBlockData checkSupportingBlock(BlockCache cache, Player player, SupportingBlockData lastSupportingBlock, Vector movementVector, double[] AABB, boolean isOnGround) {
        if (!isOnGround) {
            return new SupportingBlockData(null, false);
        }
        AABB = AxisAlignedBBUtils.move(AABB, 0.0, -1.0E-6, 0.0);
        AABB[4] = AABB[1];
        Optional<Vector> supportingBlock = SupportingBlockUtils.findSupportingBlock(cache, player, AABB);
        if (!supportingBlock.isPresent() && !lastSupportingBlock.lastOnGroundAndNoBlock()) {
            if (movementVector != null) {
                double[] AABB_2 = AxisAlignedBBUtils.move(AABB, -movementVector.getX(), 0.0, -movementVector.getZ());
                supportingBlock = SupportingBlockUtils.findSupportingBlock(cache, player, AABB_2);
                return new SupportingBlockData(supportingBlock.orElse(null), true);
            }
        } else {
            return new SupportingBlockData(supportingBlock.orElse(null), true);
        }
        return new SupportingBlockData(null, true);
    }

    private static Optional<Vector> findSupportingBlock(BlockCache cache, Player player, double[] AABB) {
        PlayerMoveData thisMove = DataManager.getPlayerData((Player)player).getGenericInstance(MovingData.class).playerMoves.getCurrentMove();
        Vector correctedPlayerLoc = new Vector(thisMove.from.getX(), thisMove.from.getY(), thisMove.from.getZ());
        Vector lastBlockLocation = null;
        double lastDistance = Double.MAX_VALUE;
        for (Vector blockLocation : SupportingBlockUtils.getCollisionsLoc(cache, AABB)) {
            Vector blockLocAsVector3d = blockLocation.clone().add(new Vector(0.5, 0.5, 0.5));
            double currentDistance = correctedPlayerLoc.distanceSquared(blockLocAsVector3d);
            if (!(currentDistance < lastDistance) && (currentDistance != lastDistance || lastBlockLocation == null || !SupportingBlockUtils.compareTo(blockLocation, lastBlockLocation))) continue;
            lastBlockLocation = blockLocation;
            lastDistance = currentDistance;
        }
        return Optional.ofNullable(lastBlockLocation);
    }

    private static boolean compareTo(Vector first, Vector second) {
        int deltaZ;
        if (first.getY() != second.getY()) {
            return first.getY() < second.getY();
        }
        int deltaX = (int)(second.getX() - first.getX());
        return deltaX + (deltaZ = (int)(second.getZ() - first.getZ())) < 0 || deltaX == 0 && deltaZ < 0;
    }
}

